/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable.shapes;

import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Paint;
import java.util.Objects;

public abstract class Shape
implements Cloneable {
    private float mWidth;
    private float mHeight;

    public float getWidth() {
        return this.mWidth;
    }

    public float getHeight() {
        return this.mHeight;
    }

    public abstract void draw(Canvas var1, Paint var2);

    public void resize(float width2, float height2) {
        if (width2 < 0.0f) {
            width2 = 0.0f;
        }
        if (height2 < 0.0f) {
            height2 = 0.0f;
        }
        if (this.mWidth != width2 || this.mHeight != height2) {
            this.mWidth = width2;
            this.mHeight = height2;
            this.onResize(width2, height2);
        }
    }

    public boolean hasAlpha() {
        return true;
    }

    protected void onResize(float width2, float height2) {
    }

    public void getOutline(Outline outline) {
    }

    public Shape clone() throws CloneNotSupportedException {
        return (Shape)super.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Shape shape2 = (Shape)o;
        return Float.compare(shape2.mWidth, this.mWidth) == 0 && Float.compare(shape2.mHeight, this.mHeight) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.mWidth), Float.valueOf(this.mHeight));
    }
}

