/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.graphics.FontListParser;
import android.text.FontConfig;
import android.util.Xml;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FontCustomizationParser {
    public static Result parse(InputStream in, String fontDir, Map<String, File> updatableFontMap) throws XmlPullParserException, IOException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(in, null);
        parser.nextTag();
        return FontCustomizationParser.readFamilies(parser, fontDir, updatableFontMap);
    }

    private static Map<String, FontConfig.FontFamily> validateAndTransformToMap(List<FontConfig.FontFamily> families) {
        HashMap<String, FontConfig.FontFamily> namedFamily = new HashMap<String, FontConfig.FontFamily>();
        for (int i = 0; i < families.size(); ++i) {
            FontConfig.FontFamily family = families.get(i);
            String name = family.getName();
            if (name == null) {
                throw new IllegalArgumentException("new-named-family requires name attribute");
            }
            if (namedFamily.put(name, family) == null) continue;
            throw new IllegalArgumentException("new-named-family requires unique name attribute");
        }
        return namedFamily;
    }

    private static Result readFamilies(XmlPullParser parser, String fontDir, Map<String, File> updatableFontMap) throws XmlPullParserException, IOException {
        ArrayList<FontConfig.FontFamily> families = new ArrayList<FontConfig.FontFamily>();
        ArrayList<FontConfig.Alias> aliases = new ArrayList<FontConfig.Alias>();
        parser.require(2, null, "fonts-modification");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tag2 = parser.getName();
            if (tag2.equals("family")) {
                FontCustomizationParser.readFamily(parser, fontDir, families, updatableFontMap);
                continue;
            }
            if (tag2.equals("alias")) {
                aliases.add(FontListParser.readAlias(parser));
                continue;
            }
            FontListParser.skip(parser);
        }
        return new Result(FontCustomizationParser.validateAndTransformToMap(families), aliases);
    }

    private static void readFamily(XmlPullParser parser, String fontDir, List<FontConfig.FontFamily> out, Map<String, File> updatableFontMap) throws XmlPullParserException, IOException {
        String customizationType = parser.getAttributeValue(null, "customizationType");
        if (customizationType == null) {
            throw new IllegalArgumentException("customizationType must be specified");
        }
        if (customizationType.equals("new-named-family")) {
            FontConfig.FontFamily fontFamily = FontListParser.readFamily(parser, fontDir, updatableFontMap, false);
            if (fontFamily != null) {
                out.add(fontFamily);
            }
        } else {
            throw new IllegalArgumentException("Unknown customizationType=" + customizationType);
        }
    }

    public static class Result {
        private final Map<String, FontConfig.FontFamily> mAdditionalNamedFamilies;
        private final List<FontConfig.Alias> mAdditionalAliases;

        public Result() {
            this.mAdditionalNamedFamilies = Collections.emptyMap();
            this.mAdditionalAliases = Collections.emptyList();
        }

        public Result(Map<String, FontConfig.FontFamily> additionalNamedFamilies, List<FontConfig.Alias> additionalAliases) {
            this.mAdditionalNamedFamilies = additionalNamedFamilies;
            this.mAdditionalAliases = additionalAliases;
        }

        public Map<String, FontConfig.FontFamily> getAdditionalNamedFamilies() {
            return this.mAdditionalNamedFamilies;
        }

        public List<FontConfig.Alias> getAdditionalAliases() {
            return this.mAdditionalAliases;
        }
    }
}

