/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.annotation.SystemApi;
import android.graphics.fonts.FontFileUpdateRequest;
import android.graphics.fonts.FontStyle;
import android.graphics.fonts.FontVariationAxis;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
public class FontFamilyUpdateRequest {
    private final List<FontFileUpdateRequest> mFontFiles;
    private final List<FontFamily> mFontFamilies;

    private FontFamilyUpdateRequest(List<FontFileUpdateRequest> fontFiles, List<FontFamily> fontFamilies) {
        this.mFontFiles = fontFiles;
        this.mFontFamilies = fontFamilies;
    }

    public List<FontFileUpdateRequest> getFontFileUpdateRequests() {
        return this.mFontFiles;
    }

    public List<FontFamily> getFontFamilies() {
        return this.mFontFamilies;
    }

    public static class Builder {
        private final List<FontFileUpdateRequest> mFontFileUpdateRequests = new ArrayList<FontFileUpdateRequest>();
        private final List<FontFamily> mFontFamilies = new ArrayList<FontFamily>();

        public Builder addFontFileUpdateRequest(FontFileUpdateRequest request) {
            Objects.requireNonNull(request);
            this.mFontFileUpdateRequests.add(request);
            return this;
        }

        public Builder addFontFamily(FontFamily fontFamily) {
            Objects.requireNonNull(fontFamily);
            this.mFontFamilies.add(fontFamily);
            return this;
        }

        public FontFamilyUpdateRequest build() {
            return new FontFamilyUpdateRequest(this.mFontFileUpdateRequests, this.mFontFamilies);
        }
    }

    public static class Font {
        private final String mPostScriptName;
        private final FontStyle mStyle;
        private final List<FontVariationAxis> mAxes;
        private final int mIndex;

        private Font(String postScriptName, FontStyle style2, int index, List<FontVariationAxis> axes) {
            this.mPostScriptName = postScriptName;
            this.mStyle = style2;
            this.mIndex = index;
            this.mAxes = axes;
        }

        public String getPostScriptName() {
            return this.mPostScriptName;
        }

        public FontStyle getStyle() {
            return this.mStyle;
        }

        public List<FontVariationAxis> getAxes() {
            return this.mAxes;
        }

        public int getIndex() {
            return this.mIndex;
        }

        public static class Builder {
            private final String mPostScriptName;
            private final FontStyle mStyle;
            private List<FontVariationAxis> mAxes = Collections.emptyList();
            private int mIndex = 0;

            public Builder(String postScriptName, FontStyle style2) {
                Objects.requireNonNull(postScriptName);
                Preconditions.checkStringNotEmpty(postScriptName);
                Objects.requireNonNull(style2);
                this.mPostScriptName = postScriptName;
                this.mStyle = style2;
            }

            public Builder setAxes(List<FontVariationAxis> axes) {
                Objects.requireNonNull(axes);
                Preconditions.checkCollectionElementsNotNull(axes, "axes");
                this.mAxes = axes;
                return this;
            }

            public Builder setIndex(int index) {
                Preconditions.checkArgumentNonnegative(index);
                this.mIndex = index;
                return this;
            }

            public Font build() {
                return new Font(this.mPostScriptName, this.mStyle, this.mIndex, this.mAxes);
            }
        }
    }

    public static class FontFamily {
        private final String mName;
        private final List<Font> mFonts;

        private FontFamily(String name, List<Font> fonts) {
            this.mName = name;
            this.mFonts = fonts;
        }

        public String getName() {
            return this.mName;
        }

        public List<Font> getFonts() {
            return this.mFonts;
        }

        public static class Builder {
            private final String mName;
            private final List<Font> mFonts;

            public Builder(String name, List<Font> fonts) {
                Objects.requireNonNull(name);
                Preconditions.checkStringNotEmpty(name);
                Objects.requireNonNull(fonts);
                Preconditions.checkCollectionElementsNotNull(fonts, "fonts");
                Preconditions.checkCollectionNotEmpty(fonts, "fonts");
                this.mName = name;
                this.mFonts = new ArrayList<Font>(fonts);
            }

            public Builder addFont(Font font) {
                this.mFonts.add(font);
                return this;
            }

            public FontFamily build() {
                return new FontFamily(this.mName, this.mFonts);
            }
        }
    }
}

