/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.graphics.fonts.FontFamilyUpdateRequest;
import android.graphics.fonts.FontStyle;
import android.graphics.fonts.FontVariationAxis;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.text.FontConfig;
import android.util.TypedXmlSerializer;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FontUpdateRequest
implements Parcelable {
    public static final int TYPE_UPDATE_FONT_FILE = 0;
    public static final int TYPE_UPDATE_FONT_FAMILY = 1;
    public static final Parcelable.Creator<FontUpdateRequest> CREATOR = new Parcelable.Creator<FontUpdateRequest>(){

        @Override
        public FontUpdateRequest createFromParcel(Parcel in) {
            return new FontUpdateRequest(in);
        }

        public FontUpdateRequest[] newArray(int size) {
            return new FontUpdateRequest[size];
        }
    };
    private final int mType;
    private final ParcelFileDescriptor mFd;
    private final byte[] mSignature;
    private final Family mFontFamily;

    public FontUpdateRequest(ParcelFileDescriptor fd, byte[] signature) {
        this.mType = 0;
        this.mFd = fd;
        this.mSignature = signature;
        this.mFontFamily = null;
    }

    public FontUpdateRequest(Family fontFamily) {
        this.mType = 1;
        this.mFd = null;
        this.mSignature = null;
        this.mFontFamily = fontFamily;
    }

    public FontUpdateRequest(String familyName, List<FontFamilyUpdateRequest.Font> variations) {
        this(FontUpdateRequest.createFontFamily(familyName, variations));
    }

    private static Family createFontFamily(String familyName, List<FontFamilyUpdateRequest.Font> fonts) {
        ArrayList<Font> updateFonts = new ArrayList<Font>(fonts.size());
        for (FontFamilyUpdateRequest.Font font : fonts) {
            updateFonts.add(new Font(font.getPostScriptName(), font.getStyle(), font.getIndex(), FontVariationAxis.toFontVariationSettings(font.getAxes())));
        }
        return new Family(familyName, updateFonts);
    }

    protected FontUpdateRequest(Parcel in) {
        this.mType = in.readInt();
        this.mFd = in.readParcelable(ParcelFileDescriptor.class.getClassLoader(), ParcelFileDescriptor.class);
        this.mSignature = in.readBlob();
        this.mFontFamily = in.readParcelable(FontConfig.FontFamily.class.getClassLoader(), Family.class);
    }

    public int getType() {
        return this.mType;
    }

    public ParcelFileDescriptor getFd() {
        return this.mFd;
    }

    public byte[] getSignature() {
        return this.mSignature;
    }

    public Family getFontFamily() {
        return this.mFontFamily;
    }

    @Override
    public int describeContents() {
        return this.mFd != null ? this.mFd.describeContents() : 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mType);
        dest.writeParcelable(this.mFd, flags);
        dest.writeBlob(this.mSignature);
        dest.writeParcelable(this.mFontFamily, flags);
    }

    private static int getAttributeValueInt(XmlPullParser parser, String name, int defaultValue) {
        try {
            String value2 = parser.getAttributeValue(null, name);
            if (value2 == null) {
                return defaultValue;
            }
            return Integer.parseInt(value2);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static class Family
    implements Parcelable {
        private static final String TAG_FAMILY = "family";
        private static final String ATTR_NAME = "name";
        private static final String TAG_FONT = "font";
        private final String mName;
        private final List<Font> mFonts;
        public static final Parcelable.Creator<Family> CREATOR = new Parcelable.Creator<Family>(){

            @Override
            public Family createFromParcel(Parcel source) {
                String familyName = source.readString8();
                List<Font> fonts = source.readParcelableList(new ArrayList(), Font.class.getClassLoader(), Font.class);
                return new Family(familyName, fonts);
            }

            public Family[] newArray(int size) {
                return new Family[size];
            }
        };

        public Family(String name, List<Font> fonts) {
            this.mName = name;
            this.mFonts = fonts;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString8(this.mName);
            dest.writeParcelableList(this.mFonts, flags);
        }

        public static void writeFamilyToXml(TypedXmlSerializer out, Family family) throws IOException {
            out.attribute(null, ATTR_NAME, family.getName());
            List<Font> fonts = family.getFonts();
            for (int i = 0; i < fonts.size(); ++i) {
                Font font = fonts.get(i);
                out.startTag(null, TAG_FONT);
                Font.writeToXml(out, font);
                out.endTag(null, TAG_FONT);
            }
        }

        public static Family readFromXml(XmlPullParser parser) throws XmlPullParserException, IOException {
            ArrayList<Font> fonts = new ArrayList<Font>();
            if (parser.getEventType() != 2 || !parser.getName().equals(TAG_FAMILY)) {
                throw new IOException("Unexpected parser state: must be START_TAG with family");
            }
            String name = parser.getAttributeValue(null, ATTR_NAME);
            if (name == null) {
                throw new IOException("name attribute is missing in family tag.");
            }
            int type = 0;
            while ((type = parser.next()) != 1) {
                if (type == 2 && parser.getName().equals(TAG_FONT)) {
                    fonts.add(Font.readFromXml(parser));
                    continue;
                }
                if (type != 3 || !parser.getName().equals(TAG_FAMILY)) continue;
            }
            return new Family(name, fonts);
        }

        public String getName() {
            return this.mName;
        }

        public List<Font> getFonts() {
            return this.mFonts;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Family family = (Family)o;
            return this.mName.equals(family.mName) && this.mFonts.equals(family.mFonts);
        }

        public int hashCode() {
            return Objects.hash(this.mName, this.mFonts);
        }

        public String toString() {
            return "Family{mName='" + this.mName + '\'' + ", mFonts=" + this.mFonts + '}';
        }
    }

    public static class Font
    implements Parcelable {
        private static final String ATTR_INDEX = "index";
        private static final String ATTR_WEIGHT = "weight";
        private static final String ATTR_SLANT = "slant";
        private static final String ATTR_AXIS = "axis";
        private static final String ATTR_POSTSCRIPT_NAME = "name";
        private final String mPostScriptName;
        private final FontStyle mFontStyle;
        private final int mIndex;
        private final String mFontVariationSettings;
        public static final Parcelable.Creator<Font> CREATOR = new Parcelable.Creator<Font>(){

            @Override
            public Font createFromParcel(Parcel source) {
                String fontName = source.readString8();
                int weight = source.readInt();
                int slant = source.readInt();
                int index = source.readInt();
                String varSettings = source.readString8();
                return new Font(fontName, new FontStyle(weight, slant), index, varSettings);
            }

            public Font[] newArray(int size) {
                return new Font[size];
            }
        };

        public Font(String postScriptName, FontStyle fontStyle, int index, String fontVariationSettings) {
            this.mPostScriptName = postScriptName;
            this.mFontStyle = fontStyle;
            this.mIndex = index;
            this.mFontVariationSettings = fontVariationSettings;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString8(this.mPostScriptName);
            dest.writeInt(this.mFontStyle.getWeight());
            dest.writeInt(this.mFontStyle.getSlant());
            dest.writeInt(this.mIndex);
            dest.writeString8(this.mFontVariationSettings);
        }

        public static void writeToXml(TypedXmlSerializer out, Font font) throws IOException {
            out.attribute(null, ATTR_POSTSCRIPT_NAME, font.getPostScriptName());
            out.attributeInt(null, ATTR_INDEX, font.getIndex());
            out.attributeInt(null, ATTR_WEIGHT, font.getFontStyle().getWeight());
            out.attributeInt(null, ATTR_SLANT, font.getFontStyle().getSlant());
            out.attribute(null, ATTR_AXIS, font.getFontVariationSettings());
        }

        public static Font readFromXml(XmlPullParser parser) throws IOException {
            String psName = parser.getAttributeValue(null, ATTR_POSTSCRIPT_NAME);
            if (psName == null) {
                throw new IOException("name attribute is missing in font tag.");
            }
            int index = FontUpdateRequest.getAttributeValueInt(parser, ATTR_INDEX, 0);
            int weight = FontUpdateRequest.getAttributeValueInt(parser, ATTR_WEIGHT, 400);
            int slant = FontUpdateRequest.getAttributeValueInt(parser, ATTR_SLANT, 0);
            String varSettings = parser.getAttributeValue(null, ATTR_AXIS);
            if (varSettings == null) {
                varSettings = "";
            }
            return new Font(psName, new FontStyle(weight, slant), index, varSettings);
        }

        public String getPostScriptName() {
            return this.mPostScriptName;
        }

        public FontStyle getFontStyle() {
            return this.mFontStyle;
        }

        public int getIndex() {
            return this.mIndex;
        }

        public String getFontVariationSettings() {
            return this.mFontVariationSettings;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Font font = (Font)o;
            return this.mIndex == font.mIndex && this.mPostScriptName.equals(font.mPostScriptName) && this.mFontStyle.equals(font.mFontStyle) && this.mFontVariationSettings.equals(font.mFontVariationSettings);
        }

        public int hashCode() {
            return Objects.hash(this.mPostScriptName, this.mFontStyle, this.mIndex, this.mFontVariationSettings);
        }

        public String toString() {
            return "Font{mPostScriptName='" + this.mPostScriptName + '\'' + ", mFontStyle=" + this.mFontStyle + ", mIndex=" + this.mIndex + ", mFontVariationSettings='" + this.mFontVariationSettings + '\'' + '}';
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

