/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.graphics.FontListParser;
import android.graphics.Typeface;
import android.graphics.fonts.Font;
import android.graphics.fonts.FontFamily;
import android.graphics.fonts.SystemFonts_Delegate;
import android.text.FontConfig;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParserException;

public final class SystemFonts {
    private static final String TAG = "SystemFonts";
    private static final String FONTS_XML = "/system/etc/fonts.xml";
    public static final String SYSTEM_FONT_DIR = "/system/fonts/";
    private static final String OEM_XML = "/product/etc/fonts_customization.xml";
    public static final String OEM_FONT_DIR = "/product/fonts/";
    private static final Object LOCK = new Object();
    @GuardedBy(value={"sLock"})
    private static Set<Font> sAvailableFonts;

    private SystemFonts() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Font> getAvailableFonts() {
        Object object = LOCK;
        synchronized (object) {
            if (sAvailableFonts == null) {
                sAvailableFonts = Font.getAvailableFonts();
            }
            return sAvailableFonts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetAvailableFonts() {
        Object object = LOCK;
        synchronized (object) {
            sAvailableFonts = null;
        }
    }

    static ByteBuffer mmap_Original(String fullPath) {
        MappedByteBuffer mappedByteBuffer;
        FileInputStream file2 = new FileInputStream(fullPath);
        try {
            FileChannel fileChannel = file2.getChannel();
            long fontSize = fileChannel.size();
            mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fontSize);
        }
        catch (Throwable throwable) {
            try {
                try {
                    file2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        file2.close();
        return mappedByteBuffer;
    }

    @LayoutlibDelegate
    private static ByteBuffer mmap(String string2) {
        return SystemFonts_Delegate.mmap(string2);
    }

    private static void pushFamilyToFallback(FontConfig.FontFamily xmlFamily, ArrayMap<String, ArrayList<FontFamily>> fallbackMap, Map<String, ByteBuffer> cache) {
        String languageTags = xmlFamily.getLocaleList().toLanguageTags();
        int variant = xmlFamily.getVariant();
        ArrayList<FontConfig.Font> defaultFonts = new ArrayList<FontConfig.Font>();
        ArrayMap<String, ArrayList<FontConfig.Font>> specificFallbackFonts = new ArrayMap<String, ArrayList<FontConfig.Font>>();
        for (FontConfig.Font font : xmlFamily.getFonts()) {
            String fallbackName = font.getFontFamilyName();
            if (fallbackName == null) {
                defaultFonts.add(font);
                continue;
            }
            ArrayList<FontConfig.Font> fallback = (ArrayList<FontConfig.Font>)specificFallbackFonts.get(fallbackName);
            if (fallback == null) {
                fallback = new ArrayList<FontConfig.Font>();
                specificFallbackFonts.put(fallbackName, fallback);
            }
            fallback.add(font);
        }
        FontFamily defaultFamily = defaultFonts.isEmpty() ? null : SystemFonts.createFontFamily(xmlFamily.getName(), defaultFonts, languageTags, variant, cache);
        for (int i = 0; i < fallbackMap.size(); ++i) {
            String name = fallbackMap.keyAt(i);
            ArrayList fallback = (ArrayList)specificFallbackFonts.get(name);
            if (fallback == null) {
                String familyName = xmlFamily.getName();
                if (defaultFamily == null || familyName != null && familyName.equals(name)) continue;
                fallbackMap.valueAt(i).add(defaultFamily);
                continue;
            }
            FontFamily family = SystemFonts.createFontFamily(xmlFamily.getName(), fallback, languageTags, variant, cache);
            if (family != null) {
                fallbackMap.valueAt(i).add(family);
                continue;
            }
            if (defaultFamily == null) continue;
            fallbackMap.valueAt(i).add(defaultFamily);
        }
    }

    private static FontFamily createFontFamily(String familyName, List<FontConfig.Font> fonts, String languageTags, int variant, Map<String, ByteBuffer> cache) {
        if (fonts.size() == 0) {
            return null;
        }
        FontFamily.Builder b = null;
        for (int i = 0; i < fonts.size(); ++i) {
            Font font;
            FontConfig.Font fontConfig = fonts.get(i);
            String fullPath = fontConfig.getFile().getAbsolutePath();
            ByteBuffer buffer = cache.get(fullPath);
            if (buffer == null) {
                if (cache.containsKey(fullPath)) continue;
                buffer = SystemFonts.mmap(fullPath);
                cache.put(fullPath, buffer);
                if (buffer == null) continue;
            }
            try {
                font = new Font.Builder(buffer, new File(fullPath), languageTags).setWeight(fontConfig.getStyle().getWeight()).setSlant(fontConfig.getStyle().getSlant()).setTtcIndex(fontConfig.getTtcIndex()).setFontVariationSettings(fontConfig.getFontVariationSettings()).build();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (b == null) {
                b = new FontFamily.Builder(font);
                continue;
            }
            b.addFont(font);
        }
        return b == null ? null : b.build(languageTags, variant, false);
    }

    private static void appendNamedFamily(FontConfig.FontFamily xmlFamily, ArrayMap<String, ByteBuffer> bufferCache, ArrayMap<String, ArrayList<FontFamily>> fallbackListMap) {
        String familyName = xmlFamily.getName();
        FontFamily family = SystemFonts.createFontFamily(familyName, xmlFamily.getFontList(), xmlFamily.getLocaleList().toLanguageTags(), xmlFamily.getVariant(), bufferCache);
        if (family == null) {
            return;
        }
        ArrayList<FontFamily> fallback = new ArrayList<FontFamily>();
        fallback.add(family);
        fallbackListMap.put(familyName, fallback);
    }

    public static FontConfig getSystemFontConfig(Map<String, File> updatableFontMap, long lastModifiedDate, int configVersion) {
        return SystemFonts.getSystemFontConfigInternal(FONTS_XML, SYSTEM_FONT_DIR, OEM_XML, OEM_FONT_DIR, updatableFontMap, lastModifiedDate, configVersion);
    }

    public static FontConfig getSystemPreinstalledFontConfig() {
        return SystemFonts.getSystemFontConfigInternal(FONTS_XML, SYSTEM_FONT_DIR, OEM_XML, OEM_FONT_DIR, null, 0L, 0);
    }

    static FontConfig getSystemFontConfigInternal_Original(String fontsXml, String systemFontDir, String oemXml, String productFontDir, Map<String, File> updatableFontMap, long lastModifiedDate, int configVersion) {
        try {
            return FontListParser.parse(fontsXml, systemFontDir, oemXml, productFontDir, updatableFontMap, lastModifiedDate, configVersion);
        }
        catch (IOException e) {
            Log.e(TAG, "Failed to open/read system font configurations.", e);
            return new FontConfig(Collections.emptyList(), Collections.emptyList(), 0L, 0);
        }
        catch (XmlPullParserException e) {
            Log.e(TAG, "Failed to parse the system font configuration.", e);
            return new FontConfig(Collections.emptyList(), Collections.emptyList(), 0L, 0);
        }
    }

    @LayoutlibDelegate
    static FontConfig getSystemFontConfigInternal(String string2, String string3, String string4, String string5, Map<String, File> map2, long l, int n) {
        return SystemFonts_Delegate.getSystemFontConfigInternal(string2, string3, string4, string5, map2, l, n);
    }

    @VisibleForTesting
    public static Map<String, FontFamily[]> buildSystemFallback(FontConfig fontConfig) {
        return SystemFonts.buildSystemFallback(fontConfig, new ArrayMap<String, ByteBuffer>());
    }

    @VisibleForTesting
    public static Map<String, FontFamily[]> buildSystemFallback(FontConfig fontConfig, ArrayMap<String, ByteBuffer> outBufferCache) {
        int i;
        ArrayMap<String, FontFamily[]> fallbackMap = new ArrayMap<String, FontFamily[]>();
        List<FontConfig.FontFamily> xmlFamilies = fontConfig.getFontFamilies();
        ArrayMap<String, ArrayList<FontFamily>> fallbackListMap = new ArrayMap<String, ArrayList<FontFamily>>();
        for (FontConfig.FontFamily xmlFamily : xmlFamilies) {
            String familyName = xmlFamily.getName();
            if (familyName == null) continue;
            SystemFonts.appendNamedFamily(xmlFamily, outBufferCache, fallbackListMap);
        }
        for (i = 0; i < xmlFamilies.size(); ++i) {
            FontConfig.FontFamily xmlFamily;
            xmlFamily = xmlFamilies.get(i);
            if (i != 0 && xmlFamily.getName() != null) continue;
            SystemFonts.pushFamilyToFallback(xmlFamily, fallbackListMap, outBufferCache);
        }
        for (i = 0; i < fallbackListMap.size(); ++i) {
            String fallbackName = fallbackListMap.keyAt(i);
            List familyList = fallbackListMap.valueAt(i);
            fallbackMap.put(fallbackName, familyList.toArray(new FontFamily[0]));
        }
        return fallbackMap;
    }

    @VisibleForTesting
    public static Map<String, Typeface> buildSystemTypefaces(FontConfig fontConfig, Map<String, FontFamily[]> fallbackMap) {
        ArrayMap<String, Typeface> result = new ArrayMap<String, Typeface>();
        Typeface.initSystemDefaultTypefaces(fallbackMap, fontConfig.getAliases(), result);
        return result;
    }
}

