/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.fonts;

import android.graphics.fonts.SystemFonts;
import android.text.FontConfig;
import android.util.Log;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Locale;
import java.util.Map;

public class SystemFonts_Delegate {
    private static final String TAG = "SystemFonts_Delegate";
    private static String sFontLocation;
    public static boolean sIsTypefaceInitialized;

    public static void setFontLocation(String fontLocation) {
        sFontLocation = fontLocation;
    }

    @LayoutlibDelegate
    static FontConfig getSystemFontConfigInternal(String fontsXml, String systemFontDir, String oemXml, String productFontDir, Map<String, File> updatableFontMap, long lastModifiedDate, int configVersion) {
        sIsTypefaceInitialized = true;
        return SystemFonts.getSystemFontConfigInternal_Original(sFontLocation + "fonts.xml", sFontLocation, null, null, updatableFontMap, lastModifiedDate, configVersion);
    }

    @LayoutlibDelegate
    static ByteBuffer mmap(String fullPath) {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        if (osName.startsWith("windows")) {
            ByteBuffer byteBuffer;
            FileInputStream file2 = new FileInputStream(fullPath);
            try {
                FileChannel fileChannel = file2.getChannel();
                int size = (int)fileChannel.size();
                ByteBuffer buffer = ByteBuffer.allocateDirect(size);
                fileChannel.read(buffer);
                byteBuffer = buffer;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        file2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Log.e(TAG, "Error mapping font file " + fullPath);
                    return null;
                }
            }
            file2.close();
            return byteBuffer;
        }
        return SystemFonts.mmap_Original(fullPath);
    }

    static {
        sIsTypefaceInitialized = false;
    }
}

