/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.text;

import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.text.LineBreakConfig;
import android.util.Log;
import com.android.internal.util.Preconditions;
import dalvik.annotation.optimization.CriticalNative;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import libcore.util.NativeAllocationRegistry;

public class MeasuredText {
    private static final String TAG = "MeasuredText";
    private final long mNativePtr;
    private final boolean mComputeHyphenation;
    private final boolean mComputeLayout;
    private final char[] mChars;
    private final int mTop;
    private final int mBottom;

    private MeasuredText(long ptr, char[] chars, boolean computeHyphenation, boolean computeLayout, int top, int bottom2) {
        this.mNativePtr = ptr;
        this.mChars = chars;
        this.mComputeHyphenation = computeHyphenation;
        this.mComputeLayout = computeLayout;
        this.mTop = top;
        this.mBottom = bottom2;
    }

    public char[] getChars() {
        return this.mChars;
    }

    public float getWidth(int start, int end) {
        Preconditions.checkArgument(0 <= start && start <= this.mChars.length, "start(%d) must be 0 <= start <= %d", start, this.mChars.length);
        Preconditions.checkArgument(0 <= end && end <= this.mChars.length, "end(%d) must be 0 <= end <= %d", end, this.mChars.length);
        Preconditions.checkArgument(start <= end, "start(%d) is larger than end(%d)", start, end);
        return MeasuredText.nGetWidth(this.mNativePtr, start, end);
    }

    public int getMemoryUsage() {
        return MeasuredText.nGetMemoryUsage(this.mNativePtr);
    }

    public void getBounds(int start, int end, Rect rect) {
        Preconditions.checkArgument(0 <= start && start <= this.mChars.length, "start(%d) must be 0 <= start <= %d", start, this.mChars.length);
        Preconditions.checkArgument(0 <= end && end <= this.mChars.length, "end(%d) must be 0 <= end <= %d", end, this.mChars.length);
        Preconditions.checkArgument(start <= end, "start(%d) is larger than end(%d)", start, end);
        Preconditions.checkNotNull(rect);
        MeasuredText.nGetBounds(this.mNativePtr, this.mChars, start, end, rect);
    }

    public void getFontMetricsInt(int start, int end, Paint.FontMetricsInt outMetrics) {
        Preconditions.checkArgument(0 <= start && start <= this.mChars.length, "start(%d) must be 0 <= start <= %d", start, this.mChars.length);
        Preconditions.checkArgument(0 <= end && end <= this.mChars.length, "end(%d) must be 0 <= end <= %d", end, this.mChars.length);
        Preconditions.checkArgument(start <= end, "start(%d) is larger than end(%d)", start, end);
        Objects.requireNonNull(outMetrics);
        long packed = MeasuredText.nGetExtent(this.mNativePtr, this.mChars, start, end);
        outMetrics.ascent = (int)(packed >> 32);
        outMetrics.descent = (int)(packed & 0xFFFFFFFFFFFFFFFFL);
        outMetrics.top = Math.min(outMetrics.ascent, this.mTop);
        outMetrics.bottom = Math.max(outMetrics.descent, this.mBottom);
    }

    public float getCharWidthAt(int offset2) {
        Preconditions.checkArgument(0 <= offset2 && offset2 < this.mChars.length, "offset(%d) is larger than text length %d" + offset2, this.mChars.length);
        return MeasuredText.nGetCharWidthAt(this.mNativePtr, offset2);
    }

    public long getNativePtr() {
        return this.mNativePtr;
    }

    @CriticalNative
    private static native float nGetWidth(long var0, int var2, int var3);

    @CriticalNative
    private static native long nGetReleaseFunc();

    @CriticalNative
    private static native int nGetMemoryUsage(long var0);

    private static native void nGetBounds(long var0, char[] var2, int var3, int var4, Rect var5);

    @CriticalNative
    private static native float nGetCharWidthAt(long var0, int var2);

    private static native long nGetExtent(long var0, char[] var2, int var3, int var4);

    public static final class Builder {
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(MeasuredText.class.getClassLoader(), MeasuredText.nGetReleaseFunc());
        private long mNativePtr;
        private final char[] mText;
        private boolean mComputeHyphenation = false;
        private boolean mComputeLayout = true;
        private boolean mFastHyphenation = false;
        private int mCurrentOffset = 0;
        private MeasuredText mHintMt = null;
        private int mTop = 0;
        private int mBottom = 0;
        private Paint.FontMetricsInt mCachedMetrics = new Paint.FontMetricsInt();
        public static final int HYPHENATION_MODE_NONE = 0;
        public static final int HYPHENATION_MODE_NORMAL = 1;
        public static final int HYPHENATION_MODE_FAST = 2;

        public Builder(char[] text) {
            Preconditions.checkNotNull(text);
            this.mText = text;
            this.mNativePtr = Builder.nInitBuilder();
        }

        public Builder(MeasuredText text) {
            Preconditions.checkNotNull(text);
            this.mText = text.mChars;
            this.mNativePtr = Builder.nInitBuilder();
            if (!text.mComputeLayout) {
                throw new IllegalArgumentException("The input MeasuredText must not be created with setComputeLayout(false).");
            }
            this.mComputeHyphenation = text.mComputeHyphenation;
            this.mComputeLayout = text.mComputeLayout;
            this.mHintMt = text;
        }

        public Builder appendStyleRun(Paint paint, int length, boolean isRtl) {
            return this.appendStyleRun(paint, null, length, isRtl);
        }

        public Builder appendStyleRun(Paint paint, LineBreakConfig lineBreakConfig, int length, boolean isRtl) {
            Preconditions.checkNotNull(paint);
            Preconditions.checkArgument(length > 0, "length can not be negative");
            int end = this.mCurrentOffset + length;
            Preconditions.checkArgument(end <= this.mText.length, "Style exceeds the text length");
            int lbStyle = lineBreakConfig != null ? lineBreakConfig.getLineBreakStyle() : 0;
            int lbWordStyle = lineBreakConfig != null ? lineBreakConfig.getLineBreakWordStyle() : 0;
            Builder.nAddStyleRun(this.mNativePtr, paint.getNativeInstance(), lbStyle, lbWordStyle, this.mCurrentOffset, end, isRtl);
            this.mCurrentOffset = end;
            paint.getFontMetricsInt(this.mCachedMetrics);
            this.mTop = Math.min(this.mTop, this.mCachedMetrics.top);
            this.mBottom = Math.max(this.mBottom, this.mCachedMetrics.bottom);
            return this;
        }

        public Builder appendReplacementRun(Paint paint, int length, float width2) {
            Preconditions.checkArgument(length > 0, "length can not be negative");
            int end = this.mCurrentOffset + length;
            Preconditions.checkArgument(end <= this.mText.length, "Replacement exceeds the text length");
            Builder.nAddReplacementRun(this.mNativePtr, paint.getNativeInstance(), this.mCurrentOffset, end, width2);
            this.mCurrentOffset = end;
            return this;
        }

        @Deprecated
        public Builder setComputeHyphenation(boolean computeHyphenation) {
            this.setComputeHyphenation(computeHyphenation ? 1 : 0);
            return this;
        }

        public Builder setComputeHyphenation(int mode) {
            switch (mode) {
                case 0: {
                    this.mComputeHyphenation = false;
                    this.mFastHyphenation = false;
                    break;
                }
                case 1: {
                    this.mComputeHyphenation = true;
                    this.mFastHyphenation = false;
                    break;
                }
                case 2: {
                    this.mComputeHyphenation = true;
                    this.mFastHyphenation = true;
                    break;
                }
                default: {
                    Log.e(MeasuredText.TAG, "Unknown hyphenation mode: " + mode);
                    this.mComputeHyphenation = false;
                    this.mFastHyphenation = false;
                }
            }
            return this;
        }

        public Builder setComputeLayout(boolean computeLayout) {
            this.mComputeLayout = computeLayout;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MeasuredText build() {
            this.ensureNativePtrNoReuse();
            if (this.mCurrentOffset != this.mText.length) {
                throw new IllegalStateException("Style info has not been provided for all text.");
            }
            if (this.mHintMt != null && this.mHintMt.mComputeHyphenation != this.mComputeHyphenation) {
                throw new IllegalArgumentException("The hyphenation configuration is different from given hint MeasuredText");
            }
            try {
                long hintPtr = this.mHintMt == null ? 0L : this.mHintMt.getNativePtr();
                long ptr = Builder.nBuildMeasuredText(this.mNativePtr, hintPtr, this.mText, this.mComputeHyphenation, this.mComputeLayout, this.mFastHyphenation);
                MeasuredText res = new MeasuredText(ptr, this.mText, this.mComputeHyphenation, this.mComputeLayout, this.mTop, this.mBottom);
                sRegistry.registerNativeAllocation(res, ptr);
                MeasuredText measuredText = res;
                return measuredText;
            }
            finally {
                Builder.nFreeBuilder(this.mNativePtr);
                this.mNativePtr = 0L;
            }
        }

        private void ensureNativePtrNoReuse() {
            if (this.mNativePtr == 0L) {
                throw new IllegalStateException("Builder can not be reused.");
            }
        }

        private static native long nInitBuilder();

        private static native void nAddStyleRun(long var0, long var2, int var4, int var5, int var6, int var7, boolean var8);

        private static native void nAddReplacementRun(long var0, long var2, int var4, int var5, float var6);

        private static native long nBuildMeasuredText(long var0, long var2, char[] var4, boolean var5, boolean var6, boolean var7);

        private static native void nFreeBuilder(long var0);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface HyphenationMode {
        }
    }
}

