/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.hardware.biometrics.BiometricTestSession;
import android.hardware.biometrics.IAuthService;
import android.hardware.biometrics.IBiometricEnabledOnKeyguardCallback;
import android.hardware.biometrics.IInvalidationCallback;
import android.hardware.biometrics.SensorProperties;
import android.hardware.biometrics.SensorPropertiesInternal;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Slog;
import com.android.internal.util.FrameworkStatsLog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class BiometricManager {
    private static final String TAG = "BiometricManager";
    public static final int BIOMETRIC_SUCCESS = 0;
    public static final int BIOMETRIC_ERROR_HW_UNAVAILABLE = 1;
    public static final int BIOMETRIC_ERROR_NONE_ENROLLED = 11;
    public static final int BIOMETRIC_ERROR_NO_HARDWARE = 12;
    public static final int BIOMETRIC_ERROR_SECURITY_UPDATE_REQUIRED = 15;
    public static final int BIOMETRIC_MULTI_SENSOR_DEFAULT = 0;
    public static final int BIOMETRIC_MULTI_SENSOR_FINGERPRINT_AND_FACE = 1;
    private final Context mContext;
    private final IAuthService mService;

    public BiometricManager(Context context, IAuthService service) {
        this.mContext = context;
        this.mService = service;
    }

    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public List<SensorProperties> getSensorProperties() {
        try {
            List<SensorPropertiesInternal> internalProperties = this.mService.getSensorProperties(this.mContext.getOpPackageName());
            ArrayList<SensorProperties> properties2 = new ArrayList<SensorProperties>();
            for (SensorPropertiesInternal internalProp : internalProperties) {
                properties2.add(SensorProperties.from(internalProp));
            }
            return properties2;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public BiometricTestSession createTestSession(int sensorId) {
        try {
            return new BiometricTestSession(this.mContext, sensorId, (context, sensorId1, callback2) -> this.mService.createTestSession(sensorId1, callback2, context.getOpPackageName()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public String getUiPackage() {
        try {
            return this.mService.getUiPackage();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.USE_BIOMETRIC")
    public int canAuthenticate() {
        int result = this.canAuthenticate(this.mContext.getUserId(), 255);
        FrameworkStatsLog.write(354, false, 0, result);
        FrameworkStatsLog.write(356, 4, this.mContext.getApplicationInfo().uid, this.mContext.getApplicationInfo().targetSdkVersion);
        return result;
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC")
    public int canAuthenticate(@Authenticators.Types int authenticators) {
        int result = this.canAuthenticate(this.mContext.getUserId(), authenticators);
        FrameworkStatsLog.write(354, true, authenticators, result);
        return result;
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public int canAuthenticate(int userId, @Authenticators.Types int authenticators) {
        if (this.mService != null) {
            try {
                String opPackageName = this.mContext.getOpPackageName();
                return this.mService.canAuthenticate(opPackageName, userId, authenticators);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        Slog.w(TAG, "canAuthenticate(): Service not connected");
        return 1;
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC")
    public Strings getStrings(@Authenticators.Types int authenticators) {
        return new Strings(this.mContext, this.mService, authenticators);
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public boolean hasEnrolledBiometrics(int userId) {
        if (this.mService != null) {
            try {
                return this.mService.hasEnrolledBiometrics(userId, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Remote exception in hasEnrolledBiometrics(): " + e);
                return false;
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void registerEnabledOnKeyguardCallback(IBiometricEnabledOnKeyguardCallback callback2) {
        if (this.mService != null) {
            try {
                this.mService.registerEnabledOnKeyguardCallback(callback2);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        } else {
            Slog.w(TAG, "registerEnabledOnKeyguardCallback(): Service not connected");
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void invalidateAuthenticatorIds(int userId, int fromSensorId, IInvalidationCallback callback2) {
        if (this.mService != null) {
            try {
                this.mService.invalidateAuthenticatorIds(userId, fromSensorId, callback2);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public long[] getAuthenticatorIds() {
        return this.getAuthenticatorIds(UserHandle.myUserId());
    }

    public long[] getAuthenticatorIds(int userId) {
        if (this.mService != null) {
            try {
                return this.mService.getAuthenticatorIds(userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        Slog.w(TAG, "getAuthenticatorIds(): Service not connected");
        return new long[0];
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void resetLockoutTimeBound(IBinder token, String opPackageName, int fromSensorId, int userId, byte[] hardwareAuthToken) {
        if (this.mService != null) {
            try {
                this.mService.resetLockoutTimeBound(token, opPackageName, fromSensorId, userId, hardwareAuthToken);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public static class Strings {
        private final Context mContext;
        private final IAuthService mService;
        @Authenticators.Types
        int mAuthenticators;

        private Strings(Context context, IAuthService service, @Authenticators.Types int authenticators) {
            this.mContext = context;
            this.mService = service;
            this.mAuthenticators = authenticators;
        }

        @RequiresPermission(value="android.permission.USE_BIOMETRIC")
        public CharSequence getButtonLabel() {
            int userId = this.mContext.getUserId();
            String opPackageName = this.mContext.getOpPackageName();
            try {
                return this.mService.getButtonLabel(userId, opPackageName, this.mAuthenticators);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        @RequiresPermission(value="android.permission.USE_BIOMETRIC")
        public CharSequence getPromptMessage() {
            int userId = this.mContext.getUserId();
            String opPackageName = this.mContext.getOpPackageName();
            try {
                return this.mService.getPromptMessage(userId, opPackageName, this.mAuthenticators);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        @RequiresPermission(value="android.permission.USE_BIOMETRIC")
        public CharSequence getSettingName() {
            int userId = this.mContext.getUserId();
            String opPackageName = this.mContext.getOpPackageName();
            try {
                return this.mService.getSettingName(userId, opPackageName, this.mAuthenticators);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public static interface Authenticators {
        @SystemApi
        @RequiresPermission(value="android.permission.WRITE_DEVICE_CONFIG")
        public static final int EMPTY_SET = 0;
        public static final int BIOMETRIC_MAX_STRENGTH = 1;
        public static final int BIOMETRIC_STRONG = 15;
        public static final int BIOMETRIC_WEAK = 255;
        @SystemApi
        @RequiresPermission(value="android.permission.WRITE_DEVICE_CONFIG")
        public static final int BIOMETRIC_CONVENIENCE = 4095;
        public static final int BIOMETRIC_MIN_STRENGTH = Short.MAX_VALUE;
        public static final int DEVICE_CREDENTIAL = 32768;

        public static @interface Types {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BiometricMultiSensorMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BiometricError {
    }
}

