/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.extension;

import android.hardware.camera2.extension.IImageProcessorImpl;
import android.hardware.camera2.extension.IRequestCallback;
import android.hardware.camera2.extension.OutputConfigId;
import android.hardware.camera2.extension.Request;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IRequestProcessorImpl
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.camera2.extension.IRequestProcessorImpl";

    public void setImageProcessor(OutputConfigId var1, IImageProcessorImpl var2) throws RemoteException;

    public int submit(Request var1, IRequestCallback var2) throws RemoteException;

    public int submitBurst(List<Request> var1, IRequestCallback var2) throws RemoteException;

    public int setRepeating(Request var1, IRequestCallback var2) throws RemoteException;

    public void abortCaptures() throws RemoteException;

    public void stopRepeating() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRequestProcessorImpl {
        static final int TRANSACTION_setImageProcessor = 1;
        static final int TRANSACTION_submit = 2;
        static final int TRANSACTION_submitBurst = 3;
        static final int TRANSACTION_setRepeating = 4;
        static final int TRANSACTION_abortCaptures = 5;
        static final int TRANSACTION_stopRepeating = 6;

        public Stub() {
            this.attachInterface(this, IRequestProcessorImpl.DESCRIPTOR);
        }

        public static IRequestProcessorImpl asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRequestProcessorImpl.DESCRIPTOR);
            if (iin != null && iin instanceof IRequestProcessorImpl) {
                return (IRequestProcessorImpl)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setImageProcessor";
                }
                case 2: {
                    return "submit";
                }
                case 3: {
                    return "submitBurst";
                }
                case 4: {
                    return "setRepeating";
                }
                case 5: {
                    return "abortCaptures";
                }
                case 6: {
                    return "stopRepeating";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRequestProcessorImpl.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    OutputConfigId _arg0 = data.readTypedObject(OutputConfigId.CREATOR);
                    IImageProcessorImpl _arg1 = IImageProcessorImpl.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setImageProcessor(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    Request _arg0 = data.readTypedObject(Request.CREATOR);
                    IRequestCallback _arg1 = IRequestCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.submit(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 3: {
                    ArrayList<Request> _arg0 = data.createTypedArrayList(Request.CREATOR);
                    IRequestCallback _arg1 = IRequestCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.submitBurst(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 4: {
                    Request _arg0 = data.readTypedObject(Request.CREATOR);
                    IRequestCallback _arg1 = IRequestCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.setRepeating(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 5: {
                    this.abortCaptures();
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    this.stopRepeating();
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 5;
        }

        private static class Proxy
        implements IRequestProcessorImpl {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRequestProcessorImpl.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setImageProcessor(OutputConfigId outputConfigId, IImageProcessorImpl imageProcessor) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestProcessorImpl.DESCRIPTOR);
                    _data.writeTypedObject(outputConfigId, 0);
                    _data.writeStrongInterface(imageProcessor);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int submit(Request request, IRequestCallback callback2) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestProcessorImpl.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int submitBurst(List<Request> requests, IRequestCallback callback2) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestProcessorImpl.DESCRIPTOR);
                    _data.writeTypedList(requests);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setRepeating(Request request, IRequestCallback callback2) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestProcessorImpl.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void abortCaptures() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestProcessorImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopRepeating() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestProcessorImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRequestProcessorImpl {
        @Override
        public void setImageProcessor(OutputConfigId outputConfigId, IImageProcessorImpl imageProcessor) throws RemoteException {
        }

        @Override
        public int submit(Request request, IRequestCallback callback2) throws RemoteException {
            return 0;
        }

        @Override
        public int submitBurst(List<Request> requests, IRequestCallback callback2) throws RemoteException {
            return 0;
        }

        @Override
        public int setRepeating(Request request, IRequestCallback callback2) throws RemoteException {
            return 0;
        }

        @Override
        public void abortCaptures() throws RemoteException {
        }

        @Override
        public void stopRepeating() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

