/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.extension;

import android.hardware.camera2.extension.CaptureStageImpl;
import android.hardware.camera2.extension.Size;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.Surface;

public interface IRequestUpdateProcessorImpl
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.camera2.extension.IRequestUpdateProcessorImpl";

    public void onOutputSurface(Surface var1, int var2) throws RemoteException;

    public void onResolutionUpdate(Size var1) throws RemoteException;

    public void onImageFormatUpdate(int var1) throws RemoteException;

    public CaptureStageImpl process(CameraMetadataNative var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRequestUpdateProcessorImpl {
        static final int TRANSACTION_onOutputSurface = 1;
        static final int TRANSACTION_onResolutionUpdate = 2;
        static final int TRANSACTION_onImageFormatUpdate = 3;
        static final int TRANSACTION_process = 4;

        public Stub() {
            this.attachInterface(this, IRequestUpdateProcessorImpl.DESCRIPTOR);
        }

        public static IRequestUpdateProcessorImpl asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRequestUpdateProcessorImpl.DESCRIPTOR);
            if (iin != null && iin instanceof IRequestUpdateProcessorImpl) {
                return (IRequestUpdateProcessorImpl)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onOutputSurface";
                }
                case 2: {
                    return "onResolutionUpdate";
                }
                case 3: {
                    return "onImageFormatUpdate";
                }
                case 4: {
                    return "process";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRequestUpdateProcessorImpl.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    Surface _arg0 = data.readTypedObject(Surface.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onOutputSurface(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    Size _arg0 = data.readTypedObject(Size.CREATOR);
                    data.enforceNoDataAvail();
                    this.onResolutionUpdate(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onImageFormatUpdate(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    CameraMetadataNative _arg0 = data.readTypedObject(CameraMetadataNative.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    CaptureStageImpl _result = this.process(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IRequestUpdateProcessorImpl {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRequestUpdateProcessorImpl.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onOutputSurface(Surface surface2, int imageFormat) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestUpdateProcessorImpl.DESCRIPTOR);
                    _data.writeTypedObject(surface2, 0);
                    _data.writeInt(imageFormat);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResolutionUpdate(Size size) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestUpdateProcessorImpl.DESCRIPTOR);
                    _data.writeTypedObject(size, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onImageFormatUpdate(int imageFormat) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestUpdateProcessorImpl.DESCRIPTOR);
                    _data.writeInt(imageFormat);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CaptureStageImpl process(CameraMetadataNative result, int sequenceId) throws RemoteException {
                CaptureStageImpl _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRequestUpdateProcessorImpl.DESCRIPTOR);
                    _data.writeTypedObject(result, 0);
                    _data.writeInt(sequenceId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(CaptureStageImpl.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IRequestUpdateProcessorImpl {
        @Override
        public void onOutputSurface(Surface surface2, int imageFormat) throws RemoteException {
        }

        @Override
        public void onResolutionUpdate(Size size) throws RemoteException {
        }

        @Override
        public void onImageFormatUpdate(int imageFormat) throws RemoteException {
        }

        @Override
        public CaptureStageImpl process(CameraMetadataNative result, int sequenceId) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

