/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalHelpers;
import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.MarshalRegistry;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.utils.TypeReference;
import android.util.Log;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class MarshalQueryableArray<T>
implements MarshalQueryable<T> {
    private static final String TAG = MarshalQueryableArray.class.getSimpleName();
    private static final boolean DEBUG = false;

    static void unmarshalPrimitiveArray(Object arr, int size, ByteBuffer buffer, PrimitiveArrayFiller filler) {
        for (int i = 0; i < size; ++i) {
            filler.fillPosition(arr, i, buffer);
        }
    }

    @Override
    public Marshaler<T> createMarshaler(TypeReference<T> managedType, int nativeType) {
        return new MarshalerArray(managedType, nativeType);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<T> managedType, int nativeType) {
        return managedType.getRawType().isArray();
    }

    private class MarshalerArray
    extends Marshaler<T> {
        private final Class<T> mClass;
        private final Marshaler<?> mComponentMarshaler;
        private final Class<?> mComponentClass;

        protected MarshalerArray(TypeReference<T> typeReference, int nativeType) {
            super(MarshalQueryableArray.this, typeReference, nativeType);
            this.mClass = typeReference.getRawType();
            TypeReference<?> componentToken = typeReference.getComponentType();
            this.mComponentMarshaler = MarshalRegistry.getMarshaler(componentToken, this.mNativeType);
            this.mComponentClass = componentToken.getRawType();
        }

        @Override
        public void marshal(T value2, ByteBuffer buffer) {
            int length = Array.getLength(value2);
            for (int i = 0; i < length; ++i) {
                this.marshalArrayElement(this.mComponentMarshaler, buffer, value2, i);
            }
        }

        @Override
        public T unmarshal(ByteBuffer buffer) {
            Object array2;
            int elementSize = this.mComponentMarshaler.getNativeSize();
            if (elementSize != Marshaler.NATIVE_SIZE_DYNAMIC) {
                int remaining = buffer.remaining();
                int arraySize = remaining / elementSize;
                if (remaining % elementSize != 0) {
                    throw new UnsupportedOperationException("Arrays for " + this.mTypeReference + " must be packed tighly into a multiple of " + elementSize + "; but there are " + remaining % elementSize + " left over bytes");
                }
                array2 = Array.newInstance(this.mComponentClass, arraySize);
                if (MarshalHelpers.isUnwrappedPrimitiveClass(this.mComponentClass) && this.mComponentClass == MarshalHelpers.getPrimitiveTypeClass(this.mNativeType)) {
                    MarshalQueryableArray.unmarshalPrimitiveArray(array2, arraySize, buffer, PrimitiveArrayFiller.getPrimitiveArrayFiller(this.mComponentClass));
                } else {
                    for (int i = 0; i < arraySize; ++i) {
                        Object elem = this.mComponentMarshaler.unmarshal(buffer);
                        Array.set(array2, i, elem);
                    }
                }
            } else {
                ArrayList arrayList = new ArrayList();
                while (buffer.hasRemaining()) {
                    Object elem = this.mComponentMarshaler.unmarshal(buffer);
                    arrayList.add(elem);
                }
                int arraySize = arrayList.size();
                array2 = this.copyListToArray(arrayList, Array.newInstance(this.mComponentClass, arraySize));
            }
            if (buffer.remaining() != 0) {
                Log.e(TAG, "Trailing bytes (" + buffer.remaining() + ") left over after unpacking " + this.mClass);
            }
            return this.mClass.cast(array2);
        }

        @Override
        public int getNativeSize() {
            return NATIVE_SIZE_DYNAMIC;
        }

        @Override
        public int calculateMarshalSize(T value2) {
            int elementSize = this.mComponentMarshaler.getNativeSize();
            int arrayLength = Array.getLength(value2);
            if (elementSize != Marshaler.NATIVE_SIZE_DYNAMIC) {
                return elementSize * arrayLength;
            }
            int size = 0;
            for (int i = 0; i < arrayLength; ++i) {
                size += this.calculateElementMarshalSize(this.mComponentMarshaler, value2, i);
            }
            return size;
        }

        private <TElem> void marshalArrayElement(Marshaler<TElem> marshaler, ByteBuffer buffer, Object array2, int index) {
            marshaler.marshal(Array.get(array2, index), buffer);
        }

        private Object copyListToArray(ArrayList<?> arrayList, Object arrayDest) {
            return arrayList.toArray((Object[])arrayDest);
        }

        private <TElem> int calculateElementMarshalSize(Marshaler<TElem> marshaler, Object array2, int index) {
            Object elem = Array.get(array2, index);
            return marshaler.calculateMarshalSize(elem);
        }
    }

    private static interface PrimitiveArrayFiller {
        public void fillPosition(Object var1, int var2, ByteBuffer var3);

        public static PrimitiveArrayFiller getPrimitiveArrayFiller(Class<?> componentType) {
            if (componentType == Integer.TYPE) {
                return new PrimitiveArrayFiller(){

                    @Override
                    public void fillPosition(Object arr, int index, ByteBuffer buffer) {
                        int i = buffer.getInt();
                        Array.setInt(arr, index, i);
                    }
                };
            }
            if (componentType == Float.TYPE) {
                return new PrimitiveArrayFiller(){

                    @Override
                    public void fillPosition(Object arr, int index, ByteBuffer buffer) {
                        float i = buffer.getFloat();
                        Array.setFloat(arr, index, i);
                    }
                };
            }
            if (componentType == Long.TYPE) {
                return new PrimitiveArrayFiller(){

                    @Override
                    public void fillPosition(Object arr, int index, ByteBuffer buffer) {
                        long i = buffer.getLong();
                        Array.setLong(arr, index, i);
                    }
                };
            }
            if (componentType == Double.TYPE) {
                return new PrimitiveArrayFiller(){

                    @Override
                    public void fillPosition(Object arr, int index, ByteBuffer buffer) {
                        double i = buffer.getDouble();
                        Array.setDouble(arr, index, i);
                    }
                };
            }
            if (componentType == Byte.TYPE) {
                return new PrimitiveArrayFiller(){

                    @Override
                    public void fillPosition(Object arr, int index, ByteBuffer buffer) {
                        byte i = buffer.get();
                        Array.setByte(arr, index, i);
                    }
                };
            }
            throw new UnsupportedOperationException("PrimitiveArrayFiller of type " + componentType.getName() + " not supported");
        }
    }
}

