/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalHelpers;
import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.utils.TypeReference;
import android.util.Log;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class MarshalQueryableEnum<T extends Enum<T>>
implements MarshalQueryable<T> {
    private static final String TAG = MarshalQueryableEnum.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final int UINT8_MIN = 0;
    private static final int UINT8_MAX = 255;
    private static final int UINT8_MASK = 255;
    private static final HashMap<Class<? extends Enum>, int[]> sEnumValues = new HashMap();

    @Override
    public Marshaler<T> createMarshaler(TypeReference<T> managedType, int nativeType) {
        return new MarshalerEnum(managedType, nativeType);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<T> managedType, int nativeType) {
        Class typeClass;
        if ((nativeType == 1 || nativeType == 0) && managedType.getType() instanceof Class && (typeClass = (Class)managedType.getType()).isEnum()) {
            try {
                typeClass.getDeclaredConstructor(String.class, Integer.TYPE);
                return true;
            }
            catch (NoSuchMethodException e) {
                Log.e(TAG, "Can't marshal class " + typeClass + "; no default constructor");
            }
            catch (SecurityException e) {
                Log.e(TAG, "Can't marshal class " + typeClass + "; not accessible");
            }
        }
        return false;
    }

    public static <T extends Enum<T>> void registerEnumValues(Class<T> enumType, int[] values2) {
        if (((Enum[])enumType.getEnumConstants()).length != values2.length) {
            throw new IllegalArgumentException("Expected values array to be the same size as the enumTypes values " + values2.length + " for type " + enumType);
        }
        sEnumValues.put(enumType, values2);
    }

    private static <T extends Enum<T>> int getEnumValue(T enumValue) {
        int[] values2 = sEnumValues.get(enumValue.getClass());
        int ordinal = enumValue.ordinal();
        if (values2 != null) {
            return values2[ordinal];
        }
        return ordinal;
    }

    private static <T extends Enum<T>> T getEnumFromValue(Class<T> enumType, int value2) {
        int ordinal;
        int[] registeredValues = sEnumValues.get(enumType);
        if (registeredValues != null) {
            ordinal = -1;
            for (int i = 0; i < registeredValues.length; ++i) {
                if (registeredValues[i] != value2) continue;
                ordinal = i;
                break;
            }
        } else {
            ordinal = value2;
        }
        Enum[] values2 = (Enum[])enumType.getEnumConstants();
        if (ordinal < 0 || ordinal >= values2.length) {
            throw new IllegalArgumentException(String.format("Argument 'value' (%d) was not a valid enum value for type %s (registered? %b)", value2, enumType, registeredValues != null));
        }
        return (T)values2[ordinal];
    }

    private class MarshalerEnum
    extends Marshaler<T> {
        private final Class<T> mClass;

        protected MarshalerEnum(TypeReference<T> typeReference, int nativeType) {
            super(MarshalQueryableEnum.this, typeReference, nativeType);
            this.mClass = typeReference.getRawType();
        }

        @Override
        public void marshal(T value2, ByteBuffer buffer) {
            int enumValue = MarshalQueryableEnum.getEnumValue(value2);
            if (this.mNativeType == 1) {
                buffer.putInt(enumValue);
            } else if (this.mNativeType == 0) {
                if (enumValue < 0 || enumValue > 255) {
                    throw new UnsupportedOperationException(String.format("Enum value %x too large to fit into unsigned byte", enumValue));
                }
                buffer.put((byte)enumValue);
            } else {
                throw new AssertionError();
            }
        }

        @Override
        public T unmarshal(ByteBuffer buffer) {
            int enumValue;
            switch (this.mNativeType) {
                case 1: {
                    enumValue = buffer.getInt();
                    break;
                }
                case 0: {
                    enumValue = buffer.get() & 0xFF;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unexpected native type; impossible since its not supported");
                }
            }
            return MarshalQueryableEnum.getEnumFromValue(this.mClass, enumValue);
        }

        @Override
        public int getNativeSize() {
            return MarshalHelpers.getPrimitiveTypeSize(this.mNativeType);
        }
    }
}

