/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.utils.TypeReference;
import java.nio.ByteBuffer;

public class MarshalQueryableMeteringRectangle
implements MarshalQueryable<MeteringRectangle> {
    private static final int SIZE = 20;

    @Override
    public Marshaler<MeteringRectangle> createMarshaler(TypeReference<MeteringRectangle> managedType, int nativeType) {
        return new MarshalerMeteringRectangle(managedType, nativeType);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<MeteringRectangle> managedType, int nativeType) {
        return nativeType == 1 && MeteringRectangle.class.equals((Object)managedType.getType());
    }

    private class MarshalerMeteringRectangle
    extends Marshaler<MeteringRectangle> {
        protected MarshalerMeteringRectangle(TypeReference<MeteringRectangle> typeReference, int nativeType) {
            super(MarshalQueryableMeteringRectangle.this, typeReference, nativeType);
        }

        @Override
        public void marshal(MeteringRectangle value2, ByteBuffer buffer) {
            int xMin = value2.getX();
            int yMin = value2.getY();
            int xMax = xMin + value2.getWidth();
            int yMax = yMin + value2.getHeight();
            int weight = value2.getMeteringWeight();
            buffer.putInt(xMin);
            buffer.putInt(yMin);
            buffer.putInt(xMax);
            buffer.putInt(yMax);
            buffer.putInt(weight);
        }

        @Override
        public MeteringRectangle unmarshal(ByteBuffer buffer) {
            int xMin = buffer.getInt();
            int yMin = buffer.getInt();
            int xMax = buffer.getInt();
            int yMax = buffer.getInt();
            int weight = buffer.getInt();
            int width2 = xMax - xMin;
            int height2 = yMax - yMin;
            return new MeteringRectangle(xMin, yMin, width2, height2, weight);
        }

        @Override
        public int getNativeSize() {
            return 20;
        }
    }
}

