/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.utils.TypeReference;
import java.nio.ByteBuffer;

public class MarshalQueryableNativeByteToInteger
implements MarshalQueryable<Integer> {
    private static final int UINT8_MASK = 255;

    @Override
    public Marshaler<Integer> createMarshaler(TypeReference<Integer> managedType, int nativeType) {
        return new MarshalerNativeByteToInteger(managedType, nativeType);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<Integer> managedType, int nativeType) {
        return (Integer.class.equals((Object)managedType.getType()) || Integer.TYPE.equals(managedType.getType())) && nativeType == 0;
    }

    private class MarshalerNativeByteToInteger
    extends Marshaler<Integer> {
        protected MarshalerNativeByteToInteger(TypeReference<Integer> typeReference, int nativeType) {
            super(MarshalQueryableNativeByteToInteger.this, typeReference, nativeType);
        }

        @Override
        public void marshal(Integer value2, ByteBuffer buffer) {
            buffer.put((byte)value2.intValue());
        }

        @Override
        public Integer unmarshal(ByteBuffer buffer) {
            return buffer.get() & 0xFF;
        }

        @Override
        public int getNativeSize() {
            return 1;
        }
    }
}

