/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalHelpers;
import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.utils.TypeReference;
import android.util.Rational;
import java.nio.ByteBuffer;

public class MarshalQueryablePrimitive<T>
implements MarshalQueryable<T> {
    @Override
    public Marshaler<T> createMarshaler(TypeReference<T> managedType, int nativeType) {
        return new MarshalerPrimitive(managedType, nativeType);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<T> managedType, int nativeType) {
        if (managedType.getType() instanceof Class) {
            Class klass = (Class)managedType.getType();
            if (klass == Byte.TYPE || klass == Byte.class) {
                return nativeType == 0;
            }
            if (klass == Integer.TYPE || klass == Integer.class) {
                return nativeType == 1;
            }
            if (klass == Float.TYPE || klass == Float.class) {
                return nativeType == 2;
            }
            if (klass == Long.TYPE || klass == Long.class) {
                return nativeType == 3;
            }
            if (klass == Double.TYPE || klass == Double.class) {
                return nativeType == 4;
            }
            if (klass == Rational.class) {
                return nativeType == 5;
            }
        }
        return false;
    }

    private class MarshalerPrimitive
    extends Marshaler<T> {
        private final Class<T> mClass;

        protected MarshalerPrimitive(TypeReference<T> typeReference, int nativeType) {
            super(MarshalQueryablePrimitive.this, typeReference, nativeType);
            this.mClass = MarshalHelpers.wrapClassIfPrimitive(typeReference.getRawType());
        }

        @Override
        public T unmarshal(ByteBuffer buffer) {
            return this.mClass.cast(this.unmarshalObject(buffer));
        }

        @Override
        public int calculateMarshalSize(T value2) {
            return MarshalHelpers.getPrimitiveTypeSize(this.mNativeType);
        }

        @Override
        public void marshal(T value2, ByteBuffer buffer) {
            if (value2 instanceof Integer) {
                MarshalHelpers.checkNativeTypeEquals(1, this.mNativeType);
                int val = (Integer)value2;
                this.marshalPrimitive(val, buffer);
            } else if (value2 instanceof Float) {
                MarshalHelpers.checkNativeTypeEquals(2, this.mNativeType);
                float val = ((Float)value2).floatValue();
                this.marshalPrimitive(val, buffer);
            } else if (value2 instanceof Long) {
                MarshalHelpers.checkNativeTypeEquals(3, this.mNativeType);
                long val = (Long)value2;
                this.marshalPrimitive(val, buffer);
            } else if (value2 instanceof Rational) {
                MarshalHelpers.checkNativeTypeEquals(5, this.mNativeType);
                this.marshalPrimitive((Rational)value2, buffer);
            } else if (value2 instanceof Double) {
                MarshalHelpers.checkNativeTypeEquals(4, this.mNativeType);
                double val = (Double)value2;
                this.marshalPrimitive(val, buffer);
            } else if (value2 instanceof Byte) {
                MarshalHelpers.checkNativeTypeEquals(0, this.mNativeType);
                byte val = (Byte)value2;
                this.marshalPrimitive(val, buffer);
            } else {
                throw new UnsupportedOperationException("Can't marshal managed type " + this.mTypeReference);
            }
        }

        private void marshalPrimitive(int value2, ByteBuffer buffer) {
            buffer.putInt(value2);
        }

        private void marshalPrimitive(float value2, ByteBuffer buffer) {
            buffer.putFloat(value2);
        }

        private void marshalPrimitive(double value2, ByteBuffer buffer) {
            buffer.putDouble(value2);
        }

        private void marshalPrimitive(long value2, ByteBuffer buffer) {
            buffer.putLong(value2);
        }

        private void marshalPrimitive(Rational value2, ByteBuffer buffer) {
            buffer.putInt(value2.getNumerator());
            buffer.putInt(value2.getDenominator());
        }

        private void marshalPrimitive(byte value2, ByteBuffer buffer) {
            buffer.put(value2);
        }

        private Object unmarshalObject(ByteBuffer buffer) {
            switch (this.mNativeType) {
                case 1: {
                    return buffer.getInt();
                }
                case 2: {
                    return Float.valueOf(buffer.getFloat());
                }
                case 3: {
                    return buffer.getLong();
                }
                case 5: {
                    int numerator = buffer.getInt();
                    int denominator = buffer.getInt();
                    return new Rational(numerator, denominator);
                }
                case 4: {
                    return buffer.getDouble();
                }
                case 0: {
                    return buffer.get();
                }
            }
            throw new UnsupportedOperationException("Can't unmarshal native type " + this.mNativeType);
        }

        @Override
        public int getNativeSize() {
            return MarshalHelpers.getPrimitiveTypeSize(this.mNativeType);
        }
    }
}

