/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.params.RecommendedStreamConfiguration;
import android.hardware.camera2.utils.TypeReference;
import java.nio.ByteBuffer;

public class MarshalQueryableRecommendedStreamConfiguration
implements MarshalQueryable<RecommendedStreamConfiguration> {
    private static final int SIZE = 20;

    @Override
    public Marshaler<RecommendedStreamConfiguration> createMarshaler(TypeReference<RecommendedStreamConfiguration> managedType, int nativeType) {
        return new MarshalerRecommendedStreamConfiguration(managedType, nativeType);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<RecommendedStreamConfiguration> managedType, int nativeType) {
        return nativeType == 1 && managedType.getType().equals(RecommendedStreamConfiguration.class);
    }

    private class MarshalerRecommendedStreamConfiguration
    extends Marshaler<RecommendedStreamConfiguration> {
        protected MarshalerRecommendedStreamConfiguration(TypeReference<RecommendedStreamConfiguration> typeReference, int nativeType) {
            super(MarshalQueryableRecommendedStreamConfiguration.this, typeReference, nativeType);
        }

        @Override
        public void marshal(RecommendedStreamConfiguration value2, ByteBuffer buffer) {
            buffer.putInt(value2.getWidth());
            buffer.putInt(value2.getHeight());
            buffer.putInt(value2.getFormat());
            buffer.putInt(value2.isInput() ? 1 : 0);
            buffer.putInt(value2.getUsecaseBitmap());
        }

        @Override
        public RecommendedStreamConfiguration unmarshal(ByteBuffer buffer) {
            int width2 = buffer.getInt();
            int height2 = buffer.getInt();
            int format = buffer.getInt();
            boolean input = buffer.getInt() != 0;
            int usecaseBitmap = buffer.getInt();
            return new RecommendedStreamConfiguration(format, width2, height2, input, usecaseBitmap);
        }

        @Override
        public int getNativeSize() {
            return 20;
        }
    }
}

