/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.params.StreamConfiguration;
import android.hardware.camera2.utils.TypeReference;
import java.nio.ByteBuffer;

public class MarshalQueryableStreamConfiguration
implements MarshalQueryable<StreamConfiguration> {
    private static final int SIZE = 16;

    @Override
    public Marshaler<StreamConfiguration> createMarshaler(TypeReference<StreamConfiguration> managedType, int nativeType) {
        return new MarshalerStreamConfiguration(managedType, nativeType);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<StreamConfiguration> managedType, int nativeType) {
        return nativeType == 1 && managedType.getType().equals(StreamConfiguration.class);
    }

    private class MarshalerStreamConfiguration
    extends Marshaler<StreamConfiguration> {
        protected MarshalerStreamConfiguration(TypeReference<StreamConfiguration> typeReference, int nativeType) {
            super(MarshalQueryableStreamConfiguration.this, typeReference, nativeType);
        }

        @Override
        public void marshal(StreamConfiguration value2, ByteBuffer buffer) {
            buffer.putInt(value2.getFormat());
            buffer.putInt(value2.getWidth());
            buffer.putInt(value2.getHeight());
            buffer.putInt(value2.isInput() ? 1 : 0);
        }

        @Override
        public StreamConfiguration unmarshal(ByteBuffer buffer) {
            int format = buffer.getInt();
            int width2 = buffer.getInt();
            int height2 = buffer.getInt();
            boolean input = buffer.getInt() != 0;
            return new StreamConfiguration(format, width2, height2, input);
        }

        @Override
        public int getNativeSize() {
            return 16;
        }
    }
}

