/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class DynamicRangeProfiles {
    public static final long STANDARD = 1L;
    public static final long HLG10 = 2L;
    public static final long HDR10 = 4L;
    public static final long HDR10_PLUS = 8L;
    public static final long DOLBY_VISION_10B_HDR_REF = 16L;
    public static final long DOLBY_VISION_10B_HDR_REF_PO = 32L;
    public static final long DOLBY_VISION_10B_HDR_OEM = 64L;
    public static final long DOLBY_VISION_10B_HDR_OEM_PO = 128L;
    public static final long DOLBY_VISION_8B_HDR_REF = 256L;
    public static final long DOLBY_VISION_8B_HDR_REF_PO = 512L;
    public static final long DOLBY_VISION_8B_HDR_OEM = 1024L;
    public static final long DOLBY_VISION_8B_HDR_OEM_PO = 2048L;
    public static final long PUBLIC_MAX = 4096L;
    private final HashMap<Long, Set<Long>> mProfileMap = new HashMap();
    private final HashMap<Long, Boolean> mLookahedLatencyMap = new HashMap();

    public DynamicRangeProfiles(long[] elements) {
        if (elements.length % 3 != 0) {
            throw new IllegalArgumentException("Dynamic range profile map length " + elements.length + " is not even!");
        }
        for (int i = 0; i < elements.length; i += 3) {
            DynamicRangeProfiles.checkProfileValue(elements[i]);
            if (elements[i] == 1L) {
                throw new IllegalArgumentException("Dynamic range profile map must not include a STANDARD profile entry!");
            }
            HashSet<Long> profiles = new HashSet<Long>();
            if (elements[i + 1] != 0L) {
                for (long profile = 1L; profile < 4096L; profile <<= 1) {
                    if ((elements[i + 1] & profile) == 0L) continue;
                    profiles.add(profile);
                }
            }
            this.mProfileMap.put(elements[i], profiles);
            this.mLookahedLatencyMap.put(elements[i], elements[i + 2] != 0L);
        }
        HashSet<Long> standardConstraints = new HashSet<Long>();
        standardConstraints.add(1L);
        for (Long profile : this.mProfileMap.keySet()) {
            if (!this.mProfileMap.get(profile).isEmpty() && !this.mProfileMap.get(profile).contains(1L)) continue;
            standardConstraints.add(profile);
        }
        this.mProfileMap.put(1L, standardConstraints);
        this.mLookahedLatencyMap.put(1L, false);
    }

    public static void checkProfileValue(long profile) {
        if (profile != 1L && profile != 2L && profile != 4L && profile != 8L && profile != 16L && profile != 32L && profile != 64L && profile != 128L && profile != 256L && profile != 512L && profile != 1024L && profile != 2048L) {
            throw new IllegalArgumentException("Unknown profile " + profile);
        }
    }

    public Set<Long> getSupportedProfiles() {
        return Collections.unmodifiableSet(this.mProfileMap.keySet());
    }

    public Set<Long> getProfileCaptureRequestConstraints(long profile) {
        Set<Long> ret = this.mProfileMap.get(profile);
        if (ret == null) {
            throw new IllegalArgumentException("Unsupported profile!");
        }
        return Collections.unmodifiableSet(ret);
    }

    public boolean isExtraLatencyPresent(long profile) {
        Boolean ret = this.mLookahedLatencyMap.get(profile);
        if (ret == null) {
            throw new IllegalArgumentException("Unsupported profile!");
        }
        return ret;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Profile {
    }
}

