/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.hardware.camera2.utils.HashCodeHelpers;
import android.util.Range;
import android.util.Size;
import com.android.internal.util.Preconditions;

public class HighSpeedVideoConfiguration {
    private static final int HIGH_SPEED_MAX_MINIMAL_FPS = 120;
    private final int mWidth;
    private final int mHeight;
    private final int mFpsMin;
    private final int mFpsMax;
    private final int mBatchSizeMax;
    private final Size mSize;
    private final Range<Integer> mFpsRange;

    public HighSpeedVideoConfiguration(int width2, int height2, int fpsMin, int fpsMax, int batchSizeMax) {
        if (fpsMax < 120) {
            throw new IllegalArgumentException("fpsMax must be at least 120");
        }
        this.mFpsMax = fpsMax;
        this.mWidth = Preconditions.checkArgumentPositive(width2, "width must be positive");
        this.mHeight = Preconditions.checkArgumentPositive(height2, "height must be positive");
        this.mFpsMin = Preconditions.checkArgumentPositive(fpsMin, "fpsMin must be positive");
        this.mSize = new Size(this.mWidth, this.mHeight);
        this.mBatchSizeMax = Preconditions.checkArgumentPositive(batchSizeMax, "batchSizeMax must be positive");
        this.mFpsRange = new Range<Integer>(this.mFpsMin, this.mFpsMax);
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public int getFpsMin() {
        return this.mFpsMin;
    }

    public int getFpsMax() {
        return this.mFpsMax;
    }

    public Size getSize() {
        return this.mSize;
    }

    public int getBatchSizeMax() {
        return this.mBatchSizeMax;
    }

    public Range<Integer> getFpsRange() {
        return this.mFpsRange;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof HighSpeedVideoConfiguration) {
            HighSpeedVideoConfiguration other = (HighSpeedVideoConfiguration)obj;
            return this.mWidth == other.mWidth && this.mHeight == other.mHeight && this.mFpsMin == other.mFpsMin && this.mFpsMax == other.mFpsMax && this.mBatchSizeMax == other.mBatchSizeMax;
        }
        return false;
    }

    public int hashCode() {
        return HashCodeHelpers.hashCode(this.mWidth, this.mHeight, this.mFpsMin, this.mFpsMax);
    }
}

