/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.utils.HashCodeHelpers;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.util.Log;
import android.util.Pair;
import android.util.Size;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class MandatoryStreamCombination {
    private static final String TAG = "MandatoryStreamCombination";
    private final String mDescription;
    private final boolean mIsReprocessable;
    private final ArrayList<MandatoryStreamInformation> mStreamsInformation = new ArrayList();
    private static final long STREAM_USE_CASE_PREVIEW = 1L;
    private static final long STREAM_USE_CASE_STILL_CAPTURE = 2L;
    private static final long STREAM_USE_CASE_RECORD = 3L;
    private static final long STREAM_USE_CASE_PREVIEW_VIDEO_STILL = 4L;
    private static final long STREAM_USE_CASE_VIDEO_CALL = 5L;
    private static StreamCombinationTemplate[] sLegacyCombinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.MAXIMUM)}, "Simple preview, GPU video processing, or no-preview video recording"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(256, SizeThreshold.MAXIMUM)}, "No-viewfinder still image capture"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.MAXIMUM)}, "In-application video/image processing"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(256, SizeThreshold.MAXIMUM)}, "Standard still imaging"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(256, SizeThreshold.MAXIMUM)}, "In-app processing plus still capture"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(34, SizeThreshold.PREVIEW)}, "Standard recording"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.PREVIEW)}, "Preview plus in-app processing"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(256, SizeThreshold.MAXIMUM)}, "Still capture plus in-app processing")};
    private static StreamCombinationTemplate[] sLimitedCombinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(34, SizeThreshold.RECORD)}, "High-resolution video recording with preview"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.RECORD)}, "High-resolution in-app video processing with preview"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.RECORD)}, "Two-input in-app video processing"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(34, SizeThreshold.RECORD), new StreamTemplate(256, SizeThreshold.RECORD)}, "High-resolution recording with video snapshot"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.RECORD), new StreamTemplate(256, SizeThreshold.RECORD)}, "High-resolution in-app processing with video snapshot"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(256, SizeThreshold.MAXIMUM)}, "Two-input in-app processing with still capture")};
    private static StreamCombinationTemplate[] sBurstCombinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(34, SizeThreshold.MAXIMUM)}, "Maximum-resolution GPU processing with preview"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.MAXIMUM)}, "Maximum-resolution in-app processing with preview"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.MAXIMUM)}, "Maximum-resolution two-input in-app processsing")};
    private static StreamCombinationTemplate[] sFullCombinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.MAXIMUM), new StreamTemplate(34, SizeThreshold.MAXIMUM)}, "Maximum-resolution GPU processing with preview"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.MAXIMUM), new StreamTemplate(35, SizeThreshold.MAXIMUM)}, "Maximum-resolution in-app processing with preview"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.MAXIMUM), new StreamTemplate(35, SizeThreshold.MAXIMUM)}, "Maximum-resolution two-input in-app processsing"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(256, SizeThreshold.MAXIMUM)}, "Video recording with maximum-size video snapshot"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.VGA), new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.MAXIMUM)}, "Standard video recording plus maximum-resolution in-app processing"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.VGA), new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.MAXIMUM)}, "Preview plus two-input maximum-resolution in-app processing")};
    private static StreamCombinationTemplate[] sRawCombinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(32, SizeThreshold.MAXIMUM)}, "No-preview DNG capture"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(32, SizeThreshold.MAXIMUM)}, "Standard DNG capture"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(32, SizeThreshold.MAXIMUM)}, "In-app processing plus DNG capture"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(32, SizeThreshold.MAXIMUM)}, "Video recording with DNG capture"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(32, SizeThreshold.MAXIMUM)}, "Preview with in-app processing and DNG capture"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(32, SizeThreshold.MAXIMUM)}, "Two-input in-app processing plus DNG capture"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(256, SizeThreshold.MAXIMUM), new StreamTemplate(32, SizeThreshold.MAXIMUM)}, "Still capture with simultaneous JPEG and DNG"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(256, SizeThreshold.MAXIMUM), new StreamTemplate(32, SizeThreshold.MAXIMUM)}, "In-app processing with simultaneous JPEG and DNG")};
    private static StreamCombinationTemplate[] sLevel3Combinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(34, SizeThreshold.VGA), new StreamTemplate(35, SizeThreshold.MAXIMUM), new StreamTemplate(32, SizeThreshold.MAXIMUM)}, "In-app viewfinder analysis with dynamic selection of output format"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(34, SizeThreshold.VGA), new StreamTemplate(256, SizeThreshold.MAXIMUM), new StreamTemplate(32, SizeThreshold.MAXIMUM)}, "In-app viewfinder analysis with dynamic selection of output format")};
    private static StreamCombinationTemplate[] sLimitedPrivateReprocCombinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(256, SizeThreshold.MAXIMUM)}, "No-viewfinder still image reprocessing", ReprocessType.PRIVATE), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(256, SizeThreshold.MAXIMUM)}, "ZSL(Zero-Shutter-Lag) still imaging", ReprocessType.PRIVATE), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(256, SizeThreshold.MAXIMUM)}, "ZSL still and in-app processing imaging", ReprocessType.PRIVATE), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(256, SizeThreshold.MAXIMUM)}, "ZSL in-app processing with still capture", ReprocessType.PRIVATE)};
    private static StreamCombinationTemplate[] sLimitedYUVReprocCombinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(256, SizeThreshold.MAXIMUM)}, "No-viewfinder still image reprocessing", ReprocessType.YUV), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(256, SizeThreshold.MAXIMUM)}, "ZSL(Zero-Shutter-Lag) still imaging", ReprocessType.YUV), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(256, SizeThreshold.MAXIMUM)}, "ZSL still and in-app processing imaging", ReprocessType.YUV), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(256, SizeThreshold.MAXIMUM)}, "ZSL in-app processing with still capture", ReprocessType.YUV)};
    private static StreamCombinationTemplate[] sFullPrivateReprocCombinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.RECORD)}, "High-resolution ZSL in-app video processing with regular preview", ReprocessType.PRIVATE), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.MAXIMUM)}, "Maximum-resolution ZSL in-app processing with regular preview", ReprocessType.PRIVATE), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.MAXIMUM)}, "Maximum-resolution two-input ZSL in-app processing", ReprocessType.PRIVATE), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(256, SizeThreshold.MAXIMUM)}, "ZSL still capture and in-app processing", ReprocessType.PRIVATE)};
    private static StreamCombinationTemplate[] sFullYUVReprocCombinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW)}, "Maximum-resolution multi-frame image fusion in-app processing with regular preview", ReprocessType.YUV), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.PREVIEW)}, "Maximum-resolution multi-frame image fusion two-input in-app processing", ReprocessType.YUV), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.RECORD)}, "High-resolution ZSL in-app video processing with regular preview", ReprocessType.YUV), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(256, SizeThreshold.MAXIMUM)}, "ZSL still capture and in-app processing", ReprocessType.YUV)};
    private static StreamCombinationTemplate[] sRAWPrivateReprocCombinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(32, SizeThreshold.MAXIMUM)}, "Mutually exclusive ZSL in-app processing and DNG capture", ReprocessType.PRIVATE), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(32, SizeThreshold.MAXIMUM)}, "Mutually exclusive ZSL in-app processing and preview with DNG capture", ReprocessType.PRIVATE), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(32, SizeThreshold.MAXIMUM)}, "Mutually exclusive ZSL two-input in-app processing and DNG capture", ReprocessType.PRIVATE), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(256, SizeThreshold.MAXIMUM), new StreamTemplate(32, SizeThreshold.MAXIMUM)}, "Mutually exclusive ZSL still capture and preview with DNG capture", ReprocessType.PRIVATE), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(256, SizeThreshold.MAXIMUM), new StreamTemplate(32, SizeThreshold.MAXIMUM)}, "Mutually exclusive ZSL in-app processing with still capture and DNG capture", ReprocessType.PRIVATE)};
    private static StreamCombinationTemplate[] sRAWYUVReprocCombinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(32, SizeThreshold.MAXIMUM)}, "Mutually exclusive ZSL in-app processing and DNG capture", ReprocessType.YUV), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(32, SizeThreshold.MAXIMUM)}, "Mutually exclusive ZSL in-app processing and preview with DNG capture", ReprocessType.YUV), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(32, SizeThreshold.MAXIMUM)}, "Mutually exclusive ZSL two-input in-app processing and DNG capture", ReprocessType.YUV), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(256, SizeThreshold.MAXIMUM), new StreamTemplate(32, SizeThreshold.MAXIMUM)}, "Mutually exclusive ZSL still capture and preview with DNG capture", ReprocessType.YUV), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.PREVIEW), new StreamTemplate(256, SizeThreshold.MAXIMUM), new StreamTemplate(32, SizeThreshold.MAXIMUM)}, "Mutually exclusive ZSL in-app processing with still capture and DNG capture", ReprocessType.YUV)};
    private static StreamCombinationTemplate[] sLevel3PrivateReprocCombinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(34, SizeThreshold.VGA), new StreamTemplate(32, SizeThreshold.MAXIMUM), new StreamTemplate(256, SizeThreshold.MAXIMUM)}, "In-app viewfinder analysis with ZSL, RAW, and JPEG reprocessing output", ReprocessType.PRIVATE)};
    private static StreamCombinationTemplate[] sLevel3YUVReprocCombinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(34, SizeThreshold.VGA), new StreamTemplate(32, SizeThreshold.MAXIMUM)}, "In-app viewfinder analysis with ZSL and RAW", ReprocessType.YUV), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(34, SizeThreshold.VGA), new StreamTemplate(32, SizeThreshold.MAXIMUM), new StreamTemplate(256, SizeThreshold.MAXIMUM)}, "In-app viewfinder analysis with ZSL, RAW, and JPEG reprocessing output", ReprocessType.YUV)};
    private static StreamCombinationTemplate[] sConcurrentStreamCombinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.s1440p)}, "In-app video / image processing"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.s1440p)}, "preview / preview to GPU"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(256, SizeThreshold.s1440p)}, "No view-finder still image capture"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.s720p), new StreamTemplate(35, SizeThreshold.s1440p)}, "Two-input in app video / image processing"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.s720p), new StreamTemplate(34, SizeThreshold.s1440p)}, "High resolution video recording with preview"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.s720p), new StreamTemplate(35, SizeThreshold.s1440p)}, "In-app video / image processing with preview"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.s720p), new StreamTemplate(34, SizeThreshold.s1440p)}, "In-app video / image processing with preview"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.s720p), new StreamTemplate(256, SizeThreshold.s1440p)}, "Standard stil image capture"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.s720p), new StreamTemplate(256, SizeThreshold.s1440p)}, "Standard still image capture")};
    private static StreamCombinationTemplate[] sConcurrentDepthOnlyStreamCombinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(1144402265, SizeThreshold.VGA)}, "Depth capture for mesh based object rendering")};
    private static StreamCombinationTemplate[] sUltraHighResolutionStreamCombinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.FULL_RES), new StreamTemplate(34, SizeThreshold.PREVIEW)}, "Ultra high resolution YUV image capture with preview"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(32, SizeThreshold.FULL_RES), new StreamTemplate(34, SizeThreshold.PREVIEW)}, "Ultra high resolution RAW_SENSOR image capture with preview"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(256, SizeThreshold.FULL_RES), new StreamTemplate(34, SizeThreshold.PREVIEW)}, "Ultra high resolution JPEG image capture with preview"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.FULL_RES), new StreamTemplate(34, SizeThreshold.PREVIEW)}, "No-viewfinder Ultra high resolution YUV image capture with image analysis"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(32, SizeThreshold.FULL_RES), new StreamTemplate(34, SizeThreshold.PREVIEW)}, "No-viewfinder Ultra high resolution RAW_SENSOR image capture with image analysis"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(256, SizeThreshold.FULL_RES), new StreamTemplate(34, SizeThreshold.PREVIEW)}, "No-viewfinder Ultra high resolution JPEG image capture with image analysis"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.FULL_RES), new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(34, SizeThreshold.RECORD)}, "Ultra high resolution YUV image capture with preview + app-based image analysis"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(32, SizeThreshold.FULL_RES), new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(34, SizeThreshold.RECORD)}, "Ultra high resolution RAW image capture with preview + app-based image analysis"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(256, SizeThreshold.FULL_RES), new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(34, SizeThreshold.RECORD)}, "Ultra high resolution JPEG image capture with preview + app-based image analysis"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.FULL_RES), new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.RECORD)}, "Ultra high resolution YUV image capture with preview + app-based image analysis"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(32, SizeThreshold.FULL_RES), new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.RECORD)}, "Ultra high resolution RAW image capture with preview + app-based image analysis"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(256, SizeThreshold.FULL_RES), new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.RECORD)}, "Ultra high resolution JPEG image capture with preview + app-based image analysis"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.FULL_RES), new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.MAXIMUM)}, "Ultra high resolution YUV image capture with preview + default", true), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(32, SizeThreshold.FULL_RES), new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.MAXIMUM)}, "Ultra high resolution RAW image capture with preview + default", true), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(256, SizeThreshold.FULL_RES), new StreamTemplate(34, SizeThreshold.PREVIEW), new StreamTemplate(35, SizeThreshold.MAXIMUM)}, "Ultra high resolution JPEG capture with preview + default", true)};
    private static StreamCombinationTemplate[] sUltraHighResolutionReprocStreamCombinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW)}, "In-app RAW remosaic reprocessing with separate preview", ReprocessType.REMOSAIC), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.PREVIEW)}, "In-app RAW remosaic reprocessing with in-app image analysis", ReprocessType.REMOSAIC), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(256, SizeThreshold.FULL_RES), new StreamTemplate(34, SizeThreshold.PREVIEW)}, "In-app RAW -> JPEG reprocessing with separate preview", ReprocessType.REMOSAIC), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.FULL_RES), new StreamTemplate(34, SizeThreshold.PREVIEW)}, "In-app RAW -> YUV reprocessing with separate preview", ReprocessType.REMOSAIC), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(256, SizeThreshold.FULL_RES), new StreamTemplate(35, SizeThreshold.PREVIEW)}, "In-app RAW -> JPEG reprocessing with in-app image analysis", ReprocessType.REMOSAIC), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.FULL_RES), new StreamTemplate(35, SizeThreshold.PREVIEW)}, "In-app RAW -> YUV reprocessing with in-app image analysis", ReprocessType.REMOSAIC)};
    private static StreamCombinationTemplate[] sUltraHighResolutionYUVReprocStreamCombinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(256, SizeThreshold.FULL_RES), new StreamTemplate(34, SizeThreshold.PREVIEW)}, "Ultra high resolution YUV -> JPEG reprocessing with separate preview", ReprocessType.YUV), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(256, SizeThreshold.FULL_RES), new StreamTemplate(35, SizeThreshold.PREVIEW)}, "Ultra high resolution YUV -> JPEG reprocessing with in-app image analysis", ReprocessType.YUV), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.FULL_RES), new StreamTemplate(34, SizeThreshold.PREVIEW)}, "Ultra high resolution YUV -> YUV reprocessing with separate preview", ReprocessType.YUV), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.FULL_RES), new StreamTemplate(35, SizeThreshold.PREVIEW)}, "Ultra high resolution YUV -> YUV reprocessing with in-app image analysis", ReprocessType.YUV)};
    private static StreamCombinationTemplate[] sUltraHighResolutionPRIVReprocStreamCombinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(256, SizeThreshold.FULL_RES), new StreamTemplate(34, SizeThreshold.PREVIEW)}, "Ultra high resolution PRIVATE -> JPEG reprocessing with separate preview", ReprocessType.PRIVATE), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(256, SizeThreshold.FULL_RES), new StreamTemplate(35, SizeThreshold.PREVIEW)}, "Ultra high resolution PRIVATE -> JPEG reprocessing with in-app image analysis", ReprocessType.PRIVATE)};
    private static StreamCombinationTemplate[] s10BitOutputStreamCombinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.MAXIMUM)}, "Simple preview, GPU video processing, or no-preview video recording"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(54, SizeThreshold.MAXIMUM)}, "In-application video/image processing"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(256, SizeThreshold.MAXIMUM), new StreamTemplate(34, SizeThreshold.PREVIEW)}, "Standard still imaging"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(54, SizeThreshold.MAXIMUM), new StreamTemplate(34, SizeThreshold.PREVIEW)}, "Maximum-resolution in-app processing with preview"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(54, SizeThreshold.MAXIMUM), new StreamTemplate(54, SizeThreshold.PREVIEW)}, "Maximum-resolution two-input in-app processing"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.RECORD), new StreamTemplate(34, SizeThreshold.PREVIEW)}, "High-resolution video recording with preview"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(54, SizeThreshold.RECORD), new StreamTemplate(34, SizeThreshold.RECORD), new StreamTemplate(34, SizeThreshold.PREVIEW)}, "High-resolution recording with in-app snapshot"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(256, SizeThreshold.RECORD), new StreamTemplate(34, SizeThreshold.RECORD), new StreamTemplate(34, SizeThreshold.PREVIEW)}, "High-resolution recording with video snapshot")};
    private static StreamCombinationTemplate[] sStreamUseCaseCombinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW, 1L)}, "Simple preview"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.PREVIEW, 1L)}, "Simple in-application image processing"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.RECORD, 3L)}, "Simple video recording"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.RECORD, 3L)}, "Simple in-application video processing"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(256, SizeThreshold.MAXIMUM, 2L)}, "Simple JPEG still capture"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.MAXIMUM, 2L)}, "Simple YUV still capture"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.s1440p, 4L)}, "Multi-purpose stream for preview, video and still capture"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.s1440p, 4L)}, "Multi-purpose YUV stream for preview, video and still capture"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.s1440p, 5L)}, "Simple video call"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.s1440p, 5L)}, "Simple YUV video call"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW, 1L), new StreamTemplate(256, SizeThreshold.MAXIMUM, 2L)}, "Preview with JPEG still image capture"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW, 1L), new StreamTemplate(35, SizeThreshold.MAXIMUM, 2L)}, "Preview with YUV still image capture"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW, 1L), new StreamTemplate(34, SizeThreshold.RECORD, 3L)}, "Preview with video recording"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW, 1L), new StreamTemplate(35, SizeThreshold.RECORD, 3L)}, "Preview with in-application video processing"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW, 1L), new StreamTemplate(35, SizeThreshold.PREVIEW, 1L)}, "Preview with in-application image processing"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW, 1L), new StreamTemplate(34, SizeThreshold.s1440p, 5L)}, "Preview with video call"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW, 1L), new StreamTemplate(35, SizeThreshold.s1440p, 5L)}, "Preview with YUV video call"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.s1440p, 4L), new StreamTemplate(256, SizeThreshold.MAXIMUM, 2L)}, "Multi-purpose stream with JPEG still capture"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.s1440p, 4L), new StreamTemplate(35, SizeThreshold.MAXIMUM, 2L)}, "Multi-purpose stream with YUV still capture"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.s1440p, 4L), new StreamTemplate(256, SizeThreshold.MAXIMUM, 2L)}, "Multi-purpose YUV stream with JPEG still capture"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.s1440p, 4L), new StreamTemplate(35, SizeThreshold.MAXIMUM, 2L)}, "Multi-purpose YUV stream with YUV still capture"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.PREVIEW, 2L), new StreamTemplate(256, SizeThreshold.MAXIMUM, 2L)}, "YUV and JPEG concurrent still image capture (for testing)"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW, 1L), new StreamTemplate(34, SizeThreshold.RECORD, 3L), new StreamTemplate(256, SizeThreshold.RECORD, 2L)}, "Preview, video record and JPEG video snapshot"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW, 1L), new StreamTemplate(34, SizeThreshold.RECORD, 3L), new StreamTemplate(35, SizeThreshold.RECORD, 2L)}, "Preview, video record and YUV video snapshot"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW, 1L), new StreamTemplate(35, SizeThreshold.RECORD, 3L), new StreamTemplate(256, SizeThreshold.RECORD, 2L)}, "Preview, in-application video processing and JPEG video snapshot"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW, 1L), new StreamTemplate(35, SizeThreshold.RECORD, 3L), new StreamTemplate(35, SizeThreshold.RECORD, 2L)}, "Preview, in-application video processing and YUV video snapshot"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW, 1L), new StreamTemplate(35, SizeThreshold.PREVIEW, 1L), new StreamTemplate(256, SizeThreshold.MAXIMUM, 2L)}, "Preview, in-application image processing, and JPEG still image capture"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.PREVIEW, 1L), new StreamTemplate(35, SizeThreshold.PREVIEW, 1L), new StreamTemplate(35, SizeThreshold.MAXIMUM, 2L)}, "Preview, in-application image processing, and YUV still image capture")};
    private static StreamCombinationTemplate[] sPreviewStabilizedStreamCombinations = new StreamCombinationTemplate[]{new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.s1440p)}, "Stabilized preview, GPU video processing, or no-preview stabilized recording"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.s1440p)}, "Stabilized preview, GPU video processing, or no-preview stabilized recording"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(256, SizeThreshold.MAXIMUM), new StreamTemplate(34, SizeThreshold.s1440p)}, "Standard JPEG still imaging with stabilized preview"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.MAXIMUM), new StreamTemplate(34, SizeThreshold.s1440p)}, "Standard YUV still imaging with stabilized preview"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.MAXIMUM), new StreamTemplate(35, SizeThreshold.s1440p)}, "Standard YUV still imaging with stabilized in-app image processing stream"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(256, SizeThreshold.MAXIMUM), new StreamTemplate(35, SizeThreshold.s1440p)}, "Standard JPEG still imaging with stabilized in-app image processing stream"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.s1440p), new StreamTemplate(34, SizeThreshold.PREVIEW)}, "High-resolution video recording with preview both streams stabilized"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(34, SizeThreshold.s1440p), new StreamTemplate(35, SizeThreshold.PREVIEW)}, "High-resolution video recording with preview both streams stabilized"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.s1440p), new StreamTemplate(35, SizeThreshold.PREVIEW)}, "High-resolution video recording with preview both streams stabilized"), new StreamCombinationTemplate(new StreamTemplate[]{new StreamTemplate(35, SizeThreshold.s1440p), new StreamTemplate(34, SizeThreshold.PREVIEW)}, "High-resolution video recording with preview both streams stabilized")};

    public MandatoryStreamCombination(List<MandatoryStreamInformation> streamsInformation, String description, boolean isReprocessable) {
        if (streamsInformation.isEmpty()) {
            throw new IllegalArgumentException("Empty stream information");
        }
        this.mStreamsInformation.addAll(streamsInformation);
        this.mDescription = description;
        this.mIsReprocessable = isReprocessable;
    }

    public CharSequence getDescription() {
        return this.mDescription;
    }

    public boolean isReprocessable() {
        return this.mIsReprocessable;
    }

    public List<MandatoryStreamInformation> getStreamsInformation() {
        return Collections.unmodifiableList(this.mStreamsInformation);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof MandatoryStreamCombination) {
            MandatoryStreamCombination other = (MandatoryStreamCombination)obj;
            if (this.mDescription != other.mDescription || this.mIsReprocessable != other.mIsReprocessable || this.mStreamsInformation.size() != other.mStreamsInformation.size()) {
                return false;
            }
            return this.mStreamsInformation.equals(other.mStreamsInformation);
        }
        return false;
    }

    public int hashCode() {
        return HashCodeHelpers.hashCode(Boolean.hashCode(this.mIsReprocessable), this.mDescription.hashCode(), this.mStreamsInformation.hashCode());
    }

    public static class Builder {
        private Size mDisplaySize;
        private List<Integer> mCapabilities;
        private int mHwLevel;
        private int mCameraId;
        private StreamConfigurationMap mStreamConfigMap;
        private StreamConfigurationMap mStreamConfigMapMaximumResolution;
        private boolean mIsHiddenPhysicalCamera;
        private boolean mIsPreviewStabilizationSupported;
        private final Size kPreviewSizeBound = new Size(1920, 1088);

        public Builder(int cameraId, int hwLevel, Size displaySize, List<Integer> capabilities, StreamConfigurationMap sm, StreamConfigurationMap smMaxResolution, boolean previewStabilization) {
            this.mCameraId = cameraId;
            this.mDisplaySize = displaySize;
            this.mCapabilities = capabilities;
            this.mStreamConfigMap = sm;
            this.mStreamConfigMapMaximumResolution = smMaxResolution;
            this.mHwLevel = hwLevel;
            this.mIsHiddenPhysicalCamera = CameraManager.isHiddenPhysicalCamera(Integer.toString(this.mCameraId));
            this.mIsPreviewStabilizationSupported = previewStabilization;
        }

        private List<MandatoryStreamCombination> getAvailableMandatoryStreamCombinationsInternal(StreamCombinationTemplate[] chosenStreamCombinations, boolean s10Bit) {
            HashMap<Pair<SizeThreshold, Integer>, List<Size>> availableSizes = this.enumerateAvailableSizes();
            if (availableSizes == null) {
                Log.e(MandatoryStreamCombination.TAG, "Available size enumeration failed!");
                return null;
            }
            ArrayList<MandatoryStreamCombination> availableStreamCombinations = new ArrayList<MandatoryStreamCombination>();
            availableStreamCombinations.ensureCapacity(chosenStreamCombinations.length);
            for (StreamCombinationTemplate combTemplate : chosenStreamCombinations) {
                MandatoryStreamCombination streamCombination;
                ArrayList<MandatoryStreamInformation> streamsInfo = new ArrayList<MandatoryStreamInformation>();
                streamsInfo.ensureCapacity(combTemplate.mStreamTemplates.length);
                for (StreamTemplate template : combTemplate.mStreamTemplates) {
                    MandatoryStreamInformation streamInfo;
                    HashSet sdrYuvSizes;
                    List<Size> sizes = null;
                    Pair<SizeThreshold, Integer> pair = new Pair<SizeThreshold, Integer>(template.mSizeThreshold, new Integer(template.mFormat));
                    sizes = availableSizes.get(pair);
                    if (s10Bit && template.mFormat == 54 && !(sdrYuvSizes = new HashSet(availableSizes.get(pair = new Pair<SizeThreshold, Integer>(template.mSizeThreshold, new Integer(35))))).equals(new HashSet<Size>(sizes))) {
                        Log.e(MandatoryStreamCombination.TAG, "The supported 10-bit YUV sizes are different from the supported 8-bit YUV sizes!");
                        return null;
                    }
                    boolean isMaximumSize = template.mSizeThreshold == SizeThreshold.MAXIMUM;
                    try {
                        streamInfo = new MandatoryStreamInformation(sizes, template.mFormat, isMaximumSize, false, false, s10Bit ? template.mFormat != 256 : false);
                    }
                    catch (IllegalArgumentException e) {
                        Log.e(MandatoryStreamCombination.TAG, "No available sizes found for format: " + template.mFormat + " size threshold: " + (Object)((Object)template.mSizeThreshold) + " combination: " + combTemplate.mDescription);
                        return null;
                    }
                    streamsInfo.add(streamInfo);
                }
                try {
                    streamCombination = new MandatoryStreamCombination(streamsInfo, combTemplate.mDescription, false);
                }
                catch (IllegalArgumentException e) {
                    Log.e(MandatoryStreamCombination.TAG, "No stream information for mandatory combination: " + combTemplate.mDescription);
                    return null;
                }
                availableStreamCombinations.add(streamCombination);
            }
            return Collections.unmodifiableList(availableStreamCombinations);
        }

        public List<MandatoryStreamCombination> getAvailableMandatoryPreviewStabilizedStreamCombinations() {
            StreamCombinationTemplate[] chosenStreamCombinations = sPreviewStabilizedStreamCombinations;
            if (!this.mIsPreviewStabilizationSupported) {
                Log.v(MandatoryStreamCombination.TAG, "Device does not support preview stabilization");
                return null;
            }
            return this.getAvailableMandatoryStreamCombinationsInternal(chosenStreamCombinations, false);
        }

        public List<MandatoryStreamCombination> getAvailableMandatory10BitStreamCombinations() {
            StreamCombinationTemplate[] chosenStreamCombinations = s10BitOutputStreamCombinations;
            if (!this.is10BitOutputSupported()) {
                Log.v(MandatoryStreamCombination.TAG, "Device is not able to output 10-bit!");
                return null;
            }
            return this.getAvailableMandatoryStreamCombinationsInternal(chosenStreamCombinations, true);
        }

        public List<MandatoryStreamCombination> getAvailableMandatoryStreamUseCaseCombinations() {
            if (!this.isCapabilitySupported(19)) {
                return null;
            }
            HashMap<Pair<SizeThreshold, Integer>, List<Size>> availableSizes = this.enumerateAvailableSizes();
            if (availableSizes == null) {
                Log.e(MandatoryStreamCombination.TAG, "Available size enumeration failed!");
                return null;
            }
            ArrayList<MandatoryStreamCombination> availableStreamCombinations = new ArrayList<MandatoryStreamCombination>();
            availableStreamCombinations.ensureCapacity(sStreamUseCaseCombinations.length);
            for (StreamCombinationTemplate combTemplate : sStreamUseCaseCombinations) {
                MandatoryStreamCombination streamCombination;
                ArrayList<MandatoryStreamInformation> streamsInfo = new ArrayList<MandatoryStreamInformation>();
                streamsInfo.ensureCapacity(combTemplate.mStreamTemplates.length);
                for (StreamTemplate template : combTemplate.mStreamTemplates) {
                    MandatoryStreamInformation streamInfo;
                    List<Size> sizes = null;
                    Pair<SizeThreshold, Integer> pair = new Pair<SizeThreshold, Integer>(template.mSizeThreshold, new Integer(template.mFormat));
                    sizes = availableSizes.get(pair);
                    boolean isMaximumSize = template.mSizeThreshold == SizeThreshold.MAXIMUM;
                    try {
                        streamInfo = new MandatoryStreamInformation(sizes, template.mFormat, isMaximumSize, false, false, false, template.mStreamUseCase);
                    }
                    catch (IllegalArgumentException e) {
                        Log.e(MandatoryStreamCombination.TAG, "No available sizes found for format: " + template.mFormat + " size threshold: " + (Object)((Object)template.mSizeThreshold) + " combination: " + combTemplate.mDescription);
                        return null;
                    }
                    streamsInfo.add(streamInfo);
                }
                try {
                    streamCombination = new MandatoryStreamCombination(streamsInfo, combTemplate.mDescription, false);
                }
                catch (IllegalArgumentException e) {
                    Log.e(MandatoryStreamCombination.TAG, "No stream information for mandatory combination: " + combTemplate.mDescription);
                    return null;
                }
                availableStreamCombinations.add(streamCombination);
            }
            return Collections.unmodifiableList(availableStreamCombinations);
        }

        public List<MandatoryStreamCombination> getAvailableMandatoryConcurrentStreamCombinations() {
            StreamCombinationTemplate[] chosenStreamCombinations = sConcurrentStreamCombinations;
            if (!this.isColorOutputSupported()) {
                Log.v(MandatoryStreamCombination.TAG, "Device is not backward compatible, depth streams are mandatory!");
                chosenStreamCombinations = sConcurrentDepthOnlyStreamCombinations;
            }
            Size sizeVGAp = new Size(640, 480);
            Size size720p = new Size(1280, 720);
            Size size1440p = new Size(1920, 1440);
            ArrayList<MandatoryStreamCombination> availableConcurrentStreamCombinations = new ArrayList<MandatoryStreamCombination>();
            availableConcurrentStreamCombinations.ensureCapacity(chosenStreamCombinations.length);
            for (StreamCombinationTemplate combTemplate : chosenStreamCombinations) {
                MandatoryStreamCombination streamCombination;
                ArrayList<MandatoryStreamInformation> streamsInfo = new ArrayList<MandatoryStreamInformation>();
                streamsInfo.ensureCapacity(combTemplate.mStreamTemplates.length);
                for (StreamTemplate template : combTemplate.mStreamTemplates) {
                    MandatoryStreamInformation streamInfo;
                    ArrayList<Size> sizes = new ArrayList<Size>();
                    Size formatSize = null;
                    switch (template.mSizeThreshold) {
                        case s1440p: {
                            formatSize = size1440p;
                            break;
                        }
                        case VGA: {
                            formatSize = sizeVGAp;
                            break;
                        }
                        default: {
                            formatSize = size720p;
                        }
                    }
                    Size sizeChosen = Builder.getMinSize(formatSize, Builder.getMaxSize(this.mStreamConfigMap.getOutputSizes(template.mFormat)));
                    sizes.add(sizeChosen);
                    try {
                        streamInfo = new MandatoryStreamInformation(sizes, template.mFormat, false);
                    }
                    catch (IllegalArgumentException e) {
                        String cause = "No available sizes found for format: " + template.mFormat + " size threshold: " + (Object)((Object)template.mSizeThreshold) + " combination: " + combTemplate.mDescription;
                        throw new RuntimeException(cause, e);
                    }
                    streamsInfo.add(streamInfo);
                }
                try {
                    streamCombination = new MandatoryStreamCombination(streamsInfo, combTemplate.mDescription, false);
                }
                catch (IllegalArgumentException e) {
                    String cause = "No stream information for mandatory combination: " + combTemplate.mDescription;
                    throw new RuntimeException(cause, e);
                }
                availableConcurrentStreamCombinations.add(streamCombination);
            }
            return Collections.unmodifiableList(availableConcurrentStreamCombinations);
        }

        public List<MandatoryStreamCombination> getAvailableMandatoryMaximumResolutionStreamCombinations() {
            if (!this.isColorOutputSupported()) {
                Log.v(MandatoryStreamCombination.TAG, "Device is not backward compatible!, no mandatory maximum res streams");
                return null;
            }
            ArrayList<StreamCombinationTemplate> chosenStreamCombinationTemplates = new ArrayList<StreamCombinationTemplate>();
            chosenStreamCombinationTemplates.addAll(Arrays.asList(sUltraHighResolutionStreamCombinations));
            ArrayList<MandatoryStreamCombination> availableStreamCombinations = new ArrayList<MandatoryStreamCombination>();
            boolean addRemosaicReprocessing = this.isRemosaicReprocessingSupported();
            int remosaicSize = 0;
            Size[] maxResYUVInputSizes = this.mStreamConfigMapMaximumResolution.getInputSizes(35);
            Size[] maxResPRIVInputSizes = this.mStreamConfigMapMaximumResolution.getInputSizes(34);
            if (addRemosaicReprocessing) {
                remosaicSize += sUltraHighResolutionReprocStreamCombinations.length;
                chosenStreamCombinationTemplates.addAll(Arrays.asList(sUltraHighResolutionReprocStreamCombinations));
            }
            if (maxResYUVInputSizes != null && maxResYUVInputSizes.length != 0) {
                remosaicSize += sUltraHighResolutionYUVReprocStreamCombinations.length;
                chosenStreamCombinationTemplates.addAll(Arrays.asList(sUltraHighResolutionYUVReprocStreamCombinations));
            }
            if (maxResPRIVInputSizes != null && maxResPRIVInputSizes.length != 0) {
                remosaicSize += sUltraHighResolutionPRIVReprocStreamCombinations.length;
                chosenStreamCombinationTemplates.addAll(Arrays.asList(sUltraHighResolutionPRIVReprocStreamCombinations));
            }
            availableStreamCombinations.ensureCapacity(chosenStreamCombinationTemplates.size() + remosaicSize);
            this.fillUHMandatoryStreamCombinations(availableStreamCombinations, chosenStreamCombinationTemplates);
            return Collections.unmodifiableList(availableStreamCombinations);
        }

        private MandatoryStreamCombination createUHSensorMandatoryStreamCombination(StreamCombinationTemplate combTemplate, int substitutedFormat) {
            MandatoryStreamCombination streamCombination;
            HashMap<Pair<SizeThreshold, Integer>, List<Size>> availableDefaultNonRawSizes;
            boolean isReprocess;
            ArrayList<MandatoryStreamInformation> streamsInfo = new ArrayList<MandatoryStreamInformation>();
            streamsInfo.ensureCapacity(combTemplate.mStreamTemplates.length);
            boolean bl = isReprocess = combTemplate.mReprocessType != ReprocessType.NONE;
            if (isReprocess) {
                int format = -1;
                ArrayList<Size> inputSize = new ArrayList<Size>();
                if (combTemplate.mReprocessType == ReprocessType.PRIVATE) {
                    inputSize.add(Builder.getMaxSize(this.mStreamConfigMapMaximumResolution.getInputSizes(34)));
                    format = 34;
                } else if (combTemplate.mReprocessType == ReprocessType.REMOSAIC) {
                    inputSize.add(Builder.getMaxSize(this.mStreamConfigMapMaximumResolution.getInputSizes(32)));
                    format = 32;
                } else {
                    inputSize.add(Builder.getMaxSize(this.mStreamConfigMapMaximumResolution.getInputSizes(35)));
                    format = 35;
                }
                streamsInfo.add(new MandatoryStreamInformation(inputSize, format, false, true, true));
                streamsInfo.add(new MandatoryStreamInformation(inputSize, format, false, false, true));
            }
            if ((availableDefaultNonRawSizes = this.enumerateAvailableSizes()) == null) {
                Log.e(MandatoryStreamCombination.TAG, "Available size enumeration failed");
                return null;
            }
            Size[] defaultRawSizes = this.mStreamConfigMap.getOutputSizes(32);
            ArrayList<Size> availableDefaultRawSizes = new ArrayList<Size>();
            if (defaultRawSizes != null) {
                availableDefaultRawSizes.ensureCapacity(defaultRawSizes.length);
                availableDefaultRawSizes.addAll(Arrays.asList(defaultRawSizes));
            }
            for (StreamTemplate template : combTemplate.mStreamTemplates) {
                MandatoryStreamInformation streamInfo;
                boolean isMaximumSize;
                List<Size> sizes = new ArrayList<Size>();
                int formatChosen = template.mFormat;
                boolean isUltraHighResolution = template.mSizeThreshold == SizeThreshold.FULL_RES;
                StreamConfigurationMap sm = isUltraHighResolution ? this.mStreamConfigMapMaximumResolution : this.mStreamConfigMap;
                boolean bl2 = isMaximumSize = template.mSizeThreshold == SizeThreshold.MAXIMUM;
                if (substitutedFormat != 0 && isMaximumSize) {
                    formatChosen = substitutedFormat;
                }
                if (isUltraHighResolution) {
                    sizes.add(Builder.getMaxSize(sm.getOutputSizes(formatChosen)));
                } else if (formatChosen == 32) {
                    sizes = availableDefaultRawSizes;
                } else {
                    Pair<SizeThreshold, Integer> pair = new Pair<SizeThreshold, Integer>(template.mSizeThreshold, new Integer(formatChosen));
                    sizes = availableDefaultNonRawSizes.get(pair);
                }
                try {
                    streamInfo = new MandatoryStreamInformation(sizes, formatChosen, isMaximumSize, false, isUltraHighResolution);
                }
                catch (IllegalArgumentException e) {
                    String cause = "No available sizes found for format: " + template.mFormat + " size threshold: " + (Object)((Object)template.mSizeThreshold) + " combination: " + combTemplate.mDescription;
                    throw new RuntimeException(cause, e);
                }
                streamsInfo.add(streamInfo);
            }
            String formatString = null;
            switch (substitutedFormat) {
                case 32: {
                    formatString = "RAW_SENSOR";
                    break;
                }
                case 256: {
                    formatString = "JPEG";
                    break;
                }
                default: {
                    formatString = "YUV";
                }
            }
            try {
                streamCombination = new MandatoryStreamCombination(streamsInfo, combTemplate.mDescription + " " + formatString + " still-capture", isReprocess);
            }
            catch (IllegalArgumentException e) {
                String cause = "No stream information for mandatory combination: " + combTemplate.mDescription;
                throw new RuntimeException(cause, e);
            }
            return streamCombination;
        }

        private void fillUHMandatoryStreamCombinations(ArrayList<MandatoryStreamCombination> availableStreamCombinations, ArrayList<StreamCombinationTemplate> chosenTemplates) {
            for (StreamCombinationTemplate combTemplate : chosenTemplates) {
                MandatoryStreamCombination streamCombination = this.createUHSensorMandatoryStreamCombination(combTemplate, 0);
                availableStreamCombinations.add(streamCombination);
                if (!combTemplate.mSubstituteYUV) continue;
                streamCombination = this.createUHSensorMandatoryStreamCombination(combTemplate, 32);
                availableStreamCombinations.add(streamCombination);
                streamCombination = this.createUHSensorMandatoryStreamCombination(combTemplate, 256);
                availableStreamCombinations.add(streamCombination);
            }
        }

        public List<MandatoryStreamCombination> getAvailableMandatoryStreamCombinations() {
            if (!this.isColorOutputSupported()) {
                Log.v(MandatoryStreamCombination.TAG, "Device is not backward compatible!");
                return null;
            }
            if (this.mCameraId < 0 && !this.isExternalCamera()) {
                Log.i(MandatoryStreamCombination.TAG, "Invalid camera id");
                return null;
            }
            ArrayList<StreamCombinationTemplate> availableTemplates = new ArrayList<StreamCombinationTemplate>();
            if (this.isHardwareLevelAtLeastLegacy()) {
                availableTemplates.addAll(Arrays.asList(sLegacyCombinations));
            }
            if (this.isHardwareLevelAtLeastLimited() || this.isExternalCamera()) {
                availableTemplates.addAll(Arrays.asList(sLimitedCombinations));
                if (this.isPrivateReprocessingSupported()) {
                    availableTemplates.addAll(Arrays.asList(sLimitedPrivateReprocCombinations));
                }
                if (this.isYUVReprocessingSupported()) {
                    availableTemplates.addAll(Arrays.asList(sLimitedYUVReprocCombinations));
                }
            }
            if (this.isCapabilitySupported(6)) {
                availableTemplates.addAll(Arrays.asList(sBurstCombinations));
            }
            if (this.isHardwareLevelAtLeastFull()) {
                availableTemplates.addAll(Arrays.asList(sFullCombinations));
                if (this.isPrivateReprocessingSupported()) {
                    availableTemplates.addAll(Arrays.asList(sFullPrivateReprocCombinations));
                }
                if (this.isYUVReprocessingSupported()) {
                    availableTemplates.addAll(Arrays.asList(sFullYUVReprocCombinations));
                }
            }
            if (this.isCapabilitySupported(3)) {
                availableTemplates.addAll(Arrays.asList(sRawCombinations));
                if (this.isPrivateReprocessingSupported()) {
                    availableTemplates.addAll(Arrays.asList(sRAWPrivateReprocCombinations));
                }
                if (this.isYUVReprocessingSupported()) {
                    availableTemplates.addAll(Arrays.asList(sRAWYUVReprocCombinations));
                }
            }
            if (this.isHardwareLevelAtLeastLevel3()) {
                availableTemplates.addAll(Arrays.asList(sLevel3Combinations));
                if (this.isPrivateReprocessingSupported()) {
                    availableTemplates.addAll(Arrays.asList(sLevel3PrivateReprocCombinations));
                }
                if (this.isYUVReprocessingSupported()) {
                    availableTemplates.addAll(Arrays.asList(sLevel3YUVReprocCombinations));
                }
            }
            return this.generateAvailableCombinations(availableTemplates);
        }

        private List<MandatoryStreamCombination> generateAvailableCombinations(ArrayList<StreamCombinationTemplate> availableTemplates) {
            if (availableTemplates.isEmpty()) {
                Log.e(MandatoryStreamCombination.TAG, "No available stream templates!");
                return null;
            }
            HashMap<Pair<SizeThreshold, Integer>, List<Size>> availableSizes = this.enumerateAvailableSizes();
            if (availableSizes == null) {
                Log.e(MandatoryStreamCombination.TAG, "Available size enumeration failed!");
                return null;
            }
            Size[] rawSizes = this.mStreamConfigMap.getOutputSizes(32);
            ArrayList<Size> availableRawSizes = new ArrayList<Size>();
            if (rawSizes != null) {
                availableRawSizes.ensureCapacity(rawSizes.length);
                availableRawSizes.addAll(Arrays.asList(rawSizes));
            }
            Size maxPrivateInputSize = new Size(0, 0);
            if (this.isPrivateReprocessingSupported()) {
                maxPrivateInputSize = Builder.getMaxSize(this.mStreamConfigMap.getInputSizes(34));
            }
            Size maxYUVInputSize = new Size(0, 0);
            if (this.isYUVReprocessingSupported()) {
                maxYUVInputSize = Builder.getMaxSize(this.mStreamConfigMap.getInputSizes(35));
            }
            ArrayList<MandatoryStreamCombination> availableStreamCombinations = new ArrayList<MandatoryStreamCombination>();
            availableStreamCombinations.ensureCapacity(availableTemplates.size());
            for (StreamCombinationTemplate combTemplate : availableTemplates) {
                MandatoryStreamCombination streamCombination;
                boolean isReprocessable;
                ArrayList<MandatoryStreamInformation> streamsInfo = new ArrayList<MandatoryStreamInformation>();
                streamsInfo.ensureCapacity(combTemplate.mStreamTemplates.length);
                boolean bl = isReprocessable = combTemplate.mReprocessType != ReprocessType.NONE;
                if (isReprocessable) {
                    int format;
                    ArrayList inputSize = new ArrayList();
                    if (combTemplate.mReprocessType == ReprocessType.PRIVATE) {
                        inputSize.add(maxPrivateInputSize);
                        format = 34;
                    } else {
                        inputSize.add(maxYUVInputSize);
                        format = 35;
                    }
                    streamsInfo.add(new MandatoryStreamInformation(inputSize, format, true, true));
                    streamsInfo.add(new MandatoryStreamInformation(inputSize, format, true));
                }
                for (StreamTemplate template : combTemplate.mStreamTemplates) {
                    MandatoryStreamInformation streamInfo;
                    List<Size> sizes = null;
                    if (template.mFormat == 32) {
                        sizes = availableRawSizes;
                    } else {
                        Pair<SizeThreshold, Integer> pair = new Pair<SizeThreshold, Integer>(template.mSizeThreshold, new Integer(template.mFormat));
                        sizes = availableSizes.get(pair);
                    }
                    boolean isMaximumSize = template.mSizeThreshold == SizeThreshold.MAXIMUM;
                    try {
                        streamInfo = new MandatoryStreamInformation(sizes, template.mFormat, isMaximumSize);
                    }
                    catch (IllegalArgumentException e) {
                        Log.e(MandatoryStreamCombination.TAG, "No available sizes found for format: " + template.mFormat + " size threshold: " + (Object)((Object)template.mSizeThreshold) + " combination: " + combTemplate.mDescription);
                        return null;
                    }
                    streamsInfo.add(streamInfo);
                }
                try {
                    streamCombination = new MandatoryStreamCombination(streamsInfo, combTemplate.mDescription, isReprocessable);
                }
                catch (IllegalArgumentException e) {
                    Log.e(MandatoryStreamCombination.TAG, "No stream information for mandatory combination: " + combTemplate.mDescription);
                    return null;
                }
                availableStreamCombinations.add(streamCombination);
            }
            return Collections.unmodifiableList(availableStreamCombinations);
        }

        private HashMap<Pair<SizeThreshold, Integer>, List<Size>> enumerateAvailableSizes() {
            int[] formats = new int[]{34, 35, 256, 54};
            Size recordingMaxSize = new Size(0, 0);
            Size previewMaxSize = new Size(0, 0);
            Size vgaSize = new Size(640, 480);
            Size s720pSize = new Size(1280, 720);
            Size s1440pSize = new Size(1920, 1440);
            recordingMaxSize = this.isExternalCamera() || this.mIsHiddenPhysicalCamera ? this.getMaxCameraRecordingSize() : this.getMaxRecordingSize();
            if (recordingMaxSize == null) {
                Log.e(MandatoryStreamCombination.TAG, "Failed to find maximum recording size!");
                return null;
            }
            HashMap<Integer, Size[]> allSizes = new HashMap<Integer, Size[]>();
            for (int format : formats) {
                Integer intFormat = new Integer(format);
                Size[] sizes = this.mStreamConfigMap.getOutputSizes(format);
                if (sizes == null) {
                    sizes = new Size[]{};
                }
                allSizes.put(intFormat, sizes);
            }
            List<Size> previewSizes = Builder.getSizesWithinBound((Size[])allSizes.get(new Integer(34)), this.kPreviewSizeBound);
            if (previewSizes == null || previewSizes.isEmpty()) {
                Log.e(MandatoryStreamCombination.TAG, "No preview sizes within preview size bound!");
                return null;
            }
            List<Size> orderedPreviewSizes = Builder.getAscendingOrderSizes(previewSizes, false);
            previewMaxSize = this.getMaxPreviewSize(orderedPreviewSizes);
            HashMap<Pair<SizeThreshold, Integer>, List<Size>> availableSizes = new HashMap<Pair<SizeThreshold, Integer>, List<Size>>();
            for (int format : formats) {
                Integer intFormat = new Integer(format);
                Size[] sizes = (Size[])allSizes.get(intFormat);
                Pair<SizeThreshold, Integer> pair = new Pair<SizeThreshold, Integer>(SizeThreshold.VGA, intFormat);
                availableSizes.put(pair, Builder.getSizesWithinBound(sizes, vgaSize));
                pair = new Pair<SizeThreshold, Integer>(SizeThreshold.PREVIEW, intFormat);
                availableSizes.put(pair, Builder.getSizesWithinBound(sizes, previewMaxSize));
                pair = new Pair<SizeThreshold, Integer>(SizeThreshold.RECORD, intFormat);
                availableSizes.put(pair, Builder.getSizesWithinBound(sizes, recordingMaxSize));
                pair = new Pair<SizeThreshold, Integer>(SizeThreshold.MAXIMUM, intFormat);
                availableSizes.put(pair, Arrays.asList(sizes));
                pair = new Pair<SizeThreshold, Integer>(SizeThreshold.s720p, intFormat);
                availableSizes.put(pair, Builder.getSizesWithinBound(sizes, s720pSize));
                pair = new Pair<SizeThreshold, Integer>(SizeThreshold.s1440p, intFormat);
                availableSizes.put(pair, Builder.getSizesWithinBound(sizes, s1440pSize));
            }
            return availableSizes;
        }

        private static List<Size> getSizesWithinBound(Size[] sizes, Size bound) {
            ArrayList<Size> ret = new ArrayList<Size>();
            for (Size size : sizes) {
                if (size.getWidth() > bound.getWidth() || size.getHeight() > bound.getHeight()) continue;
                ret.add(size);
            }
            return ret;
        }

        public static Size getMinSize(Size a, Size b) {
            if (a == null || b == null) {
                throw new IllegalArgumentException("sizes was empty");
            }
            if (a.getWidth() * a.getHeight() < b.getHeight() * b.getWidth()) {
                return a;
            }
            return b;
        }

        public static Size getMaxSize(Size ... sizes) {
            if (sizes == null || sizes.length == 0) {
                throw new IllegalArgumentException("sizes was empty");
            }
            Size sz = sizes[0];
            for (Size size : sizes) {
                if (size.getWidth() * size.getHeight() <= sz.getWidth() * sz.getHeight()) continue;
                sz = size;
            }
            return sz;
        }

        private boolean isHardwareLevelAtLeast(int level) {
            int[] sortedHwLevels = new int[]{2, 4, 0, 1, 3};
            if (level == this.mHwLevel) {
                return true;
            }
            for (int sortedlevel : sortedHwLevels) {
                if (sortedlevel == level) {
                    return true;
                }
                if (sortedlevel != this.mHwLevel) continue;
                return false;
            }
            return false;
        }

        private boolean isExternalCamera() {
            return this.mHwLevel == 4;
        }

        private boolean isHardwareLevelAtLeastLegacy() {
            return this.isHardwareLevelAtLeast(2);
        }

        private boolean isHardwareLevelAtLeastLimited() {
            return this.isHardwareLevelAtLeast(0);
        }

        private boolean isHardwareLevelAtLeastFull() {
            return this.isHardwareLevelAtLeast(1);
        }

        private boolean isHardwareLevelAtLeastLevel3() {
            return this.isHardwareLevelAtLeast(3);
        }

        private boolean isCapabilitySupported(int capability) {
            return this.mCapabilities.contains(capability);
        }

        private boolean isColorOutputSupported() {
            return this.isCapabilitySupported(0);
        }

        private boolean is10BitOutputSupported() {
            return this.isCapabilitySupported(18);
        }

        private boolean isPrivateReprocessingSupported() {
            return this.isCapabilitySupported(4);
        }

        private boolean isYUVReprocessingSupported() {
            return this.isCapabilitySupported(7);
        }

        private boolean isRemosaicReprocessingSupported() {
            return this.isCapabilitySupported(17);
        }

        private Size getMaxRecordingSize() {
            int quality;
            int n = CamcorderProfile.hasProfile(this.mCameraId, 8) ? 8 : (CamcorderProfile.hasProfile(this.mCameraId, 6) ? 6 : (CamcorderProfile.hasProfile(this.mCameraId, 5) ? 5 : (CamcorderProfile.hasProfile(this.mCameraId, 4) ? 4 : (CamcorderProfile.hasProfile(this.mCameraId, 7) ? 7 : (CamcorderProfile.hasProfile(this.mCameraId, 3) ? 3 : (quality = CamcorderProfile.hasProfile(this.mCameraId, 2) ? 2 : -1))))));
            if (quality < 0) {
                return null;
            }
            CamcorderProfile maxProfile = CamcorderProfile.get(this.mCameraId, quality);
            return new Size(maxProfile.videoFrameWidth, maxProfile.videoFrameHeight);
        }

        private Size getMaxCameraRecordingSize() {
            Size FULLHD = new Size(1920, 1080);
            Size[] videoSizeArr = this.mStreamConfigMap.getOutputSizes(MediaRecorder.class);
            ArrayList<Size> sizes = new ArrayList<Size>();
            for (Size sz : videoSizeArr) {
                if (sz.getWidth() > FULLHD.getWidth() || sz.getHeight() > FULLHD.getHeight()) continue;
                sizes.add(sz);
            }
            List<Size> videoSizes = Builder.getAscendingOrderSizes(sizes, false);
            for (Size sz : videoSizes) {
                long minFrameDuration = this.mStreamConfigMap.getOutputMinFrameDuration(MediaRecorder.class, sz);
                if (!((double)minFrameDuration > 3.3222591362126246E7)) continue;
                Log.i(MandatoryStreamCombination.TAG, "External camera " + this.mCameraId + " has max video size:" + sz);
                return sz;
            }
            Log.w(MandatoryStreamCombination.TAG, "Camera " + this.mCameraId + " does not support any 30fps video output");
            return FULLHD;
        }

        private Size getMaxPreviewSize(List<Size> orderedPreviewSizes) {
            if (orderedPreviewSizes != null) {
                for (Size size : orderedPreviewSizes) {
                    if (this.mDisplaySize.getWidth() < size.getWidth() || this.mDisplaySize.getHeight() < size.getHeight()) continue;
                    return size;
                }
            }
            Log.w(MandatoryStreamCombination.TAG, "Camera " + this.mCameraId + " maximum preview size search failed with display size " + this.mDisplaySize);
            return this.kPreviewSizeBound;
        }

        private static List<Size> getAscendingOrderSizes(List<Size> sizeList, boolean ascending) {
            SizeComparator comparator2 = new SizeComparator();
            ArrayList<Size> sortedSizes = new ArrayList<Size>();
            sortedSizes.addAll(sizeList);
            Collections.sort(sortedSizes, comparator2);
            if (!ascending) {
                Collections.reverse(sortedSizes);
            }
            return sortedSizes;
        }

        public static class SizeComparator
        implements Comparator<Size> {
            @Override
            public int compare(Size lhs, Size rhs) {
                return StreamConfigurationMap.compareSizes(lhs.getWidth(), lhs.getHeight(), rhs.getWidth(), rhs.getHeight());
            }
        }
    }

    private static class StreamCombinationTemplate {
        public StreamTemplate[] mStreamTemplates;
        public String mDescription;
        public ReprocessType mReprocessType;
        public boolean mSubstituteYUV = false;

        public StreamCombinationTemplate(StreamTemplate[] streamTemplates, String description) {
            this(streamTemplates, description, ReprocessType.NONE);
        }

        public StreamCombinationTemplate(StreamTemplate[] streamTemplates, String description, ReprocessType reprocessType) {
            this(streamTemplates, description, reprocessType, false);
        }

        public StreamCombinationTemplate(StreamTemplate[] streamTemplates, String description, boolean substituteYUV) {
            this(streamTemplates, description, ReprocessType.NONE, substituteYUV);
        }

        public StreamCombinationTemplate(StreamTemplate[] streamTemplates, String description, ReprocessType reprocessType, boolean substituteYUV) {
            this.mStreamTemplates = streamTemplates;
            this.mReprocessType = reprocessType;
            this.mDescription = description;
            this.mSubstituteYUV = substituteYUV;
        }
    }

    private static class StreamTemplate {
        public int mFormat;
        public SizeThreshold mSizeThreshold;
        public long mStreamUseCase;

        public StreamTemplate(int format, SizeThreshold sizeThreshold) {
            this(format, sizeThreshold, 0L);
        }

        public StreamTemplate(int format, SizeThreshold sizeThreshold, long streamUseCase) {
            this.mFormat = format;
            this.mSizeThreshold = sizeThreshold;
            this.mStreamUseCase = streamUseCase;
        }
    }

    private static enum ReprocessType {
        NONE,
        PRIVATE,
        YUV,
        REMOSAIC;

    }

    private static enum SizeThreshold {
        VGA,
        PREVIEW,
        RECORD,
        MAXIMUM,
        s720p,
        s1440p,
        FULL_RES;

    }

    public static class MandatoryStreamInformation {
        private final int mFormat;
        private final ArrayList<Size> mAvailableSizes = new ArrayList();
        private final boolean mIsInput;
        private final boolean mIsUltraHighResolution;
        private final boolean mIsMaximumSize;
        private final boolean mIs10BitCapable;
        private final long mStreamUseCase;

        public MandatoryStreamInformation(List<Size> availableSizes, int format, boolean isMaximumSize) {
            this(availableSizes, format, isMaximumSize, false, false);
        }

        public MandatoryStreamInformation(List<Size> availableSizes, int format, boolean isMaximumSize, boolean isInput) {
            this(availableSizes, format, isMaximumSize, isInput, false);
        }

        public MandatoryStreamInformation(List<Size> availableSizes, int format, boolean isMaximumSize, boolean isInput, boolean isUltraHighResolution) {
            this(availableSizes, format, isMaximumSize, isInput, isUltraHighResolution, false);
        }

        public MandatoryStreamInformation(List<Size> availableSizes, int format, boolean isMaximumSize, boolean isInput, boolean isUltraHighResolution, boolean is10BitCapable) {
            this(availableSizes, format, isMaximumSize, isInput, isUltraHighResolution, is10BitCapable, 0L);
        }

        public MandatoryStreamInformation(List<Size> availableSizes, int format, boolean isMaximumSize, boolean isInput, boolean isUltraHighResolution, boolean is10BitCapable, long streamUseCase) {
            if (availableSizes.isEmpty()) {
                throw new IllegalArgumentException("No available sizes");
            }
            this.mAvailableSizes.addAll(availableSizes);
            this.mFormat = StreamConfigurationMap.checkArgumentFormat(format);
            this.mIsMaximumSize = isMaximumSize;
            this.mIsInput = isInput;
            this.mIsUltraHighResolution = isUltraHighResolution;
            this.mIs10BitCapable = is10BitCapable;
            this.mStreamUseCase = streamUseCase;
        }

        public boolean isInput() {
            return this.mIsInput;
        }

        public boolean isUltraHighResolution() {
            return this.mIsUltraHighResolution;
        }

        public boolean isMaximumSize() {
            return this.mIsMaximumSize;
        }

        public boolean is10BitCapable() {
            return this.mIs10BitCapable;
        }

        public List<Size> getAvailableSizes() {
            return Collections.unmodifiableList(this.mAvailableSizes);
        }

        public int getFormat() {
            if (this.mIs10BitCapable && this.mFormat == 54) {
                return 35;
            }
            return this.mFormat;
        }

        public int get10BitFormat() {
            if (!this.mIs10BitCapable) {
                throw new UnsupportedOperationException("10-bit output is not supported!");
            }
            return this.mFormat;
        }

        public long getStreamUseCase() {
            return this.mStreamUseCase;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj instanceof MandatoryStreamInformation) {
                MandatoryStreamInformation other = (MandatoryStreamInformation)obj;
                if (this.mFormat != other.mFormat || this.mIsInput != other.mIsInput || this.mIsUltraHighResolution != other.mIsUltraHighResolution || this.mStreamUseCase != other.mStreamUseCase || this.mAvailableSizes.size() != other.mAvailableSizes.size()) {
                    return false;
                }
                return this.mAvailableSizes.equals(other.mAvailableSizes);
            }
            return false;
        }

        public int hashCode() {
            return HashCodeHelpers.hashCode(this.mFormat, Boolean.hashCode(this.mIsInput), Boolean.hashCode(this.mIsUltraHighResolution), this.mAvailableSizes.hashCode(), this.mStreamUseCase);
        }
    }
}

