/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.hardware.camera2.params.MultiResolutionStreamInfo;
import android.hardware.camera2.params.StreamConfiguration;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.utils.HashCodeHelpers;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiResolutionStreamConfigurationMap {
    private final Map<String, StreamConfiguration[]> mConfigurations;
    private final Map<Integer, List<MultiResolutionStreamInfo>> mMultiResolutionOutputConfigs = new HashMap<Integer, List<MultiResolutionStreamInfo>>();
    private final Map<Integer, List<MultiResolutionStreamInfo>> mMultiResolutionInputConfigs = new HashMap<Integer, List<MultiResolutionStreamInfo>>();

    public MultiResolutionStreamConfigurationMap(Map<String, StreamConfiguration[]> configurations) {
        Preconditions.checkNotNull(configurations, "multi-resolution configurations must not be null");
        if (configurations.size() == 0) {
            throw new IllegalArgumentException("multi-resolution configurations must not be empty");
        }
        this.mConfigurations = configurations;
        for (Map.Entry<String, StreamConfiguration[]> entry : this.mConfigurations.entrySet()) {
            String cameraId = entry.getKey();
            StreamConfiguration[] configs = entry.getValue();
            for (int i = 0; i < configs.length; ++i) {
                StreamConfiguration config = configs[i];
                int format = config.getFormat();
                MultiResolutionStreamInfo multiResolutionStreamInfo = new MultiResolutionStreamInfo(config.getWidth(), config.getHeight(), cameraId);
                Map<Integer, List<MultiResolutionStreamInfo>> destMap = config.isInput() ? this.mMultiResolutionInputConfigs : this.mMultiResolutionOutputConfigs;
                if (!destMap.containsKey(format)) {
                    ArrayList multiResolutionStreamInfoList = new ArrayList();
                    destMap.put(format, multiResolutionStreamInfoList);
                }
                destMap.get(format).add(multiResolutionStreamInfo);
            }
        }
    }

    public int[] getOutputFormats() {
        return this.getPublicImageFormats(true);
    }

    public int[] getInputFormats() {
        return this.getPublicImageFormats(false);
    }

    private int[] getPublicImageFormats(boolean output) {
        Map<Integer, List<MultiResolutionStreamInfo>> multiResolutionConfigs = output ? this.mMultiResolutionOutputConfigs : this.mMultiResolutionInputConfigs;
        int formatCount = multiResolutionConfigs.size();
        int[] formats = new int[formatCount];
        int i = 0;
        for (Integer format : multiResolutionConfigs.keySet()) {
            formats[i++] = StreamConfigurationMap.imageFormatToPublic(format);
        }
        return formats;
    }

    public Collection<MultiResolutionStreamInfo> getOutputInfo(int format) {
        return this.getInfo(format, true);
    }

    public Collection<MultiResolutionStreamInfo> getInputInfo(int format) {
        return this.getInfo(format, false);
    }

    private Collection<MultiResolutionStreamInfo> getInfo(int format, boolean output) {
        Map<Integer, List<MultiResolutionStreamInfo>> multiResolutionConfigs;
        int internalFormat = StreamConfigurationMap.imageFormatToInternal(format);
        Map<Integer, List<MultiResolutionStreamInfo>> map2 = multiResolutionConfigs = output ? this.mMultiResolutionOutputConfigs : this.mMultiResolutionInputConfigs;
        if (multiResolutionConfigs.containsKey(internalFormat)) {
            return Collections.unmodifiableCollection((Collection)multiResolutionConfigs.get(internalFormat));
        }
        return Collections.emptyList();
    }

    private void appendConfigurationsString(StringBuilder sb, boolean output) {
        sb.append(output ? "Outputs(" : "Inputs(");
        int[] formats = this.getPublicImageFormats(output);
        if (formats != null) {
            for (int format : formats) {
                Collection<MultiResolutionStreamInfo> streamInfoList = this.getInfo(format, output);
                sb.append("[" + StreamConfigurationMap.formatToString(format) + ":");
                for (MultiResolutionStreamInfo streamInfo : streamInfoList) {
                    sb.append(String.format("[w:%d, h:%d, id:%s], ", streamInfo.getWidth(), streamInfo.getHeight(), streamInfo.getPhysicalCameraId()));
                }
                if (sb.charAt(sb.length() - 1) == ' ') {
                    sb.delete(sb.length() - 2, sb.length());
                }
                sb.append("]");
            }
        }
        sb.append(")");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof MultiResolutionStreamConfigurationMap) {
            MultiResolutionStreamConfigurationMap other = (MultiResolutionStreamConfigurationMap)obj;
            if (!this.mConfigurations.keySet().equals(other.mConfigurations.keySet())) {
                return false;
            }
            for (String id2 : this.mConfigurations.keySet()) {
                if (Arrays.equals(this.mConfigurations.get(id2), other.mConfigurations.get(id2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return HashCodeHelpers.hashCodeGeneric(this.mConfigurations, this.mMultiResolutionOutputConfigs, this.mMultiResolutionInputConfigs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MultiResolutionStreamConfigurationMap(");
        this.appendConfigurationsString(sb, true);
        sb.append(",");
        this.appendConfigurationsString(sb, false);
        sb.append(")");
        return sb.toString();
    }

    public static class SizeComparator
    implements Comparator<MultiResolutionStreamInfo> {
        @Override
        public int compare(MultiResolutionStreamInfo lhs, MultiResolutionStreamInfo rhs) {
            return StreamConfigurationMap.compareSizes(lhs.getWidth(), lhs.getHeight(), rhs.getWidth(), rhs.getHeight());
        }
    }
}

