/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.annotation.SystemApi;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.MultiResolutionImageReader;
import android.hardware.camera2.params.DynamicRangeProfiles;
import android.hardware.camera2.params.MultiResolutionStreamInfo;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.utils.HashCodeHelpers;
import android.hardware.camera2.utils.SurfaceUtils;
import android.media.ImageReader;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class OutputConfiguration
implements Parcelable {
    @SystemApi
    public static final int ROTATION_0 = 0;
    @SystemApi
    public static final int ROTATION_90 = 1;
    @SystemApi
    public static final int ROTATION_180 = 2;
    @SystemApi
    public static final int ROTATION_270 = 3;
    public static final int SURFACE_GROUP_ID_NONE = -1;
    public static final int TIMESTAMP_BASE_DEFAULT = 0;
    public static final int TIMESTAMP_BASE_SENSOR = 1;
    public static final int TIMESTAMP_BASE_MONOTONIC = 2;
    public static final int TIMESTAMP_BASE_REALTIME = 3;
    public static final int TIMESTAMP_BASE_CHOREOGRAPHER_SYNCED = 4;
    public static final int MIRROR_MODE_AUTO = 0;
    public static final int MIRROR_MODE_NONE = 1;
    public static final int MIRROR_MODE_H = 2;
    public static final int MIRROR_MODE_V = 3;
    private final int SURFACE_TYPE_UNKNOWN = -1;
    private final int SURFACE_TYPE_SURFACE_VIEW = 0;
    private final int SURFACE_TYPE_SURFACE_TEXTURE = 1;
    private static final int MAX_SURFACES_COUNT = 4;
    public static final Parcelable.Creator<OutputConfiguration> CREATOR = new Parcelable.Creator<OutputConfiguration>(){

        @Override
        public OutputConfiguration createFromParcel(Parcel source) {
            return new OutputConfiguration(source);
        }

        public OutputConfiguration[] newArray(int size) {
            return new OutputConfiguration[size];
        }
    };
    private static final String TAG = "OutputConfiguration";
    private static int MULTI_RESOLUTION_GROUP_ID_COUNTER = 0;
    private ArrayList<Surface> mSurfaces;
    private final int mRotation;
    private final int mSurfaceGroupId;
    private final int mSurfaceType;
    private final Size mConfiguredSize;
    private final int mConfiguredFormat;
    private final int mConfiguredDataspace;
    private final int mConfiguredGenerationId;
    private final boolean mIsDeferredConfig;
    private boolean mIsShared;
    private String mPhysicalCameraId;
    private boolean mIsMultiResolution;
    private ArrayList<Integer> mSensorPixelModesUsed;
    private long mDynamicRangeProfile;
    private long mStreamUseCase;
    private int mTimestampBase;
    private int mMirrorMode;

    public OutputConfiguration(Surface surface2) {
        this(-1, surface2, 0);
    }

    public OutputConfiguration(int surfaceGroupId, Surface surface2) {
        this(surfaceGroupId, surface2, 0);
    }

    void setMultiResolutionOutput() {
        if (this.mIsShared) {
            throw new IllegalStateException("Multi-resolution output flag must not be set for configuration with surface sharing");
        }
        if (this.mSurfaceGroupId == -1) {
            throw new IllegalStateException("Multi-resolution output flag should only be set for surface with non-negative group ID");
        }
        this.mIsMultiResolution = true;
    }

    public void setDynamicRangeProfile(long profile) {
        this.mDynamicRangeProfile = profile;
    }

    public long getDynamicRangeProfile() {
        return this.mDynamicRangeProfile;
    }

    @SystemApi
    public OutputConfiguration(Surface surface2, int rotation) {
        this(-1, surface2, rotation);
    }

    @SystemApi
    public OutputConfiguration(int surfaceGroupId, Surface surface2, int rotation) {
        Preconditions.checkNotNull(surface2, "Surface must not be null");
        Preconditions.checkArgumentInRange(rotation, 0, 3, "Rotation constant");
        this.mSurfaceGroupId = surfaceGroupId;
        this.mSurfaceType = -1;
        this.mSurfaces = new ArrayList();
        this.mSurfaces.add(surface2);
        this.mRotation = rotation;
        this.mConfiguredSize = SurfaceUtils.getSurfaceSize(surface2);
        this.mConfiguredFormat = SurfaceUtils.getSurfaceFormat(surface2);
        this.mConfiguredDataspace = SurfaceUtils.getSurfaceDataspace(surface2);
        this.mConfiguredGenerationId = surface2.getGenerationId();
        this.mIsDeferredConfig = false;
        this.mIsShared = false;
        this.mPhysicalCameraId = null;
        this.mIsMultiResolution = false;
        this.mSensorPixelModesUsed = new ArrayList();
        this.mDynamicRangeProfile = 1L;
        this.mStreamUseCase = 0L;
        this.mTimestampBase = 0;
        this.mMirrorMode = 0;
    }

    public static Collection<OutputConfiguration> createInstancesForMultiResolutionOutput(MultiResolutionImageReader multiResolutionImageReader) {
        Preconditions.checkNotNull(multiResolutionImageReader, "Multi-resolution image reader must not be null");
        int groupId = MULTI_RESOLUTION_GROUP_ID_COUNTER++;
        if (MULTI_RESOLUTION_GROUP_ID_COUNTER == -1) {
            ++MULTI_RESOLUTION_GROUP_ID_COUNTER;
        }
        ImageReader[] imageReaders = multiResolutionImageReader.getReaders();
        ArrayList<OutputConfiguration> configs = new ArrayList<OutputConfiguration>();
        for (int i = 0; i < imageReaders.length; ++i) {
            MultiResolutionStreamInfo streamInfo = multiResolutionImageReader.getStreamInfoForImageReader(imageReaders[i]);
            OutputConfiguration config = new OutputConfiguration(groupId, imageReaders[i].getSurface());
            config.setPhysicalCameraId(streamInfo.getPhysicalCameraId());
            config.setMultiResolutionOutput();
            configs.add(config);
        }
        return configs;
    }

    public <T> OutputConfiguration(Size surfaceSize, Class<T> klass) {
        Preconditions.checkNotNull(klass, "surfaceSize must not be null");
        Preconditions.checkNotNull(klass, "klass must not be null");
        if (klass == SurfaceHolder.class) {
            this.mSurfaceType = 0;
        } else if (klass == SurfaceTexture.class) {
            this.mSurfaceType = 1;
        } else {
            this.mSurfaceType = -1;
            throw new IllegalArgumentException("Unknow surface source class type");
        }
        if (surfaceSize.getWidth() == 0 || surfaceSize.getHeight() == 0) {
            throw new IllegalArgumentException("Surface size needs to be non-zero");
        }
        this.mSurfaceGroupId = -1;
        this.mSurfaces = new ArrayList();
        this.mRotation = 0;
        this.mConfiguredSize = surfaceSize;
        this.mConfiguredFormat = StreamConfigurationMap.imageFormatToInternal(34);
        this.mConfiguredDataspace = StreamConfigurationMap.imageFormatToDataspace(34);
        this.mConfiguredGenerationId = 0;
        this.mIsDeferredConfig = true;
        this.mIsShared = false;
        this.mPhysicalCameraId = null;
        this.mIsMultiResolution = false;
        this.mSensorPixelModesUsed = new ArrayList();
        this.mDynamicRangeProfile = 1L;
        this.mStreamUseCase = 0L;
    }

    public void enableSurfaceSharing() {
        if (this.mIsMultiResolution) {
            throw new IllegalStateException("Cannot enable surface sharing on multi-resolution output configurations");
        }
        this.mIsShared = true;
    }

    public void setPhysicalCameraId(String physicalCameraId) {
        this.mPhysicalCameraId = physicalCameraId;
    }

    public void addSensorPixelModeUsed(int sensorPixelModeUsed) {
        if (sensorPixelModeUsed != 0 && sensorPixelModeUsed != 1) {
            throw new IllegalArgumentException("Not a valid sensor pixel mode " + sensorPixelModeUsed);
        }
        if (this.mSensorPixelModesUsed.contains(sensorPixelModeUsed)) {
            return;
        }
        this.mSensorPixelModesUsed.add(sensorPixelModeUsed);
    }

    public void removeSensorPixelModeUsed(int sensorPixelModeUsed) {
        if (!this.mSensorPixelModesUsed.remove((Object)sensorPixelModeUsed)) {
            throw new IllegalArgumentException("sensorPixelMode " + sensorPixelModeUsed + "is not part of this output configuration");
        }
    }

    public boolean isForPhysicalCamera() {
        return this.mPhysicalCameraId != null;
    }

    public boolean isDeferredConfiguration() {
        return this.mIsDeferredConfig;
    }

    public void addSurface(Surface surface2) {
        Preconditions.checkNotNull(surface2, "Surface must not be null");
        if (this.mSurfaces.contains(surface2)) {
            throw new IllegalStateException("Surface is already added!");
        }
        if (this.mSurfaces.size() == 1 && !this.mIsShared) {
            throw new IllegalStateException("Cannot have 2 surfaces for a non-sharing configuration");
        }
        if (this.mSurfaces.size() + 1 > 4) {
            throw new IllegalArgumentException("Exceeds maximum number of surfaces");
        }
        Size surfaceSize = SurfaceUtils.getSurfaceSize(surface2);
        if (!surfaceSize.equals(this.mConfiguredSize)) {
            Log.w(TAG, "Added surface size " + surfaceSize + " is different than pre-configured size " + this.mConfiguredSize + ", the pre-configured size will be used.");
        }
        if (this.mConfiguredFormat != SurfaceUtils.getSurfaceFormat(surface2)) {
            throw new IllegalArgumentException("The format of added surface format doesn't match");
        }
        if (this.mConfiguredFormat != 34 && this.mConfiguredDataspace != SurfaceUtils.getSurfaceDataspace(surface2)) {
            throw new IllegalArgumentException("The dataspace of added surface doesn't match");
        }
        this.mSurfaces.add(surface2);
    }

    public void removeSurface(Surface surface2) {
        if (this.getSurface() == surface2) {
            throw new IllegalArgumentException("Cannot remove surface associated with this output configuration");
        }
        if (!this.mSurfaces.remove(surface2)) {
            throw new IllegalArgumentException("Surface is not part of this output configuration");
        }
    }

    public void setStreamUseCase(long streamUseCase) {
        long maxUseCaseValue = 5L;
        if (streamUseCase > maxUseCaseValue && streamUseCase < 65536L) {
            throw new IllegalArgumentException("Not a valid stream use case value " + streamUseCase);
        }
        this.mStreamUseCase = streamUseCase;
    }

    public long getStreamUseCase() {
        return this.mStreamUseCase;
    }

    public void setTimestampBase(int timestampBase) {
        if (timestampBase < 0 || timestampBase > 4) {
            throw new IllegalArgumentException("Not a valid timestamp base value " + timestampBase);
        }
        this.mTimestampBase = timestampBase;
    }

    public int getTimestampBase() {
        return this.mTimestampBase;
    }

    public void setMirrorMode(int mirrorMode) {
        if (mirrorMode < 0 || mirrorMode > 3) {
            throw new IllegalArgumentException("Not a valid mirror mode " + mirrorMode);
        }
        this.mMirrorMode = mirrorMode;
    }

    public int getMirrorMode() {
        return this.mMirrorMode;
    }

    public OutputConfiguration(OutputConfiguration other) {
        if (other == null) {
            throw new IllegalArgumentException("OutputConfiguration shouldn't be null");
        }
        this.mSurfaces = other.mSurfaces;
        this.mRotation = other.mRotation;
        this.mSurfaceGroupId = other.mSurfaceGroupId;
        this.mSurfaceType = other.mSurfaceType;
        this.mConfiguredDataspace = other.mConfiguredDataspace;
        this.mConfiguredFormat = other.mConfiguredFormat;
        this.mConfiguredSize = other.mConfiguredSize;
        this.mConfiguredGenerationId = other.mConfiguredGenerationId;
        this.mIsDeferredConfig = other.mIsDeferredConfig;
        this.mIsShared = other.mIsShared;
        this.mPhysicalCameraId = other.mPhysicalCameraId;
        this.mIsMultiResolution = other.mIsMultiResolution;
        this.mSensorPixelModesUsed = other.mSensorPixelModesUsed;
        this.mDynamicRangeProfile = other.mDynamicRangeProfile;
        this.mStreamUseCase = other.mStreamUseCase;
        this.mTimestampBase = other.mTimestampBase;
        this.mMirrorMode = other.mMirrorMode;
    }

    private OutputConfiguration(Parcel source) {
        int rotation = source.readInt();
        int surfaceSetId = source.readInt();
        int surfaceType = source.readInt();
        int width2 = source.readInt();
        int height2 = source.readInt();
        boolean isDeferred = source.readInt() == 1;
        boolean isShared = source.readInt() == 1;
        ArrayList surfaces = new ArrayList();
        source.readTypedList(surfaces, Surface.CREATOR);
        String physicalCameraId = source.readString();
        boolean isMultiResolutionOutput = source.readInt() == 1;
        int[] sensorPixelModesUsed = source.createIntArray();
        long streamUseCase = source.readLong();
        Preconditions.checkArgumentInRange(rotation, 0, 3, "Rotation constant");
        long dynamicRangeProfile = source.readLong();
        DynamicRangeProfiles.checkProfileValue(dynamicRangeProfile);
        int timestampBase = source.readInt();
        int mirrorMode = source.readInt();
        this.mSurfaceGroupId = surfaceSetId;
        this.mRotation = rotation;
        this.mSurfaces = surfaces;
        this.mConfiguredSize = new Size(width2, height2);
        this.mIsDeferredConfig = isDeferred;
        this.mIsShared = isShared;
        this.mSurfaces = surfaces;
        if (this.mSurfaces.size() > 0) {
            this.mSurfaceType = -1;
            this.mConfiguredFormat = SurfaceUtils.getSurfaceFormat(this.mSurfaces.get(0));
            this.mConfiguredDataspace = SurfaceUtils.getSurfaceDataspace(this.mSurfaces.get(0));
            this.mConfiguredGenerationId = this.mSurfaces.get(0).getGenerationId();
        } else {
            this.mSurfaceType = surfaceType;
            this.mConfiguredFormat = StreamConfigurationMap.imageFormatToInternal(34);
            this.mConfiguredDataspace = StreamConfigurationMap.imageFormatToDataspace(34);
            this.mConfiguredGenerationId = 0;
        }
        this.mPhysicalCameraId = physicalCameraId;
        this.mIsMultiResolution = isMultiResolutionOutput;
        this.mSensorPixelModesUsed = OutputConfiguration.convertIntArrayToIntegerList(sensorPixelModesUsed);
        this.mDynamicRangeProfile = dynamicRangeProfile;
        this.mStreamUseCase = streamUseCase;
        this.mTimestampBase = timestampBase;
        this.mMirrorMode = mirrorMode;
    }

    public int getMaxSharedSurfaceCount() {
        return 4;
    }

    public Surface getSurface() {
        if (this.mSurfaces.size() == 0) {
            return null;
        }
        return this.mSurfaces.get(0);
    }

    public List<Surface> getSurfaces() {
        return Collections.unmodifiableList(this.mSurfaces);
    }

    @SystemApi
    public int getRotation() {
        return this.mRotation;
    }

    public int getSurfaceGroupId() {
        return this.mSurfaceGroupId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private static int[] convertIntegerToIntList(List<Integer> integerList) {
        int[] integerArray = new int[integerList.size()];
        for (int i = 0; i < integerList.size(); ++i) {
            integerArray[i] = integerList.get(i);
        }
        return integerArray;
    }

    private static ArrayList<Integer> convertIntArrayToIntegerList(int[] intArray) {
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        if (intArray == null) {
            return integerList;
        }
        for (int i = 0; i < intArray.length; ++i) {
            integerList.add(intArray[i]);
        }
        return integerList;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (dest == null) {
            throw new IllegalArgumentException("dest must not be null");
        }
        dest.writeInt(this.mRotation);
        dest.writeInt(this.mSurfaceGroupId);
        dest.writeInt(this.mSurfaceType);
        dest.writeInt(this.mConfiguredSize.getWidth());
        dest.writeInt(this.mConfiguredSize.getHeight());
        dest.writeInt(this.mIsDeferredConfig ? 1 : 0);
        dest.writeInt(this.mIsShared ? 1 : 0);
        dest.writeTypedList(this.mSurfaces);
        dest.writeString(this.mPhysicalCameraId);
        dest.writeInt(this.mIsMultiResolution ? 1 : 0);
        dest.writeIntArray(OutputConfiguration.convertIntegerToIntList(this.mSensorPixelModesUsed));
        dest.writeLong(this.mDynamicRangeProfile);
        dest.writeLong(this.mStreamUseCase);
        dest.writeInt(this.mTimestampBase);
        dest.writeInt(this.mMirrorMode);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof OutputConfiguration) {
            OutputConfiguration other = (OutputConfiguration)obj;
            if (this.mRotation != other.mRotation || !this.mConfiguredSize.equals(other.mConfiguredSize) || this.mConfiguredFormat != other.mConfiguredFormat || this.mSurfaceGroupId != other.mSurfaceGroupId || this.mSurfaceType != other.mSurfaceType || this.mIsDeferredConfig != other.mIsDeferredConfig || this.mIsShared != other.mIsShared || this.mConfiguredFormat != other.mConfiguredFormat || this.mConfiguredDataspace != other.mConfiguredDataspace || this.mConfiguredGenerationId != other.mConfiguredGenerationId || !Objects.equals(this.mPhysicalCameraId, other.mPhysicalCameraId) || this.mIsMultiResolution != other.mIsMultiResolution || this.mStreamUseCase != other.mStreamUseCase || this.mTimestampBase != other.mTimestampBase || this.mMirrorMode != other.mMirrorMode) {
                return false;
            }
            if (this.mSensorPixelModesUsed.size() != other.mSensorPixelModesUsed.size()) {
                return false;
            }
            for (int j = 0; j < this.mSensorPixelModesUsed.size(); ++j) {
                if (this.mSensorPixelModesUsed.get(j) == other.mSensorPixelModesUsed.get(j)) continue;
                return false;
            }
            int minLen = Math.min(this.mSurfaces.size(), other.mSurfaces.size());
            for (int i = 0; i < minLen; ++i) {
                if (this.mSurfaces.get(i) == other.mSurfaces.get(i)) continue;
                return false;
            }
            return this.mDynamicRangeProfile == other.mDynamicRangeProfile;
        }
        return false;
    }

    public int hashCode() {
        if (this.mIsDeferredConfig) {
            return HashCodeHelpers.hashCode(this.mRotation, this.mConfiguredSize.hashCode(), this.mConfiguredFormat, this.mConfiguredDataspace, this.mSurfaceGroupId, this.mSurfaceType, this.mIsShared ? 1.0f : 0.0f, this.mPhysicalCameraId == null ? 0.0f : (float)this.mPhysicalCameraId.hashCode(), this.mIsMultiResolution ? 1.0f : 0.0f, this.mSensorPixelModesUsed.hashCode(), this.mDynamicRangeProfile, this.mStreamUseCase, this.mTimestampBase, this.mMirrorMode);
        }
        return HashCodeHelpers.hashCode(this.mRotation, this.mSurfaces.hashCode(), this.mConfiguredGenerationId, this.mConfiguredSize.hashCode(), this.mConfiguredFormat, this.mConfiguredDataspace, this.mSurfaceGroupId, this.mIsShared ? 1.0f : 0.0f, this.mPhysicalCameraId == null ? 0.0f : (float)this.mPhysicalCameraId.hashCode(), this.mIsMultiResolution ? 1.0f : 0.0f, this.mSensorPixelModesUsed.hashCode(), this.mDynamicRangeProfile, this.mStreamUseCase, this.mTimestampBase, this.mMirrorMode);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MirrorMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StreamUseCase {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SensorPixelMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TimestampBase {
    }
}

