/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.params;

import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.utils.HashCodeHelpers;
import android.util.Size;
import com.android.internal.util.Preconditions;

public class StreamConfigurationDuration {
    private final int mFormat;
    private final int mWidth;
    private final int mHeight;
    private final long mDurationNs;

    public StreamConfigurationDuration(int format, int width2, int height2, long durationNs) {
        this.mFormat = StreamConfigurationMap.checkArgumentFormatInternal(format);
        this.mWidth = Preconditions.checkArgumentPositive(width2, "width must be positive");
        this.mHeight = Preconditions.checkArgumentPositive(height2, "height must be positive");
        this.mDurationNs = Preconditions.checkArgumentNonnegative(durationNs, "durationNs must be non-negative");
    }

    public int getFormat() {
        return this.mFormat;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public Size getSize() {
        return new Size(this.mWidth, this.mHeight);
    }

    public long getDuration() {
        return this.mDurationNs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof StreamConfigurationDuration) {
            StreamConfigurationDuration other = (StreamConfigurationDuration)obj;
            return this.mFormat == other.mFormat && this.mWidth == other.mWidth && this.mHeight == other.mHeight && this.mDurationNs == other.mDurationNs;
        }
        return false;
    }

    public int hashCode() {
        return HashCodeHelpers.hashCode(this.mFormat, this.mWidth, this.mHeight, (int)this.mDurationNs, (int)(this.mDurationNs >>> 32));
    }
}

