/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.MathUtils;
import android.util.TypedXmlPullParser;
import android.util.TypedXmlSerializer;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

@SystemApi
public class BrightnessCorrection
implements Parcelable {
    private static final int SCALE_AND_TRANSLATE_LOG = 1;
    private static final String TAG_SCALE_AND_TRANSLATE_LOG = "scale-and-translate-log";
    private BrightnessCorrectionImplementation mImplementation;
    public static final Parcelable.Creator<BrightnessCorrection> CREATOR = new Parcelable.Creator<BrightnessCorrection>(){

        @Override
        public BrightnessCorrection createFromParcel(Parcel in) {
            int type = in.readInt();
            switch (type) {
                case 1: {
                    return ScaleAndTranslateLog.readFromParcel(in);
                }
            }
            return null;
        }

        public BrightnessCorrection[] newArray(int size) {
            return new BrightnessCorrection[size];
        }
    };

    private BrightnessCorrection(BrightnessCorrectionImplementation implementation) {
        this.mImplementation = implementation;
    }

    public static BrightnessCorrection createScaleAndTranslateLog(float scale, float translate) {
        ScaleAndTranslateLog implementation = new ScaleAndTranslateLog(scale, translate);
        return new BrightnessCorrection(implementation);
    }

    public float apply(float brightness) {
        return this.mImplementation.apply(brightness);
    }

    public String toString() {
        return this.mImplementation.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrightnessCorrection)) {
            return false;
        }
        BrightnessCorrection other = (BrightnessCorrection)o;
        return other.mImplementation.equals(this.mImplementation);
    }

    public int hashCode() {
        return this.mImplementation.hashCode();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.mImplementation.writeToParcel(dest);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void saveToXml(TypedXmlSerializer serializer) throws IOException {
        this.mImplementation.saveToXml(serializer);
    }

    public static BrightnessCorrection loadFromXml(TypedXmlPullParser parser) throws IOException, XmlPullParserException {
        int depth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, depth)) {
            if (!TAG_SCALE_AND_TRANSLATE_LOG.equals(parser.getName())) continue;
            return ScaleAndTranslateLog.loadFromXml(parser);
        }
        return null;
    }

    private static float loadFloatFromXml(TypedXmlPullParser parser, String attribute) {
        return parser.getAttributeFloat(null, attribute, Float.NaN);
    }

    private static class ScaleAndTranslateLog
    implements BrightnessCorrectionImplementation {
        private static final float MIN_SCALE = 0.5f;
        private static final float MAX_SCALE = 2.0f;
        private static final float MIN_TRANSLATE = -0.6f;
        private static final float MAX_TRANSLATE = 0.7f;
        private static final String ATTR_SCALE = "scale";
        private static final String ATTR_TRANSLATE = "translate";
        private final float mScale;
        private final float mTranslate;

        ScaleAndTranslateLog(float scale, float translate) {
            if (Float.isNaN(scale) || Float.isNaN(translate)) {
                throw new IllegalArgumentException("scale and translate must be numbers");
            }
            this.mScale = MathUtils.constrain(scale, 0.5f, 2.0f);
            this.mTranslate = MathUtils.constrain(translate, -0.6f, 0.7f);
        }

        @Override
        public float apply(float brightness) {
            return MathUtils.exp(this.mScale * MathUtils.log(brightness) + this.mTranslate);
        }

        @Override
        public String toString() {
            return "ScaleAndTranslateLog(" + this.mScale + ", " + this.mTranslate + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScaleAndTranslateLog)) {
                return false;
            }
            ScaleAndTranslateLog other = (ScaleAndTranslateLog)o;
            return other.mScale == this.mScale && other.mTranslate == this.mTranslate;
        }

        public int hashCode() {
            int result = 1;
            result = result * 31 + Float.hashCode(this.mScale);
            result = result * 31 + Float.hashCode(this.mTranslate);
            return result;
        }

        @Override
        public void writeToParcel(Parcel dest) {
            dest.writeInt(1);
            dest.writeFloat(this.mScale);
            dest.writeFloat(this.mTranslate);
        }

        @Override
        public void saveToXml(TypedXmlSerializer serializer) throws IOException {
            serializer.startTag(null, BrightnessCorrection.TAG_SCALE_AND_TRANSLATE_LOG);
            serializer.attributeFloat(null, ATTR_SCALE, this.mScale);
            serializer.attributeFloat(null, ATTR_TRANSLATE, this.mTranslate);
            serializer.endTag(null, BrightnessCorrection.TAG_SCALE_AND_TRANSLATE_LOG);
        }

        static BrightnessCorrection readFromParcel(Parcel in) {
            float scale = in.readFloat();
            float translate = in.readFloat();
            return BrightnessCorrection.createScaleAndTranslateLog(scale, translate);
        }

        static BrightnessCorrection loadFromXml(TypedXmlPullParser parser) throws IOException, XmlPullParserException {
            float scale = BrightnessCorrection.loadFloatFromXml(parser, ATTR_SCALE);
            float translate = BrightnessCorrection.loadFloatFromXml(parser, ATTR_TRANSLATE);
            return BrightnessCorrection.createScaleAndTranslateLog(scale, translate);
        }
    }

    private static interface BrightnessCorrectionImplementation {
        public float apply(float var1);

        public String toString();

        public void writeToParcel(Parcel var1);

        public void saveToXml(TypedXmlSerializer var1) throws IOException;
    }
}

