/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class BrightnessInfo
implements Parcelable {
    public static final int HIGH_BRIGHTNESS_MODE_OFF = 0;
    public static final int HIGH_BRIGHTNESS_MODE_SUNLIGHT = 1;
    public static final int HIGH_BRIGHTNESS_MODE_HDR = 2;
    public static final int BRIGHTNESS_MAX_REASON_NONE = 0;
    public static final int BRIGHTNESS_MAX_REASON_THERMAL = 1;
    public final float brightness;
    public final float adjustedBrightness;
    public final float brightnessMinimum;
    public final float brightnessMaximum;
    public final float highBrightnessTransitionPoint;
    public final int highBrightnessMode;
    public final int brightnessMaxReason;
    public static final Parcelable.Creator<BrightnessInfo> CREATOR = new Parcelable.Creator<BrightnessInfo>(){

        @Override
        public BrightnessInfo createFromParcel(Parcel source) {
            return new BrightnessInfo(source);
        }

        public BrightnessInfo[] newArray(int size) {
            return new BrightnessInfo[size];
        }
    };

    public BrightnessInfo(float brightness, float brightnessMinimum, float brightnessMaximum, int highBrightnessMode, float highBrightnessTransitionPoint, int brightnessMaxReason) {
        this(brightness, brightness, brightnessMinimum, brightnessMaximum, highBrightnessMode, highBrightnessTransitionPoint, brightnessMaxReason);
    }

    public BrightnessInfo(float brightness, float adjustedBrightness, float brightnessMinimum, float brightnessMaximum, int highBrightnessMode, float highBrightnessTransitionPoint, int brightnessMaxReason) {
        this.brightness = brightness;
        this.adjustedBrightness = adjustedBrightness;
        this.brightnessMinimum = brightnessMinimum;
        this.brightnessMaximum = brightnessMaximum;
        this.highBrightnessMode = highBrightnessMode;
        this.highBrightnessTransitionPoint = highBrightnessTransitionPoint;
        this.brightnessMaxReason = brightnessMaxReason;
    }

    public static String hbmToString(int highBrightnessMode) {
        switch (highBrightnessMode) {
            case 0: {
                return "off";
            }
            case 2: {
                return "hdr";
            }
            case 1: {
                return "sunlight";
            }
        }
        return "invalid";
    }

    public static String briMaxReasonToString(int reason) {
        switch (reason) {
            case 0: {
                return "none";
            }
            case 1: {
                return "thermal";
            }
        }
        return "invalid";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(this.brightness);
        dest.writeFloat(this.adjustedBrightness);
        dest.writeFloat(this.brightnessMinimum);
        dest.writeFloat(this.brightnessMaximum);
        dest.writeInt(this.highBrightnessMode);
        dest.writeFloat(this.highBrightnessTransitionPoint);
        dest.writeInt(this.brightnessMaxReason);
    }

    private BrightnessInfo(Parcel source) {
        this.brightness = source.readFloat();
        this.adjustedBrightness = source.readFloat();
        this.brightnessMinimum = source.readFloat();
        this.brightnessMaximum = source.readFloat();
        this.highBrightnessMode = source.readInt();
        this.highBrightnessTransitionPoint = source.readFloat();
        this.brightnessMaxReason = source.readInt();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BrightnessMaxReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HighBrightnessMode {
    }
}

