/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.pm.ParceledListSlice;
import android.graphics.Point;
import android.hardware.display.BrightnessConfiguration;
import android.hardware.display.BrightnessInfo;
import android.hardware.display.Curve;
import android.hardware.display.IDisplayManagerCallback;
import android.hardware.display.IVirtualDisplayCallback;
import android.hardware.display.VirtualDisplayConfig;
import android.hardware.display.WifiDisplayStatus;
import android.hardware.graphics.common.DisplayDecorationSupport;
import android.media.projection.IMediaProjection;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.Display;
import android.view.DisplayInfo;
import android.view.Surface;

public interface IDisplayManager
extends IInterface {
    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/hardware/display/IDisplayManager.aidl:37:1:37:25")
    public DisplayInfo getDisplayInfo(int var1) throws RemoteException;

    public int[] getDisplayIds(boolean var1) throws RemoteException;

    public boolean isUidPresentOnDisplay(int var1, int var2) throws RemoteException;

    public void registerCallback(IDisplayManagerCallback var1) throws RemoteException;

    public void registerCallbackWithEventMask(IDisplayManagerCallback var1, long var2) throws RemoteException;

    public void startWifiDisplayScan() throws RemoteException;

    public void stopWifiDisplayScan() throws RemoteException;

    public void connectWifiDisplay(String var1) throws RemoteException;

    public void disconnectWifiDisplay() throws RemoteException;

    public void renameWifiDisplay(String var1, String var2) throws RemoteException;

    public void forgetWifiDisplay(String var1) throws RemoteException;

    public void pauseWifiDisplay() throws RemoteException;

    public void resumeWifiDisplay() throws RemoteException;

    public WifiDisplayStatus getWifiDisplayStatus() throws RemoteException;

    public void setUserDisabledHdrTypes(int[] var1) throws RemoteException;

    public void setAreUserDisabledHdrTypesAllowed(boolean var1) throws RemoteException;

    public boolean areUserDisabledHdrTypesAllowed() throws RemoteException;

    public int[] getUserDisabledHdrTypes() throws RemoteException;

    public void requestColorMode(int var1, int var2) throws RemoteException;

    public int createVirtualDisplay(VirtualDisplayConfig var1, IVirtualDisplayCallback var2, IMediaProjection var3, String var4) throws RemoteException;

    public void resizeVirtualDisplay(IVirtualDisplayCallback var1, int var2, int var3, int var4) throws RemoteException;

    public void setVirtualDisplaySurface(IVirtualDisplayCallback var1, Surface var2) throws RemoteException;

    public void releaseVirtualDisplay(IVirtualDisplayCallback var1) throws RemoteException;

    public void setVirtualDisplayState(IVirtualDisplayCallback var1, boolean var2) throws RemoteException;

    public Point getStableDisplaySize() throws RemoteException;

    public ParceledListSlice getBrightnessEvents(String var1) throws RemoteException;

    public ParceledListSlice getAmbientBrightnessStats() throws RemoteException;

    public void setBrightnessConfigurationForUser(BrightnessConfiguration var1, int var2, String var3) throws RemoteException;

    public void setBrightnessConfigurationForDisplay(BrightnessConfiguration var1, String var2, int var3, String var4) throws RemoteException;

    public BrightnessConfiguration getBrightnessConfigurationForDisplay(String var1, int var2) throws RemoteException;

    public BrightnessConfiguration getBrightnessConfigurationForUser(int var1) throws RemoteException;

    public BrightnessConfiguration getDefaultBrightnessConfiguration() throws RemoteException;

    public boolean isMinimalPostProcessingRequested(int var1) throws RemoteException;

    public void setTemporaryBrightness(int var1, float var2) throws RemoteException;

    public void setBrightness(int var1, float var2) throws RemoteException;

    public float getBrightness(int var1) throws RemoteException;

    public void setTemporaryAutoBrightnessAdjustment(float var1) throws RemoteException;

    public Curve getMinimumBrightnessCurve() throws RemoteException;

    public BrightnessInfo getBrightnessInfo(int var1) throws RemoteException;

    public int getPreferredWideGamutColorSpaceId() throws RemoteException;

    public void setUserPreferredDisplayMode(int var1, Display.Mode var2) throws RemoteException;

    public Display.Mode getUserPreferredDisplayMode(int var1) throws RemoteException;

    public Display.Mode getSystemPreferredDisplayMode(int var1) throws RemoteException;

    public void setShouldAlwaysRespectAppRequestedMode(boolean var1) throws RemoteException;

    public boolean shouldAlwaysRespectAppRequestedMode() throws RemoteException;

    public void setRefreshRateSwitchingType(int var1) throws RemoteException;

    public int getRefreshRateSwitchingType() throws RemoteException;

    public DisplayDecorationSupport getDisplayDecorationSupport(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDisplayManager {
        public static final String DESCRIPTOR = "android.hardware.display.IDisplayManager";
        static final int TRANSACTION_getDisplayInfo = 1;
        static final int TRANSACTION_getDisplayIds = 2;
        static final int TRANSACTION_isUidPresentOnDisplay = 3;
        static final int TRANSACTION_registerCallback = 4;
        static final int TRANSACTION_registerCallbackWithEventMask = 5;
        static final int TRANSACTION_startWifiDisplayScan = 6;
        static final int TRANSACTION_stopWifiDisplayScan = 7;
        static final int TRANSACTION_connectWifiDisplay = 8;
        static final int TRANSACTION_disconnectWifiDisplay = 9;
        static final int TRANSACTION_renameWifiDisplay = 10;
        static final int TRANSACTION_forgetWifiDisplay = 11;
        static final int TRANSACTION_pauseWifiDisplay = 12;
        static final int TRANSACTION_resumeWifiDisplay = 13;
        static final int TRANSACTION_getWifiDisplayStatus = 14;
        static final int TRANSACTION_setUserDisabledHdrTypes = 15;
        static final int TRANSACTION_setAreUserDisabledHdrTypesAllowed = 16;
        static final int TRANSACTION_areUserDisabledHdrTypesAllowed = 17;
        static final int TRANSACTION_getUserDisabledHdrTypes = 18;
        static final int TRANSACTION_requestColorMode = 19;
        static final int TRANSACTION_createVirtualDisplay = 20;
        static final int TRANSACTION_resizeVirtualDisplay = 21;
        static final int TRANSACTION_setVirtualDisplaySurface = 22;
        static final int TRANSACTION_releaseVirtualDisplay = 23;
        static final int TRANSACTION_setVirtualDisplayState = 24;
        static final int TRANSACTION_getStableDisplaySize = 25;
        static final int TRANSACTION_getBrightnessEvents = 26;
        static final int TRANSACTION_getAmbientBrightnessStats = 27;
        static final int TRANSACTION_setBrightnessConfigurationForUser = 28;
        static final int TRANSACTION_setBrightnessConfigurationForDisplay = 29;
        static final int TRANSACTION_getBrightnessConfigurationForDisplay = 30;
        static final int TRANSACTION_getBrightnessConfigurationForUser = 31;
        static final int TRANSACTION_getDefaultBrightnessConfiguration = 32;
        static final int TRANSACTION_isMinimalPostProcessingRequested = 33;
        static final int TRANSACTION_setTemporaryBrightness = 34;
        static final int TRANSACTION_setBrightness = 35;
        static final int TRANSACTION_getBrightness = 36;
        static final int TRANSACTION_setTemporaryAutoBrightnessAdjustment = 37;
        static final int TRANSACTION_getMinimumBrightnessCurve = 38;
        static final int TRANSACTION_getBrightnessInfo = 39;
        static final int TRANSACTION_getPreferredWideGamutColorSpaceId = 40;
        static final int TRANSACTION_setUserPreferredDisplayMode = 41;
        static final int TRANSACTION_getUserPreferredDisplayMode = 42;
        static final int TRANSACTION_getSystemPreferredDisplayMode = 43;
        static final int TRANSACTION_setShouldAlwaysRespectAppRequestedMode = 44;
        static final int TRANSACTION_shouldAlwaysRespectAppRequestedMode = 45;
        static final int TRANSACTION_setRefreshRateSwitchingType = 46;
        static final int TRANSACTION_getRefreshRateSwitchingType = 47;
        static final int TRANSACTION_getDisplayDecorationSupport = 48;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IDisplayManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IDisplayManager) {
                return (IDisplayManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getDisplayInfo";
                }
                case 2: {
                    return "getDisplayIds";
                }
                case 3: {
                    return "isUidPresentOnDisplay";
                }
                case 4: {
                    return "registerCallback";
                }
                case 5: {
                    return "registerCallbackWithEventMask";
                }
                case 6: {
                    return "startWifiDisplayScan";
                }
                case 7: {
                    return "stopWifiDisplayScan";
                }
                case 8: {
                    return "connectWifiDisplay";
                }
                case 9: {
                    return "disconnectWifiDisplay";
                }
                case 10: {
                    return "renameWifiDisplay";
                }
                case 11: {
                    return "forgetWifiDisplay";
                }
                case 12: {
                    return "pauseWifiDisplay";
                }
                case 13: {
                    return "resumeWifiDisplay";
                }
                case 14: {
                    return "getWifiDisplayStatus";
                }
                case 15: {
                    return "setUserDisabledHdrTypes";
                }
                case 16: {
                    return "setAreUserDisabledHdrTypesAllowed";
                }
                case 17: {
                    return "areUserDisabledHdrTypesAllowed";
                }
                case 18: {
                    return "getUserDisabledHdrTypes";
                }
                case 19: {
                    return "requestColorMode";
                }
                case 20: {
                    return "createVirtualDisplay";
                }
                case 21: {
                    return "resizeVirtualDisplay";
                }
                case 22: {
                    return "setVirtualDisplaySurface";
                }
                case 23: {
                    return "releaseVirtualDisplay";
                }
                case 24: {
                    return "setVirtualDisplayState";
                }
                case 25: {
                    return "getStableDisplaySize";
                }
                case 26: {
                    return "getBrightnessEvents";
                }
                case 27: {
                    return "getAmbientBrightnessStats";
                }
                case 28: {
                    return "setBrightnessConfigurationForUser";
                }
                case 29: {
                    return "setBrightnessConfigurationForDisplay";
                }
                case 30: {
                    return "getBrightnessConfigurationForDisplay";
                }
                case 31: {
                    return "getBrightnessConfigurationForUser";
                }
                case 32: {
                    return "getDefaultBrightnessConfiguration";
                }
                case 33: {
                    return "isMinimalPostProcessingRequested";
                }
                case 34: {
                    return "setTemporaryBrightness";
                }
                case 35: {
                    return "setBrightness";
                }
                case 36: {
                    return "getBrightness";
                }
                case 37: {
                    return "setTemporaryAutoBrightnessAdjustment";
                }
                case 38: {
                    return "getMinimumBrightnessCurve";
                }
                case 39: {
                    return "getBrightnessInfo";
                }
                case 40: {
                    return "getPreferredWideGamutColorSpaceId";
                }
                case 41: {
                    return "setUserPreferredDisplayMode";
                }
                case 42: {
                    return "getUserPreferredDisplayMode";
                }
                case 43: {
                    return "getSystemPreferredDisplayMode";
                }
                case 44: {
                    return "setShouldAlwaysRespectAppRequestedMode";
                }
                case 45: {
                    return "shouldAlwaysRespectAppRequestedMode";
                }
                case 46: {
                    return "setRefreshRateSwitchingType";
                }
                case 47: {
                    return "getRefreshRateSwitchingType";
                }
                case 48: {
                    return "getDisplayDecorationSupport";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    DisplayInfo _result = this.getDisplayInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    int[] _result = this.getDisplayIds(_arg0);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isUidPresentOnDisplay(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    IDisplayManagerCallback _arg0 = IDisplayManagerCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    IDisplayManagerCallback _arg0 = IDisplayManagerCallback.Stub.asInterface(data.readStrongBinder());
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.registerCallbackWithEventMask(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    this.startWifiDisplayScan();
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    this.stopWifiDisplayScan();
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.connectWifiDisplay(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    this.disconnectWifiDisplay();
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.renameWifiDisplay(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.forgetWifiDisplay(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    this.pauseWifiDisplay();
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    this.resumeWifiDisplay();
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    WifiDisplayStatus _result = this.getWifiDisplayStatus();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 15: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.setUserDisabledHdrTypes(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setAreUserDisabledHdrTypesAllowed(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    boolean _result = this.areUserDisabledHdrTypesAllowed();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 18: {
                    int[] _result = this.getUserDisabledHdrTypes();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.requestColorMode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    VirtualDisplayConfig _arg0 = data.readTypedObject(VirtualDisplayConfig.CREATOR);
                    IVirtualDisplayCallback _arg1 = IVirtualDisplayCallback.Stub.asInterface(data.readStrongBinder());
                    IMediaProjection _arg2 = IMediaProjection.Stub.asInterface(data.readStrongBinder());
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.createVirtualDisplay(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 21: {
                    IVirtualDisplayCallback _arg0 = IVirtualDisplayCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.resizeVirtualDisplay(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    IVirtualDisplayCallback _arg0 = IVirtualDisplayCallback.Stub.asInterface(data.readStrongBinder());
                    Surface _arg1 = data.readTypedObject(Surface.CREATOR);
                    data.enforceNoDataAvail();
                    this.setVirtualDisplaySurface(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    IVirtualDisplayCallback _arg0 = IVirtualDisplayCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.releaseVirtualDisplay(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    IVirtualDisplayCallback _arg0 = IVirtualDisplayCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setVirtualDisplayState(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    Point _result = this.getStableDisplaySize();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 26: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    ParceledListSlice _result = this.getBrightnessEvents(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 27: {
                    ParceledListSlice _result = this.getAmbientBrightnessStats();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 28: {
                    BrightnessConfiguration _arg0 = data.readTypedObject(BrightnessConfiguration.CREATOR);
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.setBrightnessConfigurationForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    BrightnessConfiguration _arg0 = data.readTypedObject(BrightnessConfiguration.CREATOR);
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    this.setBrightnessConfigurationForDisplay(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    BrightnessConfiguration _result = this.getBrightnessConfigurationForDisplay(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 31: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    BrightnessConfiguration _result = this.getBrightnessConfigurationForUser(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 32: {
                    BrightnessConfiguration _result = this.getDefaultBrightnessConfiguration();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 33: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isMinimalPostProcessingRequested(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 34: {
                    int _arg0 = data.readInt();
                    float _arg1 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setTemporaryBrightness(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    int _arg0 = data.readInt();
                    float _arg1 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setBrightness(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    float _result = this.getBrightness(_arg0);
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 37: {
                    float _arg0 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setTemporaryAutoBrightnessAdjustment(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    Curve _result = this.getMinimumBrightnessCurve();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 39: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    BrightnessInfo _result = this.getBrightnessInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 40: {
                    int _result = this.getPreferredWideGamutColorSpaceId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 41: {
                    int _arg0 = data.readInt();
                    Display.Mode _arg1 = data.readTypedObject(Display.Mode.CREATOR);
                    data.enforceNoDataAvail();
                    this.setUserPreferredDisplayMode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 42: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Display.Mode _result = this.getUserPreferredDisplayMode(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 43: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Display.Mode _result = this.getSystemPreferredDisplayMode(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 44: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setShouldAlwaysRespectAppRequestedMode(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    boolean _result = this.shouldAlwaysRespectAppRequestedMode();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 46: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setRefreshRateSwitchingType(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    int _result = this.getRefreshRateSwitchingType();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 48: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    DisplayDecorationSupport _result = this.getDisplayDecorationSupport(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 47;
        }

        private static class Proxy
        implements IDisplayManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DisplayInfo getDisplayInfo(int displayId) throws RemoteException {
                DisplayInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(DisplayInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getDisplayIds(boolean includeDisabled) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(includeDisabled);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isUidPresentOnDisplay(int uid, int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCallback(IDisplayManagerCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCallbackWithEventMask(IDisplayManagerCallback callback2, long eventsMask) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback2);
                    _data.writeLong(eventsMask);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startWifiDisplayScan() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopWifiDisplayScan() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connectWifiDisplay(String address) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disconnectWifiDisplay() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void renameWifiDisplay(String address, String alias) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    _data.writeString(alias);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forgetWifiDisplay(String address) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(address);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void pauseWifiDisplay() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resumeWifiDisplay() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WifiDisplayStatus getWifiDisplayStatus() throws RemoteException {
                WifiDisplayStatus _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(WifiDisplayStatus.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUserDisabledHdrTypes(int[] userDisabledTypes) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(userDisabledTypes);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAreUserDisabledHdrTypesAllowed(boolean areUserDisabledHdrTypesAllowed) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(areUserDisabledHdrTypesAllowed);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean areUserDisabledHdrTypesAllowed() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getUserDisabledHdrTypes() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestColorMode(int displayId, int colorMode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(colorMode);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int createVirtualDisplay(VirtualDisplayConfig virtualDisplayConfig, IVirtualDisplayCallback callback2, IMediaProjection projectionToken, String packageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(virtualDisplayConfig, 0);
                    _data.writeStrongInterface(callback2);
                    _data.writeStrongInterface(projectionToken);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resizeVirtualDisplay(IVirtualDisplayCallback token, int width2, int height2, int densityDpi) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeInt(width2);
                    _data.writeInt(height2);
                    _data.writeInt(densityDpi);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVirtualDisplaySurface(IVirtualDisplayCallback token, Surface surface2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeTypedObject(surface2, 0);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseVirtualDisplay(IVirtualDisplayCallback token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVirtualDisplayState(IVirtualDisplayCallback token, boolean isOn) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(token);
                    _data.writeBoolean(isOn);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Point getStableDisplaySize() throws RemoteException {
                Point _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Point.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getBrightnessEvents(String callingPackage) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getAmbientBrightnessStats() throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBrightnessConfigurationForUser(BrightnessConfiguration c, int userId, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(c, 0);
                    _data.writeInt(userId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBrightnessConfigurationForDisplay(BrightnessConfiguration c, String uniqueDisplayId, int userId, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(c, 0);
                    _data.writeString(uniqueDisplayId);
                    _data.writeInt(userId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BrightnessConfiguration getBrightnessConfigurationForDisplay(String uniqueDisplayId, int userId) throws RemoteException {
                BrightnessConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uniqueDisplayId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(BrightnessConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BrightnessConfiguration getBrightnessConfigurationForUser(int userId) throws RemoteException {
                BrightnessConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(BrightnessConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BrightnessConfiguration getDefaultBrightnessConfiguration() throws RemoteException {
                BrightnessConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(BrightnessConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMinimalPostProcessingRequested(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTemporaryBrightness(int displayId, float brightness) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeFloat(brightness);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBrightness(int displayId, float brightness) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeFloat(brightness);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getBrightness(int displayId) throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTemporaryAutoBrightnessAdjustment(float adjustment) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(adjustment);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Curve getMinimumBrightnessCurve() throws RemoteException {
                Curve _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Curve.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BrightnessInfo getBrightnessInfo(int displayId) throws RemoteException {
                BrightnessInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(BrightnessInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPreferredWideGamutColorSpaceId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUserPreferredDisplayMode(int displayId, Display.Mode mode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(mode, 0);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Display.Mode getUserPreferredDisplayMode(int displayId) throws RemoteException {
                Display.Mode _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Display.Mode.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Display.Mode getSystemPreferredDisplayMode(int displayId) throws RemoteException {
                Display.Mode _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Display.Mode.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShouldAlwaysRespectAppRequestedMode(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldAlwaysRespectAppRequestedMode() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRefreshRateSwitchingType(int newValue) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(newValue);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRefreshRateSwitchingType() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DisplayDecorationSupport getDisplayDecorationSupport(int displayId) throws RemoteException {
                DisplayDecorationSupport _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(DisplayDecorationSupport.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IDisplayManager {
        @Override
        public DisplayInfo getDisplayInfo(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public int[] getDisplayIds(boolean includeDisabled) throws RemoteException {
            return null;
        }

        @Override
        public boolean isUidPresentOnDisplay(int uid, int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void registerCallback(IDisplayManagerCallback callback2) throws RemoteException {
        }

        @Override
        public void registerCallbackWithEventMask(IDisplayManagerCallback callback2, long eventsMask) throws RemoteException {
        }

        @Override
        public void startWifiDisplayScan() throws RemoteException {
        }

        @Override
        public void stopWifiDisplayScan() throws RemoteException {
        }

        @Override
        public void connectWifiDisplay(String address) throws RemoteException {
        }

        @Override
        public void disconnectWifiDisplay() throws RemoteException {
        }

        @Override
        public void renameWifiDisplay(String address, String alias) throws RemoteException {
        }

        @Override
        public void forgetWifiDisplay(String address) throws RemoteException {
        }

        @Override
        public void pauseWifiDisplay() throws RemoteException {
        }

        @Override
        public void resumeWifiDisplay() throws RemoteException {
        }

        @Override
        public WifiDisplayStatus getWifiDisplayStatus() throws RemoteException {
            return null;
        }

        @Override
        public void setUserDisabledHdrTypes(int[] userDisabledTypes) throws RemoteException {
        }

        @Override
        public void setAreUserDisabledHdrTypesAllowed(boolean areUserDisabledHdrTypesAllowed) throws RemoteException {
        }

        @Override
        public boolean areUserDisabledHdrTypesAllowed() throws RemoteException {
            return false;
        }

        @Override
        public int[] getUserDisabledHdrTypes() throws RemoteException {
            return null;
        }

        @Override
        public void requestColorMode(int displayId, int colorMode) throws RemoteException {
        }

        @Override
        public int createVirtualDisplay(VirtualDisplayConfig virtualDisplayConfig, IVirtualDisplayCallback callback2, IMediaProjection projectionToken, String packageName) throws RemoteException {
            return 0;
        }

        @Override
        public void resizeVirtualDisplay(IVirtualDisplayCallback token, int width2, int height2, int densityDpi) throws RemoteException {
        }

        @Override
        public void setVirtualDisplaySurface(IVirtualDisplayCallback token, Surface surface2) throws RemoteException {
        }

        @Override
        public void releaseVirtualDisplay(IVirtualDisplayCallback token) throws RemoteException {
        }

        @Override
        public void setVirtualDisplayState(IVirtualDisplayCallback token, boolean isOn) throws RemoteException {
        }

        @Override
        public Point getStableDisplaySize() throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getBrightnessEvents(String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getAmbientBrightnessStats() throws RemoteException {
            return null;
        }

        @Override
        public void setBrightnessConfigurationForUser(BrightnessConfiguration c, int userId, String packageName) throws RemoteException {
        }

        @Override
        public void setBrightnessConfigurationForDisplay(BrightnessConfiguration c, String uniqueDisplayId, int userId, String packageName) throws RemoteException {
        }

        @Override
        public BrightnessConfiguration getBrightnessConfigurationForDisplay(String uniqueDisplayId, int userId) throws RemoteException {
            return null;
        }

        @Override
        public BrightnessConfiguration getBrightnessConfigurationForUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public BrightnessConfiguration getDefaultBrightnessConfiguration() throws RemoteException {
            return null;
        }

        @Override
        public boolean isMinimalPostProcessingRequested(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void setTemporaryBrightness(int displayId, float brightness) throws RemoteException {
        }

        @Override
        public void setBrightness(int displayId, float brightness) throws RemoteException {
        }

        @Override
        public float getBrightness(int displayId) throws RemoteException {
            return 0.0f;
        }

        @Override
        public void setTemporaryAutoBrightnessAdjustment(float adjustment) throws RemoteException {
        }

        @Override
        public Curve getMinimumBrightnessCurve() throws RemoteException {
            return null;
        }

        @Override
        public BrightnessInfo getBrightnessInfo(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public int getPreferredWideGamutColorSpaceId() throws RemoteException {
            return 0;
        }

        @Override
        public void setUserPreferredDisplayMode(int displayId, Display.Mode mode) throws RemoteException {
        }

        @Override
        public Display.Mode getUserPreferredDisplayMode(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public Display.Mode getSystemPreferredDisplayMode(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public void setShouldAlwaysRespectAppRequestedMode(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean shouldAlwaysRespectAppRequestedMode() throws RemoteException {
            return false;
        }

        @Override
        public void setRefreshRateSwitchingType(int newValue) throws RemoteException {
        }

        @Override
        public int getRefreshRateSwitchingType() throws RemoteException {
            return 0;
        }

        @Override
        public DisplayDecorationSupport getDisplayDecorationSupport(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

