/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.fingerprint;

import android.annotation.RequiresPermission;
import android.app.ActivityManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.hardware.biometrics.BiometricAuthenticator;
import android.hardware.biometrics.BiometricFingerprintConstants;
import android.hardware.biometrics.BiometricStateListener;
import android.hardware.biometrics.BiometricTestSession;
import android.hardware.biometrics.IBiometricServiceLockoutResetCallback;
import android.hardware.biometrics.SensorProperties;
import android.hardware.fingerprint.Fingerprint;
import android.hardware.fingerprint.FingerprintSensorProperties;
import android.hardware.fingerprint.FingerprintSensorPropertiesInternal;
import android.hardware.fingerprint.IFingerprintAuthenticatorsRegisteredCallback;
import android.hardware.fingerprint.IFingerprintService;
import android.hardware.fingerprint.IFingerprintServiceReceiver;
import android.hardware.fingerprint.ISidefpsController;
import android.hardware.fingerprint.IUdfpsOverlayController;
import android.os.Binder;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.UserHandle;
import android.security.identity.IdentityCredential;
import android.security.identity.PresentationSession;
import android.util.Slog;
import com.android.internal.util.FrameworkStatsLog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.Signature;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.Mac;

@Deprecated
public class FingerprintManager
implements BiometricAuthenticator,
BiometricFingerprintConstants {
    private static final String TAG = "FingerprintManager";
    private static final boolean DEBUG = true;
    private static final int MSG_ENROLL_RESULT = 100;
    private static final int MSG_ACQUIRED = 101;
    private static final int MSG_AUTHENTICATION_SUCCEEDED = 102;
    private static final int MSG_AUTHENTICATION_FAILED = 103;
    private static final int MSG_ERROR = 104;
    private static final int MSG_REMOVED = 105;
    private static final int MSG_CHALLENGE_GENERATED = 106;
    private static final int MSG_FINGERPRINT_DETECTED = 107;
    private static final int MSG_UDFPS_POINTER_DOWN = 108;
    private static final int MSG_UDFPS_POINTER_UP = 109;
    public static final int ENROLL_FIND_SENSOR = 1;
    public static final int ENROLL_ENROLL = 2;
    public static final int SENSOR_ID_ANY = -1;
    private IFingerprintService mService;
    private Context mContext;
    private IBinder mToken = new Binder();
    private AuthenticationCallback mAuthenticationCallback;
    private FingerprintDetectionCallback mFingerprintDetectionCallback;
    private EnrollmentCallback mEnrollmentCallback;
    private RemovalCallback mRemovalCallback;
    private GenerateChallengeCallback mGenerateChallengeCallback;
    private CryptoObject mCryptoObject;
    private RemoveTracker mRemoveTracker;
    private Handler mHandler;
    private float[] mEnrollStageThresholds;
    private IFingerprintServiceReceiver mServiceReceiver = new IFingerprintServiceReceiver.Stub(){

        @Override
        public void onEnrollResult(Fingerprint fp, int remaining) {
            FingerprintManager.this.mHandler.obtainMessage(100, remaining, 0, fp).sendToTarget();
        }

        @Override
        public void onAcquired(int acquireInfo, int vendorCode) {
            FingerprintManager.this.mHandler.obtainMessage(101, acquireInfo, vendorCode).sendToTarget();
        }

        @Override
        public void onAuthenticationSucceeded(Fingerprint fp, int userId, boolean isStrongBiometric) {
            FingerprintManager.this.mHandler.obtainMessage(102, userId, isStrongBiometric ? 1 : 0, fp).sendToTarget();
        }

        @Override
        public void onFingerprintDetected(int sensorId, int userId, boolean isStrongBiometric) {
            FingerprintManager.this.mHandler.obtainMessage(107, sensorId, userId, isStrongBiometric).sendToTarget();
        }

        @Override
        public void onAuthenticationFailed() {
            FingerprintManager.this.mHandler.obtainMessage(103).sendToTarget();
        }

        @Override
        public void onError(int error, int vendorCode) {
            FingerprintManager.this.mHandler.obtainMessage(104, error, vendorCode).sendToTarget();
        }

        @Override
        public void onRemoved(Fingerprint fp, int remaining) {
            FingerprintManager.this.mHandler.obtainMessage(105, remaining, 0, fp).sendToTarget();
        }

        @Override
        public void onChallengeGenerated(int sensorId, int userId, long challenge) {
            FingerprintManager.this.mHandler.obtainMessage(106, sensorId, userId, challenge).sendToTarget();
        }

        @Override
        public void onUdfpsPointerDown(int sensorId) {
            FingerprintManager.this.mHandler.obtainMessage(108, sensorId, 0).sendToTarget();
        }

        @Override
        public void onUdfpsPointerUp(int sensorId) {
            FingerprintManager.this.mHandler.obtainMessage(109, sensorId, 0).sendToTarget();
        }
    };

    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public List<SensorProperties> getSensorProperties() {
        ArrayList<SensorProperties> properties2 = new ArrayList<SensorProperties>();
        List<FingerprintSensorPropertiesInternal> internalProperties = this.getSensorPropertiesInternal();
        for (FingerprintSensorPropertiesInternal internalProp : internalProperties) {
            properties2.add(FingerprintSensorProperties.from(internalProp));
        }
        return properties2;
    }

    @RequiresPermission(value="android.permission.TEST_BIOMETRIC")
    public BiometricTestSession createTestSession(int sensorId) {
        try {
            return new BiometricTestSession(this.mContext, sensorId, (context, sensorId1, callback2) -> this.mService.createTestSession(sensorId1, callback2, context.getOpPackageName()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void useHandler(Handler handler) {
        if (handler != null) {
            this.mHandler = new MyHandler(handler.getLooper());
        } else if (this.mHandler.getLooper() != this.mContext.getMainLooper()) {
            this.mHandler = new MyHandler(this.mContext.getMainLooper());
        }
    }

    @Deprecated
    @RequiresPermission(anyOf={"android.permission.USE_BIOMETRIC", "android.permission.USE_FINGERPRINT"})
    public void authenticate(CryptoObject crypto, CancellationSignal cancel, int flags, AuthenticationCallback callback2, Handler handler) {
        this.authenticate(crypto, cancel, callback2, handler, -1, this.mContext.getUserId(), flags);
    }

    @RequiresPermission(anyOf={"android.permission.USE_BIOMETRIC", "android.permission.USE_FINGERPRINT"})
    public void authenticate(CryptoObject crypto, CancellationSignal cancel, AuthenticationCallback callback2, Handler handler, int userId) {
        this.authenticate(crypto, cancel, callback2, handler, -1, userId, 0);
    }

    @RequiresPermission(anyOf={"android.permission.USE_BIOMETRIC", "android.permission.USE_FINGERPRINT"})
    public void authenticate(CryptoObject crypto, CancellationSignal cancel, AuthenticationCallback callback2, Handler handler, int sensorId, int userId, int flags) {
        boolean ignoreEnrollmentState;
        FrameworkStatsLog.write(356, 1, this.mContext.getApplicationInfo().uid, this.mContext.getApplicationInfo().targetSdkVersion);
        if (callback2 == null) {
            throw new IllegalArgumentException("Must supply an authentication callback");
        }
        if (cancel != null && cancel.isCanceled()) {
            Slog.w(TAG, "authentication already canceled");
            return;
        }
        boolean bl = ignoreEnrollmentState = flags != 0;
        if (this.mService != null) {
            try {
                this.useHandler(handler);
                this.mAuthenticationCallback = callback2;
                this.mCryptoObject = crypto;
                long operationId = crypto != null ? crypto.getOpId() : 0L;
                long authId = this.mService.authenticate(this.mToken, operationId, sensorId, userId, this.mServiceReceiver, this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), ignoreEnrollmentState);
                if (cancel != null) {
                    cancel.setOnCancelListener(new OnAuthenticationCancelListener(authId));
                }
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Remote exception while authenticating: ", e);
                callback2.onAuthenticationError(1, FingerprintManager.getErrorString(this.mContext, 1, 0));
            }
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void detectFingerprint(CancellationSignal cancel, FingerprintDetectionCallback callback2, int userId) {
        if (this.mService == null) {
            return;
        }
        if (cancel.isCanceled()) {
            Slog.w(TAG, "Detection already cancelled");
            return;
        }
        this.mFingerprintDetectionCallback = callback2;
        try {
            long authId = this.mService.detectFingerprint(this.mToken, userId, this.mServiceReceiver, this.mContext.getOpPackageName());
            cancel.setOnCancelListener(new OnFingerprintDetectionCancelListener(authId));
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Remote exception when requesting finger detect", e);
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_FINGERPRINT")
    public void enroll(byte[] hardwareAuthToken, CancellationSignal cancel, int userId, EnrollmentCallback callback2, int enrollReason) {
        if (userId == -2) {
            userId = this.getCurrentUserId();
        }
        if (callback2 == null) {
            throw new IllegalArgumentException("Must supply an enrollment callback");
        }
        if (cancel != null && cancel.isCanceled()) {
            Slog.w(TAG, "enrollment already canceled");
            return;
        }
        if (this.mService != null) {
            try {
                this.mEnrollmentCallback = callback2;
                long enrollId = this.mService.enroll(this.mToken, hardwareAuthToken, userId, this.mServiceReceiver, this.mContext.getOpPackageName(), enrollReason);
                if (cancel != null) {
                    cancel.setOnCancelListener(new OnEnrollCancelListener(enrollId));
                }
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Remote exception in enroll: ", e);
                callback2.onEnrollmentError(1, FingerprintManager.getErrorString(this.mContext, 1, 0));
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_FINGERPRINT")
    public void generateChallenge(int sensorId, int userId, GenerateChallengeCallback callback2) {
        if (this.mService != null) {
            try {
                this.mGenerateChallengeCallback = callback2;
                this.mService.generateChallenge(this.mToken, sensorId, userId, this.mServiceReceiver, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_FINGERPRINT")
    public void generateChallenge(int userId, GenerateChallengeCallback callback2) {
        FingerprintSensorPropertiesInternal sensorProps = this.getFirstFingerprintSensor();
        if (sensorProps == null) {
            Slog.e(TAG, "No sensors");
            return;
        }
        this.generateChallenge(sensorProps.sensorId, userId, callback2);
    }

    @RequiresPermission(value="android.permission.MANAGE_FINGERPRINT")
    public void revokeChallenge(int userId, long challenge) {
        if (this.mService != null) {
            try {
                FingerprintSensorPropertiesInternal sensorProps = this.getFirstFingerprintSensor();
                if (sensorProps == null) {
                    Slog.e(TAG, "No sensors");
                    return;
                }
                this.mService.revokeChallenge(this.mToken, sensorProps.sensorId, userId, this.mContext.getOpPackageName(), challenge);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.RESET_FINGERPRINT_LOCKOUT")
    public void resetLockout(int sensorId, int userId, byte[] hardwareAuthToken) {
        if (this.mService != null) {
            try {
                this.mService.resetLockout(this.mToken, sensorId, userId, hardwareAuthToken, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_FINGERPRINT")
    public void remove(Fingerprint fp, int userId, RemovalCallback callback2) {
        if (this.mService != null) {
            try {
                this.mRemovalCallback = callback2;
                this.mRemoveTracker = new RemoveTracker(1, fp);
                this.mService.remove(this.mToken, fp.getBiometricId(), userId, this.mServiceReceiver, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_FINGERPRINT")
    public void removeAll(int userId, RemovalCallback callback2) {
        if (this.mService != null) {
            try {
                this.mRemovalCallback = callback2;
                this.mRemoveTracker = new RemoveTracker(2, null);
                this.mService.removeAll(this.mToken, userId, this.mServiceReceiver, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_FINGERPRINT")
    public void rename(int fpId, int userId, String newName) {
        if (this.mService != null) {
            try {
                this.mService.rename(fpId, userId, newName);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        } else {
            Slog.w(TAG, "rename(): Service not connected!");
        }
    }

    @RequiresPermission(value="android.permission.USE_FINGERPRINT")
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public List<Fingerprint> getEnrolledFingerprints(int userId) {
        if (this.mService != null) {
            try {
                return this.mService.getEnrolledFingerprints(userId, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    @RequiresPermission(value="android.permission.USE_FINGERPRINT")
    @UnsupportedAppUsage
    public List<Fingerprint> getEnrolledFingerprints() {
        return this.getEnrolledFingerprints(this.mContext.getUserId());
    }

    public boolean hasEnrolledTemplates() {
        return this.hasEnrolledFingerprints();
    }

    public boolean hasEnrolledTemplates(int userId) {
        return this.hasEnrolledFingerprints(userId);
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void setUdfpsOverlayController(IUdfpsOverlayController controller) {
        if (this.mService == null) {
            Slog.w(TAG, "setUdfpsOverlayController: no fingerprint service");
            return;
        }
        try {
            this.mService.setUdfpsOverlayController(controller);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void setSidefpsController(ISidefpsController controller) {
        if (this.mService == null) {
            Slog.w(TAG, "setSidefpsController: no fingerprint service");
            return;
        }
        try {
            this.mService.setSidefpsController(controller);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void registerBiometricStateListener(BiometricStateListener listener2) {
        try {
            this.mService.registerBiometricStateListener(listener2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void onPointerDown(long requestId, int sensorId, int x, int y, float minor, float major) {
        if (this.mService == null) {
            Slog.w(TAG, "onFingerDown: no fingerprint service");
            return;
        }
        try {
            this.mService.onPointerDown(requestId, sensorId, x, y, minor, major);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void onPointerUp(long requestId, int sensorId) {
        if (this.mService == null) {
            Slog.w(TAG, "onFingerDown: no fingerprint service");
            return;
        }
        try {
            this.mService.onPointerUp(requestId, sensorId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void onUiReady(long requestId, int sensorId) {
        if (this.mService == null) {
            Slog.w(TAG, "onUiReady: no fingerprint service");
            return;
        }
        try {
            this.mService.onUiReady(requestId, sensorId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.USE_FINGERPRINT")
    public boolean hasEnrolledFingerprints() {
        FrameworkStatsLog.write(356, 2, this.mContext.getApplicationInfo().uid, this.mContext.getApplicationInfo().targetSdkVersion);
        return this.hasEnrolledFingerprints(UserHandle.myUserId());
    }

    @RequiresPermission(allOf={"android.permission.USE_FINGERPRINT", "android.permission.INTERACT_ACROSS_USERS"})
    public boolean hasEnrolledFingerprints(int userId) {
        if (this.mService != null) {
            try {
                return this.mService.hasEnrolledFingerprintsDeprecated(userId, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    @Deprecated
    @RequiresPermission(value="android.permission.USE_FINGERPRINT")
    public boolean isHardwareDetected() {
        FrameworkStatsLog.write(356, 3, this.mContext.getApplicationInfo().uid, this.mContext.getApplicationInfo().targetSdkVersion);
        if (this.mService != null) {
            try {
                return this.mService.isHardwareDetectedDeprecated(this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        Slog.w(TAG, "isFingerprintHardwareDetected(): Service not connected!");
        return false;
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public List<FingerprintSensorPropertiesInternal> getSensorPropertiesInternal() {
        try {
            if (this.mService == null) {
                return new ArrayList<FingerprintSensorPropertiesInternal>();
            }
            return this.mService.getSensorPropertiesInternal(this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isPowerbuttonFps() {
        FingerprintSensorPropertiesInternal sensorProps = this.getFirstFingerprintSensor();
        return sensorProps.sensorType == 4;
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public void addAuthenticatorsRegisteredCallback(IFingerprintAuthenticatorsRegisteredCallback callback2) {
        if (this.mService != null) {
            try {
                this.mService.addAuthenticatorsRegisteredCallback(callback2);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        } else {
            Slog.w(TAG, "addProvidersAvailableCallback(): Service not connected!");
        }
    }

    @RequiresPermission(value="android.permission.USE_BIOMETRIC_INTERNAL")
    public int getLockoutModeForUser(int sensorId, int userId) {
        if (this.mService != null) {
            try {
                return this.mService.getLockoutModeForUser(sensorId, userId);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
            }
        }
        return 0;
    }

    public void addLockoutResetCallback(final LockoutResetCallback callback2) {
        if (this.mService != null) {
            try {
                final PowerManager powerManager = this.mContext.getSystemService(PowerManager.class);
                this.mService.addLockoutResetCallback(new IBiometricServiceLockoutResetCallback.Stub(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onLockoutReset(int sensorId, IRemoteCallback serverCallback) throws RemoteException {
                        try {
                            PowerManager.WakeLock wakeLock = powerManager.newWakeLock(1, "lockoutResetCallback");
                            wakeLock.acquire();
                            FingerprintManager.this.mHandler.post(() -> {
                                try {
                                    callback2.onLockoutReset(sensorId);
                                }
                                finally {
                                    wakeLock.release();
                                }
                            });
                        }
                        finally {
                            serverCallback.sendResult(null);
                        }
                    }
                }, this.mContext.getOpPackageName());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        } else {
            Slog.w(TAG, "addLockoutResetCallback(): Service not connected!");
        }
    }

    private void sendRemovedResult(Fingerprint fingerprint, int remaining) {
        if (this.mRemovalCallback == null) {
            return;
        }
        if (this.mRemoveTracker == null) {
            Slog.w(TAG, "Removal tracker is null");
            return;
        }
        if (this.mRemoveTracker.mRemoveRequest == 1) {
            if (fingerprint == null) {
                Slog.e(TAG, "Received MSG_REMOVED, but fingerprint is null");
                return;
            }
            if (this.mRemoveTracker.mSingleFingerprint == null) {
                Slog.e(TAG, "Missing fingerprint");
                return;
            }
            int fingerId = fingerprint.getBiometricId();
            int reqFingerId = this.mRemoveTracker.mSingleFingerprint.getBiometricId();
            if (reqFingerId != 0 && fingerId != 0 && fingerId != reqFingerId) {
                Slog.w(TAG, "Finger id didn't match: " + fingerId + " != " + reqFingerId);
                return;
            }
        }
        this.mRemovalCallback.onRemovalSucceeded(fingerprint, remaining);
    }

    private void sendEnrollResult(Fingerprint fp, int remaining) {
        if (this.mEnrollmentCallback != null) {
            this.mEnrollmentCallback.onEnrollmentProgress(remaining);
        }
    }

    private void sendAuthenticatedSucceeded(Fingerprint fp, int userId, boolean isStrongBiometric) {
        if (this.mAuthenticationCallback != null) {
            AuthenticationResult result = new AuthenticationResult(this.mCryptoObject, fp, userId, isStrongBiometric);
            this.mAuthenticationCallback.onAuthenticationSucceeded(result);
        }
    }

    private void sendAuthenticatedFailed() {
        if (this.mAuthenticationCallback != null) {
            this.mAuthenticationCallback.onAuthenticationFailed();
        }
    }

    private void sendAcquiredResult(int acquireInfo, int vendorCode) {
        int clientInfo;
        String msg;
        if (this.mAuthenticationCallback != null) {
            this.mAuthenticationCallback.onAuthenticationAcquired(acquireInfo);
        }
        if ((msg = FingerprintManager.getAcquiredString(this.mContext, acquireInfo, vendorCode)) == null) {
            return;
        }
        int n = clientInfo = acquireInfo == 6 ? vendorCode + 1000 : acquireInfo;
        if (this.mEnrollmentCallback != null) {
            this.mEnrollmentCallback.onEnrollmentHelp(clientInfo, msg);
        } else if (this.mAuthenticationCallback != null && acquireInfo != 7) {
            this.mAuthenticationCallback.onAuthenticationHelp(clientInfo, msg);
        }
    }

    private void sendErrorResult(int errMsgId, int vendorCode) {
        int clientErrMsgId;
        int n = clientErrMsgId = errMsgId == 8 ? vendorCode + 1000 : errMsgId;
        if (this.mEnrollmentCallback != null) {
            this.mEnrollmentCallback.onEnrollmentError(clientErrMsgId, FingerprintManager.getErrorString(this.mContext, errMsgId, vendorCode));
        } else if (this.mAuthenticationCallback != null) {
            this.mAuthenticationCallback.onAuthenticationError(clientErrMsgId, FingerprintManager.getErrorString(this.mContext, errMsgId, vendorCode));
        } else if (this.mRemovalCallback != null) {
            Fingerprint fp = this.mRemoveTracker != null ? this.mRemoveTracker.mSingleFingerprint : null;
            this.mRemovalCallback.onRemovalError(fp, clientErrMsgId, FingerprintManager.getErrorString(this.mContext, errMsgId, vendorCode));
        }
    }

    private void sendChallengeGenerated(int sensorId, int userId, long challenge) {
        if (this.mGenerateChallengeCallback == null) {
            Slog.e(TAG, "sendChallengeGenerated, callback null");
            return;
        }
        this.mGenerateChallengeCallback.onChallengeGenerated(sensorId, userId, challenge);
    }

    private void sendFingerprintDetected(int sensorId, int userId, boolean isStrongBiometric) {
        if (this.mFingerprintDetectionCallback == null) {
            Slog.e(TAG, "sendFingerprintDetected, callback null");
            return;
        }
        this.mFingerprintDetectionCallback.onFingerprintDetected(sensorId, userId, isStrongBiometric);
    }

    private void sendUdfpsPointerDown(int sensorId) {
        if (this.mAuthenticationCallback == null) {
            Slog.e(TAG, "sendUdfpsPointerDown, callback null");
            return;
        }
        this.mAuthenticationCallback.onUdfpsPointerDown(sensorId);
    }

    private void sendUdfpsPointerUp(int sensorId) {
        if (this.mAuthenticationCallback == null) {
            Slog.e(TAG, "sendUdfpsPointerUp, callback null");
            return;
        }
        this.mAuthenticationCallback.onUdfpsPointerUp(sensorId);
    }

    public FingerprintManager(Context context, IFingerprintService service) {
        this.mContext = context;
        this.mService = service;
        if (this.mService == null) {
            Slog.v(TAG, "FingerprintService was null");
        }
        this.mHandler = new MyHandler(context);
    }

    private int getCurrentUserId() {
        try {
            return ActivityManager.getService().getCurrentUser().id;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private FingerprintSensorPropertiesInternal getFirstFingerprintSensor() {
        List<FingerprintSensorPropertiesInternal> allSensors = this.getSensorPropertiesInternal();
        return allSensors.isEmpty() ? null : allSensors.get(0);
    }

    private void cancelEnrollment(long requestId) {
        if (this.mService != null) {
            try {
                this.mService.cancelEnrollment(this.mToken, requestId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private void cancelAuthentication(long requestId) {
        if (this.mService != null) {
            try {
                this.mService.cancelAuthentication(this.mToken, this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), requestId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private void cancelFingerprintDetect(long requestId) {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.cancelFingerprintDetect(this.mToken, this.mContext.getOpPackageName(), requestId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getEnrollStageCount() {
        if (this.mEnrollStageThresholds == null) {
            this.mEnrollStageThresholds = FingerprintManager.createEnrollStageThresholds(this.mContext);
        }
        return this.mEnrollStageThresholds.length + 1;
    }

    public float getEnrollStageThreshold(int index) {
        if (this.mEnrollStageThresholds == null) {
            this.mEnrollStageThresholds = FingerprintManager.createEnrollStageThresholds(this.mContext);
        }
        if (index < 0 || index > this.mEnrollStageThresholds.length) {
            Slog.w(TAG, "Unsupported enroll stage index: " + index);
            return index < 0 ? 0.0f : 1.0f;
        }
        return index == this.mEnrollStageThresholds.length ? 1.0f : this.mEnrollStageThresholds[index];
    }

    private static float[] createEnrollStageThresholds(Context context) {
        String[] enrollStageThresholdStrings = context.getResources().getStringArray(17236145);
        float[] enrollStageThresholds = new float[enrollStageThresholdStrings.length];
        for (int i = 0; i < enrollStageThresholds.length; ++i) {
            enrollStageThresholds[i] = Float.parseFloat(enrollStageThresholdStrings[i]);
        }
        return enrollStageThresholds;
    }

    public static String getErrorString(Context context, int errMsg, int vendorCode) {
        switch (errMsg) {
            case 1: {
                return context.getString(17040343);
            }
            case 2: {
                return context.getString(17040352);
            }
            case 3: {
                return context.getString(17040351);
            }
            case 4: {
                return context.getString(17040348);
            }
            case 5: {
                return context.getString(17040342);
            }
            case 7: {
                return context.getString(17040345);
            }
            case 9: {
                return context.getString(17040346);
            }
            case 10: {
                return context.getString(17040353);
            }
            case 11: {
                return context.getString(17040347);
            }
            case 12: {
                return context.getString(17040344);
            }
            case 15: {
                return context.getString(17040350);
            }
            case 18: {
                return context.getString(17040341);
            }
            case 8: {
                String[] msgArray = context.getResources().getStringArray(17236161);
                if (vendorCode >= msgArray.length) break;
                return msgArray[vendorCode];
            }
        }
        Slog.w(TAG, "Invalid error message: " + errMsg + ", " + vendorCode);
        return context.getString(17040354);
    }

    public static String getAcquiredString(Context context, int acquireInfo, int vendorCode) {
        switch (acquireInfo) {
            case 0: {
                return null;
            }
            case 1: {
                return context.getString(17040333);
            }
            case 2: {
                return context.getString(17040332);
            }
            case 3: {
                return context.getString(17040329);
            }
            case 4: {
                return context.getString(17040336);
            }
            case 5: {
                return context.getString(17040335);
            }
            case 9: {
                return context.getString(17040331);
            }
            case 10: {
                return context.getString(17040334);
            }
            case 6: {
                String[] msgArray = context.getResources().getStringArray(17236160);
                if (vendorCode >= msgArray.length) break;
                return msgArray[vendorCode];
            }
            case 7: {
                return null;
            }
        }
        Slog.w(TAG, "Invalid acquired message: " + acquireInfo + ", " + vendorCode);
        return null;
    }

    private class MyHandler
    extends Handler {
        private MyHandler(Context context) {
            super(context.getMainLooper());
        }

        private MyHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 100: {
                    FingerprintManager.this.sendEnrollResult((Fingerprint)msg.obj, msg.arg1);
                    break;
                }
                case 101: {
                    FingerprintManager.this.sendAcquiredResult(msg.arg1, msg.arg2);
                    break;
                }
                case 102: {
                    FingerprintManager.this.sendAuthenticatedSucceeded((Fingerprint)msg.obj, msg.arg1, msg.arg2 == 1);
                    break;
                }
                case 103: {
                    FingerprintManager.this.sendAuthenticatedFailed();
                    break;
                }
                case 104: {
                    FingerprintManager.this.sendErrorResult(msg.arg1, msg.arg2);
                    break;
                }
                case 105: {
                    FingerprintManager.this.sendRemovedResult((Fingerprint)msg.obj, msg.arg1);
                    break;
                }
                case 106: {
                    FingerprintManager.this.sendChallengeGenerated(msg.arg1, msg.arg2, (Long)msg.obj);
                    break;
                }
                case 107: {
                    FingerprintManager.this.sendFingerprintDetected(msg.arg1, msg.arg2, (Boolean)msg.obj);
                    break;
                }
                case 108: {
                    FingerprintManager.this.sendUdfpsPointerDown(msg.arg1);
                    break;
                }
                case 109: {
                    FingerprintManager.this.sendUdfpsPointerUp(msg.arg1);
                    break;
                }
                default: {
                    Slog.w(FingerprintManager.TAG, "Unknown message: " + msg.what);
                }
            }
        }
    }

    public static interface GenerateChallengeCallback {
        public void onChallengeGenerated(int var1, int var2, long var3);
    }

    public static abstract class LockoutResetCallback {
        public void onLockoutReset(int sensorId) {
        }
    }

    public static abstract class RemovalCallback {
        public void onRemovalError(Fingerprint fp, int errMsgId, CharSequence errString) {
        }

        public void onRemovalSucceeded(Fingerprint fp, int remaining) {
        }
    }

    public static abstract class EnrollmentCallback {
        public void onEnrollmentError(int errMsgId, CharSequence errString) {
        }

        public void onEnrollmentHelp(int helpMsgId, CharSequence helpString) {
        }

        public void onEnrollmentProgress(int remaining) {
        }
    }

    public static interface FingerprintDetectionCallback {
        public void onFingerprintDetected(int var1, int var2, boolean var3);
    }

    @Deprecated
    public static abstract class AuthenticationCallback
    extends BiometricAuthenticator.AuthenticationCallback {
        @Override
        public void onAuthenticationError(int errorCode, CharSequence errString) {
        }

        @Override
        public void onAuthenticationHelp(int helpCode, CharSequence helpString) {
        }

        public void onAuthenticationSucceeded(AuthenticationResult result) {
        }

        @Override
        public void onAuthenticationFailed() {
        }

        @Override
        public void onAuthenticationAcquired(int acquireInfo) {
        }

        public void onUdfpsPointerDown(int sensorId) {
        }

        public void onUdfpsPointerUp(int sensorId) {
        }
    }

    @Deprecated
    public static class AuthenticationResult {
        private Fingerprint mFingerprint;
        private CryptoObject mCryptoObject;
        private int mUserId;
        private boolean mIsStrongBiometric;

        public AuthenticationResult(CryptoObject crypto, Fingerprint fingerprint, int userId, boolean isStrongBiometric) {
            this.mCryptoObject = crypto;
            this.mFingerprint = fingerprint;
            this.mUserId = userId;
            this.mIsStrongBiometric = isStrongBiometric;
        }

        public CryptoObject getCryptoObject() {
            return this.mCryptoObject;
        }

        @UnsupportedAppUsage
        public Fingerprint getFingerprint() {
            return this.mFingerprint;
        }

        public int getUserId() {
            return this.mUserId;
        }

        public boolean isStrongBiometric() {
            return this.mIsStrongBiometric;
        }
    }

    @Deprecated
    public static class CryptoObject
    extends android.hardware.biometrics.CryptoObject {
        public CryptoObject(Signature signature) {
            super(signature);
        }

        public CryptoObject(Cipher cipher) {
            super(cipher);
        }

        public CryptoObject(Mac mac) {
            super(mac);
        }

        @Override
        public Signature getSignature() {
            return super.getSignature();
        }

        @Override
        public Cipher getCipher() {
            return super.getCipher();
        }

        @Override
        public Mac getMac() {
            return super.getMac();
        }

        @Override
        @Deprecated
        public IdentityCredential getIdentityCredential() {
            return super.getIdentityCredential();
        }

        @Override
        public PresentationSession getPresentationSession() {
            return super.getPresentationSession();
        }
    }

    private class OnFingerprintDetectionCancelListener
    implements CancellationSignal.OnCancelListener {
        private final long mAuthRequestId;

        OnFingerprintDetectionCancelListener(long id2) {
            this.mAuthRequestId = id2;
        }

        @Override
        public void onCancel() {
            Slog.d(FingerprintManager.TAG, "Cancel fingerprint detect requested for: " + this.mAuthRequestId);
            FingerprintManager.this.cancelFingerprintDetect(this.mAuthRequestId);
        }
    }

    private class OnAuthenticationCancelListener
    implements CancellationSignal.OnCancelListener {
        private final long mAuthRequestId;

        OnAuthenticationCancelListener(long id2) {
            this.mAuthRequestId = id2;
        }

        @Override
        public void onCancel() {
            Slog.d(FingerprintManager.TAG, "Cancel fingerprint authentication requested for: " + this.mAuthRequestId);
            FingerprintManager.this.cancelAuthentication(this.mAuthRequestId);
        }
    }

    private class OnEnrollCancelListener
    implements CancellationSignal.OnCancelListener {
        private final long mAuthRequestId;

        private OnEnrollCancelListener(long id2) {
            this.mAuthRequestId = id2;
        }

        @Override
        public void onCancel() {
            Slog.d(FingerprintManager.TAG, "Cancel fingerprint enrollment requested for: " + this.mAuthRequestId);
            FingerprintManager.this.cancelEnrollment(this.mAuthRequestId);
        }
    }

    private static class RemoveTracker {
        static final int REMOVE_SINGLE = 1;
        static final int REMOVE_ALL = 2;
        @RemoveRequest
        final int mRemoveRequest;
        final Fingerprint mSingleFingerprint;

        RemoveTracker(@RemoveRequest int request, Fingerprint fingerprint) {
            this.mRemoveRequest = request;
            this.mSingleFingerprint = fingerprint;
        }

        static @interface RemoveRequest {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EnrollReason {
    }
}

