/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.fingerprint;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IUdfpsHbmListener
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.fingerprint.IUdfpsHbmListener";

    public void onHbmEnabled(int var1) throws RemoteException;

    public void onHbmDisabled(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IUdfpsHbmListener {
        static final int TRANSACTION_onHbmEnabled = 1;
        static final int TRANSACTION_onHbmDisabled = 2;

        public Stub() {
            this.attachInterface(this, IUdfpsHbmListener.DESCRIPTOR);
        }

        public static IUdfpsHbmListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IUdfpsHbmListener.DESCRIPTOR);
            if (iin != null && iin instanceof IUdfpsHbmListener) {
                return (IUdfpsHbmListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onHbmEnabled";
                }
                case 2: {
                    return "onHbmDisabled";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IUdfpsHbmListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onHbmEnabled(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onHbmDisabled(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IUdfpsHbmListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IUdfpsHbmListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onHbmEnabled(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUdfpsHbmListener.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onHbmDisabled(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IUdfpsHbmListener.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IUdfpsHbmListener {
        @Override
        public void onHbmEnabled(int displayId) throws RemoteException {
        }

        @Override
        public void onHbmDisabled(int displayId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

