/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.hardware.hdmi.HdmiAudioSystemClient;
import android.hardware.hdmi.HdmiClient;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.hardware.hdmi.HdmiHotplugEvent;
import android.hardware.hdmi.HdmiPlaybackClient;
import android.hardware.hdmi.HdmiSwitchClient;
import android.hardware.hdmi.HdmiTvClient;
import android.hardware.hdmi.HdmiUtils;
import android.hardware.hdmi.IHdmiCecSettingChangeListener;
import android.hardware.hdmi.IHdmiCecVolumeControlFeatureListener;
import android.hardware.hdmi.IHdmiControlService;
import android.hardware.hdmi.IHdmiControlStatusChangeListener;
import android.hardware.hdmi.IHdmiHotplugEventListener;
import android.os.Binder;
import android.os.RemoteException;
import android.sysprop.HdmiProperties;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.util.ConcurrentUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

@SystemApi
public class HdmiControlManager {
    private static final String TAG = "HdmiControlManager";
    private final IHdmiControlService mService;
    private static final int INVALID_PHYSICAL_ADDRESS = 65535;
    public static final String ACTION_OSD_MESSAGE = "android.hardware.hdmi.action.OSD_MESSAGE";
    public static final int OSD_MESSAGE_ARC_CONNECTED_INVALID_PORT = 1;
    public static final int OSD_MESSAGE_AVR_VOLUME_CHANGED = 2;
    public static final String EXTRA_MESSAGE_ID = "android.hardware.hdmi.extra.MESSAGE_ID";
    public static final String EXTRA_MESSAGE_EXTRA_PARAM1 = "android.hardware.hdmi.extra.MESSAGE_EXTRA_PARAM1";
    public static final String EXTRA_LOCALE = "android.hardware.hdmi.extra.LOCALE";
    public static final int AVR_VOLUME_MUTED = 101;
    public static final int POWER_STATUS_UNKNOWN = -1;
    public static final int POWER_STATUS_ON = 0;
    public static final int POWER_STATUS_STANDBY = 1;
    public static final int POWER_STATUS_TRANSIENT_TO_ON = 2;
    public static final int POWER_STATUS_TRANSIENT_TO_STANDBY = 3;
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_TIMEOUT = 1;
    public static final int RESULT_SOURCE_NOT_AVAILABLE = 2;
    public static final int RESULT_TARGET_NOT_AVAILABLE = 3;
    @Deprecated
    public static final int RESULT_ALREADY_IN_PROGRESS = 4;
    public static final int RESULT_EXCEPTION = 5;
    public static final int RESULT_INCORRECT_MODE = 6;
    public static final int RESULT_COMMUNICATION_FAILED = 7;
    public static final int DEVICE_EVENT_ADD_DEVICE = 1;
    public static final int DEVICE_EVENT_REMOVE_DEVICE = 2;
    public static final int DEVICE_EVENT_UPDATE_DEVICE = 3;
    public static final int ONE_TOUCH_RECORD_RECORDING_CURRENTLY_SELECTED_SOURCE = 1;
    public static final int ONE_TOUCH_RECORD_RECORDING_DIGITAL_SERVICE = 2;
    public static final int ONE_TOUCH_RECORD_RECORDING_ANALOGUE_SERVICE = 3;
    public static final int ONE_TOUCH_RECORD_RECORDING_EXTERNAL_INPUT = 4;
    public static final int ONE_TOUCH_RECORD_UNABLE_DIGITAL_SERVICE = 5;
    public static final int ONE_TOUCH_RECORD_UNABLE_ANALOGUE_SERVICE = 6;
    public static final int ONE_TOUCH_RECORD_UNABLE_SELECTED_SERVICE = 7;
    public static final int ONE_TOUCH_RECORD_INVALID_EXTERNAL_PLUG_NUMBER = 9;
    public static final int ONE_TOUCH_RECORD_INVALID_EXTERNAL_PHYSICAL_ADDRESS = 10;
    public static final int ONE_TOUCH_RECORD_UNSUPPORTED_CA = 11;
    public static final int ONE_TOUCH_RECORD_NO_OR_INSUFFICIENT_CA_ENTITLEMENTS = 12;
    public static final int ONE_TOUCH_RECORD_DISALLOW_TO_COPY = 13;
    public static final int ONE_TOUCH_RECORD_DISALLOW_TO_FUTHER_COPIES = 14;
    public static final int ONE_TOUCH_RECORD_NO_MEDIA = 16;
    public static final int ONE_TOUCH_RECORD_PLAYING = 17;
    public static final int ONE_TOUCH_RECORD_ALREADY_RECORDING = 18;
    public static final int ONE_TOUCH_RECORD_MEDIA_PROTECTED = 19;
    public static final int ONE_TOUCH_RECORD_NO_SOURCE_SIGNAL = 20;
    public static final int ONE_TOUCH_RECORD_MEDIA_PROBLEM = 21;
    public static final int ONE_TOUCH_RECORD_NOT_ENOUGH_SPACE = 22;
    public static final int ONE_TOUCH_RECORD_PARENT_LOCK_ON = 23;
    public static final int ONE_TOUCH_RECORD_RECORDING_TERMINATED_NORMALLY = 26;
    public static final int ONE_TOUCH_RECORD_RECORDING_ALREADY_TERMINATED = 27;
    public static final int ONE_TOUCH_RECORD_OTHER_REASON = 31;
    public static final int ONE_TOUCH_RECORD_PREVIOUS_RECORDING_IN_PROGRESS = 48;
    public static final int ONE_TOUCH_RECORD_CHECK_RECORDER_CONNECTION = 49;
    public static final int ONE_TOUCH_RECORD_FAIL_TO_RECORD_DISPLAYED_SCREEN = 50;
    public static final int ONE_TOUCH_RECORD_CEC_DISABLED = 51;
    public static final int TIMER_RECORDING_TYPE_DIGITAL = 1;
    public static final int TIMER_RECORDING_TYPE_ANALOGUE = 2;
    public static final int TIMER_RECORDING_TYPE_EXTERNAL = 3;
    public static final int TIMER_STATUS_MEDIA_INFO_PRESENT_NOT_PROTECTED = 0;
    public static final int TIMER_STATUS_MEDIA_INFO_PRESENT_PROTECTED = 1;
    public static final int TIMER_STATUS_MEDIA_INFO_NOT_PRESENT = 2;
    public static final int TIMER_STATUS_PROGRAMMED_INFO_ENOUGH_SPACE = 8;
    public static final int TIMER_STATUS_PROGRAMMED_INFO_NOT_ENOUGH_SPACE = 9;
    public static final int TIMER_STATUS_PROGRAMMED_INFO_MIGHT_NOT_ENOUGH_SPACE = 11;
    public static final int TIMER_STATUS_PROGRAMMED_INFO_NO_MEDIA_INFO = 10;
    public static final int TIMER_STATUS_NOT_PROGRAMMED_NO_FREE_TIME = 1;
    public static final int TIMER_STATUS_NOT_PROGRAMMED_DATE_OUT_OF_RANGE = 2;
    public static final int TIMER_STATUS_NOT_PROGRAMMED_INVALID_SEQUENCE = 3;
    public static final int TIMER_STATUS_NOT_PROGRAMMED_INVALID_EXTERNAL_PLUG_NUMBER = 4;
    public static final int TIMER_STATUS_NOT_PROGRAMMED_INVALID_EXTERNAL_PHYSICAL_NUMBER = 5;
    public static final int TIMER_STATUS_NOT_PROGRAMMED_CA_NOT_SUPPORTED = 6;
    public static final int TIMER_STATUS_NOT_PROGRAMMED_NO_CA_ENTITLEMENTS = 7;
    public static final int TIMER_STATUS_NOT_PROGRAMMED_UNSUPPORTED_RESOLUTION = 8;
    public static final int TIMER_STATUS_NOT_PROGRAMMED_PARENTAL_LOCK_ON = 9;
    public static final int TIMER_STATUS_NOT_PROGRAMMED_CLOCK_FAILURE = 10;
    public static final int TIMER_STATUS_NOT_PROGRAMMED_DUPLICATED = 14;
    public static final int TIMER_RECORDING_RESULT_EXTRA_NO_ERROR = 0;
    public static final int TIMER_RECORDING_RESULT_EXTRA_CHECK_RECORDER_CONNECTION = 1;
    public static final int TIMER_RECORDING_RESULT_EXTRA_FAIL_TO_RECORD_SELECTED_SOURCE = 2;
    public static final int TIMER_RECORDING_RESULT_EXTRA_CEC_DISABLED = 3;
    public static final int CLEAR_TIMER_STATUS_TIMER_NOT_CLEARED_RECORDING = 0;
    public static final int CLEAR_TIMER_STATUS_TIMER_NOT_CLEARED_NO_MATCHING = 1;
    public static final int CLEAR_TIMER_STATUS_TIMER_NOT_CLEARED_NO_INFO_AVAILABLE = 2;
    public static final int CLEAR_TIMER_STATUS_TIMER_CLEARED = 128;
    public static final int CLEAR_TIMER_STATUS_CHECK_RECORDER_CONNECTION = 160;
    public static final int CLEAR_TIMER_STATUS_FAIL_TO_CLEAR_SELECTED_SOURCE = 161;
    public static final int CLEAR_TIMER_STATUS_CEC_DISABLE = 162;
    public static final int CONTROL_STATE_CHANGED_REASON_START = 0;
    public static final int CONTROL_STATE_CHANGED_REASON_SETTING = 1;
    public static final int CONTROL_STATE_CHANGED_REASON_WAKEUP = 2;
    public static final int CONTROL_STATE_CHANGED_REASON_STANDBY = 3;
    public static final int HDMI_CEC_CONTROL_ENABLED = 1;
    public static final int HDMI_CEC_CONTROL_DISABLED = 0;
    public static final int HDMI_CEC_VERSION_1_4_B = 5;
    public static final int HDMI_CEC_VERSION_2_0 = 6;
    public static final int ROUTING_CONTROL_ENABLED = 1;
    public static final int ROUTING_CONTROL_DISABLED = 0;
    public static final String POWER_CONTROL_MODE_TV = "to_tv";
    public static final String POWER_CONTROL_MODE_TV_AND_AUDIO_SYSTEM = "to_tv_and_audio_system";
    public static final String POWER_CONTROL_MODE_BROADCAST = "broadcast";
    public static final String POWER_CONTROL_MODE_NONE = "none";
    public static final String POWER_STATE_CHANGE_ON_ACTIVE_SOURCE_LOST_NONE = "none";
    public static final String POWER_STATE_CHANGE_ON_ACTIVE_SOURCE_LOST_STANDBY_NOW = "standby_now";
    public static final int SYSTEM_AUDIO_CONTROL_ENABLED = 1;
    public static final int SYSTEM_AUDIO_CONTROL_DISABLED = 0;
    public static final int SYSTEM_AUDIO_MODE_MUTING_ENABLED = 1;
    public static final int SYSTEM_AUDIO_MODE_MUTING_DISABLED = 0;
    public static final int VOLUME_CONTROL_ENABLED = 1;
    public static final int VOLUME_CONTROL_DISABLED = 0;
    public static final int TV_WAKE_ON_ONE_TOUCH_PLAY_ENABLED = 1;
    public static final int TV_WAKE_ON_ONE_TOUCH_PLAY_DISABLED = 0;
    public static final int TV_SEND_STANDBY_ON_SLEEP_ENABLED = 1;
    public static final int TV_SEND_STANDBY_ON_SLEEP_DISABLED = 0;
    public static final int SET_MENU_LANGUAGE_ENABLED = 1;
    public static final int SET_MENU_LANGUAGE_DISABLED = 0;
    public static final int RC_PROFILE_TV_NONE = 0;
    public static final int RC_PROFILE_TV_ONE = 2;
    public static final int RC_PROFILE_TV_TWO = 6;
    public static final int RC_PROFILE_TV_THREE = 10;
    public static final int RC_PROFILE_TV_FOUR = 14;
    public static final int RC_PROFILE_SOURCE_MENU_HANDLED = 1;
    public static final int RC_PROFILE_SOURCE_MENU_NOT_HANDLED = 0;
    public static final int QUERY_SAD_ENABLED = 1;
    public static final int QUERY_SAD_DISABLED = 0;
    public static final String CEC_SETTING_NAME_HDMI_CEC_ENABLED = "hdmi_cec_enabled";
    public static final String CEC_SETTING_NAME_HDMI_CEC_VERSION = "hdmi_cec_version";
    public static final String CEC_SETTING_NAME_ROUTING_CONTROL = "routing_control";
    public static final String CEC_SETTING_NAME_POWER_CONTROL_MODE = "power_control_mode";
    public static final String CEC_SETTING_NAME_POWER_STATE_CHANGE_ON_ACTIVE_SOURCE_LOST = "power_state_change_on_active_source_lost";
    public static final String CEC_SETTING_NAME_SYSTEM_AUDIO_CONTROL = "system_audio_control";
    public static final String CEC_SETTING_NAME_SYSTEM_AUDIO_MODE_MUTING = "system_audio_mode_muting";
    public static final String CEC_SETTING_NAME_VOLUME_CONTROL_MODE = "volume_control_enabled";
    public static final String CEC_SETTING_NAME_TV_WAKE_ON_ONE_TOUCH_PLAY = "tv_wake_on_one_touch_play";
    public static final String CEC_SETTING_NAME_TV_SEND_STANDBY_ON_SLEEP = "tv_send_standby_on_sleep";
    public static final String CEC_SETTING_NAME_SET_MENU_LANGUAGE = "set_menu_language";
    public static final String CEC_SETTING_NAME_RC_PROFILE_TV = "rc_profile_tv";
    public static final String CEC_SETTING_NAME_RC_PROFILE_SOURCE_HANDLES_ROOT_MENU = "rc_profile_source_handles_root_menu";
    public static final String CEC_SETTING_NAME_RC_PROFILE_SOURCE_HANDLES_SETUP_MENU = "rc_profile_source_handles_setup_menu";
    public static final String CEC_SETTING_NAME_RC_PROFILE_SOURCE_HANDLES_CONTENTS_MENU = "rc_profile_source_handles_contents_menu";
    public static final String CEC_SETTING_NAME_RC_PROFILE_SOURCE_HANDLES_TOP_MENU = "rc_profile_source_handles_top_menu";
    public static final String CEC_SETTING_NAME_RC_PROFILE_SOURCE_HANDLES_MEDIA_CONTEXT_SENSITIVE_MENU = "rc_profile_source_handles_media_context_sensitive_menu";
    public static final String CEC_SETTING_NAME_QUERY_SAD_LPCM = "query_sad_lpcm";
    public static final String CEC_SETTING_NAME_QUERY_SAD_DD = "query_sad_dd";
    public static final String CEC_SETTING_NAME_QUERY_SAD_MPEG1 = "query_sad_mpeg1";
    public static final String CEC_SETTING_NAME_QUERY_SAD_MP3 = "query_sad_mp3";
    public static final String CEC_SETTING_NAME_QUERY_SAD_MPEG2 = "query_sad_mpeg2";
    public static final String CEC_SETTING_NAME_QUERY_SAD_AAC = "query_sad_aac";
    public static final String CEC_SETTING_NAME_QUERY_SAD_DTS = "query_sad_dts";
    public static final String CEC_SETTING_NAME_QUERY_SAD_ATRAC = "query_sad_atrac";
    public static final String CEC_SETTING_NAME_QUERY_SAD_ONEBITAUDIO = "query_sad_onebitaudio";
    public static final String CEC_SETTING_NAME_QUERY_SAD_DDP = "query_sad_ddp";
    public static final String CEC_SETTING_NAME_QUERY_SAD_DTSHD = "query_sad_dtshd";
    public static final String CEC_SETTING_NAME_QUERY_SAD_TRUEHD = "query_sad_truehd";
    public static final String CEC_SETTING_NAME_QUERY_SAD_DST = "query_sad_dst";
    public static final String CEC_SETTING_NAME_QUERY_SAD_WMAPRO = "query_sad_wmapro";
    public static final String CEC_SETTING_NAME_QUERY_SAD_MAX = "query_sad_max";
    private final boolean mHasPlaybackDevice;
    private final boolean mHasTvDevice;
    private final boolean mHasAudioSystemDevice;
    private final boolean mHasSwitchDevice;
    private final boolean mIsSwitchDevice;
    private final ArrayMap<HotplugEventListener, IHdmiHotplugEventListener> mHotplugEventListeners = new ArrayMap();
    private final ArrayMap<HdmiControlStatusChangeListener, IHdmiControlStatusChangeListener> mHdmiControlStatusChangeListeners = new ArrayMap();
    private final ArrayMap<HdmiCecVolumeControlFeatureListener, IHdmiCecVolumeControlFeatureListener> mHdmiCecVolumeControlFeatureListeners = new ArrayMap();
    private final ArrayMap<String, ArrayMap<CecSettingChangeListener, IHdmiCecSettingChangeListener>> mCecSettingChangeListeners = new ArrayMap();

    public HdmiControlManager(IHdmiControlService service) {
        this.mService = service;
        int[] types = null;
        if (this.mService != null) {
            try {
                types = this.mService.getSupportedTypes();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        this.mHasTvDevice = HdmiControlManager.hasDeviceType(types, 0);
        this.mHasPlaybackDevice = HdmiControlManager.hasDeviceType(types, 4);
        this.mHasAudioSystemDevice = HdmiControlManager.hasDeviceType(types, 5);
        this.mHasSwitchDevice = HdmiControlManager.hasDeviceType(types, 6);
        this.mIsSwitchDevice = HdmiProperties.is_switch().orElse(false);
    }

    private static boolean hasDeviceType(int[] types, int type) {
        if (types == null) {
            return false;
        }
        for (int t : types) {
            if (t != type) continue;
            return true;
        }
        return false;
    }

    @SuppressLint(value={"RequiresPermission"})
    public HdmiClient getClient(int type) {
        if (this.mService == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return this.mHasTvDevice ? new HdmiTvClient(this.mService) : null;
            }
            case 4: {
                return this.mHasPlaybackDevice ? new HdmiPlaybackClient(this.mService) : null;
            }
            case 5: {
                return this.mHasAudioSystemDevice ? new HdmiAudioSystemClient(this.mService) : null;
            }
            case 6: {
                return this.mHasSwitchDevice || this.mIsSwitchDevice ? new HdmiSwitchClient(this.mService) : null;
            }
        }
        return null;
    }

    @SuppressLint(value={"RequiresPermission"})
    public HdmiPlaybackClient getPlaybackClient() {
        return (HdmiPlaybackClient)this.getClient(4);
    }

    @SuppressLint(value={"RequiresPermission"})
    public HdmiTvClient getTvClient() {
        return (HdmiTvClient)this.getClient(0);
    }

    @SuppressLint(value={"RequiresPermission"})
    public HdmiAudioSystemClient getAudioSystemClient() {
        return (HdmiAudioSystemClient)this.getClient(5);
    }

    @SuppressLint(value={"RequiresPermission"})
    public HdmiSwitchClient getSwitchClient() {
        return (HdmiSwitchClient)this.getClient(6);
    }

    public List<HdmiDeviceInfo> getConnectedDevices() {
        try {
            return this.mService.getDeviceList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public List<HdmiDeviceInfo> getConnectedDevicesList() {
        try {
            return this.mService.getDeviceList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void powerOffDevice(HdmiDeviceInfo deviceInfo) {
        Objects.requireNonNull(deviceInfo);
        try {
            this.mService.powerOffRemoteDevice(deviceInfo.getLogicalAddress(), deviceInfo.getDevicePowerStatus());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void powerOffRemoteDevice(HdmiDeviceInfo deviceInfo) {
        Objects.requireNonNull(deviceInfo);
        try {
            this.mService.powerOffRemoteDevice(deviceInfo.getLogicalAddress(), deviceInfo.getDevicePowerStatus());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void powerOnDevice(HdmiDeviceInfo deviceInfo) {
        Objects.requireNonNull(deviceInfo);
        try {
            this.mService.powerOnRemoteDevice(deviceInfo.getLogicalAddress(), deviceInfo.getDevicePowerStatus());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void powerOnRemoteDevice(HdmiDeviceInfo deviceInfo) {
        Objects.requireNonNull(deviceInfo);
        try {
            this.mService.powerOnRemoteDevice(deviceInfo.getLogicalAddress(), deviceInfo.getDevicePowerStatus());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setActiveSource(HdmiDeviceInfo deviceInfo) {
        Objects.requireNonNull(deviceInfo);
        try {
            this.mService.askRemoteDeviceToBecomeActiveSource(deviceInfo.getPhysicalAddress());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void requestRemoteDeviceToBecomeActiveSource(HdmiDeviceInfo deviceInfo) {
        Objects.requireNonNull(deviceInfo);
        try {
            this.mService.askRemoteDeviceToBecomeActiveSource(deviceInfo.getPhysicalAddress());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void setStandbyMode(boolean isStandbyModeOn) {
        try {
            this.mService.setStandbyMode(isStandbyModeOn);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void toggleAndFollowTvPower() {
        try {
            this.mService.toggleAndFollowTvPower();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public boolean shouldHandleTvPowerKey() {
        try {
            return this.mService.shouldHandleTvPowerKey();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void setHdmiCecVolumeControlEnabled(int hdmiCecVolumeControlEnabled) {
        try {
            this.mService.setCecSettingIntValue(CEC_SETTING_NAME_VOLUME_CONTROL_MODE, hdmiCecVolumeControlEnabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public int getHdmiCecVolumeControlEnabled() {
        try {
            return this.mService.getCecSettingIntValue(CEC_SETTING_NAME_VOLUME_CONTROL_MODE);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean getSystemAudioMode() {
        try {
            return this.mService.getSystemAudioMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getPhysicalAddress() {
        try {
            return this.mService.getPhysicalAddress();
        }
        catch (RemoteException e) {
            return 65535;
        }
    }

    public boolean isDeviceConnected(HdmiDeviceInfo targetDevice) {
        Objects.requireNonNull(targetDevice);
        int physicalAddress = this.getPhysicalAddress();
        if (physicalAddress == 65535) {
            return false;
        }
        int targetPhysicalAddress = targetDevice.getPhysicalAddress();
        if (targetPhysicalAddress == 65535) {
            return false;
        }
        return HdmiUtils.getLocalPortFromPhysicalAddress(targetPhysicalAddress, physicalAddress) != -1;
    }

    @Deprecated
    public boolean isRemoteDeviceConnected(HdmiDeviceInfo targetDevice) {
        Objects.requireNonNull(targetDevice);
        int physicalAddress = this.getPhysicalAddress();
        if (physicalAddress == 65535) {
            return false;
        }
        int targetPhysicalAddress = targetDevice.getPhysicalAddress();
        if (targetPhysicalAddress == 65535) {
            return false;
        }
        return HdmiUtils.getLocalPortFromPhysicalAddress(targetPhysicalAddress, physicalAddress) != -1;
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void addHotplugEventListener(HotplugEventListener listener2) {
        this.addHotplugEventListener(ConcurrentUtils.DIRECT_EXECUTOR, listener2);
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void addHotplugEventListener(Executor executor, HotplugEventListener listener2) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            return;
        }
        if (this.mHotplugEventListeners.containsKey(listener2)) {
            Log.e(TAG, "listener is already registered");
            return;
        }
        IHdmiHotplugEventListener wrappedListener = this.getHotplugEventListenerWrapper(executor, listener2);
        this.mHotplugEventListeners.put(listener2, wrappedListener);
        try {
            this.mService.addHotplugEventListener(wrappedListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void removeHotplugEventListener(HotplugEventListener listener2) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            return;
        }
        IHdmiHotplugEventListener wrappedListener = this.mHotplugEventListeners.remove(listener2);
        if (wrappedListener == null) {
            Log.e(TAG, "tried to remove not-registered listener");
            return;
        }
        try {
            this.mService.removeHotplugEventListener(wrappedListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private IHdmiHotplugEventListener getHotplugEventListenerWrapper(final Executor executor, final HotplugEventListener listener2) {
        return new IHdmiHotplugEventListener.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceived(HdmiHotplugEvent event) {
                long token = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> listener2.onReceived(event));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        };
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void addHdmiControlStatusChangeListener(HdmiControlStatusChangeListener listener2) {
        this.addHdmiControlStatusChangeListener(ConcurrentUtils.DIRECT_EXECUTOR, listener2);
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void addHdmiControlStatusChangeListener(Executor executor, HdmiControlStatusChangeListener listener2) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            return;
        }
        if (this.mHdmiControlStatusChangeListeners.containsKey(listener2)) {
            Log.e(TAG, "listener is already registered");
            return;
        }
        IHdmiControlStatusChangeListener wrappedListener = this.getHdmiControlStatusChangeListenerWrapper(executor, listener2);
        this.mHdmiControlStatusChangeListeners.put(listener2, wrappedListener);
        try {
            this.mService.addHdmiControlStatusChangeListener(wrappedListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void removeHdmiControlStatusChangeListener(HdmiControlStatusChangeListener listener2) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            return;
        }
        IHdmiControlStatusChangeListener wrappedListener = this.mHdmiControlStatusChangeListeners.remove(listener2);
        if (wrappedListener == null) {
            Log.e(TAG, "tried to remove not-registered listener");
            return;
        }
        try {
            this.mService.removeHdmiControlStatusChangeListener(wrappedListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private IHdmiControlStatusChangeListener getHdmiControlStatusChangeListenerWrapper(final Executor executor, final HdmiControlStatusChangeListener listener2) {
        return new IHdmiControlStatusChangeListener.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStatusChange(int isCecEnabled, boolean isCecAvailable) {
                long token = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> listener2.onStatusChange(isCecEnabled, isCecAvailable));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        };
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void addHdmiCecVolumeControlFeatureListener(Executor executor, HdmiCecVolumeControlFeatureListener listener2) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            return;
        }
        if (this.mHdmiCecVolumeControlFeatureListeners.containsKey(listener2)) {
            Log.e(TAG, "listener is already registered");
            return;
        }
        IHdmiCecVolumeControlFeatureListener wrappedListener = this.createHdmiCecVolumeControlFeatureListenerWrapper(executor, listener2);
        this.mHdmiCecVolumeControlFeatureListeners.put(listener2, wrappedListener);
        try {
            this.mService.addHdmiCecVolumeControlFeatureListener(wrappedListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void removeHdmiCecVolumeControlFeatureListener(HdmiCecVolumeControlFeatureListener listener2) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            return;
        }
        IHdmiCecVolumeControlFeatureListener wrappedListener = this.mHdmiCecVolumeControlFeatureListeners.remove(listener2);
        if (wrappedListener == null) {
            Log.e(TAG, "tried to remove not-registered listener");
            return;
        }
        try {
            this.mService.removeHdmiCecVolumeControlFeatureListener(wrappedListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private IHdmiCecVolumeControlFeatureListener createHdmiCecVolumeControlFeatureListenerWrapper(final Executor executor, final HdmiCecVolumeControlFeatureListener listener2) {
        return new IHdmiCecVolumeControlFeatureListener.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onHdmiCecVolumeControlFeature(int enabled) {
                long token = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> listener2.onHdmiCecVolumeControlFeature(enabled));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        };
    }

    private void addCecSettingChangeListener(@CecSettingName String setting, Executor executor, CecSettingChangeListener listener2) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            return;
        }
        if (this.mCecSettingChangeListeners.containsKey(setting) && this.mCecSettingChangeListeners.get(setting).containsKey(listener2)) {
            Log.e(TAG, "listener is already registered");
            return;
        }
        IHdmiCecSettingChangeListener wrappedListener = this.getCecSettingChangeListenerWrapper(executor, listener2);
        if (!this.mCecSettingChangeListeners.containsKey(setting)) {
            this.mCecSettingChangeListeners.put(setting, new ArrayMap());
        }
        this.mCecSettingChangeListeners.get(setting).put(listener2, wrappedListener);
        try {
            this.mService.addCecSettingChangeListener(setting, wrappedListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private void removeCecSettingChangeListener(@CecSettingName String setting, CecSettingChangeListener listener2) {
        IHdmiCecSettingChangeListener wrappedListener;
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            return;
        }
        IHdmiCecSettingChangeListener iHdmiCecSettingChangeListener = wrappedListener = !this.mCecSettingChangeListeners.containsKey(setting) ? null : this.mCecSettingChangeListeners.get(setting).remove(listener2);
        if (wrappedListener == null) {
            Log.e(TAG, "tried to remove not-registered listener");
            return;
        }
        try {
            this.mService.removeCecSettingChangeListener(setting, wrappedListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private IHdmiCecSettingChangeListener getCecSettingChangeListenerWrapper(final Executor executor, final CecSettingChangeListener listener2) {
        return new IHdmiCecSettingChangeListener.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onChange(String setting) {
                long token = Binder.clearCallingIdentity();
                try {
                    executor.execute(() -> listener2.onChange(setting));
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        };
    }

    @CecSettingName
    @RequiresPermission(value="android.permission.HDMI_CEC")
    public List<String> getUserCecSettings() {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            return this.mService.getUserCecSettings();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public List<String> getAllowedCecSettingStringValues(@CecSettingName String name) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            return this.mService.getAllowedCecSettingStringValues(name);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public List<Integer> getAllowedCecSettingIntValues(@CecSettingName String name) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            int[] allowedValues = this.mService.getAllowedCecSettingIntValues(name);
            return Arrays.stream(allowedValues).boxed().collect(Collectors.toList());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void setHdmiCecEnabled(int value2) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            this.mService.setCecSettingIntValue(CEC_SETTING_NAME_HDMI_CEC_ENABLED, value2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public int getHdmiCecEnabled() {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            return this.mService.getCecSettingIntValue(CEC_SETTING_NAME_HDMI_CEC_ENABLED);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void addHdmiCecEnabledChangeListener(CecSettingChangeListener listener2) {
        this.addHdmiCecEnabledChangeListener(ConcurrentUtils.DIRECT_EXECUTOR, listener2);
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void addHdmiCecEnabledChangeListener(Executor executor, CecSettingChangeListener listener2) {
        this.addCecSettingChangeListener(CEC_SETTING_NAME_HDMI_CEC_ENABLED, executor, listener2);
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void removeHdmiCecEnabledChangeListener(CecSettingChangeListener listener2) {
        this.removeCecSettingChangeListener(CEC_SETTING_NAME_HDMI_CEC_ENABLED, listener2);
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void setHdmiCecVersion(int value2) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            this.mService.setCecSettingIntValue(CEC_SETTING_NAME_HDMI_CEC_VERSION, value2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public int getHdmiCecVersion() {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            return this.mService.getCecSettingIntValue(CEC_SETTING_NAME_HDMI_CEC_VERSION);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void setRoutingControl(int value2) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            this.mService.setCecSettingIntValue(CEC_SETTING_NAME_ROUTING_CONTROL, value2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public int getRoutingControl() {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            return this.mService.getCecSettingIntValue(CEC_SETTING_NAME_ROUTING_CONTROL);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void setPowerControlMode(String value2) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            this.mService.setCecSettingStringValue(CEC_SETTING_NAME_POWER_CONTROL_MODE, value2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public String getPowerControlMode() {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            return this.mService.getCecSettingStringValue(CEC_SETTING_NAME_POWER_CONTROL_MODE);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void setPowerStateChangeOnActiveSourceLost(String value2) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            this.mService.setCecSettingStringValue(CEC_SETTING_NAME_POWER_STATE_CHANGE_ON_ACTIVE_SOURCE_LOST, value2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public String getPowerStateChangeOnActiveSourceLost() {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            return this.mService.getCecSettingStringValue(CEC_SETTING_NAME_POWER_STATE_CHANGE_ON_ACTIVE_SOURCE_LOST);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void setSystemAudioControl(int value2) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            this.mService.setCecSettingIntValue(CEC_SETTING_NAME_SYSTEM_AUDIO_CONTROL, value2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public int getSystemAudioControl() {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            return this.mService.getCecSettingIntValue(CEC_SETTING_NAME_SYSTEM_AUDIO_CONTROL);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void setSystemAudioModeMuting(int value2) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            this.mService.setCecSettingIntValue(CEC_SETTING_NAME_SYSTEM_AUDIO_MODE_MUTING, value2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public int getSystemAudioModeMuting() {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            return this.mService.getCecSettingIntValue(CEC_SETTING_NAME_SYSTEM_AUDIO_MODE_MUTING);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void setTvWakeOnOneTouchPlay(int value2) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            this.mService.setCecSettingIntValue(CEC_SETTING_NAME_TV_WAKE_ON_ONE_TOUCH_PLAY, value2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public int getTvWakeOnOneTouchPlay() {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            return this.mService.getCecSettingIntValue(CEC_SETTING_NAME_TV_WAKE_ON_ONE_TOUCH_PLAY);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void setTvSendStandbyOnSleep(int value2) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            this.mService.setCecSettingIntValue(CEC_SETTING_NAME_TV_SEND_STANDBY_ON_SLEEP, value2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public int getTvSendStandbyOnSleep() {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            return this.mService.getCecSettingIntValue(CEC_SETTING_NAME_TV_SEND_STANDBY_ON_SLEEP);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void setSadPresenceInQuery(@CecSettingSad String setting, int value2) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            this.mService.setCecSettingIntValue(setting, value2);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public void setSadsPresenceInQuery(@CecSettingSad List<String> settings, int value2) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            for (String sad : settings) {
                this.mService.setCecSettingIntValue(sad, value2);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.HDMI_CEC")
    public int getSadPresenceInQuery(@CecSettingSad String setting) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            throw new RuntimeException("HdmiControlService is not available");
        }
        try {
            return this.mService.getCecSettingIntValue(setting);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static interface CecSettingChangeListener {
        public void onChange(@CecSettingName String var1);
    }

    public static interface VendorCommandListener {
        public void onReceived(int var1, int var2, byte[] var3, boolean var4);

        public void onControlStateChanged(boolean var1, int var2);
    }

    public static interface HdmiCecVolumeControlFeatureListener {
        public void onHdmiCecVolumeControlFeature(int var1);
    }

    public static interface HdmiControlStatusChangeListener {
        public void onStatusChange(int var1, boolean var2);
    }

    public static interface HotplugEventListener {
        public void onReceived(HdmiHotplugEvent var1);
    }

    public static @interface CecSettingSad {
    }

    public static @interface CecSettingName {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SadPresenceInQuery {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RcProfileSourceHandlesMenu {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RcProfileTv {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetMenuLanguage {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TvSendStandbyOnSleep {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TvWakeOnOneTouchPlay {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VolumeControl {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SystemAudioModeMuting {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SystemAudioControl {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ActiveSourceLostBehavior {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PowerControlMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RoutingControl {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HdmiCecVersion {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HdmiCecControl {
    }

    public static @interface ControlCallbackResult {
    }
}

