/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.annotation.SystemApi;
import android.hardware.hdmi.HdmiRecordSources;

@SystemApi
public abstract class HdmiRecordListener {
    public abstract HdmiRecordSources.RecordSource onOneTouchRecordSourceRequested(int var1);

    public void onOneTouchRecordResult(int recorderAddress, int result) {
    }

    public void onTimerRecordingResult(int recorderAddress, TimerStatusData data) {
    }

    public void onClearTimerRecordingResult(int recorderAddress, int result) {
    }

    @SystemApi
    public static class TimerStatusData {
        private boolean mOverlapped;
        private int mMediaInfo;
        private boolean mProgrammed;
        private int mProgrammedInfo;
        private int mNotProgrammedError;
        private int mDurationHour;
        private int mDurationMinute;
        private int mExtraError;

        static TimerStatusData parseFrom(int result) {
            TimerStatusData data = new TimerStatusData();
            data.mOverlapped = (result >> 31 & 1) != 0;
            data.mMediaInfo = result >> 29 & 3;
            boolean bl = data.mProgrammed = (result >> 28 & 1) != 0;
            if (data.mProgrammed) {
                data.mProgrammedInfo = result >> 24 & 0xF;
                data.mDurationHour = TimerStatusData.bcdByteToInt((byte)(result >> 16 & 0xFF));
                data.mDurationMinute = TimerStatusData.bcdByteToInt((byte)(result >> 8 & 0xFF));
            } else {
                data.mNotProgrammedError = result >> 24 & 0xF;
                data.mDurationHour = TimerStatusData.bcdByteToInt((byte)(result >> 16 & 0xFF));
                data.mDurationMinute = TimerStatusData.bcdByteToInt((byte)(result >> 8 & 0xFF));
            }
            data.mExtraError = result & 0xFF;
            return data;
        }

        private static int bcdByteToInt(byte value2) {
            return (value2 >> 4 & 0xF) * 10 + value2 & 0xF;
        }

        private TimerStatusData() {
        }

        public boolean isOverlapped() {
            return this.mOverlapped;
        }

        public int getMediaInfo() {
            return this.mMediaInfo;
        }

        public boolean isProgrammed() {
            return this.mProgrammed;
        }

        public int getProgrammedInfo() {
            if (!this.isProgrammed()) {
                throw new IllegalStateException("No programmed info. Call getNotProgammedError() instead.");
            }
            return this.mProgrammedInfo;
        }

        public int getNotProgammedError() {
            if (this.isProgrammed()) {
                throw new IllegalStateException("Has no not-programmed error. Call getProgrammedInfo() instead.");
            }
            return this.mNotProgrammedError;
        }

        public int getDurationHour() {
            return this.mDurationHour;
        }

        public int getDurationMinute() {
            return this.mDurationMinute;
        }

        public int getExtraError() {
            return this.mExtraError;
        }
    }
}

