/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.hardware.hdmi.HdmiDeviceInfo;
import android.hardware.hdmi.HdmiPortInfo;
import android.hardware.hdmi.IHdmiCecSettingChangeListener;
import android.hardware.hdmi.IHdmiCecVolumeControlFeatureListener;
import android.hardware.hdmi.IHdmiControlCallback;
import android.hardware.hdmi.IHdmiControlStatusChangeListener;
import android.hardware.hdmi.IHdmiDeviceEventListener;
import android.hardware.hdmi.IHdmiHotplugEventListener;
import android.hardware.hdmi.IHdmiInputChangeListener;
import android.hardware.hdmi.IHdmiMhlVendorCommandListener;
import android.hardware.hdmi.IHdmiRecordListener;
import android.hardware.hdmi.IHdmiSystemAudioModeChangeListener;
import android.hardware.hdmi.IHdmiVendorCommandListener;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IHdmiControlService
extends IInterface {
    public int[] getSupportedTypes() throws RemoteException;

    public HdmiDeviceInfo getActiveSource() throws RemoteException;

    public void oneTouchPlay(IHdmiControlCallback var1) throws RemoteException;

    public void toggleAndFollowTvPower() throws RemoteException;

    public boolean shouldHandleTvPowerKey() throws RemoteException;

    public void queryDisplayStatus(IHdmiControlCallback var1) throws RemoteException;

    public void addHdmiControlStatusChangeListener(IHdmiControlStatusChangeListener var1) throws RemoteException;

    public void removeHdmiControlStatusChangeListener(IHdmiControlStatusChangeListener var1) throws RemoteException;

    public void addHdmiCecVolumeControlFeatureListener(IHdmiCecVolumeControlFeatureListener var1) throws RemoteException;

    public void removeHdmiCecVolumeControlFeatureListener(IHdmiCecVolumeControlFeatureListener var1) throws RemoteException;

    public void addHotplugEventListener(IHdmiHotplugEventListener var1) throws RemoteException;

    public void removeHotplugEventListener(IHdmiHotplugEventListener var1) throws RemoteException;

    public void addDeviceEventListener(IHdmiDeviceEventListener var1) throws RemoteException;

    public void deviceSelect(int var1, IHdmiControlCallback var2) throws RemoteException;

    public void portSelect(int var1, IHdmiControlCallback var2) throws RemoteException;

    public void sendKeyEvent(int var1, int var2, boolean var3) throws RemoteException;

    public void sendVolumeKeyEvent(int var1, int var2, boolean var3) throws RemoteException;

    public List<HdmiPortInfo> getPortInfo() throws RemoteException;

    public boolean canChangeSystemAudioMode() throws RemoteException;

    public boolean getSystemAudioMode() throws RemoteException;

    public int getPhysicalAddress() throws RemoteException;

    public void setSystemAudioMode(boolean var1, IHdmiControlCallback var2) throws RemoteException;

    public void addSystemAudioModeChangeListener(IHdmiSystemAudioModeChangeListener var1) throws RemoteException;

    public void removeSystemAudioModeChangeListener(IHdmiSystemAudioModeChangeListener var1) throws RemoteException;

    public void setArcMode(boolean var1) throws RemoteException;

    public void setProhibitMode(boolean var1) throws RemoteException;

    public void setSystemAudioVolume(int var1, int var2, int var3) throws RemoteException;

    public void setSystemAudioMute(boolean var1) throws RemoteException;

    public void setInputChangeListener(IHdmiInputChangeListener var1) throws RemoteException;

    public List<HdmiDeviceInfo> getInputDevices() throws RemoteException;

    public List<HdmiDeviceInfo> getDeviceList() throws RemoteException;

    public void powerOffRemoteDevice(int var1, int var2) throws RemoteException;

    public void powerOnRemoteDevice(int var1, int var2) throws RemoteException;

    public void askRemoteDeviceToBecomeActiveSource(int var1) throws RemoteException;

    public void sendVendorCommand(int var1, int var2, byte[] var3, boolean var4) throws RemoteException;

    public void addVendorCommandListener(IHdmiVendorCommandListener var1, int var2) throws RemoteException;

    public void sendStandby(int var1, int var2) throws RemoteException;

    public void setHdmiRecordListener(IHdmiRecordListener var1) throws RemoteException;

    public void startOneTouchRecord(int var1, byte[] var2) throws RemoteException;

    public void stopOneTouchRecord(int var1) throws RemoteException;

    public void startTimerRecording(int var1, int var2, byte[] var3) throws RemoteException;

    public void clearTimerRecording(int var1, int var2, byte[] var3) throws RemoteException;

    public void sendMhlVendorCommand(int var1, int var2, int var3, byte[] var4) throws RemoteException;

    public void addHdmiMhlVendorCommandListener(IHdmiMhlVendorCommandListener var1) throws RemoteException;

    public void setStandbyMode(boolean var1) throws RemoteException;

    public void reportAudioStatus(int var1, int var2, int var3, boolean var4) throws RemoteException;

    public void setSystemAudioModeOnForAudioOnlySource() throws RemoteException;

    public boolean setMessageHistorySize(int var1) throws RemoteException;

    public int getMessageHistorySize() throws RemoteException;

    public void addCecSettingChangeListener(String var1, IHdmiCecSettingChangeListener var2) throws RemoteException;

    public void removeCecSettingChangeListener(String var1, IHdmiCecSettingChangeListener var2) throws RemoteException;

    public List<String> getUserCecSettings() throws RemoteException;

    public List<String> getAllowedCecSettingStringValues(String var1) throws RemoteException;

    public int[] getAllowedCecSettingIntValues(String var1) throws RemoteException;

    public String getCecSettingStringValue(String var1) throws RemoteException;

    public void setCecSettingStringValue(String var1, String var2) throws RemoteException;

    public int getCecSettingIntValue(String var1) throws RemoteException;

    public void setCecSettingIntValue(String var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IHdmiControlService {
        public static final String DESCRIPTOR = "android.hardware.hdmi.IHdmiControlService";
        static final int TRANSACTION_getSupportedTypes = 1;
        static final int TRANSACTION_getActiveSource = 2;
        static final int TRANSACTION_oneTouchPlay = 3;
        static final int TRANSACTION_toggleAndFollowTvPower = 4;
        static final int TRANSACTION_shouldHandleTvPowerKey = 5;
        static final int TRANSACTION_queryDisplayStatus = 6;
        static final int TRANSACTION_addHdmiControlStatusChangeListener = 7;
        static final int TRANSACTION_removeHdmiControlStatusChangeListener = 8;
        static final int TRANSACTION_addHdmiCecVolumeControlFeatureListener = 9;
        static final int TRANSACTION_removeHdmiCecVolumeControlFeatureListener = 10;
        static final int TRANSACTION_addHotplugEventListener = 11;
        static final int TRANSACTION_removeHotplugEventListener = 12;
        static final int TRANSACTION_addDeviceEventListener = 13;
        static final int TRANSACTION_deviceSelect = 14;
        static final int TRANSACTION_portSelect = 15;
        static final int TRANSACTION_sendKeyEvent = 16;
        static final int TRANSACTION_sendVolumeKeyEvent = 17;
        static final int TRANSACTION_getPortInfo = 18;
        static final int TRANSACTION_canChangeSystemAudioMode = 19;
        static final int TRANSACTION_getSystemAudioMode = 20;
        static final int TRANSACTION_getPhysicalAddress = 21;
        static final int TRANSACTION_setSystemAudioMode = 22;
        static final int TRANSACTION_addSystemAudioModeChangeListener = 23;
        static final int TRANSACTION_removeSystemAudioModeChangeListener = 24;
        static final int TRANSACTION_setArcMode = 25;
        static final int TRANSACTION_setProhibitMode = 26;
        static final int TRANSACTION_setSystemAudioVolume = 27;
        static final int TRANSACTION_setSystemAudioMute = 28;
        static final int TRANSACTION_setInputChangeListener = 29;
        static final int TRANSACTION_getInputDevices = 30;
        static final int TRANSACTION_getDeviceList = 31;
        static final int TRANSACTION_powerOffRemoteDevice = 32;
        static final int TRANSACTION_powerOnRemoteDevice = 33;
        static final int TRANSACTION_askRemoteDeviceToBecomeActiveSource = 34;
        static final int TRANSACTION_sendVendorCommand = 35;
        static final int TRANSACTION_addVendorCommandListener = 36;
        static final int TRANSACTION_sendStandby = 37;
        static final int TRANSACTION_setHdmiRecordListener = 38;
        static final int TRANSACTION_startOneTouchRecord = 39;
        static final int TRANSACTION_stopOneTouchRecord = 40;
        static final int TRANSACTION_startTimerRecording = 41;
        static final int TRANSACTION_clearTimerRecording = 42;
        static final int TRANSACTION_sendMhlVendorCommand = 43;
        static final int TRANSACTION_addHdmiMhlVendorCommandListener = 44;
        static final int TRANSACTION_setStandbyMode = 45;
        static final int TRANSACTION_reportAudioStatus = 46;
        static final int TRANSACTION_setSystemAudioModeOnForAudioOnlySource = 47;
        static final int TRANSACTION_setMessageHistorySize = 48;
        static final int TRANSACTION_getMessageHistorySize = 49;
        static final int TRANSACTION_addCecSettingChangeListener = 50;
        static final int TRANSACTION_removeCecSettingChangeListener = 51;
        static final int TRANSACTION_getUserCecSettings = 52;
        static final int TRANSACTION_getAllowedCecSettingStringValues = 53;
        static final int TRANSACTION_getAllowedCecSettingIntValues = 54;
        static final int TRANSACTION_getCecSettingStringValue = 55;
        static final int TRANSACTION_setCecSettingStringValue = 56;
        static final int TRANSACTION_getCecSettingIntValue = 57;
        static final int TRANSACTION_setCecSettingIntValue = 58;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IHdmiControlService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IHdmiControlService) {
                return (IHdmiControlService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getSupportedTypes";
                }
                case 2: {
                    return "getActiveSource";
                }
                case 3: {
                    return "oneTouchPlay";
                }
                case 4: {
                    return "toggleAndFollowTvPower";
                }
                case 5: {
                    return "shouldHandleTvPowerKey";
                }
                case 6: {
                    return "queryDisplayStatus";
                }
                case 7: {
                    return "addHdmiControlStatusChangeListener";
                }
                case 8: {
                    return "removeHdmiControlStatusChangeListener";
                }
                case 9: {
                    return "addHdmiCecVolumeControlFeatureListener";
                }
                case 10: {
                    return "removeHdmiCecVolumeControlFeatureListener";
                }
                case 11: {
                    return "addHotplugEventListener";
                }
                case 12: {
                    return "removeHotplugEventListener";
                }
                case 13: {
                    return "addDeviceEventListener";
                }
                case 14: {
                    return "deviceSelect";
                }
                case 15: {
                    return "portSelect";
                }
                case 16: {
                    return "sendKeyEvent";
                }
                case 17: {
                    return "sendVolumeKeyEvent";
                }
                case 18: {
                    return "getPortInfo";
                }
                case 19: {
                    return "canChangeSystemAudioMode";
                }
                case 20: {
                    return "getSystemAudioMode";
                }
                case 21: {
                    return "getPhysicalAddress";
                }
                case 22: {
                    return "setSystemAudioMode";
                }
                case 23: {
                    return "addSystemAudioModeChangeListener";
                }
                case 24: {
                    return "removeSystemAudioModeChangeListener";
                }
                case 25: {
                    return "setArcMode";
                }
                case 26: {
                    return "setProhibitMode";
                }
                case 27: {
                    return "setSystemAudioVolume";
                }
                case 28: {
                    return "setSystemAudioMute";
                }
                case 29: {
                    return "setInputChangeListener";
                }
                case 30: {
                    return "getInputDevices";
                }
                case 31: {
                    return "getDeviceList";
                }
                case 32: {
                    return "powerOffRemoteDevice";
                }
                case 33: {
                    return "powerOnRemoteDevice";
                }
                case 34: {
                    return "askRemoteDeviceToBecomeActiveSource";
                }
                case 35: {
                    return "sendVendorCommand";
                }
                case 36: {
                    return "addVendorCommandListener";
                }
                case 37: {
                    return "sendStandby";
                }
                case 38: {
                    return "setHdmiRecordListener";
                }
                case 39: {
                    return "startOneTouchRecord";
                }
                case 40: {
                    return "stopOneTouchRecord";
                }
                case 41: {
                    return "startTimerRecording";
                }
                case 42: {
                    return "clearTimerRecording";
                }
                case 43: {
                    return "sendMhlVendorCommand";
                }
                case 44: {
                    return "addHdmiMhlVendorCommandListener";
                }
                case 45: {
                    return "setStandbyMode";
                }
                case 46: {
                    return "reportAudioStatus";
                }
                case 47: {
                    return "setSystemAudioModeOnForAudioOnlySource";
                }
                case 48: {
                    return "setMessageHistorySize";
                }
                case 49: {
                    return "getMessageHistorySize";
                }
                case 50: {
                    return "addCecSettingChangeListener";
                }
                case 51: {
                    return "removeCecSettingChangeListener";
                }
                case 52: {
                    return "getUserCecSettings";
                }
                case 53: {
                    return "getAllowedCecSettingStringValues";
                }
                case 54: {
                    return "getAllowedCecSettingIntValues";
                }
                case 55: {
                    return "getCecSettingStringValue";
                }
                case 56: {
                    return "setCecSettingStringValue";
                }
                case 57: {
                    return "getCecSettingIntValue";
                }
                case 58: {
                    return "setCecSettingIntValue";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int[] _result = this.getSupportedTypes();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 2: {
                    HdmiDeviceInfo _result = this.getActiveSource();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    IHdmiControlCallback _arg0 = IHdmiControlCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.oneTouchPlay(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    this.toggleAndFollowTvPower();
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    boolean _result = this.shouldHandleTvPowerKey();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 6: {
                    IHdmiControlCallback _arg0 = IHdmiControlCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.queryDisplayStatus(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    IHdmiControlStatusChangeListener _arg0 = IHdmiControlStatusChangeListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addHdmiControlStatusChangeListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    IHdmiControlStatusChangeListener _arg0 = IHdmiControlStatusChangeListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeHdmiControlStatusChangeListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    IHdmiCecVolumeControlFeatureListener _arg0 = IHdmiCecVolumeControlFeatureListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addHdmiCecVolumeControlFeatureListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    IHdmiCecVolumeControlFeatureListener _arg0 = IHdmiCecVolumeControlFeatureListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeHdmiCecVolumeControlFeatureListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    IHdmiHotplugEventListener _arg0 = IHdmiHotplugEventListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addHotplugEventListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    IHdmiHotplugEventListener _arg0 = IHdmiHotplugEventListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeHotplugEventListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    IHdmiDeviceEventListener _arg0 = IHdmiDeviceEventListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addDeviceEventListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    IHdmiControlCallback _arg1 = IHdmiControlCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.deviceSelect(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    IHdmiControlCallback _arg1 = IHdmiControlCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.portSelect(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.sendKeyEvent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.sendVolumeKeyEvent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    List<HdmiPortInfo> _result = this.getPortInfo();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 19: {
                    boolean _result = this.canChangeSystemAudioMode();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 20: {
                    boolean _result = this.getSystemAudioMode();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 21: {
                    int _result = this.getPhysicalAddress();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 22: {
                    boolean _arg0 = data.readBoolean();
                    IHdmiControlCallback _arg1 = IHdmiControlCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setSystemAudioMode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    IHdmiSystemAudioModeChangeListener _arg0 = IHdmiSystemAudioModeChangeListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addSystemAudioModeChangeListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    IHdmiSystemAudioModeChangeListener _arg0 = IHdmiSystemAudioModeChangeListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeSystemAudioModeChangeListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setArcMode(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setProhibitMode(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setSystemAudioVolume(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setSystemAudioMute(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    IHdmiInputChangeListener _arg0 = IHdmiInputChangeListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setInputChangeListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    List<HdmiDeviceInfo> _result = this.getInputDevices();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 31: {
                    List<HdmiDeviceInfo> _result = this.getDeviceList();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 32: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.powerOffRemoteDevice(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.powerOnRemoteDevice(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.askRemoteDeviceToBecomeActiveSource(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    byte[] _arg2 = data.createByteArray();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.sendVendorCommand(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    IHdmiVendorCommandListener _arg0 = IHdmiVendorCommandListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.addVendorCommandListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendStandby(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    IHdmiRecordListener _arg0 = IHdmiRecordListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setHdmiRecordListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 39: {
                    int _arg0 = data.readInt();
                    byte[] _arg1 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.startOneTouchRecord(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 40: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.stopOneTouchRecord(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    byte[] _arg2 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.startTimerRecording(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 42: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    byte[] _arg2 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.clearTimerRecording(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    byte[] _arg3 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.sendMhlVendorCommand(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 44: {
                    IHdmiMhlVendorCommandListener _arg0 = IHdmiMhlVendorCommandListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addHdmiMhlVendorCommandListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setStandbyMode(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 46: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.reportAudioStatus(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    this.setSystemAudioModeOnForAudioOnlySource();
                    reply.writeNoException();
                    break;
                }
                case 48: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.setMessageHistorySize(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 49: {
                    int _result = this.getMessageHistorySize();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 50: {
                    String _arg0 = data.readString();
                    IHdmiCecSettingChangeListener _arg1 = IHdmiCecSettingChangeListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addCecSettingChangeListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 51: {
                    String _arg0 = data.readString();
                    IHdmiCecSettingChangeListener _arg1 = IHdmiCecSettingChangeListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeCecSettingChangeListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 52: {
                    List<String> _result = this.getUserCecSettings();
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 53: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    List<String> _result = this.getAllowedCecSettingStringValues(_arg0);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 54: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    int[] _result = this.getAllowedCecSettingIntValues(_arg0);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 55: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    String _result = this.getCecSettingStringValue(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 56: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.setCecSettingStringValue(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 57: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.getCecSettingIntValue(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 58: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setCecSettingIntValue(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 57;
        }

        private static class Proxy
        implements IHdmiControlService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getSupportedTypes() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public HdmiDeviceInfo getActiveSource() throws RemoteException {
                HdmiDeviceInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(HdmiDeviceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void oneTouchPlay(IHdmiControlCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void toggleAndFollowTvPower() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldHandleTvPowerKey() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void queryDisplayStatus(IHdmiControlCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addHdmiControlStatusChangeListener(IHdmiControlStatusChangeListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeHdmiControlStatusChangeListener(IHdmiControlStatusChangeListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addHdmiCecVolumeControlFeatureListener(IHdmiCecVolumeControlFeatureListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeHdmiCecVolumeControlFeatureListener(IHdmiCecVolumeControlFeatureListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addHotplugEventListener(IHdmiHotplugEventListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeHotplugEventListener(IHdmiHotplugEventListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addDeviceEventListener(IHdmiDeviceEventListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deviceSelect(int deviceId, IHdmiControlCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void portSelect(int portId, IHdmiControlCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(portId);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendKeyEvent(int deviceType, int keyCode, boolean isPressed) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceType);
                    _data.writeInt(keyCode);
                    _data.writeBoolean(isPressed);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendVolumeKeyEvent(int deviceType, int keyCode, boolean isPressed) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceType);
                    _data.writeInt(keyCode);
                    _data.writeBoolean(isPressed);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<HdmiPortInfo> getPortInfo() throws RemoteException {
                ArrayList<HdmiPortInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(HdmiPortInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean canChangeSystemAudioMode() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getSystemAudioMode() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPhysicalAddress() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSystemAudioMode(boolean enabled, IHdmiControlCallback callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addSystemAudioModeChangeListener(IHdmiSystemAudioModeChangeListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeSystemAudioModeChangeListener(IHdmiSystemAudioModeChangeListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setArcMode(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setProhibitMode(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSystemAudioVolume(int oldIndex, int newIndex, int maxIndex) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(oldIndex);
                    _data.writeInt(newIndex);
                    _data.writeInt(maxIndex);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSystemAudioMute(boolean mute) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(mute);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInputChangeListener(IHdmiInputChangeListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<HdmiDeviceInfo> getInputDevices() throws RemoteException {
                ArrayList<HdmiDeviceInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(HdmiDeviceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<HdmiDeviceInfo> getDeviceList() throws RemoteException {
                ArrayList<HdmiDeviceInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(HdmiDeviceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void powerOffRemoteDevice(int logicalAddress, int powerStatus) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(logicalAddress);
                    _data.writeInt(powerStatus);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void powerOnRemoteDevice(int logicalAddress, int powerStatus) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(logicalAddress);
                    _data.writeInt(powerStatus);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void askRemoteDeviceToBecomeActiveSource(int physicalAddress) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(physicalAddress);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendVendorCommand(int deviceType, int targetAddress, byte[] params, boolean hasVendorId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceType);
                    _data.writeInt(targetAddress);
                    _data.writeByteArray(params);
                    _data.writeBoolean(hasVendorId);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addVendorCommandListener(IHdmiVendorCommandListener listener2, int vendorId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    _data.writeInt(vendorId);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendStandby(int deviceType, int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceType);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHdmiRecordListener(IHdmiRecordListener callback2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startOneTouchRecord(int recorderAddress, byte[] recordSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(recorderAddress);
                    _data.writeByteArray(recordSource);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopOneTouchRecord(int recorderAddress) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(recorderAddress);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startTimerRecording(int recorderAddress, int sourceType, byte[] recordSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(recorderAddress);
                    _data.writeInt(sourceType);
                    _data.writeByteArray(recordSource);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearTimerRecording(int recorderAddress, int sourceType, byte[] recordSource) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(recorderAddress);
                    _data.writeInt(sourceType);
                    _data.writeByteArray(recordSource);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendMhlVendorCommand(int portId, int offset2, int length, byte[] data) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(portId);
                    _data.writeInt(offset2);
                    _data.writeInt(length);
                    _data.writeByteArray(data);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addHdmiMhlVendorCommandListener(IHdmiMhlVendorCommandListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStandbyMode(boolean isStandbyModeOn) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(isStandbyModeOn);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportAudioStatus(int deviceType, int volume, int maxVolume, boolean isMute) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceType);
                    _data.writeInt(volume);
                    _data.writeInt(maxVolume);
                    _data.writeBoolean(isMute);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSystemAudioModeOnForAudioOnlySource() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setMessageHistorySize(int newSize) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(newSize);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getMessageHistorySize() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addCecSettingChangeListener(String name, IHdmiCecSettingChangeListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeCecSettingChangeListener(String name, IHdmiCecSettingChangeListener listener2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeStrongInterface(listener2);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getUserCecSettings() throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getAllowedCecSettingStringValues(String name) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getAllowedCecSettingIntValues(String name) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getCecSettingStringValue(String name) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCecSettingStringValue(String name, String value2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeString(value2);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getCecSettingIntValue(String name) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCecSettingIntValue(String name, int value2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeInt(value2);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IHdmiControlService {
        @Override
        public int[] getSupportedTypes() throws RemoteException {
            return null;
        }

        @Override
        public HdmiDeviceInfo getActiveSource() throws RemoteException {
            return null;
        }

        @Override
        public void oneTouchPlay(IHdmiControlCallback callback2) throws RemoteException {
        }

        @Override
        public void toggleAndFollowTvPower() throws RemoteException {
        }

        @Override
        public boolean shouldHandleTvPowerKey() throws RemoteException {
            return false;
        }

        @Override
        public void queryDisplayStatus(IHdmiControlCallback callback2) throws RemoteException {
        }

        @Override
        public void addHdmiControlStatusChangeListener(IHdmiControlStatusChangeListener listener2) throws RemoteException {
        }

        @Override
        public void removeHdmiControlStatusChangeListener(IHdmiControlStatusChangeListener listener2) throws RemoteException {
        }

        @Override
        public void addHdmiCecVolumeControlFeatureListener(IHdmiCecVolumeControlFeatureListener listener2) throws RemoteException {
        }

        @Override
        public void removeHdmiCecVolumeControlFeatureListener(IHdmiCecVolumeControlFeatureListener listener2) throws RemoteException {
        }

        @Override
        public void addHotplugEventListener(IHdmiHotplugEventListener listener2) throws RemoteException {
        }

        @Override
        public void removeHotplugEventListener(IHdmiHotplugEventListener listener2) throws RemoteException {
        }

        @Override
        public void addDeviceEventListener(IHdmiDeviceEventListener listener2) throws RemoteException {
        }

        @Override
        public void deviceSelect(int deviceId, IHdmiControlCallback callback2) throws RemoteException {
        }

        @Override
        public void portSelect(int portId, IHdmiControlCallback callback2) throws RemoteException {
        }

        @Override
        public void sendKeyEvent(int deviceType, int keyCode, boolean isPressed) throws RemoteException {
        }

        @Override
        public void sendVolumeKeyEvent(int deviceType, int keyCode, boolean isPressed) throws RemoteException {
        }

        @Override
        public List<HdmiPortInfo> getPortInfo() throws RemoteException {
            return null;
        }

        @Override
        public boolean canChangeSystemAudioMode() throws RemoteException {
            return false;
        }

        @Override
        public boolean getSystemAudioMode() throws RemoteException {
            return false;
        }

        @Override
        public int getPhysicalAddress() throws RemoteException {
            return 0;
        }

        @Override
        public void setSystemAudioMode(boolean enabled, IHdmiControlCallback callback2) throws RemoteException {
        }

        @Override
        public void addSystemAudioModeChangeListener(IHdmiSystemAudioModeChangeListener listener2) throws RemoteException {
        }

        @Override
        public void removeSystemAudioModeChangeListener(IHdmiSystemAudioModeChangeListener listener2) throws RemoteException {
        }

        @Override
        public void setArcMode(boolean enabled) throws RemoteException {
        }

        @Override
        public void setProhibitMode(boolean enabled) throws RemoteException {
        }

        @Override
        public void setSystemAudioVolume(int oldIndex, int newIndex, int maxIndex) throws RemoteException {
        }

        @Override
        public void setSystemAudioMute(boolean mute) throws RemoteException {
        }

        @Override
        public void setInputChangeListener(IHdmiInputChangeListener listener2) throws RemoteException {
        }

        @Override
        public List<HdmiDeviceInfo> getInputDevices() throws RemoteException {
            return null;
        }

        @Override
        public List<HdmiDeviceInfo> getDeviceList() throws RemoteException {
            return null;
        }

        @Override
        public void powerOffRemoteDevice(int logicalAddress, int powerStatus) throws RemoteException {
        }

        @Override
        public void powerOnRemoteDevice(int logicalAddress, int powerStatus) throws RemoteException {
        }

        @Override
        public void askRemoteDeviceToBecomeActiveSource(int physicalAddress) throws RemoteException {
        }

        @Override
        public void sendVendorCommand(int deviceType, int targetAddress, byte[] params, boolean hasVendorId) throws RemoteException {
        }

        @Override
        public void addVendorCommandListener(IHdmiVendorCommandListener listener2, int vendorId) throws RemoteException {
        }

        @Override
        public void sendStandby(int deviceType, int deviceId) throws RemoteException {
        }

        @Override
        public void setHdmiRecordListener(IHdmiRecordListener callback2) throws RemoteException {
        }

        @Override
        public void startOneTouchRecord(int recorderAddress, byte[] recordSource) throws RemoteException {
        }

        @Override
        public void stopOneTouchRecord(int recorderAddress) throws RemoteException {
        }

        @Override
        public void startTimerRecording(int recorderAddress, int sourceType, byte[] recordSource) throws RemoteException {
        }

        @Override
        public void clearTimerRecording(int recorderAddress, int sourceType, byte[] recordSource) throws RemoteException {
        }

        @Override
        public void sendMhlVendorCommand(int portId, int offset2, int length, byte[] data) throws RemoteException {
        }

        @Override
        public void addHdmiMhlVendorCommandListener(IHdmiMhlVendorCommandListener listener2) throws RemoteException {
        }

        @Override
        public void setStandbyMode(boolean isStandbyModeOn) throws RemoteException {
        }

        @Override
        public void reportAudioStatus(int deviceType, int volume, int maxVolume, boolean isMute) throws RemoteException {
        }

        @Override
        public void setSystemAudioModeOnForAudioOnlySource() throws RemoteException {
        }

        @Override
        public boolean setMessageHistorySize(int newSize) throws RemoteException {
            return false;
        }

        @Override
        public int getMessageHistorySize() throws RemoteException {
            return 0;
        }

        @Override
        public void addCecSettingChangeListener(String name, IHdmiCecSettingChangeListener listener2) throws RemoteException {
        }

        @Override
        public void removeCecSettingChangeListener(String name, IHdmiCecSettingChangeListener listener2) throws RemoteException {
        }

        @Override
        public List<String> getUserCecSettings() throws RemoteException {
            return null;
        }

        @Override
        public List<String> getAllowedCecSettingStringValues(String name) throws RemoteException {
            return null;
        }

        @Override
        public int[] getAllowedCecSettingIntValues(String name) throws RemoteException {
            return null;
        }

        @Override
        public String getCecSettingStringValue(String name) throws RemoteException {
            return null;
        }

        @Override
        public void setCecSettingStringValue(String name, String value2) throws RemoteException {
        }

        @Override
        public int getCecSettingIntValue(String name) throws RemoteException {
            return 0;
        }

        @Override
        public void setCecSettingIntValue(String name, int value2) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

