/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.input;

import android.app.ActivityThread;
import android.app.Application;
import android.content.Context;
import android.hardware.input.InputManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.IVibratorStateListener;
import android.os.VibrationAttributes;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.os.VibratorInfo;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import java.util.concurrent.Executor;

class InputDeviceVibrator
extends Vibrator {
    private static final String TAG = "InputDeviceVibrator";
    private final int mDeviceId;
    private final VibratorInfo mVibratorInfo;
    private final Binder mToken;
    private final InputManager mInputManager;
    @GuardedBy(value={"mDelegates"})
    private final ArrayMap<Vibrator.OnVibratorStateChangedListener, OnVibratorStateChangedListenerDelegate> mDelegates = new ArrayMap();

    InputDeviceVibrator(InputManager inputManager, int deviceId, int vibratorId) {
        this.mInputManager = inputManager;
        this.mDeviceId = deviceId;
        this.mVibratorInfo = new VibratorInfo.Builder(vibratorId).setCapabilities(4L).setSupportedEffects(new int[0]).setSupportedBraking(new int[0]).build();
        this.mToken = new Binder();
    }

    @Override
    protected VibratorInfo getInfo() {
        return this.mVibratorInfo;
    }

    @Override
    public boolean hasVibrator() {
        return true;
    }

    @Override
    public boolean isVibrating() {
        return this.mInputManager.isVibrating(this.mDeviceId);
    }

    @Override
    public void addVibratorStateListener(Vibrator.OnVibratorStateChangedListener listener2) {
        Preconditions.checkNotNull(listener2);
        Application context = ActivityThread.currentApplication();
        this.addVibratorStateListener(((Context)context).getMainExecutor(), listener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVibratorStateListener(Executor executor, Vibrator.OnVibratorStateChangedListener listener2) {
        Preconditions.checkNotNull(listener2);
        Preconditions.checkNotNull(executor);
        ArrayMap<Vibrator.OnVibratorStateChangedListener, OnVibratorStateChangedListenerDelegate> arrayMap = this.mDelegates;
        synchronized (arrayMap) {
            if (this.mDelegates.containsKey(listener2)) {
                Log.w(TAG, "Listener already registered.");
                return;
            }
            OnVibratorStateChangedListenerDelegate delegate = new OnVibratorStateChangedListenerDelegate(listener2, executor);
            if (!this.mInputManager.registerVibratorStateListener(this.mDeviceId, delegate)) {
                Log.w(TAG, "Failed to register vibrate state listener");
                return;
            }
            this.mDelegates.put(listener2, delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVibratorStateListener(Vibrator.OnVibratorStateChangedListener listener2) {
        Preconditions.checkNotNull(listener2);
        ArrayMap<Vibrator.OnVibratorStateChangedListener, OnVibratorStateChangedListenerDelegate> arrayMap = this.mDelegates;
        synchronized (arrayMap) {
            if (this.mDelegates.containsKey(listener2)) {
                OnVibratorStateChangedListenerDelegate delegate = this.mDelegates.get(listener2);
                if (!this.mInputManager.unregisterVibratorStateListener(this.mDeviceId, delegate)) {
                    Log.w(TAG, "Failed to unregister vibrate state listener");
                    return;
                }
                this.mDelegates.remove(listener2);
            }
        }
    }

    @Override
    public boolean hasAmplitudeControl() {
        return this.mVibratorInfo.hasCapability(4L);
    }

    @Override
    public void vibrate(int uid, String opPkg, VibrationEffect effect, String reason, VibrationAttributes attributes) {
        this.mInputManager.vibrate(this.mDeviceId, effect, (IBinder)this.mToken);
    }

    @Override
    public void cancel() {
        this.mInputManager.cancelVibrate(this.mDeviceId, this.mToken);
    }

    @Override
    public void cancel(int usageFilter) {
        this.cancel();
    }

    private class OnVibratorStateChangedListenerDelegate
    extends IVibratorStateListener.Stub {
        private final Executor mExecutor;
        private final Vibrator.OnVibratorStateChangedListener mListener;

        OnVibratorStateChangedListenerDelegate(Vibrator.OnVibratorStateChangedListener listener2, Executor executor) {
            this.mExecutor = executor;
            this.mListener = listener2;
        }

        @Override
        public void onVibrating(boolean isVibrating) {
            this.mExecutor.execute(() -> this.mListener.onVibratorStateChanged(isVibrating));
        }
    }
}

