/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.app.PendingIntent;
import android.hardware.location.ContextHubInfo;
import android.hardware.location.ContextHubMessage;
import android.hardware.location.IContextHubCallback;
import android.hardware.location.IContextHubClient;
import android.hardware.location.IContextHubClientCallback;
import android.hardware.location.IContextHubTransactionCallback;
import android.hardware.location.NanoApp;
import android.hardware.location.NanoAppBinary;
import android.hardware.location.NanoAppFilter;
import android.hardware.location.NanoAppInstanceInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IContextHubService
extends IInterface {
    public int registerCallback(IContextHubCallback var1) throws RemoteException;

    public int[] getContextHubHandles() throws RemoteException;

    public ContextHubInfo getContextHubInfo(int var1) throws RemoteException;

    public int loadNanoApp(int var1, NanoApp var2) throws RemoteException;

    public int unloadNanoApp(int var1) throws RemoteException;

    public NanoAppInstanceInfo getNanoAppInstanceInfo(int var1) throws RemoteException;

    public int[] findNanoAppOnHub(int var1, NanoAppFilter var2) throws RemoteException;

    public int sendMessage(int var1, int var2, ContextHubMessage var3) throws RemoteException;

    public IContextHubClient createClient(int var1, IContextHubClientCallback var2, String var3, String var4) throws RemoteException;

    public IContextHubClient createPendingIntentClient(int var1, PendingIntent var2, long var3, String var5) throws RemoteException;

    public List<ContextHubInfo> getContextHubs() throws RemoteException;

    public void loadNanoAppOnHub(int var1, IContextHubTransactionCallback var2, NanoAppBinary var3) throws RemoteException;

    public void unloadNanoAppFromHub(int var1, IContextHubTransactionCallback var2, long var3) throws RemoteException;

    public void enableNanoApp(int var1, IContextHubTransactionCallback var2, long var3) throws RemoteException;

    public void disableNanoApp(int var1, IContextHubTransactionCallback var2, long var3) throws RemoteException;

    public void queryNanoApps(int var1, IContextHubTransactionCallback var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IContextHubService {
        public static final String DESCRIPTOR = "android.hardware.location.IContextHubService";
        static final int TRANSACTION_registerCallback = 1;
        static final int TRANSACTION_getContextHubHandles = 2;
        static final int TRANSACTION_getContextHubInfo = 3;
        static final int TRANSACTION_loadNanoApp = 4;
        static final int TRANSACTION_unloadNanoApp = 5;
        static final int TRANSACTION_getNanoAppInstanceInfo = 6;
        static final int TRANSACTION_findNanoAppOnHub = 7;
        static final int TRANSACTION_sendMessage = 8;
        static final int TRANSACTION_createClient = 9;
        static final int TRANSACTION_createPendingIntentClient = 10;
        static final int TRANSACTION_getContextHubs = 11;
        static final int TRANSACTION_loadNanoAppOnHub = 12;
        static final int TRANSACTION_unloadNanoAppFromHub = 13;
        static final int TRANSACTION_enableNanoApp = 14;
        static final int TRANSACTION_disableNanoApp = 15;
        static final int TRANSACTION_queryNanoApps = 16;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IContextHubService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IContextHubService) {
                return (IContextHubService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "registerCallback";
                }
                case 2: {
                    return "getContextHubHandles";
                }
                case 3: {
                    return "getContextHubInfo";
                }
                case 4: {
                    return "loadNanoApp";
                }
                case 5: {
                    return "unloadNanoApp";
                }
                case 6: {
                    return "getNanoAppInstanceInfo";
                }
                case 7: {
                    return "findNanoAppOnHub";
                }
                case 8: {
                    return "sendMessage";
                }
                case 9: {
                    return "createClient";
                }
                case 10: {
                    return "createPendingIntentClient";
                }
                case 11: {
                    return "getContextHubs";
                }
                case 12: {
                    return "loadNanoAppOnHub";
                }
                case 13: {
                    return "unloadNanoAppFromHub";
                }
                case 14: {
                    return "enableNanoApp";
                }
                case 15: {
                    return "disableNanoApp";
                }
                case 16: {
                    return "queryNanoApps";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    IContextHubCallback _arg0 = IContextHubCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.registerCallback(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 2: {
                    int[] _result = this.getContextHubHandles();
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    ContextHubInfo _result = this.getContextHubInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    NanoApp _arg1 = data.readTypedObject(NanoApp.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.loadNanoApp(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.unloadNanoApp(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    NanoAppInstanceInfo _result = this.getNanoAppInstanceInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    NanoAppFilter _arg1 = data.readTypedObject(NanoAppFilter.CREATOR);
                    data.enforceNoDataAvail();
                    int[] _result = this.findNanoAppOnHub(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ContextHubMessage _arg2 = data.readTypedObject(ContextHubMessage.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.sendMessage(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    IContextHubClientCallback _arg1 = IContextHubClientCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    IContextHubClient _result = this.createClient(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    PendingIntent _arg1 = data.readTypedObject(PendingIntent.CREATOR);
                    long _arg2 = data.readLong();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    IContextHubClient _result = this.createPendingIntentClient(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 11: {
                    List<ContextHubInfo> _result = this.getContextHubs();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    IContextHubTransactionCallback _arg1 = IContextHubTransactionCallback.Stub.asInterface(data.readStrongBinder());
                    NanoAppBinary _arg2 = data.readTypedObject(NanoAppBinary.CREATOR);
                    data.enforceNoDataAvail();
                    this.loadNanoAppOnHub(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    IContextHubTransactionCallback _arg1 = IContextHubTransactionCallback.Stub.asInterface(data.readStrongBinder());
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.unloadNanoAppFromHub(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    IContextHubTransactionCallback _arg1 = IContextHubTransactionCallback.Stub.asInterface(data.readStrongBinder());
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.enableNanoApp(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    IContextHubTransactionCallback _arg1 = IContextHubTransactionCallback.Stub.asInterface(data.readStrongBinder());
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.disableNanoApp(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    IContextHubTransactionCallback _arg1 = IContextHubTransactionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.queryNanoApps(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 15;
        }

        private static class Proxy
        implements IContextHubService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int registerCallback(IContextHubCallback callback2) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback2);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] getContextHubHandles() throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ContextHubInfo getContextHubInfo(int contextHubHandle) throws RemoteException {
                ContextHubInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(contextHubHandle);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ContextHubInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int loadNanoApp(int contextHubHandle, NanoApp nanoApp) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(contextHubHandle);
                    _data.writeTypedObject(nanoApp, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int unloadNanoApp(int nanoAppHandle) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(nanoAppHandle);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NanoAppInstanceInfo getNanoAppInstanceInfo(int nanoAppHandle) throws RemoteException {
                NanoAppInstanceInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(nanoAppHandle);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(NanoAppInstanceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] findNanoAppOnHub(int contextHubHandle, NanoAppFilter filter2) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(contextHubHandle);
                    _data.writeTypedObject(filter2, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int sendMessage(int contextHubHandle, int nanoAppHandle, ContextHubMessage msg) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(contextHubHandle);
                    _data.writeInt(nanoAppHandle);
                    _data.writeTypedObject(msg, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IContextHubClient createClient(int contextHubId, IContextHubClientCallback client, String attributionTag, String packageName) throws RemoteException {
                IContextHubClient _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(contextHubId);
                    _data.writeStrongInterface(client);
                    _data.writeString(attributionTag);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = IContextHubClient.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IContextHubClient createPendingIntentClient(int contextHubId, PendingIntent pendingIntent, long nanoAppId, String attributionTag) throws RemoteException {
                IContextHubClient _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(contextHubId);
                    _data.writeTypedObject(pendingIntent, 0);
                    _data.writeLong(nanoAppId);
                    _data.writeString(attributionTag);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = IContextHubClient.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ContextHubInfo> getContextHubs() throws RemoteException {
                ArrayList<ContextHubInfo> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(ContextHubInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void loadNanoAppOnHub(int contextHubId, IContextHubTransactionCallback transactionCallback, NanoAppBinary nanoAppBinary) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(contextHubId);
                    _data.writeStrongInterface(transactionCallback);
                    _data.writeTypedObject(nanoAppBinary, 0);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unloadNanoAppFromHub(int contextHubId, IContextHubTransactionCallback transactionCallback, long nanoAppId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(contextHubId);
                    _data.writeStrongInterface(transactionCallback);
                    _data.writeLong(nanoAppId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableNanoApp(int contextHubId, IContextHubTransactionCallback transactionCallback, long nanoAppId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(contextHubId);
                    _data.writeStrongInterface(transactionCallback);
                    _data.writeLong(nanoAppId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableNanoApp(int contextHubId, IContextHubTransactionCallback transactionCallback, long nanoAppId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(contextHubId);
                    _data.writeStrongInterface(transactionCallback);
                    _data.writeLong(nanoAppId);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void queryNanoApps(int contextHubId, IContextHubTransactionCallback transactionCallback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(contextHubId);
                    _data.writeStrongInterface(transactionCallback);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IContextHubService {
        @Override
        public int registerCallback(IContextHubCallback callback2) throws RemoteException {
            return 0;
        }

        @Override
        public int[] getContextHubHandles() throws RemoteException {
            return null;
        }

        @Override
        public ContextHubInfo getContextHubInfo(int contextHubHandle) throws RemoteException {
            return null;
        }

        @Override
        public int loadNanoApp(int contextHubHandle, NanoApp nanoApp) throws RemoteException {
            return 0;
        }

        @Override
        public int unloadNanoApp(int nanoAppHandle) throws RemoteException {
            return 0;
        }

        @Override
        public NanoAppInstanceInfo getNanoAppInstanceInfo(int nanoAppHandle) throws RemoteException {
            return null;
        }

        @Override
        public int[] findNanoAppOnHub(int contextHubHandle, NanoAppFilter filter2) throws RemoteException {
            return null;
        }

        @Override
        public int sendMessage(int contextHubHandle, int nanoAppHandle, ContextHubMessage msg) throws RemoteException {
            return 0;
        }

        @Override
        public IContextHubClient createClient(int contextHubId, IContextHubClientCallback client, String attributionTag, String packageName) throws RemoteException {
            return null;
        }

        @Override
        public IContextHubClient createPendingIntentClient(int contextHubId, PendingIntent pendingIntent, long nanoAppId, String attributionTag) throws RemoteException {
            return null;
        }

        @Override
        public List<ContextHubInfo> getContextHubs() throws RemoteException {
            return null;
        }

        @Override
        public void loadNanoAppOnHub(int contextHubId, IContextHubTransactionCallback transactionCallback, NanoAppBinary nanoAppBinary) throws RemoteException {
        }

        @Override
        public void unloadNanoAppFromHub(int contextHubId, IContextHubTransactionCallback transactionCallback, long nanoAppId) throws RemoteException {
        }

        @Override
        public void enableNanoApp(int contextHubId, IContextHubTransactionCallback transactionCallback, long nanoAppId) throws RemoteException {
        }

        @Override
        public void disableNanoApp(int contextHubId, IContextHubTransactionCallback transactionCallback, long nanoAppId) throws RemoteException {
        }

        @Override
        public void queryNanoApps(int contextHubId, IContextHubTransactionCallback transactionCallback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

