/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.radio;

import android.graphics.Bitmap;
import android.hardware.radio.ProgramList;
import android.hardware.radio.ProgramSelector;
import android.hardware.radio.RadioManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public interface ITuner
extends IInterface {
    public void close() throws RemoteException;

    public boolean isClosed() throws RemoteException;

    public void setConfiguration(RadioManager.BandConfig var1) throws RemoteException;

    public RadioManager.BandConfig getConfiguration() throws RemoteException;

    public void setMuted(boolean var1) throws RemoteException;

    public boolean isMuted() throws RemoteException;

    public void step(boolean var1, boolean var2) throws RemoteException;

    public void scan(boolean var1, boolean var2) throws RemoteException;

    public void tune(ProgramSelector var1) throws RemoteException;

    public void cancel() throws RemoteException;

    public void cancelAnnouncement() throws RemoteException;

    public Bitmap getImage(int var1) throws RemoteException;

    public boolean startBackgroundScan() throws RemoteException;

    public void startProgramListUpdates(ProgramList.Filter var1) throws RemoteException;

    public void stopProgramListUpdates() throws RemoteException;

    public boolean isConfigFlagSupported(int var1) throws RemoteException;

    public boolean isConfigFlagSet(int var1) throws RemoteException;

    public void setConfigFlag(int var1, boolean var2) throws RemoteException;

    public Map<String, String> setParameters(Map<String, String> var1) throws RemoteException;

    public Map<String, String> getParameters(List<String> var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITuner {
        public static final String DESCRIPTOR = "android.hardware.radio.ITuner";
        static final int TRANSACTION_close = 1;
        static final int TRANSACTION_isClosed = 2;
        static final int TRANSACTION_setConfiguration = 3;
        static final int TRANSACTION_getConfiguration = 4;
        static final int TRANSACTION_setMuted = 5;
        static final int TRANSACTION_isMuted = 6;
        static final int TRANSACTION_step = 7;
        static final int TRANSACTION_scan = 8;
        static final int TRANSACTION_tune = 9;
        static final int TRANSACTION_cancel = 10;
        static final int TRANSACTION_cancelAnnouncement = 11;
        static final int TRANSACTION_getImage = 12;
        static final int TRANSACTION_startBackgroundScan = 13;
        static final int TRANSACTION_startProgramListUpdates = 14;
        static final int TRANSACTION_stopProgramListUpdates = 15;
        static final int TRANSACTION_isConfigFlagSupported = 16;
        static final int TRANSACTION_isConfigFlagSet = 17;
        static final int TRANSACTION_setConfigFlag = 18;
        static final int TRANSACTION_setParameters = 19;
        static final int TRANSACTION_getParameters = 20;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITuner asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITuner) {
                return (ITuner)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "close";
                }
                case 2: {
                    return "isClosed";
                }
                case 3: {
                    return "setConfiguration";
                }
                case 4: {
                    return "getConfiguration";
                }
                case 5: {
                    return "setMuted";
                }
                case 6: {
                    return "isMuted";
                }
                case 7: {
                    return "step";
                }
                case 8: {
                    return "scan";
                }
                case 9: {
                    return "tune";
                }
                case 10: {
                    return "cancel";
                }
                case 11: {
                    return "cancelAnnouncement";
                }
                case 12: {
                    return "getImage";
                }
                case 13: {
                    return "startBackgroundScan";
                }
                case 14: {
                    return "startProgramListUpdates";
                }
                case 15: {
                    return "stopProgramListUpdates";
                }
                case 16: {
                    return "isConfigFlagSupported";
                }
                case 17: {
                    return "isConfigFlagSet";
                }
                case 18: {
                    return "setConfigFlag";
                }
                case 19: {
                    return "setParameters";
                }
                case 20: {
                    return "getParameters";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    this.close();
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    boolean _result = this.isClosed();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 3: {
                    RadioManager.BandConfig _arg0 = data.readTypedObject(RadioManager.BandConfig.CREATOR);
                    data.enforceNoDataAvail();
                    this.setConfiguration(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    RadioManager.BandConfig _result = this.getConfiguration();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 5: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setMuted(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    boolean _result = this.isMuted();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    boolean _arg0 = data.readBoolean();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.step(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    boolean _arg0 = data.readBoolean();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.scan(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    ProgramSelector _arg0 = data.readTypedObject(ProgramSelector.CREATOR);
                    data.enforceNoDataAvail();
                    this.tune(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    this.cancel();
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    this.cancelAnnouncement();
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Bitmap _result = this.getImage(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 13: {
                    boolean _result = this.startBackgroundScan();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 14: {
                    ProgramList.Filter _arg0 = data.readTypedObject(ProgramList.Filter.CREATOR);
                    data.enforceNoDataAvail();
                    this.startProgramListUpdates(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    this.stopProgramListUpdates();
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isConfigFlagSupported(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isConfigFlagSet(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setConfigFlag(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    int N = data.readInt();
                    HashMap<String, String> _arg0 = N < 0 ? null : new HashMap<String, String>();
                    IntStream.range(0, N).forEach(i -> {
                        String k = data.readString();
                        String v = data.readString();
                        _arg0.put(k, v);
                    });
                    data.enforceNoDataAvail();
                    Map<String, String> _result = this.setParameters(_arg0);
                    reply.writeNoException();
                    if (_result == null) {
                        reply.writeInt(-1);
                        break;
                    }
                    reply.writeInt(_result.size());
                    _result.forEach((k, v) -> {
                        reply.writeString((String)k);
                        reply.writeString((String)v);
                    });
                    break;
                }
                case 20: {
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    data.enforceNoDataAvail();
                    Map<String, String> _result = this.getParameters(_arg0);
                    reply.writeNoException();
                    if (_result == null) {
                        reply.writeInt(-1);
                        break;
                    }
                    reply.writeInt(_result.size());
                    _result.forEach((k, v) -> {
                        reply.writeString((String)k);
                        reply.writeString((String)v);
                    });
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 19;
        }

        private static class Proxy
        implements ITuner {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isClosed() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setConfiguration(RadioManager.BandConfig config) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RadioManager.BandConfig getConfiguration() throws RemoteException {
                RadioManager.BandConfig _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(RadioManager.BandConfig.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMuted(boolean mute) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(mute);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMuted() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void step(boolean directionDown, boolean skipSubChannel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(directionDown);
                    _data.writeBoolean(skipSubChannel);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void scan(boolean directionDown, boolean skipSubChannel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(directionDown);
                    _data.writeBoolean(skipSubChannel);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tune(ProgramSelector selector) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(selector, 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancel() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelAnnouncement() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bitmap getImage(int id2) throws RemoteException {
                Bitmap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(id2);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Bitmap.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startBackgroundScan() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startProgramListUpdates(ProgramList.Filter filter2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(filter2, 0);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopProgramListUpdates() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isConfigFlagSupported(int flag) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flag);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isConfigFlagSet(int flag) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flag);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setConfigFlag(int flag, boolean value2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flag);
                    _data.writeBoolean(value2);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<String, String> setParameters(Map<String, String> parameters) throws RemoteException {
                HashMap<String, String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (parameters == null) {
                        _data.writeInt(-1);
                    } else {
                        _data.writeInt(parameters.size());
                        parameters.forEach((k, v) -> {
                            _data.writeString((String)k);
                            _data.writeString((String)v);
                        });
                    }
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    int N = _reply.readInt();
                    _result = N < 0 ? null : new HashMap<String, String>();
                    IntStream.range(0, N).forEach(i -> {
                        String k = _reply.readString();
                        String v = _reply.readString();
                        _result.put(k, v);
                    });
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<String, String> getParameters(List<String> keys) throws RemoteException {
                HashMap<String, String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringList(keys);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    int N = _reply.readInt();
                    _result = N < 0 ? null : new HashMap<String, String>();
                    IntStream.range(0, N).forEach(i -> {
                        String k = _reply.readString();
                        String v = _reply.readString();
                        _result.put(k, v);
                    });
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ITuner {
        @Override
        public void close() throws RemoteException {
        }

        @Override
        public boolean isClosed() throws RemoteException {
            return false;
        }

        @Override
        public void setConfiguration(RadioManager.BandConfig config) throws RemoteException {
        }

        @Override
        public RadioManager.BandConfig getConfiguration() throws RemoteException {
            return null;
        }

        @Override
        public void setMuted(boolean mute) throws RemoteException {
        }

        @Override
        public boolean isMuted() throws RemoteException {
            return false;
        }

        @Override
        public void step(boolean directionDown, boolean skipSubChannel) throws RemoteException {
        }

        @Override
        public void scan(boolean directionDown, boolean skipSubChannel) throws RemoteException {
        }

        @Override
        public void tune(ProgramSelector selector) throws RemoteException {
        }

        @Override
        public void cancel() throws RemoteException {
        }

        @Override
        public void cancelAnnouncement() throws RemoteException {
        }

        @Override
        public Bitmap getImage(int id2) throws RemoteException {
            return null;
        }

        @Override
        public boolean startBackgroundScan() throws RemoteException {
            return false;
        }

        @Override
        public void startProgramListUpdates(ProgramList.Filter filter2) throws RemoteException {
        }

        @Override
        public void stopProgramListUpdates() throws RemoteException {
        }

        @Override
        public boolean isConfigFlagSupported(int flag) throws RemoteException {
            return false;
        }

        @Override
        public boolean isConfigFlagSet(int flag) throws RemoteException {
            return false;
        }

        @Override
        public void setConfigFlag(int flag, boolean value2) throws RemoteException {
        }

        @Override
        public Map<String, String> setParameters(Map<String, String> parameters) throws RemoteException {
            return null;
        }

        @Override
        public Map<String, String> getParameters(List<String> keys) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

