/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.number;

import android.icu.impl.number.DecimalQuantity;
import android.icu.impl.number.LongNameHandler;
import android.icu.impl.number.MicroProps;
import android.icu.impl.number.MicroPropsGenerator;
import android.icu.impl.number.MixedUnitLongNameHandler;
import android.icu.number.NumberFormatter;
import android.icu.text.PluralRules;
import android.icu.util.MeasureUnit;
import android.icu.util.ULocale;
import java.util.ArrayList;
import java.util.List;

public class LongNameMultiplexer
implements MicroPropsGenerator {
    private final MicroPropsGenerator fParent;
    private List<ParentlessMicroPropsGenerator> fHandlers;
    private List<MeasureUnit> fMeasureUnits;

    public LongNameMultiplexer(MicroPropsGenerator fParent) {
        this.fParent = fParent;
    }

    public static LongNameMultiplexer forMeasureUnits(ULocale locale, List<MeasureUnit> units, NumberFormatter.UnitWidth width2, String unitDisplayCase, PluralRules rules, MicroPropsGenerator parent) {
        LongNameMultiplexer result = new LongNameMultiplexer(parent);
        assert (units.size() > 0);
        result.fMeasureUnits = new ArrayList<MeasureUnit>();
        result.fHandlers = new ArrayList<ParentlessMicroPropsGenerator>();
        for (int i = 0; i < units.size(); ++i) {
            MeasureUnit unit2 = units.get(i);
            result.fMeasureUnits.add(unit2);
            if (unit2.getComplexity() == MeasureUnit.Complexity.MIXED) {
                MixedUnitLongNameHandler mlnh = MixedUnitLongNameHandler.forMeasureUnit(locale, unit2, width2, unitDisplayCase, rules, null);
                result.fHandlers.add(mlnh);
                continue;
            }
            LongNameHandler lnh = LongNameHandler.forMeasureUnit(locale, unit2, width2, unitDisplayCase, rules, null);
            result.fHandlers.add(lnh);
        }
        return result;
    }

    @Override
    public MicroProps processQuantity(DecimalQuantity quantity) {
        MicroProps micros = this.fParent.processQuantity(quantity);
        for (int i = 0; i < this.fHandlers.size(); ++i) {
            if (!this.fMeasureUnits.get(i).equals(micros.outputUnit)) continue;
            ParentlessMicroPropsGenerator handler = this.fHandlers.get(i);
            return handler.processQuantityWithMicros(quantity, micros);
        }
        throw new AssertionError((Object)" We shouldn't receive any outputUnit for which we haven't already got a LongNameHandler");
    }

    public static interface ParentlessMicroPropsGenerator {
        public MicroProps processQuantityWithMicros(DecimalQuantity var1, MicroProps var2);
    }
}

