/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.inputmethodservice.IInputMethodSessionWrapper;
import android.inputmethodservice.InputMethodServiceInternal;
import android.inputmethodservice.RemoteInputConnection;
import android.os.Binder;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.util.Log;
import android.view.InputChannel;
import android.view.MotionEvent;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputBinding;
import android.view.inputmethod.InputMethod;
import android.view.inputmethod.InputMethodSession;
import android.view.inputmethod.InputMethodSubtype;
import android.window.ImeOnBackInvokedDispatcher;
import com.android.internal.inputmethod.CancellationGroup;
import com.android.internal.inputmethod.IInputMethodPrivilegedOperations;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;
import com.android.internal.view.IInlineSuggestionsRequestCallback;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethod;
import com.android.internal.view.IInputMethodSession;
import com.android.internal.view.IInputSessionCallback;
import com.android.internal.view.InlineSuggestionsRequestInfo;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class IInputMethodWrapper
extends IInputMethod.Stub
implements HandlerCaller.Callback {
    private static final String TAG = "InputMethodWrapper";
    private static final int DO_DUMP = 1;
    private static final int DO_INITIALIZE_INTERNAL = 10;
    private static final int DO_SET_INPUT_CONTEXT = 20;
    private static final int DO_UNSET_INPUT_CONTEXT = 30;
    private static final int DO_START_INPUT = 32;
    private static final int DO_ON_NAV_BUTTON_FLAGS_CHANGED = 35;
    private static final int DO_CREATE_SESSION = 40;
    private static final int DO_SET_SESSION_ENABLED = 45;
    private static final int DO_SHOW_SOFT_INPUT = 60;
    private static final int DO_HIDE_SOFT_INPUT = 70;
    private static final int DO_CHANGE_INPUTMETHOD_SUBTYPE = 80;
    private static final int DO_CREATE_INLINE_SUGGESTIONS_REQUEST = 90;
    private static final int DO_CAN_START_STYLUS_HANDWRITING = 100;
    private static final int DO_START_STYLUS_HANDWRITING = 110;
    private static final int DO_INIT_INK_WINDOW = 120;
    private static final int DO_FINISH_STYLUS_HANDWRITING = 130;
    final WeakReference<InputMethodServiceInternal> mTarget;
    final Context mContext;
    @UnsupportedAppUsage
    final HandlerCaller mCaller;
    final WeakReference<InputMethod> mInputMethod;
    final int mTargetSdkVersion;
    CancellationGroup mCancellationGroup = null;

    IInputMethodWrapper(InputMethodServiceInternal imsInternal, InputMethod inputMethod) {
        this.mTarget = new WeakReference<InputMethodServiceInternal>(imsInternal);
        this.mContext = imsInternal.getContext().getApplicationContext();
        this.mCaller = new HandlerCaller(this.mContext, null, this, true);
        this.mInputMethod = new WeakReference<InputMethod>(inputMethod);
        this.mTargetSdkVersion = imsInternal.getContext().getApplicationInfo().targetSdkVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeMessage(Message msg) {
        InputMethod inputMethod = (InputMethod)this.mInputMethod.get();
        if (inputMethod == null && msg.what != 1) {
            Log.w(TAG, "Input method reference was null, ignoring message: " + msg.what);
            return;
        }
        switch (msg.what) {
            case 1: {
                InputMethodServiceInternal target = (InputMethodServiceInternal)this.mTarget.get();
                if (target == null) {
                    return;
                }
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    target.dump((FileDescriptor)args.arg1, (PrintWriter)args.arg2, (String[])args.arg3);
                }
                catch (RuntimeException e) {
                    ((PrintWriter)args.arg2).println("Exception: " + e);
                }
                Object e = args.arg4;
                synchronized (e) {
                    ((CountDownLatch)args.arg4).countDown();
                }
                args.recycle();
                return;
            }
            case 10: {
                SomeArgs args = (SomeArgs)msg.obj;
                try {
                    inputMethod.initializeInternal((IBinder)args.arg1, (IInputMethodPrivilegedOperations)args.arg2, msg.arg1, (Boolean)args.arg3, msg.arg2);
                }
                finally {
                    args.recycle();
                }
                return;
            }
            case 20: {
                inputMethod.bindInput((InputBinding)msg.obj);
                return;
            }
            case 30: {
                inputMethod.unbindInput();
                return;
            }
            case 32: {
                SomeArgs args = (SomeArgs)msg.obj;
                IBinder startInputToken = (IBinder)args.arg1;
                IInputContext inputContext = (IInputContext)((SomeArgs)args.arg2).arg1;
                ImeOnBackInvokedDispatcher imeDispatcher = (ImeOnBackInvokedDispatcher)((SomeArgs)args.arg2).arg2;
                EditorInfo info = (EditorInfo)args.arg3;
                CancellationGroup cancellationGroup = (CancellationGroup)args.arg4;
                boolean restarting = args.argi5 == 1;
                int navButtonFlags = args.argi6;
                RemoteInputConnection ic = inputContext != null ? new RemoteInputConnection(this.mTarget, inputContext, cancellationGroup) : null;
                info.makeCompatible(this.mTargetSdkVersion);
                inputMethod.dispatchStartInputWithToken(ic, info, restarting, startInputToken, navButtonFlags, imeDispatcher);
                args.recycle();
                return;
            }
            case 35: {
                inputMethod.onNavButtonFlagsChanged(msg.arg1);
                return;
            }
            case 40: {
                SomeArgs args = (SomeArgs)msg.obj;
                inputMethod.createSession(new InputMethodSessionCallbackWrapper(this.mContext, (InputChannel)args.arg1, (IInputSessionCallback)args.arg2));
                args.recycle();
                return;
            }
            case 45: {
                inputMethod.setSessionEnabled((InputMethodSession)msg.obj, msg.arg1 != 0);
                return;
            }
            case 60: {
                SomeArgs args = (SomeArgs)msg.obj;
                inputMethod.showSoftInputWithToken(msg.arg1, (ResultReceiver)args.arg2, (IBinder)args.arg1);
                args.recycle();
                return;
            }
            case 70: {
                SomeArgs args = (SomeArgs)msg.obj;
                inputMethod.hideSoftInputWithToken(msg.arg1, (ResultReceiver)args.arg2, (IBinder)args.arg1);
                args.recycle();
                return;
            }
            case 80: {
                inputMethod.changeInputMethodSubtype((InputMethodSubtype)msg.obj);
                return;
            }
            case 90: {
                SomeArgs args = (SomeArgs)msg.obj;
                inputMethod.onCreateInlineSuggestionsRequest((InlineSuggestionsRequestInfo)args.arg1, (IInlineSuggestionsRequestCallback)args.arg2);
                args.recycle();
                return;
            }
            case 100: {
                inputMethod.canStartStylusHandwriting(msg.arg1);
                return;
            }
            case 110: {
                SomeArgs args = (SomeArgs)msg.obj;
                inputMethod.startStylusHandwriting(msg.arg1, (InputChannel)args.arg1, (List)args.arg2);
                args.recycle();
                return;
            }
            case 120: {
                inputMethod.initInkWindow();
                return;
            }
            case 130: {
                inputMethod.finishStylusHandwriting();
                return;
            }
        }
        Log.w(TAG, "Unhandled message code: " + msg.what);
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
        InputMethodServiceInternal target = (InputMethodServiceInternal)this.mTarget.get();
        if (target == null) {
            return;
        }
        if (target.getContext().checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            fout.println("Permission Denial: can't dump InputMethodManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        this.mCaller.getHandler().sendMessageAtFrontOfQueue(this.mCaller.obtainMessageOOOO(1, fd, fout, args, latch));
        try {
            if (!latch.await(5L, TimeUnit.SECONDS)) {
                fout.println("Timeout waiting for dump");
            }
        }
        catch (InterruptedException e) {
            fout.println("Interrupted waiting for dump");
        }
    }

    @Override
    public void initializeInternal(IBinder token, IInputMethodPrivilegedOperations privOps, int configChanges, boolean stylusHwSupported, int navButtonFlags) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIIOOO(10, configChanges, navButtonFlags, token, privOps, stylusHwSupported));
    }

    @Override
    public void onCreateInlineSuggestionsRequest(InlineSuggestionsRequestInfo requestInfo, IInlineSuggestionsRequestCallback cb) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(90, requestInfo, cb));
    }

    @Override
    public void bindInput(InputBinding binding) {
        if (this.mCancellationGroup != null) {
            Log.e(TAG, "bindInput must be paired with unbindInput.");
        }
        this.mCancellationGroup = new CancellationGroup();
        RemoteInputConnection ic = new RemoteInputConnection(this.mTarget, IInputContext.Stub.asInterface(binding.getConnectionToken()), this.mCancellationGroup);
        InputBinding nu = new InputBinding(ic, binding);
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(20, nu));
    }

    @Override
    public void unbindInput() {
        if (this.mCancellationGroup != null) {
            this.mCancellationGroup.cancelAll();
            this.mCancellationGroup = null;
        } else {
            Log.e(TAG, "unbindInput must be paired with bindInput.");
        }
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(30));
    }

    @Override
    public void startInput(IBinder startInputToken, IInputContext inputContext, EditorInfo attribute, boolean restarting, int navButtonFlags, ImeOnBackInvokedDispatcher imeDispatcher) {
        if (this.mCancellationGroup == null) {
            Log.e(TAG, "startInput must be called after bindInput.");
            this.mCancellationGroup = new CancellationGroup();
        }
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = inputContext;
        args.arg2 = imeDispatcher;
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOOOOII(32, startInputToken, args, attribute, this.mCancellationGroup, restarting ? 1 : 0, navButtonFlags));
    }

    @Override
    public void onNavButtonFlagsChanged(int navButtonFlags) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageI(35, navButtonFlags));
    }

    @Override
    public void createSession(InputChannel channel, IInputSessionCallback callback2) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageOO(40, channel, callback2));
    }

    @Override
    public void setSessionEnabled(IInputMethodSession session, boolean enabled) {
        try {
            InputMethodSession ls = ((IInputMethodSessionWrapper)session).getInternalInputMethodSession();
            if (ls == null) {
                Log.w(TAG, "Session is already finished: " + session);
                return;
            }
            this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIO(45, enabled ? 1 : 0, ls));
        }
        catch (ClassCastException e) {
            Log.w(TAG, "Incoming session not of correct type: " + session, e);
        }
    }

    @Override
    public void showSoftInput(IBinder showInputToken, int flags, ResultReceiver resultReceiver) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIOO(60, flags, showInputToken, resultReceiver));
    }

    @Override
    public void hideSoftInput(IBinder hideInputToken, int flags, ResultReceiver resultReceiver) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIOO(70, flags, hideInputToken, resultReceiver));
    }

    @Override
    public void changeInputMethodSubtype(InputMethodSubtype subtype) {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageO(80, subtype));
    }

    @Override
    public void canStartStylusHandwriting(int requestId) throws RemoteException {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageI(100, requestId));
    }

    @Override
    public void startStylusHandwriting(int requestId, InputChannel channel, List<MotionEvent> stylusEvents) throws RemoteException {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessageIOO(110, requestId, channel, stylusEvents));
    }

    @Override
    public void initInkWindow() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(120));
    }

    @Override
    public void finishStylusHandwriting() {
        this.mCaller.executeOrSendMessage(this.mCaller.obtainMessage(130));
    }

    static class InputMethodSessionCallbackWrapper
    implements InputMethod.SessionCallback {
        final Context mContext;
        final InputChannel mChannel;
        final IInputSessionCallback mCb;

        InputMethodSessionCallbackWrapper(Context context, InputChannel channel, IInputSessionCallback cb) {
            this.mContext = context;
            this.mChannel = channel;
            this.mCb = cb;
        }

        @Override
        public void sessionCreated(InputMethodSession session) {
            try {
                if (session != null) {
                    IInputMethodSessionWrapper wrap = new IInputMethodSessionWrapper(this.mContext, session, this.mChannel);
                    this.mCb.sessionCreated(wrap);
                } else {
                    if (this.mChannel != null) {
                        this.mChannel.dispose();
                    }
                    this.mCb.sessionCreated(null);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

