/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.content.Context;
import android.os.IBinder;
import android.util.Slog;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.android.internal.policy.PhoneWindow;

class InkWindow
extends PhoneWindow {
    private final WindowManager mWindowManager;
    private boolean mIsViewAdded;
    private View mInkView;
    private InkVisibilityListener mInkViewVisibilityListener;
    private ViewTreeObserver.OnGlobalLayoutListener mGlobalLayoutListener;

    public InkWindow(Context context) {
        super(context);
        this.setType(2011);
        WindowManager.LayoutParams attrs = this.getAttributes();
        attrs.layoutInDisplayCutoutMode = 3;
        attrs.setFitInsetsTypes(0);
        this.setAttributes(attrs);
        this.addFlags(792);
        this.setBackgroundDrawableResource(17170445);
        this.setLayout(-1, -1);
        this.mWindowManager = context.getSystemService(WindowManager.class);
    }

    void initOnly() {
        this.show(true);
    }

    void show() {
        this.show(false);
    }

    private void show(boolean keepInvisible) {
        if (this.getDecorView() == null) {
            Slog.i("InputMethodService", "DecorView is not set for InkWindow. show() failed.");
            return;
        }
        this.getDecorView().setVisibility(keepInvisible ? 4 : 0);
        if (!this.mIsViewAdded) {
            this.mWindowManager.addView(this.getDecorView(), this.getAttributes());
            this.mIsViewAdded = true;
        }
    }

    void hide(boolean remove) {
        if (this.getDecorView() != null) {
            this.getDecorView().setVisibility(remove ? 8 : 4);
        }
    }

    void setToken(IBinder token) {
        WindowManager.LayoutParams lp = this.getAttributes();
        lp.token = token;
        this.setAttributes(lp);
    }

    @Override
    public void addContentView(View view2, ViewGroup.LayoutParams params) {
        if (this.mInkView == null) {
            this.mInkView = view2;
        } else if (this.mInkView != view2) {
            throw new IllegalStateException("Only one Child Inking view is permitted.");
        }
        super.addContentView(view2, params);
        this.initInkViewVisibilityListener();
    }

    @Override
    public void setContentView(View view2, ViewGroup.LayoutParams params) {
        this.mInkView = view2;
        super.setContentView(view2, params);
        this.initInkViewVisibilityListener();
    }

    @Override
    public void setContentView(View view2) {
        this.mInkView = view2;
        super.setContentView(view2);
        this.initInkViewVisibilityListener();
    }

    @Override
    public void clearContentView() {
        if (this.mGlobalLayoutListener != null && this.mInkView != null) {
            this.mInkView.getViewTreeObserver().removeOnGlobalLayoutListener(this.mGlobalLayoutListener);
        }
        this.mGlobalLayoutListener = null;
        this.mInkView = null;
        super.clearContentView();
    }

    void setInkViewVisibilityListener(InkVisibilityListener listener2) {
        this.mInkViewVisibilityListener = listener2;
        this.initInkViewVisibilityListener();
    }

    void initInkViewVisibilityListener() {
        if (this.mInkView == null || this.mInkViewVisibilityListener == null || this.mGlobalLayoutListener != null) {
            return;
        }
        this.mGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            @Override
            public void onGlobalLayout() {
                if (InkWindow.this.mInkView.isVisibleToUser()) {
                    if (InkWindow.this.mInkViewVisibilityListener != null) {
                        InkWindow.this.mInkViewVisibilityListener.onInkViewVisible();
                    }
                    InkWindow.this.mInkView.getViewTreeObserver().removeOnGlobalLayoutListener(this);
                    InkWindow.this.mGlobalLayoutListener = null;
                }
            }
        };
        this.mInkView.getViewTreeObserver().addOnGlobalLayoutListener(this.mGlobalLayoutListener);
    }

    boolean isInkViewVisible() {
        return this.getDecorView().getVisibility() == 0 && this.mInkView != null && this.mInkView.isVisibleToUser();
    }

    static interface InkVisibilityListener {
        public void onInkViewVisible();
    }
}

