/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.app.Dialog;
import android.graphics.Rect;
import android.inputmethodservice.InputMethodService;
import android.os.IBinder;
import android.util.Log;
import android.util.proto.ProtoOutputStream;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.WindowManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

class SoftInputWindow
extends Dialog {
    private static final boolean DEBUG = false;
    private static final String TAG = "SoftInputWindow";
    private final KeyEvent.DispatcherState mDispatcherState;
    private final Rect mBounds = new Rect();
    private final InputMethodService mService;
    private int mWindowState = 0;

    void setToken(IBinder token) {
        switch (this.mWindowState) {
            case 0: {
                WindowManager.LayoutParams lp = this.getWindow().getAttributes();
                lp.token = token;
                this.getWindow().setAttributes(lp);
                this.updateWindowState(1);
                this.getWindow().getDecorView().setVisibility(4);
                this.show();
                return;
            }
            case 1: 
            case 2: 
            case 3: {
                throw new IllegalStateException("setToken can be called only once");
            }
            case 4: {
                Log.i(TAG, "Ignoring setToken() because window is already destroyed.");
                return;
            }
        }
        throw new IllegalStateException("Unexpected state=" + this.mWindowState);
    }

    SoftInputWindow(InputMethodService service, int theme, KeyEvent.DispatcherState dispatcherState) {
        super(service, theme);
        this.mService = service;
        this.mDispatcherState = dispatcherState;
    }

    @Override
    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        this.mDispatcherState.reset();
    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.getWindow().getDecorView().getHitRect(this.mBounds);
        if (ev.isWithinBoundsNoHistory(this.mBounds.left, this.mBounds.top, this.mBounds.right - 1, this.mBounds.bottom - 1)) {
            return super.dispatchTouchEvent(ev);
        }
        MotionEvent temp = ev.clampNoHistory(this.mBounds.left, this.mBounds.top, this.mBounds.right - 1, this.mBounds.bottom - 1);
        boolean handled = super.dispatchTouchEvent(temp);
        temp.recycle();
        return handled;
    }

    @Override
    public void show() {
        switch (this.mWindowState) {
            case 0: {
                throw new IllegalStateException("Window token is not set yet.");
            }
            case 1: 
            case 2: {
                try {
                    super.show();
                    this.updateWindowState(2);
                }
                catch (WindowManager.BadTokenException e) {
                    Log.i(TAG, "Probably the IME window token is already invalidated. show() does nothing.");
                    this.updateWindowState(3);
                }
                return;
            }
            case 3: {
                Log.i(TAG, "Not trying to call show() because it was already rejected once.");
                return;
            }
            case 4: {
                Log.i(TAG, "Ignoring show() because the window is already destroyed.");
                return;
            }
        }
        throw new IllegalStateException("Unexpected state=" + this.mWindowState);
    }

    void dismissForDestroyIfNecessary() {
        switch (this.mWindowState) {
            case 0: 
            case 1: {
                this.updateWindowState(4);
                return;
            }
            case 2: {
                try {
                    this.getWindow().setWindowAnimations(0);
                    this.dismiss();
                }
                catch (WindowManager.BadTokenException e) {
                    Log.i(TAG, "Probably the IME window token is already invalidated. No need to dismiss it.");
                }
                this.updateWindowState(4);
                return;
            }
            case 3: {
                Log.i(TAG, "Not trying to dismiss the window because it is most likely unnecessary.");
                this.updateWindowState(4);
                return;
            }
            case 4: {
                throw new IllegalStateException("dismissForDestroyIfNecessary can be called only once");
            }
        }
        throw new IllegalStateException("Unexpected state=" + this.mWindowState);
    }

    private void updateWindowState(int newState) {
        this.mWindowState = newState;
    }

    private static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "TOKEN_PENDING";
            }
            case 1: {
                return "TOKEN_SET";
            }
            case 2: {
                return "SHOWN_AT_LEAST_ONCE";
            }
            case 3: {
                return "REJECTED_AT_LEAST_ONCE";
            }
            case 4: {
                return "DESTROYED";
            }
        }
        throw new IllegalStateException("Unknown state=" + state);
    }

    void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        this.mBounds.dumpDebug(proto, 1146756268037L);
        proto.write(1120986464262L, this.mWindowState);
        proto.end(token);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface WindowState {
        public static final int TOKEN_PENDING = 0;
        public static final int TOKEN_SET = 1;
        public static final int SHOWN_AT_LEAST_ONCE = 2;
        public static final int REJECTED_AT_LEAST_ONCE = 3;
        public static final int DESTROYED = 4;
    }
}

