/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice.navigationbar;

import android.animation.ObjectAnimator;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.inputmethodservice.navigationbar.NavigationBarUtils;
import android.inputmethodservice.navigationbar.NavigationBarView;
import android.os.SystemClock;
import android.util.FloatProperty;
import android.util.Log;
import android.view.MotionEvent;

class DeadZone {
    public static final String TAG = "DeadZone";
    public static final boolean DEBUG = false;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final boolean CHATTY = true;
    private static final FloatProperty<DeadZone> FLASH_PROPERTY = new FloatProperty<DeadZone>("DeadZoneFlash"){

        @Override
        public void setValue(DeadZone object, float value2) {
            object.setFlash(value2);
        }

        @Override
        public Float get(DeadZone object) {
            return Float.valueOf(object.getFlash());
        }
    };
    private final NavigationBarView mNavigationBarView;
    private boolean mShouldFlash;
    private float mFlashFrac = 0.0f;
    private int mSizeMax;
    private int mSizeMin;
    private int mHold;
    private int mDecay;
    private boolean mVertical;
    private long mLastPokeTime;
    private int mDisplayRotation;
    private final Runnable mDebugFlash = new Runnable(){

        @Override
        public void run() {
            ObjectAnimator.ofFloat(DeadZone.this, FLASH_PROPERTY, 1.0f, 0.0f).setDuration(150L).start();
        }
    };

    DeadZone(NavigationBarView view2) {
        this.mNavigationBarView = view2;
        this.onConfigurationChanged(0);
    }

    static float lerp(float a, float b, float f) {
        return (b - a) * f + a;
    }

    private float getSize(long now) {
        if (this.mSizeMax == 0) {
            return 0.0f;
        }
        long dt = now - this.mLastPokeTime;
        if (dt > (long)(this.mHold + this.mDecay)) {
            return this.mSizeMin;
        }
        if (dt < (long)this.mHold) {
            return this.mSizeMax;
        }
        return (int)DeadZone.lerp(this.mSizeMax, this.mSizeMin, (float)(dt - (long)this.mHold) / (float)this.mDecay);
    }

    public void setFlashOnTouchCapture(boolean dbg) {
        this.mShouldFlash = dbg;
        this.mFlashFrac = 0.0f;
        this.mNavigationBarView.postInvalidate();
    }

    public void onConfigurationChanged(int rotation) {
        this.mDisplayRotation = rotation;
        Resources res = this.mNavigationBarView.getResources();
        this.mHold = 333;
        this.mDecay = 333;
        this.mSizeMin = NavigationBarUtils.dpToPx(12.0f, res);
        this.mSizeMax = NavigationBarUtils.dpToPx(32.0f, res);
        this.mVertical = res.getConfiguration().orientation == 2;
        this.setFlashOnTouchCapture(false);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getToolType(0) == 3) {
            return false;
        }
        int action2 = event.getAction();
        if (action2 == 4) {
            this.poke(event);
            return true;
        }
        if (action2 == 0) {
            boolean consumeEvent;
            int size = (int)this.getSize(event.getEventTime());
            if (this.mVertical) {
                consumeEvent = this.mDisplayRotation == 3 ? event.getX() > (float)(this.mNavigationBarView.getWidth() - size) : event.getX() < (float)size;
            } else {
                boolean bl = consumeEvent = event.getY() < (float)size;
            }
            if (consumeEvent) {
                Log.v(TAG, "consuming errant click: (" + event.getX() + "," + event.getY() + ")");
                if (this.mShouldFlash) {
                    this.mNavigationBarView.post(this.mDebugFlash);
                    this.mNavigationBarView.postInvalidate();
                }
                return true;
            }
        }
        return false;
    }

    private void poke(MotionEvent event) {
        this.mLastPokeTime = event.getEventTime();
        if (this.mShouldFlash) {
            this.mNavigationBarView.postInvalidate();
        }
    }

    public void setFlash(float f) {
        this.mFlashFrac = f;
        this.mNavigationBarView.postInvalidate();
    }

    public float getFlash() {
        return this.mFlashFrac;
    }

    public void onDraw(Canvas can) {
        if (!this.mShouldFlash || this.mFlashFrac <= 0.0f) {
            return;
        }
        int size = (int)this.getSize(SystemClock.uptimeMillis());
        if (this.mVertical) {
            if (this.mDisplayRotation == 3) {
                can.clipRect(can.getWidth() - size, 0, can.getWidth(), can.getHeight());
            } else {
                can.clipRect(0, 0, size, can.getHeight());
            }
        } else {
            can.clipRect(0, 0, can.getWidth(), size);
        }
        float frac = this.mFlashFrac;
        can.drawARGB((int)(frac * 255.0f), 221, 238, 170);
    }
}

