/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice.navigationbar;

import android.animation.ArgbEvaluator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.Drawable;
import android.inputmethodservice.navigationbar.NavigationBarUtils;
import android.util.FloatProperty;

class KeyButtonDrawable
extends Drawable {
    public static final FloatProperty<KeyButtonDrawable> KEY_DRAWABLE_ROTATE = new FloatProperty<KeyButtonDrawable>("KeyButtonRotation"){

        @Override
        public void setValue(KeyButtonDrawable drawable2, float degree) {
            drawable2.setRotation(degree);
        }

        @Override
        public Float get(KeyButtonDrawable drawable2) {
            return Float.valueOf(drawable2.getRotation());
        }
    };
    public static final FloatProperty<KeyButtonDrawable> KEY_DRAWABLE_TRANSLATE_Y = new FloatProperty<KeyButtonDrawable>("KeyButtonTranslateY"){

        @Override
        public void setValue(KeyButtonDrawable drawable2, float y) {
            drawable2.setTranslationY(y);
        }

        @Override
        public Float get(KeyButtonDrawable drawable2) {
            return Float.valueOf(drawable2.getTranslationY());
        }
    };
    private final Paint mIconPaint = new Paint(3);
    private final Paint mShadowPaint = new Paint(3);
    private final ShadowDrawableState mState;
    private AnimatedVectorDrawable mAnimatedDrawable;
    private final Drawable.Callback mAnimatedDrawableCallback = new Drawable.Callback(){

        @Override
        public void invalidateDrawable(Drawable who) {
            KeyButtonDrawable.this.invalidateSelf();
        }

        @Override
        public void scheduleDrawable(Drawable who, Runnable what, long when) {
            KeyButtonDrawable.this.scheduleSelf(what, when);
        }

        @Override
        public void unscheduleDrawable(Drawable who, Runnable what) {
            KeyButtonDrawable.this.unscheduleSelf(what);
        }
    };

    KeyButtonDrawable(Drawable d, int lightColor, int darkColor, boolean horizontalFlip, Color ovalBackgroundColor) {
        this(d, new ShadowDrawableState(lightColor, darkColor, d instanceof AnimatedVectorDrawable, horizontalFlip, ovalBackgroundColor));
    }

    private KeyButtonDrawable(Drawable d, ShadowDrawableState state) {
        this.mState = state;
        if (d != null) {
            this.mState.mBaseHeight = d.getIntrinsicHeight();
            this.mState.mBaseWidth = d.getIntrinsicWidth();
            this.mState.mChangingConfigurations = d.getChangingConfigurations();
            this.mState.mChildState = d.getConstantState();
        }
        if (this.canAnimate()) {
            this.mAnimatedDrawable = (AnimatedVectorDrawable)this.mState.mChildState.newDrawable().mutate();
            this.mAnimatedDrawable.setCallback(this.mAnimatedDrawableCallback);
            this.setDrawableBounds(this.mAnimatedDrawable);
        }
    }

    public void setDarkIntensity(float intensity) {
        this.mState.mDarkIntensity = intensity;
        int color2 = (Integer)ArgbEvaluator.getInstance().evaluate(intensity, (Object)this.mState.mLightColor, (Object)this.mState.mDarkColor);
        this.updateShadowAlpha();
        this.setColorFilter(new PorterDuffColorFilter(color2, PorterDuff.Mode.SRC_ATOP));
    }

    public void setRotation(float degrees) {
        if (this.canAnimate()) {
            return;
        }
        if (this.mState.mRotateDegrees != degrees) {
            this.mState.mRotateDegrees = degrees;
            this.invalidateSelf();
        }
    }

    public void setTranslationX(float x) {
        this.setTranslation(x, this.mState.mTranslationY);
    }

    public void setTranslationY(float y) {
        this.setTranslation(this.mState.mTranslationX, y);
    }

    public void setTranslation(float x, float y) {
        if (this.mState.mTranslationX != x || this.mState.mTranslationY != y) {
            this.mState.mTranslationX = x;
            this.mState.mTranslationY = y;
            this.invalidateSelf();
        }
    }

    public void setShadowProperties(int x, int y, int size, int color2) {
        if (this.canAnimate()) {
            return;
        }
        if (this.mState.mShadowOffsetX != x || this.mState.mShadowOffsetY != y || this.mState.mShadowSize != size || this.mState.mShadowColor != color2) {
            this.mState.mShadowOffsetX = x;
            this.mState.mShadowOffsetY = y;
            this.mState.mShadowSize = size;
            this.mState.mShadowColor = color2;
            this.mShadowPaint.setColorFilter(new PorterDuffColorFilter(this.mState.mShadowColor, PorterDuff.Mode.SRC_ATOP));
            this.updateShadowAlpha();
            this.invalidateSelf();
        }
    }

    @Override
    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed = super.setVisible(visible, restart);
        if (changed) {
            this.jumpToCurrentState();
        }
        return changed;
    }

    @Override
    public void jumpToCurrentState() {
        super.jumpToCurrentState();
        if (this.mAnimatedDrawable != null) {
            this.mAnimatedDrawable.jumpToCurrentState();
        }
    }

    @Override
    public void setAlpha(int alpha) {
        this.mState.mAlpha = alpha;
        this.mIconPaint.setAlpha(alpha);
        this.updateShadowAlpha();
        this.invalidateSelf();
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mIconPaint.setColorFilter(colorFilter);
        if (this.mAnimatedDrawable != null) {
            if (this.hasOvalBg()) {
                this.mAnimatedDrawable.setColorFilter(new PorterDuffColorFilter(this.mState.mLightColor, PorterDuff.Mode.SRC_IN));
            } else {
                this.mAnimatedDrawable.setColorFilter(colorFilter);
            }
        }
        this.invalidateSelf();
    }

    public float getDarkIntensity() {
        return this.mState.mDarkIntensity;
    }

    public float getRotation() {
        return this.mState.mRotateDegrees;
    }

    public float getTranslationX() {
        return this.mState.mTranslationX;
    }

    public float getTranslationY() {
        return this.mState.mTranslationY;
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        return this.mState;
    }

    @Override
    public int getOpacity() {
        return -3;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mState.mBaseHeight + (this.mState.mShadowSize + Math.abs(this.mState.mShadowOffsetY)) * 2;
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mState.mBaseWidth + (this.mState.mShadowSize + Math.abs(this.mState.mShadowOffsetX)) * 2;
    }

    public boolean canAnimate() {
        return this.mState.mSupportsAnimation;
    }

    public void startAnimation() {
        if (this.mAnimatedDrawable != null) {
            this.mAnimatedDrawable.start();
        }
    }

    public void resetAnimation() {
        if (this.mAnimatedDrawable != null) {
            this.mAnimatedDrawable.reset();
        }
    }

    public void clearAnimationCallbacks() {
        if (this.mAnimatedDrawable != null) {
            this.mAnimatedDrawable.clearAnimationCallbacks();
        }
    }

    @Override
    public void draw(Canvas canvas) {
        Rect bounds2 = this.getBounds();
        if (bounds2.isEmpty()) {
            return;
        }
        if (this.mAnimatedDrawable != null) {
            this.mAnimatedDrawable.draw(canvas);
        } else {
            boolean hwBitmapChanged;
            boolean bl = hwBitmapChanged = this.mState.mIsHardwareBitmap != canvas.isHardwareAccelerated();
            if (hwBitmapChanged) {
                this.mState.mIsHardwareBitmap = canvas.isHardwareAccelerated();
            }
            if (this.mState.mLastDrawnIcon == null || hwBitmapChanged) {
                this.regenerateBitmapIconCache();
            }
            canvas.save();
            canvas.translate(this.mState.mTranslationX, this.mState.mTranslationY);
            canvas.rotate(this.mState.mRotateDegrees, this.getIntrinsicWidth() / 2, this.getIntrinsicHeight() / 2);
            if (this.mState.mShadowSize > 0) {
                if (this.mState.mLastDrawnShadow == null || hwBitmapChanged) {
                    this.regenerateBitmapShadowCache();
                }
                float radians = (float)((double)this.mState.mRotateDegrees * Math.PI / 180.0);
                float shadowOffsetX = (float)(Math.sin(radians) * (double)this.mState.mShadowOffsetY + Math.cos(radians) * (double)this.mState.mShadowOffsetX) - this.mState.mTranslationX;
                float shadowOffsetY = (float)(Math.cos(radians) * (double)this.mState.mShadowOffsetY - Math.sin(radians) * (double)this.mState.mShadowOffsetX) - this.mState.mTranslationY;
                canvas.drawBitmap(this.mState.mLastDrawnShadow, shadowOffsetX, shadowOffsetY, this.mShadowPaint);
            }
            canvas.drawBitmap(this.mState.mLastDrawnIcon, null, bounds2, this.mIconPaint);
            canvas.restore();
        }
    }

    @Override
    public boolean canApplyTheme() {
        return this.mState.canApplyTheme();
    }

    int getDrawableBackgroundColor() {
        return this.mState.mOvalBackgroundColor.toArgb();
    }

    boolean hasOvalBg() {
        return this.mState.mOvalBackgroundColor != null;
    }

    private void regenerateBitmapIconCache() {
        int width2 = this.getIntrinsicWidth();
        int height2 = this.getIntrinsicHeight();
        Bitmap bitmap = Bitmap.createBitmap(width2, height2, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Drawable d = this.mState.mChildState.newDrawable().mutate();
        this.setDrawableBounds(d);
        canvas.save();
        if (this.mState.mHorizontalFlip) {
            canvas.scale(-1.0f, 1.0f, (float)width2 * 0.5f, (float)height2 * 0.5f);
        }
        d.draw(canvas);
        canvas.restore();
        if (this.mState.mIsHardwareBitmap) {
            bitmap = bitmap.copy(Bitmap.Config.HARDWARE, false);
        }
        this.mState.mLastDrawnIcon = bitmap;
    }

    private void regenerateBitmapShadowCache() {
        if (this.mState.mShadowSize == 0) {
            this.mState.mLastDrawnIcon = null;
            return;
        }
        int width2 = this.getIntrinsicWidth();
        int height2 = this.getIntrinsicHeight();
        Bitmap bitmap = Bitmap.createBitmap(width2, height2, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Drawable d = this.mState.mChildState.newDrawable().mutate();
        this.setDrawableBounds(d);
        canvas.save();
        if (this.mState.mHorizontalFlip) {
            canvas.scale(-1.0f, 1.0f, (float)width2 * 0.5f, (float)height2 * 0.5f);
        }
        d.draw(canvas);
        canvas.restore();
        Paint paint = new Paint(3);
        paint.setMaskFilter(new BlurMaskFilter(this.mState.mShadowSize, BlurMaskFilter.Blur.NORMAL));
        int[] offset2 = new int[2];
        Bitmap shadow = bitmap.extractAlpha(paint, offset2);
        paint.setMaskFilter(null);
        bitmap.eraseColor(0);
        canvas.drawBitmap(shadow, offset2[0], offset2[1], paint);
        if (this.mState.mIsHardwareBitmap) {
            bitmap = bitmap.copy(Bitmap.Config.HARDWARE, false);
        }
        this.mState.mLastDrawnShadow = bitmap;
    }

    private void updateShadowAlpha() {
        int alpha = Color.alpha(this.mState.mShadowColor);
        this.mShadowPaint.setAlpha(Math.round((float)alpha * ((float)this.mState.mAlpha / 255.0f) * (1.0f - this.mState.mDarkIntensity)));
    }

    private void setDrawableBounds(Drawable d) {
        int offsetX = this.mState.mShadowSize + Math.abs(this.mState.mShadowOffsetX);
        int offsetY = this.mState.mShadowSize + Math.abs(this.mState.mShadowOffsetY);
        d.setBounds(offsetX, offsetY, this.getIntrinsicWidth() - offsetX, this.getIntrinsicHeight() - offsetY);
    }

    public static KeyButtonDrawable create(Context context, int lightColor, int darkColor, int iconResId, boolean hasShadow, Color ovalBackgroundColor) {
        Resources res = context.getResources();
        boolean isRtl = res.getConfiguration().getLayoutDirection() == 1;
        Drawable d = context.getDrawable(iconResId);
        KeyButtonDrawable drawable2 = new KeyButtonDrawable(d, lightColor, darkColor, isRtl && d.isAutoMirrored(), ovalBackgroundColor);
        if (hasShadow) {
            int offsetX = NavigationBarUtils.dpToPx(0.0f, res);
            int offsetY = NavigationBarUtils.dpToPx(1.0f, res);
            int radius = NavigationBarUtils.dpToPx(0.5f, res);
            int color2 = 0x30000000;
            drawable2.setShadowProperties(offsetX, offsetY, radius, color2);
        }
        return drawable2;
    }

    private static class ShadowDrawableState
    extends Drawable.ConstantState {
        int mChangingConfigurations;
        int mBaseWidth;
        int mBaseHeight;
        float mRotateDegrees;
        float mTranslationX;
        float mTranslationY;
        int mShadowOffsetX;
        int mShadowOffsetY;
        int mShadowSize;
        int mShadowColor;
        float mDarkIntensity;
        int mAlpha;
        boolean mHorizontalFlip;
        boolean mIsHardwareBitmap;
        Bitmap mLastDrawnIcon;
        Bitmap mLastDrawnShadow;
        Drawable.ConstantState mChildState;
        final int mLightColor;
        final int mDarkColor;
        final boolean mSupportsAnimation;
        final Color mOvalBackgroundColor;

        ShadowDrawableState(int lightColor, int darkColor, boolean animated, boolean horizontalFlip, Color ovalBackgroundColor) {
            this.mLightColor = lightColor;
            this.mDarkColor = darkColor;
            this.mSupportsAnimation = animated;
            this.mAlpha = 255;
            this.mHorizontalFlip = horizontalFlip;
            this.mOvalBackgroundColor = ovalBackgroundColor;
        }

        @Override
        public Drawable newDrawable() {
            return new KeyButtonDrawable(null, this);
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public boolean canApplyTheme() {
            return true;
        }
    }
}

