/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice.navigationbar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.inputmethodservice.InputMethodService;
import android.inputmethodservice.navigationbar.ButtonInterface;
import android.inputmethodservice.navigationbar.KeyButtonDrawable;
import android.inputmethodservice.navigationbar.KeyButtonRipple;
import android.media.AudioManager;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.inputmethod.InputConnection;
import android.widget.ImageView;
import com.android.internal.annotations.VisibleForTesting;

public class KeyButtonView
extends ImageView
implements ButtonInterface {
    private static final String TAG = KeyButtonView.class.getSimpleName();
    private final boolean mPlaySounds;
    private long mDownTime;
    private boolean mTracking;
    private int mCode;
    private int mTouchDownX;
    private int mTouchDownY;
    private AudioManager mAudioManager;
    private boolean mGestureAborted;
    @VisibleForTesting
    boolean mLongClicked;
    private View.OnClickListener mOnClickListener;
    private final KeyButtonRipple mRipple;
    private final Paint mOvalBgPaint = new Paint(3);
    private float mDarkIntensity;
    private boolean mHasOvalBg = false;
    private final Runnable mCheckLongPress = new Runnable(){

        @Override
        public void run() {
            if (KeyButtonView.this.isPressed()) {
                if (KeyButtonView.this.isLongClickable()) {
                    KeyButtonView.this.performLongClick();
                    KeyButtonView.this.mLongClicked = true;
                } else {
                    if (KeyButtonView.this.mCode != 0) {
                        KeyButtonView.this.sendEvent(0, 128);
                        KeyButtonView.this.sendAccessibilityEvent(2);
                    }
                    KeyButtonView.this.mLongClicked = true;
                }
            }
        }
    };
    public static final float QUICKSTEP_TOUCH_SLOP_RATIO = 3.0f;

    public KeyButtonView(Context context, AttributeSet attrs) {
        super(context, attrs);
        switch (this.getId()) {
            case 16909121: {
                this.mCode = 4;
                break;
            }
            default: {
                this.mCode = 0;
            }
        }
        this.mPlaySounds = true;
        this.setClickable(true);
        this.mAudioManager = context.getSystemService(AudioManager.class);
        this.mRipple = new KeyButtonRipple(context, this, 17105258);
        this.setBackground(this.mRipple);
        this.setWillNotDraw(false);
        this.forceHasOverlappingRendering(false);
    }

    @Override
    public boolean isClickable() {
        return this.mCode != 0 || super.isClickable();
    }

    public void setCode(int code) {
        this.mCode = code;
    }

    @Override
    public void setOnClickListener(View.OnClickListener onClickListener) {
        super.setOnClickListener(onClickListener);
        this.mOnClickListener = onClickListener;
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        if (this.mCode != 0) {
            info.addAction(new AccessibilityNodeInfo.AccessibilityAction(16, null));
            if (this.isLongClickable()) {
                info.addAction(new AccessibilityNodeInfo.AccessibilityAction(32, null));
            }
        }
    }

    @Override
    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (visibility != 0) {
            this.jumpDrawablesToCurrentState();
        }
    }

    @Override
    public boolean performAccessibilityActionInternal(int action2, Bundle arguments) {
        if (action2 == 16 && this.mCode != 0) {
            this.sendEvent(0, 0, SystemClock.uptimeMillis());
            this.sendEvent(1, this.mTracking ? 512 : 0);
            this.mTracking = false;
            this.sendAccessibilityEvent(1);
            this.playSoundEffect(0);
            return true;
        }
        if (action2 == 32 && this.mCode != 0) {
            this.sendEvent(0, 128);
            this.sendEvent(1, this.mTracking ? 512 : 0);
            this.mTracking = false;
            this.sendAccessibilityEvent(2);
            return true;
        }
        return super.performAccessibilityActionInternal(action2, arguments);
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        boolean showSwipeUI = false;
        int action2 = ev.getAction();
        if (action2 == 0) {
            this.mGestureAborted = false;
        }
        if (this.mGestureAborted) {
            this.setPressed(false);
            return false;
        }
        switch (action2) {
            case 0: {
                this.mDownTime = SystemClock.uptimeMillis();
                this.mLongClicked = false;
                this.setPressed(true);
                this.mTouchDownX = (int)ev.getRawX();
                this.mTouchDownY = (int)ev.getRawY();
                if (this.mCode != 0) {
                    this.sendEvent(0, 0, this.mDownTime);
                } else {
                    this.performHapticFeedback(1);
                }
                this.playSoundEffect(0);
                this.removeCallbacks(this.mCheckLongPress);
                this.postDelayed(this.mCheckLongPress, ViewConfiguration.getLongPressTimeout());
                break;
            }
            case 2: {
                int x = (int)ev.getRawX();
                int y = (int)ev.getRawY();
                float slop = KeyButtonView.getQuickStepTouchSlopPx(this.getContext());
                if (!((float)Math.abs(x - this.mTouchDownX) > slop) && !((float)Math.abs(y - this.mTouchDownY) > slop)) break;
                this.setPressed(false);
                this.removeCallbacks(this.mCheckLongPress);
                break;
            }
            case 3: {
                this.setPressed(false);
                if (this.mCode != 0) {
                    this.sendEvent(1, 32);
                }
                this.removeCallbacks(this.mCheckLongPress);
                break;
            }
            case 1: {
                boolean doHapticFeedback;
                boolean doIt = this.isPressed() && !this.mLongClicked;
                this.setPressed(false);
                boolean bl = doHapticFeedback = SystemClock.uptimeMillis() - this.mDownTime > 150L;
                if (doHapticFeedback && !this.mLongClicked) {
                    this.performHapticFeedback(8);
                }
                if (this.mCode != 0) {
                    if (doIt) {
                        this.sendEvent(1, this.mTracking ? 512 : 0);
                        this.mTracking = false;
                        this.sendAccessibilityEvent(1);
                    } else {
                        this.sendEvent(1, 32);
                    }
                } else if (doIt && this.mOnClickListener != null) {
                    this.mOnClickListener.onClick(this);
                    this.sendAccessibilityEvent(1);
                }
                this.removeCallbacks(this.mCheckLongPress);
            }
        }
        return true;
    }

    @Override
    public void setImageDrawable(Drawable drawable2) {
        super.setImageDrawable(drawable2);
        if (drawable2 == null) {
            return;
        }
        KeyButtonDrawable keyButtonDrawable = (KeyButtonDrawable)drawable2;
        keyButtonDrawable.setDarkIntensity(this.mDarkIntensity);
        this.mHasOvalBg = keyButtonDrawable.hasOvalBg();
        if (this.mHasOvalBg) {
            this.mOvalBgPaint.setColor(keyButtonDrawable.getDrawableBackgroundColor());
        }
        this.mRipple.setType(keyButtonDrawable.hasOvalBg() ? KeyButtonRipple.Type.OVAL : KeyButtonRipple.Type.ROUNDED_RECT);
    }

    @Override
    public void playSoundEffect(int soundConstant) {
        if (!this.mPlaySounds) {
            return;
        }
        this.mAudioManager.playSoundEffect(soundConstant);
    }

    private void sendEvent(int action2, int flags) {
        this.sendEvent(action2, flags, SystemClock.uptimeMillis());
    }

    private void sendEvent(int action2, int flags, long when) {
        if (this.mCode != 4 || flags == 128 || action2 == 1) {
            // empty if block
        }
        if (this.mContext instanceof InputMethodService) {
            InputConnection ic;
            boolean handled;
            int repeatCount = (flags & 0x80) != 0 ? 1 : 0;
            KeyEvent ev = new KeyEvent(this.mDownTime, when, action2, this.mCode, repeatCount, 0, -1, 0, flags | 2 | 0x40, 257);
            int displayId = -1;
            if (this.getDisplay() != null) {
                displayId = this.getDisplay().getDisplayId();
            }
            if (displayId != -1) {
                ev.setDisplayId(displayId);
            }
            InputMethodService ims = (InputMethodService)this.mContext;
            switch (action2) {
                case 0: {
                    handled = ims.onKeyDown(ev.getKeyCode(), ev);
                    this.mTracking = handled && ev.getRepeatCount() == 0 && (ev.getFlags() & 0x40000000) != 0;
                    break;
                }
                case 1: {
                    handled = ims.onKeyUp(ev.getKeyCode(), ev);
                    break;
                }
                default: {
                    handled = false;
                }
            }
            if (!handled && (ic = ims.getCurrentInputConnection()) != null) {
                ic.sendKeyEvent(ev);
            }
        }
    }

    @Override
    public void setDarkIntensity(float darkIntensity) {
        this.mDarkIntensity = darkIntensity;
        Drawable drawable2 = this.getDrawable();
        if (drawable2 != null) {
            ((KeyButtonDrawable)drawable2).setDarkIntensity(darkIntensity);
            this.invalidate();
        }
        this.mRipple.setDarkIntensity(darkIntensity);
    }

    @Override
    public void setDelayTouchFeedback(boolean shouldDelay) {
        this.mRipple.setDelayTouchFeedback(shouldDelay);
    }

    @Override
    public void draw(Canvas canvas) {
        if (this.mHasOvalBg) {
            int d = Math.min(this.getWidth(), this.getHeight());
            canvas.drawOval(0.0f, 0.0f, d, d, this.mOvalBgPaint);
        }
        super.draw(canvas);
    }

    private static float getQuickStepTouchSlopPx(Context context) {
        return 3.0f * (float)ViewConfiguration.get(context).getScaledTouchSlop();
    }
}

