/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice.navigationbar;

import android.content.Context;
import android.content.res.Configuration;
import android.inputmethodservice.navigationbar.ButtonDispatcher;
import android.inputmethodservice.navigationbar.ReverseLinearLayout;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.Space;

public class NavigationBarInflaterView
extends FrameLayout {
    private static final String TAG = "NavBarInflater";
    public static final String NAV_BAR_VIEWS = "sysui_nav_bar";
    public static final String NAV_BAR_LEFT = "sysui_nav_bar_left";
    public static final String NAV_BAR_RIGHT = "sysui_nav_bar_right";
    public static final String MENU_IME_ROTATE = "menu_ime";
    public static final String BACK = "back";
    public static final String HOME = "home";
    public static final String RECENT = "recent";
    public static final String NAVSPACE = "space";
    public static final String CLIPBOARD = "clipboard";
    public static final String HOME_HANDLE = "home_handle";
    public static final String KEY = "key";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String CONTEXTUAL = "contextual";
    public static final String IME_SWITCHER = "ime_switcher";
    public static final String GRAVITY_SEPARATOR = ";";
    public static final String BUTTON_SEPARATOR = ",";
    public static final String SIZE_MOD_START = "[";
    public static final String SIZE_MOD_END = "]";
    public static final String KEY_CODE_START = "(";
    public static final String KEY_IMAGE_DELIM = ":";
    public static final String KEY_CODE_END = ")";
    private static final String WEIGHT_SUFFIX = "W";
    private static final String WEIGHT_CENTERED_SUFFIX = "WC";
    private static final String ABSOLUTE_SUFFIX = "A";
    private static final String ABSOLUTE_VERTICAL_CENTERED_SUFFIX = "C";
    private static final String CONFIG_NAV_BAR_LAYOUT_HANDLE = "back[70AC];home_handle;ime_switcher[70AC]";
    protected LayoutInflater mLayoutInflater;
    protected LayoutInflater mLandscapeInflater;
    protected FrameLayout mHorizontal;
    SparseArray<ButtonDispatcher> mButtonDispatchers;
    private View mLastPortrait;
    private View mLastLandscape;
    private boolean mAlternativeOrder;

    public NavigationBarInflaterView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createInflaters();
    }

    void createInflaters() {
        this.mLayoutInflater = LayoutInflater.from(this.mContext);
        Configuration landscape = new Configuration();
        landscape.setTo(this.mContext.getResources().getConfiguration());
        landscape.orientation = 2;
        this.mLandscapeInflater = LayoutInflater.from(this.mContext.createConfigurationContext(landscape));
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.inflateChildren();
        this.clearViews();
        this.inflateLayout(this.getDefaultLayout());
    }

    private void inflateChildren() {
        this.removeAllViews();
        this.mHorizontal = (FrameLayout)this.mLayoutInflater.inflate(17367186, (ViewGroup)this, false);
        this.addView(this.mHorizontal);
        this.updateAlternativeOrder();
    }

    String getDefaultLayout() {
        return CONFIG_NAV_BAR_LAYOUT_HANDLE;
    }

    void setButtonDispatchers(SparseArray<ButtonDispatcher> buttonDispatchers) {
        this.mButtonDispatchers = buttonDispatchers;
        for (int i = 0; i < buttonDispatchers.size(); ++i) {
            this.initiallyFill(buttonDispatchers.valueAt(i));
        }
    }

    void updateButtonDispatchersCurrentView() {
        if (this.mButtonDispatchers != null) {
            FrameLayout view2 = this.mHorizontal;
            for (int i = 0; i < this.mButtonDispatchers.size(); ++i) {
                ButtonDispatcher dispatcher = this.mButtonDispatchers.valueAt(i);
                dispatcher.setCurrentView(view2);
            }
        }
    }

    void setAlternativeOrder(boolean alternativeOrder) {
        if (alternativeOrder != this.mAlternativeOrder) {
            this.mAlternativeOrder = alternativeOrder;
            this.updateAlternativeOrder();
        }
    }

    private void updateAlternativeOrder() {
        this.updateAlternativeOrder((View)this.mHorizontal.findViewById(16909124));
        this.updateAlternativeOrder((View)this.mHorizontal.findViewById(16909123));
    }

    private void updateAlternativeOrder(View v) {
        if (v instanceof ReverseLinearLayout) {
            ((ReverseLinearLayout)v).setAlternativeOrder(this.mAlternativeOrder);
        }
    }

    private void initiallyFill(ButtonDispatcher buttonDispatcher) {
        this.addAll(buttonDispatcher, (ViewGroup)this.mHorizontal.findViewById(16909124));
        this.addAll(buttonDispatcher, (ViewGroup)this.mHorizontal.findViewById(16909123));
    }

    private void addAll(ButtonDispatcher buttonDispatcher, ViewGroup parent) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (parent.getChildAt(i).getId() == buttonDispatcher.getId()) {
                buttonDispatcher.addView(parent.getChildAt(i));
            }
            if (!(parent.getChildAt(i) instanceof ViewGroup)) continue;
            this.addAll(buttonDispatcher, (ViewGroup)parent.getChildAt(i));
        }
    }

    protected void inflateLayout(String newLayout) {
        String[] sets;
        if (newLayout == null) {
            newLayout = this.getDefaultLayout();
        }
        if ((sets = newLayout.split(GRAVITY_SEPARATOR, 3)).length != 3) {
            Log.d(TAG, "Invalid layout.");
            newLayout = this.getDefaultLayout();
            sets = newLayout.split(GRAVITY_SEPARATOR, 3);
        }
        String[] start = sets[0].split(BUTTON_SEPARATOR);
        String[] center = sets[1].split(BUTTON_SEPARATOR);
        String[] end = sets[2].split(BUTTON_SEPARATOR);
        this.inflateButtons(start, (ViewGroup)this.mHorizontal.findViewById(16909124), false, true);
        this.inflateButtons(center, (ViewGroup)this.mHorizontal.findViewById(16909123), false, false);
        this.addGravitySpacer((LinearLayout)this.mHorizontal.findViewById(16909124));
        this.inflateButtons(end, (ViewGroup)this.mHorizontal.findViewById(16909124), false, false);
        this.updateButtonDispatchersCurrentView();
    }

    private void addGravitySpacer(LinearLayout layout2) {
        layout2.addView((View)new Space(this.mContext), new LinearLayout.LayoutParams(0, 0, 1.0f));
    }

    private void inflateButtons(String[] buttons, ViewGroup parent, boolean landscape, boolean start) {
        for (int i = 0; i < buttons.length; ++i) {
            this.inflateButton(buttons[i], parent, landscape, start);
        }
    }

    private ViewGroup.LayoutParams copy(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof LinearLayout.LayoutParams) {
            return new LinearLayout.LayoutParams(layoutParams.width, layoutParams.height, ((LinearLayout.LayoutParams)layoutParams).weight);
        }
        return new FrameLayout.LayoutParams(layoutParams.width, layoutParams.height);
    }

    protected View inflateButton(String buttonSpec, ViewGroup parent, boolean landscape, boolean start) {
        LayoutInflater inflater = landscape ? this.mLandscapeInflater : this.mLayoutInflater;
        View v = this.createView(buttonSpec, parent, inflater);
        if (v == null) {
            return null;
        }
        v = this.applySize(v, buttonSpec, landscape, start);
        parent.addView(v);
        this.addToDispatchers(v);
        View lastView = landscape ? this.mLastLandscape : this.mLastPortrait;
        View accessibilityView = v;
        if (v instanceof ReverseLinearLayout.ReverseRelativeLayout) {
            accessibilityView = ((ReverseLinearLayout.ReverseRelativeLayout)v).getChildAt(0);
        }
        if (lastView != null) {
            accessibilityView.setAccessibilityTraversalAfter(lastView.getId());
        }
        if (landscape) {
            this.mLastLandscape = accessibilityView;
        } else {
            this.mLastPortrait = accessibilityView;
        }
        return v;
    }

    private View applySize(View v, String buttonSpec, boolean landscape, boolean start) {
        String sizeStr = NavigationBarInflaterView.extractSize(buttonSpec);
        if (sizeStr == null) {
            return v;
        }
        if (sizeStr.contains(WEIGHT_SUFFIX) || sizeStr.contains(ABSOLUTE_SUFFIX)) {
            int gravity;
            ReverseLinearLayout.ReverseRelativeLayout frame = new ReverseLinearLayout.ReverseRelativeLayout(this.mContext);
            FrameLayout.LayoutParams childParams = new FrameLayout.LayoutParams(v.getLayoutParams());
            int n = landscape ? (start ? 48 : 80) : (gravity = start ? 0x800003 : 0x800005);
            if (sizeStr.endsWith(WEIGHT_CENTERED_SUFFIX)) {
                gravity = 17;
            } else if (sizeStr.endsWith(ABSOLUTE_VERTICAL_CENTERED_SUFFIX)) {
                gravity = 16;
            }
            frame.setDefaultGravity(gravity);
            frame.setGravity(gravity);
            frame.addView(v, childParams);
            if (sizeStr.contains(WEIGHT_SUFFIX)) {
                float weight = Float.parseFloat(sizeStr.substring(0, sizeStr.indexOf(WEIGHT_SUFFIX)));
                frame.setLayoutParams(new LinearLayout.LayoutParams(0, -1, weight));
            } else {
                int width2 = (int)NavigationBarInflaterView.convertDpToPx(this.mContext, Float.parseFloat(sizeStr.substring(0, sizeStr.indexOf(ABSOLUTE_SUFFIX))));
                frame.setLayoutParams(new LinearLayout.LayoutParams(width2, -1));
            }
            frame.setClipChildren(false);
            frame.setClipToPadding(false);
            return frame;
        }
        float size = Float.parseFloat(sizeStr);
        ViewGroup.LayoutParams params = v.getLayoutParams();
        params.width = (int)((float)params.width * size);
        return v;
    }

    View createView(String buttonSpec, ViewGroup parent, LayoutInflater inflater) {
        View v = null;
        String button = NavigationBarInflaterView.extractButton(buttonSpec);
        if (LEFT.equals(button)) {
            button = NavigationBarInflaterView.extractButton(NAVSPACE);
        } else if (RIGHT.equals(button)) {
            button = NavigationBarInflaterView.extractButton(MENU_IME_ROTATE);
        }
        if (!HOME.equals(button)) {
            if (BACK.equals(button)) {
                v = inflater.inflate(17367182, parent, false);
            } else if (!(RECENT.equals(button) || MENU_IME_ROTATE.equals(button) || NAVSPACE.equals(button) || CLIPBOARD.equals(button) || CONTEXTUAL.equals(button))) {
                if (HOME_HANDLE.equals(button)) {
                    v = inflater.inflate(17367183, parent, false);
                } else if (IME_SWITCHER.equals(button)) {
                    v = inflater.inflate(0x1090090, parent, false);
                } else if (button.startsWith(KEY)) {
                    // empty if block
                }
            }
        }
        return v;
    }

    private static String extractSize(String buttonSpec) {
        if (!buttonSpec.contains(SIZE_MOD_START)) {
            return null;
        }
        int sizeStart = buttonSpec.indexOf(SIZE_MOD_START);
        return buttonSpec.substring(sizeStart + 1, buttonSpec.indexOf(SIZE_MOD_END));
    }

    private static String extractButton(String buttonSpec) {
        if (!buttonSpec.contains(SIZE_MOD_START)) {
            return buttonSpec;
        }
        return buttonSpec.substring(0, buttonSpec.indexOf(SIZE_MOD_START));
    }

    private void addToDispatchers(View v) {
        if (this.mButtonDispatchers != null) {
            int indexOfKey = this.mButtonDispatchers.indexOfKey(v.getId());
            if (indexOfKey >= 0) {
                this.mButtonDispatchers.valueAt(indexOfKey).addView(v);
            }
            if (v instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)v;
                int numChildViews = viewGroup.getChildCount();
                for (int i = 0; i < numChildViews; ++i) {
                    this.addToDispatchers(viewGroup.getChildAt(i));
                }
            }
        }
    }

    private void clearViews() {
        if (this.mButtonDispatchers != null) {
            for (int i = 0; i < this.mButtonDispatchers.size(); ++i) {
                this.mButtonDispatchers.valueAt(i).clear();
            }
        }
        this.clearAllChildren((ViewGroup)this.mHorizontal.findViewById(16909122));
    }

    private void clearAllChildren(ViewGroup group) {
        for (int i = 0; i < group.getChildCount(); ++i) {
            ((ViewGroup)group.getChildAt(i)).removeAllViews();
        }
    }

    private static float convertDpToPx(Context context, float dp) {
        return dp * context.getResources().getDisplayMetrics().density;
    }
}

