/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
public class CorrelationVector
implements Parcelable {
    private final double mSamplingWidthMeters;
    private final double mSamplingStartMeters;
    private final double mFrequencyOffsetMetersPerSecond;
    private final int[] mMagnitude;
    public static final Parcelable.Creator<CorrelationVector> CREATOR = new Parcelable.Creator<CorrelationVector>(){

        @Override
        public CorrelationVector createFromParcel(Parcel parcel) {
            return new CorrelationVector(parcel);
        }

        public CorrelationVector[] newArray(int size) {
            return new CorrelationVector[size];
        }
    };

    public double getSamplingWidthMeters() {
        return this.mSamplingWidthMeters;
    }

    public double getSamplingStartMeters() {
        return this.mSamplingStartMeters;
    }

    public double getFrequencyOffsetMetersPerSecond() {
        return this.mFrequencyOffsetMetersPerSecond;
    }

    public int[] getMagnitude() {
        return (int[])this.mMagnitude.clone();
    }

    private CorrelationVector(Builder builder2) {
        Preconditions.checkNotNull(builder2.mMagnitude, "Magnitude array must not be null");
        Preconditions.checkArgumentPositive(builder2.mMagnitude.length, "Magnitude array must have non-zero length");
        Preconditions.checkArgument(builder2.mFrequencyOffsetMetersPerSecond >= 0.0, "FrequencyOffsetMetersPerSecond must be non-negative (greater than or equal to 0)");
        Preconditions.checkArgument(builder2.mSamplingWidthMeters > 0.0, "SamplingWidthMeters must be positive (greater than 0)");
        this.mMagnitude = builder2.mMagnitude;
        this.mFrequencyOffsetMetersPerSecond = builder2.mFrequencyOffsetMetersPerSecond;
        this.mSamplingWidthMeters = builder2.mSamplingWidthMeters;
        this.mSamplingStartMeters = builder2.mSamplingStartMeters;
    }

    private CorrelationVector(Parcel in) {
        this.mSamplingWidthMeters = in.readDouble();
        this.mSamplingStartMeters = in.readDouble();
        this.mFrequencyOffsetMetersPerSecond = in.readDouble();
        this.mMagnitude = new int[in.readInt()];
        in.readIntArray(this.mMagnitude);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "CorrelationVector{FrequencyOffsetMetersPerSecond=" + this.mFrequencyOffsetMetersPerSecond + ", SamplingWidthMeters=" + this.mSamplingWidthMeters + ", SamplingStartMeters=" + this.mSamplingStartMeters + ", Magnitude=" + Arrays.toString(this.mMagnitude) + '}';
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(this.mSamplingWidthMeters);
        dest.writeDouble(this.mSamplingStartMeters);
        dest.writeDouble(this.mFrequencyOffsetMetersPerSecond);
        dest.writeInt(this.mMagnitude.length);
        dest.writeIntArray(this.mMagnitude);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CorrelationVector)) {
            return false;
        }
        CorrelationVector c = (CorrelationVector)object;
        return Arrays.equals(this.mMagnitude, c.getMagnitude()) && Double.compare(this.mSamplingWidthMeters, c.getSamplingWidthMeters()) == 0 && Double.compare(this.mSamplingStartMeters, c.getSamplingStartMeters()) == 0 && Double.compare(this.mFrequencyOffsetMetersPerSecond, c.getFrequencyOffsetMetersPerSecond()) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.mSamplingWidthMeters, this.mSamplingStartMeters, this.mFrequencyOffsetMetersPerSecond, Arrays.hashCode(this.mMagnitude));
    }

    public static class Builder {
        private double mSamplingWidthMeters;
        private double mSamplingStartMeters;
        private double mFrequencyOffsetMetersPerSecond;
        private int[] mMagnitude;

        public Builder setSamplingWidthMeters(double samplingWidthMeters) {
            this.mSamplingWidthMeters = samplingWidthMeters;
            return this;
        }

        public Builder setSamplingStartMeters(double samplingStartMeters) {
            this.mSamplingStartMeters = samplingStartMeters;
            return this;
        }

        public Builder setFrequencyOffsetMetersPerSecond(double frequencyOffsetMetersPerSecond) {
            this.mFrequencyOffsetMetersPerSecond = frequencyOffsetMetersPerSecond;
            return this;
        }

        public Builder setMagnitude(int[] magnitude) {
            this.mMagnitude = magnitude;
            return this;
        }

        public CorrelationVector build() {
            return new CorrelationVector(this);
        }
    }
}

