/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.location.CorrelationVector;
import android.location.SatellitePvt;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GnssMeasurement
implements Parcelable {
    private int mFlags;
    private int mSvid;
    private int mConstellationType;
    private double mTimeOffsetNanos;
    private int mState;
    private long mReceivedSvTimeNanos;
    private long mReceivedSvTimeUncertaintyNanos;
    private double mCn0DbHz;
    private double mBasebandCn0DbHz;
    private double mPseudorangeRateMetersPerSecond;
    private double mPseudorangeRateUncertaintyMetersPerSecond;
    private int mAccumulatedDeltaRangeState;
    private double mAccumulatedDeltaRangeMeters;
    private double mAccumulatedDeltaRangeUncertaintyMeters;
    private float mCarrierFrequencyHz;
    private long mCarrierCycles;
    private double mCarrierPhase;
    private double mCarrierPhaseUncertainty;
    private int mMultipathIndicator;
    private double mSnrInDb;
    private double mAutomaticGainControlLevelInDb;
    private String mCodeType;
    private double mFullInterSignalBiasNanos;
    private double mFullInterSignalBiasUncertaintyNanos;
    private double mSatelliteInterSignalBiasNanos;
    private double mSatelliteInterSignalBiasUncertaintyNanos;
    private SatellitePvt mSatellitePvt;
    private Collection<CorrelationVector> mReadOnlyCorrelationVectors;
    private static final int HAS_NO_FLAGS = 0;
    private static final int HAS_CODE_TYPE = 16384;
    private static final int HAS_BASEBAND_CN0 = 32768;
    private static final int HAS_SATELLITE_PVT = 0x100000;
    private static final int HAS_CORRELATION_VECTOR = 0x200000;
    public static final int MULTIPATH_INDICATOR_UNKNOWN = 0;
    public static final int MULTIPATH_INDICATOR_DETECTED = 1;
    public static final int MULTIPATH_INDICATOR_NOT_DETECTED = 2;
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_CODE_LOCK = 1;
    public static final int STATE_BIT_SYNC = 2;
    public static final int STATE_SUBFRAME_SYNC = 4;
    public static final int STATE_TOW_DECODED = 8;
    public static final int STATE_MSEC_AMBIGUOUS = 16;
    public static final int STATE_SYMBOL_SYNC = 32;
    public static final int STATE_GLO_STRING_SYNC = 64;
    public static final int STATE_GLO_TOD_DECODED = 128;
    public static final int STATE_BDS_D2_BIT_SYNC = 256;
    public static final int STATE_BDS_D2_SUBFRAME_SYNC = 512;
    public static final int STATE_GAL_E1BC_CODE_LOCK = 1024;
    public static final int STATE_GAL_E1C_2ND_CODE_LOCK = 2048;
    public static final int STATE_GAL_E1B_PAGE_SYNC = 4096;
    public static final int STATE_SBAS_SYNC = 8192;
    public static final int STATE_TOW_KNOWN = 16384;
    public static final int STATE_GLO_TOD_KNOWN = 32768;
    public static final int STATE_2ND_CODE_LOCK = 65536;
    private static final int STATE_ALL = 16383;
    public static final int ADR_STATE_UNKNOWN = 0;
    public static final int ADR_STATE_VALID = 1;
    public static final int ADR_STATE_RESET = 2;
    public static final int ADR_STATE_CYCLE_SLIP = 4;
    public static final int ADR_STATE_HALF_CYCLE_RESOLVED = 8;
    public static final int ADR_STATE_HALF_CYCLE_REPORTED = 16;
    public static final int ADR_STATE_ALL = 31;
    public static final Parcelable.Creator<GnssMeasurement> CREATOR = new Parcelable.Creator<GnssMeasurement>(){

        @Override
        public GnssMeasurement createFromParcel(Parcel parcel) {
            GnssMeasurement gnssMeasurement = new GnssMeasurement();
            gnssMeasurement.mFlags = parcel.readInt();
            gnssMeasurement.mSvid = parcel.readInt();
            gnssMeasurement.mConstellationType = parcel.readInt();
            gnssMeasurement.mTimeOffsetNanos = parcel.readDouble();
            gnssMeasurement.mState = parcel.readInt();
            gnssMeasurement.mReceivedSvTimeNanos = parcel.readLong();
            gnssMeasurement.mReceivedSvTimeUncertaintyNanos = parcel.readLong();
            gnssMeasurement.mCn0DbHz = parcel.readDouble();
            gnssMeasurement.mPseudorangeRateMetersPerSecond = parcel.readDouble();
            gnssMeasurement.mPseudorangeRateUncertaintyMetersPerSecond = parcel.readDouble();
            gnssMeasurement.mAccumulatedDeltaRangeState = parcel.readInt();
            gnssMeasurement.mAccumulatedDeltaRangeMeters = parcel.readDouble();
            gnssMeasurement.mAccumulatedDeltaRangeUncertaintyMeters = parcel.readDouble();
            gnssMeasurement.mCarrierFrequencyHz = parcel.readFloat();
            gnssMeasurement.mCarrierCycles = parcel.readLong();
            gnssMeasurement.mCarrierPhase = parcel.readDouble();
            gnssMeasurement.mCarrierPhaseUncertainty = parcel.readDouble();
            gnssMeasurement.mMultipathIndicator = parcel.readInt();
            gnssMeasurement.mSnrInDb = parcel.readDouble();
            gnssMeasurement.mAutomaticGainControlLevelInDb = parcel.readDouble();
            gnssMeasurement.mCodeType = parcel.readString();
            gnssMeasurement.mBasebandCn0DbHz = parcel.readDouble();
            gnssMeasurement.mFullInterSignalBiasNanos = parcel.readDouble();
            gnssMeasurement.mFullInterSignalBiasUncertaintyNanos = parcel.readDouble();
            gnssMeasurement.mSatelliteInterSignalBiasNanos = parcel.readDouble();
            gnssMeasurement.mSatelliteInterSignalBiasUncertaintyNanos = parcel.readDouble();
            if (gnssMeasurement.hasSatellitePvt()) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                gnssMeasurement.mSatellitePvt = parcel.readParcelable(classLoader, SatellitePvt.class);
            }
            if (gnssMeasurement.hasCorrelationVectors()) {
                CorrelationVector[] correlationVectorsArray = new CorrelationVector[parcel.readInt()];
                parcel.readTypedArray(correlationVectorsArray, CorrelationVector.CREATOR);
                List<CorrelationVector> corrVecCollection = Arrays.asList(correlationVectorsArray);
                gnssMeasurement.mReadOnlyCorrelationVectors = Collections.unmodifiableCollection(corrVecCollection);
            }
            return gnssMeasurement;
        }

        public GnssMeasurement[] newArray(int i) {
            return new GnssMeasurement[i];
        }
    };

    public GnssMeasurement() {
        this.initialize();
    }

    public void set(GnssMeasurement measurement) {
        this.mFlags = measurement.mFlags;
        this.mSvid = measurement.mSvid;
        this.mConstellationType = measurement.mConstellationType;
        this.mTimeOffsetNanos = measurement.mTimeOffsetNanos;
        this.mState = measurement.mState;
        this.mReceivedSvTimeNanos = measurement.mReceivedSvTimeNanos;
        this.mReceivedSvTimeUncertaintyNanos = measurement.mReceivedSvTimeUncertaintyNanos;
        this.mCn0DbHz = measurement.mCn0DbHz;
        this.mBasebandCn0DbHz = measurement.mBasebandCn0DbHz;
        this.mPseudorangeRateMetersPerSecond = measurement.mPseudorangeRateMetersPerSecond;
        this.mPseudorangeRateUncertaintyMetersPerSecond = measurement.mPseudorangeRateUncertaintyMetersPerSecond;
        this.mAccumulatedDeltaRangeState = measurement.mAccumulatedDeltaRangeState;
        this.mAccumulatedDeltaRangeMeters = measurement.mAccumulatedDeltaRangeMeters;
        this.mAccumulatedDeltaRangeUncertaintyMeters = measurement.mAccumulatedDeltaRangeUncertaintyMeters;
        this.mCarrierFrequencyHz = measurement.mCarrierFrequencyHz;
        this.mCarrierCycles = measurement.mCarrierCycles;
        this.mCarrierPhase = measurement.mCarrierPhase;
        this.mCarrierPhaseUncertainty = measurement.mCarrierPhaseUncertainty;
        this.mMultipathIndicator = measurement.mMultipathIndicator;
        this.mSnrInDb = measurement.mSnrInDb;
        this.mAutomaticGainControlLevelInDb = measurement.mAutomaticGainControlLevelInDb;
        this.mCodeType = measurement.mCodeType;
        this.mFullInterSignalBiasNanos = measurement.mFullInterSignalBiasNanos;
        this.mFullInterSignalBiasUncertaintyNanos = measurement.mFullInterSignalBiasUncertaintyNanos;
        this.mSatelliteInterSignalBiasNanos = measurement.mSatelliteInterSignalBiasNanos;
        this.mSatelliteInterSignalBiasUncertaintyNanos = measurement.mSatelliteInterSignalBiasUncertaintyNanos;
        this.mSatellitePvt = measurement.mSatellitePvt;
        this.mReadOnlyCorrelationVectors = measurement.mReadOnlyCorrelationVectors;
    }

    public void reset() {
        this.initialize();
    }

    public int getSvid() {
        return this.mSvid;
    }

    public void setSvid(int value2) {
        this.mSvid = value2;
    }

    public int getConstellationType() {
        return this.mConstellationType;
    }

    public void setConstellationType(int value2) {
        this.mConstellationType = value2;
    }

    public double getTimeOffsetNanos() {
        return this.mTimeOffsetNanos;
    }

    public void setTimeOffsetNanos(double value2) {
        this.mTimeOffsetNanos = value2;
    }

    public int getState() {
        return this.mState;
    }

    public void setState(int value2) {
        this.mState = value2;
    }

    private String getStateString() {
        int remainingStates;
        if (this.mState == 0) {
            return "Unknown";
        }
        StringBuilder builder2 = new StringBuilder();
        if ((this.mState & 1) != 0) {
            builder2.append("CodeLock|");
        }
        if ((this.mState & 2) != 0) {
            builder2.append("BitSync|");
        }
        if ((this.mState & 4) != 0) {
            builder2.append("SubframeSync|");
        }
        if ((this.mState & 8) != 0) {
            builder2.append("TowDecoded|");
        }
        if ((this.mState & 0x4000) != 0) {
            builder2.append("TowKnown|");
        }
        if ((this.mState & 0x10) != 0) {
            builder2.append("MsecAmbiguous|");
        }
        if ((this.mState & 0x20) != 0) {
            builder2.append("SymbolSync|");
        }
        if ((this.mState & 0x40) != 0) {
            builder2.append("GloStringSync|");
        }
        if ((this.mState & 0x80) != 0) {
            builder2.append("GloTodDecoded|");
        }
        if ((this.mState & 0x8000) != 0) {
            builder2.append("GloTodKnown|");
        }
        if ((this.mState & 0x100) != 0) {
            builder2.append("BdsD2BitSync|");
        }
        if ((this.mState & 0x200) != 0) {
            builder2.append("BdsD2SubframeSync|");
        }
        if ((this.mState & 0x400) != 0) {
            builder2.append("GalE1bcCodeLock|");
        }
        if ((this.mState & 0x800) != 0) {
            builder2.append("E1c2ndCodeLock|");
        }
        if ((this.mState & 0x1000) != 0) {
            builder2.append("GalE1bPageSync|");
        }
        if ((this.mState & 0x2000) != 0) {
            builder2.append("SbasSync|");
        }
        if ((this.mState & 0x10000) != 0) {
            builder2.append("2ndCodeLock|");
        }
        if ((remainingStates = this.mState & 0xFFFFC000) > 0) {
            builder2.append("Other(");
            builder2.append(Integer.toBinaryString(remainingStates));
            builder2.append(")|");
        }
        builder2.setLength(builder2.length() - 1);
        return builder2.toString();
    }

    public long getReceivedSvTimeNanos() {
        return this.mReceivedSvTimeNanos;
    }

    public void setReceivedSvTimeNanos(long value2) {
        this.mReceivedSvTimeNanos = value2;
    }

    public long getReceivedSvTimeUncertaintyNanos() {
        return this.mReceivedSvTimeUncertaintyNanos;
    }

    public void setReceivedSvTimeUncertaintyNanos(long value2) {
        this.mReceivedSvTimeUncertaintyNanos = value2;
    }

    public double getCn0DbHz() {
        return this.mCn0DbHz;
    }

    public void setCn0DbHz(double value2) {
        this.mCn0DbHz = value2;
    }

    public boolean hasBasebandCn0DbHz() {
        return this.isFlagSet(32768);
    }

    public double getBasebandCn0DbHz() {
        return this.mBasebandCn0DbHz;
    }

    public void setBasebandCn0DbHz(double value2) {
        this.setFlag(32768);
        this.mBasebandCn0DbHz = value2;
    }

    public void resetBasebandCn0DbHz() {
        this.resetFlag(32768);
    }

    public double getPseudorangeRateMetersPerSecond() {
        return this.mPseudorangeRateMetersPerSecond;
    }

    public void setPseudorangeRateMetersPerSecond(double value2) {
        this.mPseudorangeRateMetersPerSecond = value2;
    }

    public double getPseudorangeRateUncertaintyMetersPerSecond() {
        return this.mPseudorangeRateUncertaintyMetersPerSecond;
    }

    public void setPseudorangeRateUncertaintyMetersPerSecond(double value2) {
        this.mPseudorangeRateUncertaintyMetersPerSecond = value2;
    }

    public int getAccumulatedDeltaRangeState() {
        return this.mAccumulatedDeltaRangeState;
    }

    public void setAccumulatedDeltaRangeState(int value2) {
        this.mAccumulatedDeltaRangeState = value2;
    }

    private String getAccumulatedDeltaRangeStateString() {
        int remainingStates;
        if (this.mAccumulatedDeltaRangeState == 0) {
            return "Unknown";
        }
        StringBuilder builder2 = new StringBuilder();
        if ((this.mAccumulatedDeltaRangeState & 1) == 1) {
            builder2.append("Valid|");
        }
        if ((this.mAccumulatedDeltaRangeState & 2) == 2) {
            builder2.append("Reset|");
        }
        if ((this.mAccumulatedDeltaRangeState & 4) == 4) {
            builder2.append("CycleSlip|");
        }
        if ((this.mAccumulatedDeltaRangeState & 8) == 8) {
            builder2.append("HalfCycleResolved|");
        }
        if ((this.mAccumulatedDeltaRangeState & 0x10) == 16) {
            builder2.append("HalfCycleReported|");
        }
        if ((remainingStates = this.mAccumulatedDeltaRangeState & 0xFFFFFFE0) > 0) {
            builder2.append("Other(");
            builder2.append(Integer.toBinaryString(remainingStates));
            builder2.append(")|");
        }
        builder2.deleteCharAt(builder2.length() - 1);
        return builder2.toString();
    }

    public double getAccumulatedDeltaRangeMeters() {
        return this.mAccumulatedDeltaRangeMeters;
    }

    public void setAccumulatedDeltaRangeMeters(double value2) {
        this.mAccumulatedDeltaRangeMeters = value2;
    }

    public double getAccumulatedDeltaRangeUncertaintyMeters() {
        return this.mAccumulatedDeltaRangeUncertaintyMeters;
    }

    public void setAccumulatedDeltaRangeUncertaintyMeters(double value2) {
        this.mAccumulatedDeltaRangeUncertaintyMeters = value2;
    }

    public boolean hasCarrierFrequencyHz() {
        return this.isFlagSet(512);
    }

    public float getCarrierFrequencyHz() {
        return this.mCarrierFrequencyHz;
    }

    public void setCarrierFrequencyHz(float carrierFrequencyHz) {
        this.setFlag(512);
        this.mCarrierFrequencyHz = carrierFrequencyHz;
    }

    public void resetCarrierFrequencyHz() {
        this.resetFlag(512);
        this.mCarrierFrequencyHz = Float.NaN;
    }

    @Deprecated
    public boolean hasCarrierCycles() {
        return this.isFlagSet(1024);
    }

    @Deprecated
    public long getCarrierCycles() {
        return this.mCarrierCycles;
    }

    @Deprecated
    public void setCarrierCycles(long value2) {
        this.setFlag(1024);
        this.mCarrierCycles = value2;
    }

    @Deprecated
    public void resetCarrierCycles() {
        this.resetFlag(1024);
        this.mCarrierCycles = Long.MIN_VALUE;
    }

    @Deprecated
    public boolean hasCarrierPhase() {
        return this.isFlagSet(2048);
    }

    @Deprecated
    public double getCarrierPhase() {
        return this.mCarrierPhase;
    }

    @Deprecated
    public void setCarrierPhase(double value2) {
        this.setFlag(2048);
        this.mCarrierPhase = value2;
    }

    @Deprecated
    public void resetCarrierPhase() {
        this.resetFlag(2048);
    }

    @Deprecated
    public boolean hasCarrierPhaseUncertainty() {
        return this.isFlagSet(4096);
    }

    @Deprecated
    public double getCarrierPhaseUncertainty() {
        return this.mCarrierPhaseUncertainty;
    }

    @Deprecated
    public void setCarrierPhaseUncertainty(double value2) {
        this.setFlag(4096);
        this.mCarrierPhaseUncertainty = value2;
    }

    @Deprecated
    public void resetCarrierPhaseUncertainty() {
        this.resetFlag(4096);
    }

    public int getMultipathIndicator() {
        return this.mMultipathIndicator;
    }

    public void setMultipathIndicator(int value2) {
        this.mMultipathIndicator = value2;
    }

    private String getMultipathIndicatorString() {
        switch (this.mMultipathIndicator) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Detected";
            }
            case 2: {
                return "NotDetected";
            }
        }
        return "<Invalid: " + this.mMultipathIndicator + ">";
    }

    public boolean hasSnrInDb() {
        return this.isFlagSet(1);
    }

    public double getSnrInDb() {
        return this.mSnrInDb;
    }

    public void setSnrInDb(double snrInDb) {
        this.setFlag(1);
        this.mSnrInDb = snrInDb;
    }

    public void resetSnrInDb() {
        this.resetFlag(1);
    }

    @Deprecated
    public boolean hasAutomaticGainControlLevelDb() {
        return this.isFlagSet(8192);
    }

    @Deprecated
    public double getAutomaticGainControlLevelDb() {
        return this.mAutomaticGainControlLevelInDb;
    }

    @Deprecated
    public void setAutomaticGainControlLevelInDb(double agcLevelDb) {
        this.setFlag(8192);
        this.mAutomaticGainControlLevelInDb = agcLevelDb;
    }

    public void resetAutomaticGainControlLevel() {
        this.resetFlag(8192);
    }

    public boolean hasCodeType() {
        return this.isFlagSet(16384);
    }

    public String getCodeType() {
        return this.mCodeType;
    }

    public void setCodeType(String codeType) {
        this.setFlag(16384);
        this.mCodeType = codeType;
    }

    public void resetCodeType() {
        this.resetFlag(16384);
        this.mCodeType = "UNKNOWN";
    }

    public boolean hasFullInterSignalBiasNanos() {
        return this.isFlagSet(65536);
    }

    public double getFullInterSignalBiasNanos() {
        return this.mFullInterSignalBiasNanos;
    }

    public void setFullInterSignalBiasNanos(double fullInterSignalBiasNanos) {
        this.setFlag(65536);
        this.mFullInterSignalBiasNanos = fullInterSignalBiasNanos;
    }

    public void resetFullInterSignalBiasNanos() {
        this.resetFlag(65536);
    }

    public boolean hasFullInterSignalBiasUncertaintyNanos() {
        return this.isFlagSet(131072);
    }

    public double getFullInterSignalBiasUncertaintyNanos() {
        return this.mFullInterSignalBiasUncertaintyNanos;
    }

    public void setFullInterSignalBiasUncertaintyNanos(double fullInterSignalBiasUncertaintyNanos) {
        this.setFlag(131072);
        this.mFullInterSignalBiasUncertaintyNanos = fullInterSignalBiasUncertaintyNanos;
    }

    public void resetFullInterSignalBiasUncertaintyNanos() {
        this.resetFlag(131072);
    }

    public boolean hasSatelliteInterSignalBiasNanos() {
        return this.isFlagSet(262144);
    }

    public double getSatelliteInterSignalBiasNanos() {
        return this.mSatelliteInterSignalBiasNanos;
    }

    public void setSatelliteInterSignalBiasNanos(double satelliteInterSignalBiasNanos) {
        this.setFlag(262144);
        this.mSatelliteInterSignalBiasNanos = satelliteInterSignalBiasNanos;
    }

    public void resetSatelliteInterSignalBiasNanos() {
        this.resetFlag(262144);
    }

    public boolean hasSatelliteInterSignalBiasUncertaintyNanos() {
        return this.isFlagSet(524288);
    }

    public double getSatelliteInterSignalBiasUncertaintyNanos() {
        return this.mSatelliteInterSignalBiasUncertaintyNanos;
    }

    public void setSatelliteInterSignalBiasUncertaintyNanos(double satelliteInterSignalBiasUncertaintyNanos) {
        this.setFlag(524288);
        this.mSatelliteInterSignalBiasUncertaintyNanos = satelliteInterSignalBiasUncertaintyNanos;
    }

    public void resetSatelliteInterSignalBiasUncertaintyNanos() {
        this.resetFlag(524288);
    }

    @SystemApi
    public boolean hasSatellitePvt() {
        return this.isFlagSet(0x100000);
    }

    @SystemApi
    public SatellitePvt getSatellitePvt() {
        return this.mSatellitePvt;
    }

    public void setSatellitePvt(SatellitePvt satellitePvt) {
        if (satellitePvt == null) {
            this.resetSatellitePvt();
        } else {
            this.setFlag(0x100000);
            this.mSatellitePvt = satellitePvt;
        }
    }

    public void resetSatellitePvt() {
        this.resetFlag(0x100000);
    }

    @SystemApi
    public boolean hasCorrelationVectors() {
        return this.isFlagSet(0x200000);
    }

    @SystemApi
    @SuppressLint(value={"NullableCollection"})
    public Collection<CorrelationVector> getCorrelationVectors() {
        return this.mReadOnlyCorrelationVectors;
    }

    public void setCorrelationVectors(@SuppressLint(value={"NullableCollection"}) Collection<CorrelationVector> correlationVectors) {
        if (correlationVectors == null || correlationVectors.isEmpty()) {
            this.resetCorrelationVectors();
        } else {
            this.setFlag(0x200000);
            this.mReadOnlyCorrelationVectors = Collections.unmodifiableCollection(correlationVectors);
        }
    }

    public void resetCorrelationVectors() {
        this.resetFlag(0x200000);
        this.mReadOnlyCorrelationVectors = null;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mFlags);
        parcel.writeInt(this.mSvid);
        parcel.writeInt(this.mConstellationType);
        parcel.writeDouble(this.mTimeOffsetNanos);
        parcel.writeInt(this.mState);
        parcel.writeLong(this.mReceivedSvTimeNanos);
        parcel.writeLong(this.mReceivedSvTimeUncertaintyNanos);
        parcel.writeDouble(this.mCn0DbHz);
        parcel.writeDouble(this.mPseudorangeRateMetersPerSecond);
        parcel.writeDouble(this.mPseudorangeRateUncertaintyMetersPerSecond);
        parcel.writeInt(this.mAccumulatedDeltaRangeState);
        parcel.writeDouble(this.mAccumulatedDeltaRangeMeters);
        parcel.writeDouble(this.mAccumulatedDeltaRangeUncertaintyMeters);
        parcel.writeFloat(this.mCarrierFrequencyHz);
        parcel.writeLong(this.mCarrierCycles);
        parcel.writeDouble(this.mCarrierPhase);
        parcel.writeDouble(this.mCarrierPhaseUncertainty);
        parcel.writeInt(this.mMultipathIndicator);
        parcel.writeDouble(this.mSnrInDb);
        parcel.writeDouble(this.mAutomaticGainControlLevelInDb);
        parcel.writeString(this.mCodeType);
        parcel.writeDouble(this.mBasebandCn0DbHz);
        parcel.writeDouble(this.mFullInterSignalBiasNanos);
        parcel.writeDouble(this.mFullInterSignalBiasUncertaintyNanos);
        parcel.writeDouble(this.mSatelliteInterSignalBiasNanos);
        parcel.writeDouble(this.mSatelliteInterSignalBiasUncertaintyNanos);
        if (this.hasSatellitePvt()) {
            parcel.writeParcelable(this.mSatellitePvt, flags);
        }
        if (this.hasCorrelationVectors()) {
            int correlationVectorCount = this.mReadOnlyCorrelationVectors.size();
            Parcelable[] correlationVectorArray = this.mReadOnlyCorrelationVectors.toArray(new CorrelationVector[correlationVectorCount]);
            parcel.writeInt(correlationVectorArray.length);
            parcel.writeTypedArray(correlationVectorArray, flags);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        String format = "   %-29s = %s\n";
        String formatWithUncertainty = "   %-29s = %-25s   %-40s = %s\n";
        StringBuilder builder2 = new StringBuilder("GnssMeasurement:\n");
        builder2.append(String.format("   %-29s = %s\n", "Svid", this.mSvid));
        builder2.append(String.format("   %-29s = %s\n", "ConstellationType", this.mConstellationType));
        builder2.append(String.format("   %-29s = %s\n", "TimeOffsetNanos", this.mTimeOffsetNanos));
        builder2.append(String.format("   %-29s = %s\n", "State", this.getStateString()));
        builder2.append(String.format("   %-29s = %-25s   %-40s = %s\n", "ReceivedSvTimeNanos", this.mReceivedSvTimeNanos, "ReceivedSvTimeUncertaintyNanos", this.mReceivedSvTimeUncertaintyNanos));
        builder2.append(String.format("   %-29s = %s\n", "Cn0DbHz", this.mCn0DbHz));
        if (this.hasBasebandCn0DbHz()) {
            builder2.append(String.format("   %-29s = %s\n", "BasebandCn0DbHz", this.mBasebandCn0DbHz));
        }
        builder2.append(String.format("   %-29s = %-25s   %-40s = %s\n", "PseudorangeRateMetersPerSecond", this.mPseudorangeRateMetersPerSecond, "PseudorangeRateUncertaintyMetersPerSecond", this.mPseudorangeRateUncertaintyMetersPerSecond));
        builder2.append(String.format("   %-29s = %s\n", "AccumulatedDeltaRangeState", this.getAccumulatedDeltaRangeStateString()));
        builder2.append(String.format("   %-29s = %-25s   %-40s = %s\n", "AccumulatedDeltaRangeMeters", this.mAccumulatedDeltaRangeMeters, "AccumulatedDeltaRangeUncertaintyMeters", this.mAccumulatedDeltaRangeUncertaintyMeters));
        if (this.hasCarrierFrequencyHz()) {
            builder2.append(String.format("   %-29s = %s\n", "CarrierFrequencyHz", Float.valueOf(this.mCarrierFrequencyHz)));
        }
        if (this.hasCarrierCycles()) {
            builder2.append(String.format("   %-29s = %s\n", "CarrierCycles", this.mCarrierCycles));
        }
        if (this.hasCarrierPhase() || this.hasCarrierPhaseUncertainty()) {
            builder2.append(String.format("   %-29s = %-25s   %-40s = %s\n", "CarrierPhase", this.hasCarrierPhase() ? Double.valueOf(this.mCarrierPhase) : null, "CarrierPhaseUncertainty", this.hasCarrierPhaseUncertainty() ? Double.valueOf(this.mCarrierPhaseUncertainty) : null));
        }
        builder2.append(String.format("   %-29s = %s\n", "MultipathIndicator", this.getMultipathIndicatorString()));
        if (this.hasSnrInDb()) {
            builder2.append(String.format("   %-29s = %s\n", "SnrInDb", this.mSnrInDb));
        }
        if (this.hasAutomaticGainControlLevelDb()) {
            builder2.append(String.format("   %-29s = %s\n", "AgcLevelDb", this.mAutomaticGainControlLevelInDb));
        }
        if (this.hasCodeType()) {
            builder2.append(String.format("   %-29s = %s\n", "CodeType", this.mCodeType));
        }
        if (this.hasFullInterSignalBiasNanos() || this.hasFullInterSignalBiasUncertaintyNanos()) {
            builder2.append(String.format("   %-29s = %-25s   %-40s = %s\n", "InterSignalBiasNs", this.hasFullInterSignalBiasNanos() ? Double.valueOf(this.mFullInterSignalBiasNanos) : null, "InterSignalBiasUncertaintyNs", this.hasFullInterSignalBiasUncertaintyNanos() ? Double.valueOf(this.mFullInterSignalBiasUncertaintyNanos) : null));
        }
        if (this.hasSatelliteInterSignalBiasNanos() || this.hasSatelliteInterSignalBiasUncertaintyNanos()) {
            builder2.append(String.format("   %-29s = %-25s   %-40s = %s\n", "SatelliteInterSignalBiasNs", this.hasSatelliteInterSignalBiasNanos() ? Double.valueOf(this.mSatelliteInterSignalBiasNanos) : null, "SatelliteInterSignalBiasUncertaintyNs", this.hasSatelliteInterSignalBiasUncertaintyNanos() ? Double.valueOf(this.mSatelliteInterSignalBiasUncertaintyNanos) : null));
        }
        if (this.hasSatellitePvt()) {
            builder2.append(this.mSatellitePvt.toString());
        }
        if (this.hasCorrelationVectors()) {
            for (CorrelationVector correlationVector : this.mReadOnlyCorrelationVectors) {
                builder2.append(correlationVector.toString());
                builder2.append("\n");
            }
        }
        return builder2.toString();
    }

    private void initialize() {
        this.mFlags = 0;
        this.setSvid(0);
        this.setTimeOffsetNanos(-9.223372036854776E18);
        this.setState(0);
        this.setReceivedSvTimeNanos(Long.MIN_VALUE);
        this.setReceivedSvTimeUncertaintyNanos(Long.MAX_VALUE);
        this.setCn0DbHz(Double.MIN_VALUE);
        this.setPseudorangeRateMetersPerSecond(Double.MIN_VALUE);
        this.setPseudorangeRateUncertaintyMetersPerSecond(Double.MIN_VALUE);
        this.setAccumulatedDeltaRangeState(0);
        this.setAccumulatedDeltaRangeMeters(Double.MIN_VALUE);
        this.setAccumulatedDeltaRangeUncertaintyMeters(Double.MIN_VALUE);
        this.resetCarrierFrequencyHz();
        this.resetCarrierCycles();
        this.resetCarrierPhase();
        this.resetCarrierPhaseUncertainty();
        this.setMultipathIndicator(0);
        this.resetSnrInDb();
        this.resetAutomaticGainControlLevel();
        this.resetCodeType();
        this.resetBasebandCn0DbHz();
        this.resetFullInterSignalBiasNanos();
        this.resetFullInterSignalBiasUncertaintyNanos();
        this.resetSatelliteInterSignalBiasNanos();
        this.resetSatelliteInterSignalBiasUncertaintyNanos();
        this.resetSatellitePvt();
        this.resetCorrelationVectors();
    }

    private void setFlag(int flag) {
        this.mFlags |= flag;
    }

    private void resetFlag(int flag) {
        this.mFlags &= ~flag;
    }

    private boolean isFlagSet(int flag) {
        return (this.mFlags & flag) == flag;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AdrState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MultipathIndicator {
    }
}

