/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.location.GnssAutomaticGainControl;
import android.location.GnssClock;
import android.location.GnssMeasurement;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GnssMeasurementsEvent
implements Parcelable {
    private final GnssClock mClock;
    private final List<GnssMeasurement> mMeasurements;
    private final List<GnssAutomaticGainControl> mGnssAgcs;
    public static final Parcelable.Creator<GnssMeasurementsEvent> CREATOR = new Parcelable.Creator<GnssMeasurementsEvent>(){

        @Override
        public GnssMeasurementsEvent createFromParcel(Parcel in) {
            GnssClock clock = in.readParcelable(this.getClass().getClassLoader(), GnssClock.class);
            ArrayList<GnssMeasurement> measurements = in.createTypedArrayList(GnssMeasurement.CREATOR);
            ArrayList<GnssAutomaticGainControl> agcs = in.createTypedArrayList(GnssAutomaticGainControl.CREATOR);
            return new GnssMeasurementsEvent(clock, measurements, agcs);
        }

        public GnssMeasurementsEvent[] newArray(int size) {
            return new GnssMeasurementsEvent[size];
        }
    };

    private GnssMeasurementsEvent(GnssClock clock, List<GnssMeasurement> measurements, List<GnssAutomaticGainControl> agcs) {
        this.mMeasurements = measurements;
        this.mGnssAgcs = agcs;
        this.mClock = clock;
    }

    public GnssClock getClock() {
        return this.mClock;
    }

    public Collection<GnssMeasurement> getMeasurements() {
        return this.mMeasurements;
    }

    public Collection<GnssAutomaticGainControl> getGnssAutomaticGainControls() {
        return this.mGnssAgcs;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeParcelable(this.mClock, flags);
        parcel.writeTypedList(this.mMeasurements);
        parcel.writeTypedList(this.mGnssAgcs);
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder("GnssMeasurementsEvent[");
        builder2.append(this.mClock);
        builder2.append(' ').append(this.mMeasurements.toString());
        builder2.append(' ').append(this.mGnssAgcs.toString());
        builder2.append("]");
        return builder2.toString();
    }

    public static class Builder {
        private GnssClock mClock;
        private List<GnssMeasurement> mMeasurements;
        private List<GnssAutomaticGainControl> mGnssAgcs;

        public Builder() {
            this.mClock = new GnssClock();
            this.mMeasurements = new ArrayList<GnssMeasurement>();
            this.mGnssAgcs = new ArrayList<GnssAutomaticGainControl>();
        }

        public Builder(GnssMeasurementsEvent event) {
            this.mClock = event.getClock();
            this.mMeasurements = (List)event.getMeasurements();
            this.mGnssAgcs = (List)event.getGnssAutomaticGainControls();
        }

        public Builder setClock(GnssClock clock) {
            Preconditions.checkNotNull(clock);
            this.mClock = clock;
            return this;
        }

        public Builder setMeasurements(GnssMeasurement ... measurements) {
            this.mMeasurements = measurements == null ? Collections.emptyList() : Arrays.asList(measurements);
            return this;
        }

        public Builder setMeasurements(Collection<GnssMeasurement> measurements) {
            this.mMeasurements = new ArrayList<GnssMeasurement>(measurements);
            return this;
        }

        public Builder setGnssAutomaticGainControls(GnssAutomaticGainControl ... agcs) {
            this.mGnssAgcs = agcs == null ? Collections.emptyList() : Arrays.asList(agcs);
            return this;
        }

        public Builder setGnssAutomaticGainControls(Collection<GnssAutomaticGainControl> agcs) {
            this.mGnssAgcs = new ArrayList<GnssAutomaticGainControl>(agcs);
            return this;
        }

        public GnssMeasurementsEvent build() {
            return new GnssMeasurementsEvent(this.mClock, this.mMeasurements, this.mGnssAgcs);
        }
    }

    public static abstract class Callback {
        @Deprecated
        public static final int STATUS_NOT_SUPPORTED = 0;
        @Deprecated
        public static final int STATUS_READY = 1;
        @Deprecated
        public static final int STATUS_LOCATION_DISABLED = 2;
        @Deprecated
        public static final int STATUS_NOT_ALLOWED = 3;

        public void onGnssMeasurementsReceived(GnssMeasurementsEvent eventArgs) {
        }

        @Deprecated
        public void onStatusChanged(int status) {
        }

        @Deprecated
        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface GnssMeasurementsStatus {
        }
    }
}

