/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.location.Address;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IGeocodeListener
extends IInterface {
    public static final String DESCRIPTOR = "android.location.IGeocodeListener";

    public void onResults(String var1, List<Address> var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IGeocodeListener {
        static final int TRANSACTION_onResults = 1;

        public Stub() {
            this.attachInterface(this, IGeocodeListener.DESCRIPTOR);
        }

        public static IGeocodeListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IGeocodeListener.DESCRIPTOR);
            if (iin != null && iin instanceof IGeocodeListener) {
                return (IGeocodeListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onResults";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IGeocodeListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    ArrayList<Address> _arg1 = data.createTypedArrayList(Address.CREATOR);
                    data.enforceNoDataAvail();
                    this.onResults(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IGeocodeListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IGeocodeListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResults(String error, List<Address> results) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IGeocodeListener.DESCRIPTOR);
                    _data.writeString(error);
                    _data.writeTypedList(results);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IGeocodeListener {
        @Override
        public void onResults(String error, List<Address> results) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

