/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.location.Criteria;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.WorkSource;
import android.util.TimeUtils;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class LocationRequest
implements Parcelable {
    public static final long LOW_POWER_EXCEPTIONS = 168936375L;
    public static final long PASSIVE_INTERVAL = Long.MAX_VALUE;
    public static final int QUALITY_HIGH_ACCURACY = 100;
    public static final int QUALITY_BALANCED_POWER_ACCURACY = 102;
    public static final int QUALITY_LOW_POWER = 104;
    @Deprecated
    @SystemApi
    public static final int ACCURACY_FINE = 100;
    @Deprecated
    @SystemApi
    public static final int ACCURACY_BLOCK = 102;
    @Deprecated
    @SystemApi
    public static final int ACCURACY_CITY = 104;
    @SystemApi
    @Deprecated
    public static final int POWER_NONE = 200;
    @Deprecated
    @SystemApi
    public static final int POWER_LOW = 201;
    @Deprecated
    @SystemApi
    public static final int POWER_HIGH = 203;
    private static final long IMPLICIT_MIN_UPDATE_INTERVAL = -1L;
    private static final double IMPLICIT_MIN_UPDATE_INTERVAL_FACTOR = 0.16666666666666666;
    private String mProvider;
    private int mQuality;
    private long mIntervalMillis;
    private long mMinUpdateIntervalMillis;
    private long mExpireAtRealtimeMillis;
    private long mDurationMillis;
    private int mMaxUpdates;
    private float mMinUpdateDistanceMeters;
    private final long mMaxUpdateDelayMillis;
    private boolean mHideFromAppOps;
    private final boolean mAdasGnssBypass;
    private boolean mBypass;
    private boolean mLowPower;
    private WorkSource mWorkSource;
    public static final Parcelable.Creator<LocationRequest> CREATOR = new Parcelable.Creator<LocationRequest>(){

        @Override
        public LocationRequest createFromParcel(Parcel in) {
            return new LocationRequest(in.readString(), in.readLong(), in.readInt(), in.readLong(), in.readLong(), in.readInt(), in.readLong(), in.readFloat(), in.readLong(), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readTypedObject(WorkSource.CREATOR));
        }

        public LocationRequest[] newArray(int size) {
            return new LocationRequest[size];
        }
    };

    @SystemApi
    @Deprecated
    public static LocationRequest create() {
        return new Builder(3600000L).build();
    }

    @SystemApi
    @Deprecated
    public static LocationRequest createFromDeprecatedProvider(String provider2, long intervalMillis, float minUpdateDistanceMeters, boolean singleShot) {
        Preconditions.checkArgument(provider2 != null, "invalid null provider");
        if (intervalMillis < 0L) {
            intervalMillis = 0L;
        } else if (intervalMillis == Long.MAX_VALUE) {
            intervalMillis = 0x7FFFFFFFFFFFFFFEL;
        }
        if (minUpdateDistanceMeters < 0.0f) {
            minUpdateDistanceMeters = 0.0f;
        }
        int quality = "passive".equals(provider2) ? 200 : ("gps".equals(provider2) ? 100 : 102);
        return new Builder(intervalMillis).setMinUpdateIntervalMillis(intervalMillis).setMinUpdateDistanceMeters(minUpdateDistanceMeters).setMaxUpdates(singleShot ? 1 : Integer.MAX_VALUE).build().setProvider(provider2).setQuality(quality);
    }

    @SystemApi
    @Deprecated
    public static LocationRequest createFromDeprecatedCriteria(Criteria criteria, long intervalMillis, float minUpdateDistanceMeters, boolean singleShot) {
        Preconditions.checkArgument(criteria != null, "invalid null criteria");
        if (intervalMillis < 0L) {
            intervalMillis = 0L;
        } else if (intervalMillis == Long.MAX_VALUE) {
            intervalMillis = 0x7FFFFFFFFFFFFFFEL;
        }
        if (minUpdateDistanceMeters < 0.0f) {
            minUpdateDistanceMeters = 0.0f;
        }
        return new Builder(intervalMillis).setQuality(criteria).setMinUpdateIntervalMillis(intervalMillis).setMinUpdateDistanceMeters(minUpdateDistanceMeters).setMaxUpdates(singleShot ? 1 : Integer.MAX_VALUE).build();
    }

    private LocationRequest(String provider2, long intervalMillis, int quality, long expireAtRealtimeMillis, long durationMillis, int maxUpdates, long minUpdateIntervalMillis, float minUpdateDistanceMeters, long maxUpdateDelayMillis, boolean hiddenFromAppOps, boolean adasGnssBypass, boolean bypass, boolean lowPower, WorkSource workSource) {
        this.mProvider = provider2;
        this.mIntervalMillis = intervalMillis;
        this.mQuality = quality;
        this.mMinUpdateIntervalMillis = minUpdateIntervalMillis;
        this.mExpireAtRealtimeMillis = expireAtRealtimeMillis;
        this.mDurationMillis = durationMillis;
        this.mMaxUpdates = maxUpdates;
        this.mMinUpdateDistanceMeters = minUpdateDistanceMeters;
        this.mMaxUpdateDelayMillis = maxUpdateDelayMillis;
        this.mHideFromAppOps = hiddenFromAppOps;
        this.mAdasGnssBypass = adasGnssBypass;
        this.mBypass = bypass;
        this.mLowPower = lowPower;
        this.mWorkSource = Objects.requireNonNull(workSource);
    }

    @SystemApi
    @Deprecated
    public LocationRequest setProvider(String provider2) {
        Preconditions.checkArgument(provider2 != null);
        this.mProvider = provider2;
        return this;
    }

    @SystemApi
    @Deprecated
    public String getProvider() {
        return this.mProvider != null ? this.mProvider : "fused";
    }

    @SystemApi
    @Deprecated
    public LocationRequest setQuality(int quality) {
        switch (quality) {
            case 100: 
            case 203: {
                this.mQuality = 100;
                break;
            }
            case 102: {
                this.mQuality = 102;
                break;
            }
            case 104: 
            case 201: {
                this.mQuality = 104;
                break;
            }
            case 200: {
                this.mIntervalMillis = Long.MAX_VALUE;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid quality: " + quality);
            }
        }
        return this;
    }

    public int getQuality() {
        return this.mQuality;
    }

    @SystemApi
    @Deprecated
    public LocationRequest setInterval(long millis) {
        Preconditions.checkArgument(millis >= 0L);
        if (millis == Long.MAX_VALUE) {
            millis = 0x7FFFFFFFFFFFFFFEL;
        }
        this.mIntervalMillis = millis;
        if (this.mMinUpdateIntervalMillis > this.mIntervalMillis) {
            this.mMinUpdateIntervalMillis = this.mIntervalMillis;
        }
        return this;
    }

    @SystemApi
    @Deprecated
    public long getInterval() {
        return this.getIntervalMillis();
    }

    public long getIntervalMillis() {
        return this.mIntervalMillis;
    }

    @SystemApi
    @Deprecated
    public LocationRequest setFastestInterval(long millis) {
        Preconditions.checkArgument(millis >= 0L);
        this.mMinUpdateIntervalMillis = millis;
        return this;
    }

    @SystemApi
    @Deprecated
    public long getFastestInterval() {
        return this.getMinUpdateIntervalMillis();
    }

    @SystemApi
    @Deprecated
    public LocationRequest setExpireAt(long millis) {
        this.mExpireAtRealtimeMillis = Math.max(millis, 0L);
        return this;
    }

    @SystemApi
    @Deprecated
    public long getExpireAt() {
        return this.mExpireAtRealtimeMillis;
    }

    @SystemApi
    @Deprecated
    public LocationRequest setExpireIn(long millis) {
        this.mDurationMillis = millis;
        return this;
    }

    @SystemApi
    @Deprecated
    public long getExpireIn() {
        return this.getDurationMillis();
    }

    public long getDurationMillis() {
        return this.mDurationMillis;
    }

    public long getExpirationRealtimeMs(long startRealtimeMs) {
        long expirationRealtimeMs = this.mDurationMillis > Long.MAX_VALUE - startRealtimeMs ? Long.MAX_VALUE : startRealtimeMs + this.mDurationMillis;
        return Math.min(expirationRealtimeMs, this.mExpireAtRealtimeMillis);
    }

    @SystemApi
    @Deprecated
    public LocationRequest setNumUpdates(int numUpdates) {
        if (numUpdates <= 0) {
            throw new IllegalArgumentException("invalid numUpdates: " + numUpdates);
        }
        this.mMaxUpdates = numUpdates;
        return this;
    }

    @SystemApi
    @Deprecated
    public int getNumUpdates() {
        return this.getMaxUpdates();
    }

    public int getMaxUpdates() {
        return this.mMaxUpdates;
    }

    public long getMinUpdateIntervalMillis() {
        if (this.mMinUpdateIntervalMillis == -1L) {
            return (long)((double)this.mIntervalMillis * 0.16666666666666666);
        }
        return Math.min(this.mMinUpdateIntervalMillis, this.mIntervalMillis);
    }

    @SystemApi
    @Deprecated
    public LocationRequest setSmallestDisplacement(float minDisplacementMeters) {
        this.mMinUpdateDistanceMeters = Preconditions.checkArgumentInRange(minDisplacementMeters, 0.0f, Float.MAX_VALUE, "minDisplacementMeters");
        return this;
    }

    @SystemApi
    @Deprecated
    public float getSmallestDisplacement() {
        return this.getMinUpdateDistanceMeters();
    }

    public float getMinUpdateDistanceMeters() {
        return this.mMinUpdateDistanceMeters;
    }

    public long getMaxUpdateDelayMillis() {
        return this.mMaxUpdateDelayMillis;
    }

    @SystemApi
    @Deprecated
    public void setHideFromAppOps(boolean hiddenFromAppOps) {
        this.mHideFromAppOps = hiddenFromAppOps;
    }

    @SystemApi
    @Deprecated
    public boolean getHideFromAppOps() {
        return this.isHiddenFromAppOps();
    }

    @SystemApi
    public boolean isHiddenFromAppOps() {
        return this.mHideFromAppOps;
    }

    @SystemApi
    public boolean isAdasGnssBypass() {
        return this.mAdasGnssBypass;
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.LOCATION_BYPASS")
    public LocationRequest setLocationSettingsIgnored(boolean locationSettingsIgnored) {
        this.mBypass = locationSettingsIgnored;
        return this;
    }

    @SystemApi
    public boolean isLocationSettingsIgnored() {
        return this.mBypass;
    }

    public boolean isBypass() {
        return this.mAdasGnssBypass || this.mBypass;
    }

    @SystemApi
    @Deprecated
    public LocationRequest setLowPowerMode(boolean enabled) {
        this.mLowPower = enabled;
        return this;
    }

    @Deprecated
    @SystemApi
    public boolean isLowPowerMode() {
        return this.isLowPower();
    }

    @SystemApi
    public boolean isLowPower() {
        return this.mLowPower;
    }

    @SystemApi
    @Deprecated
    public void setWorkSource(WorkSource workSource) {
        if (workSource == null) {
            workSource = new WorkSource();
        }
        this.mWorkSource = workSource;
    }

    @SystemApi
    public WorkSource getWorkSource() {
        return this.mWorkSource;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.mProvider);
        parcel.writeLong(this.mIntervalMillis);
        parcel.writeInt(this.mQuality);
        parcel.writeLong(this.mExpireAtRealtimeMillis);
        parcel.writeLong(this.mDurationMillis);
        parcel.writeInt(this.mMaxUpdates);
        parcel.writeLong(this.mMinUpdateIntervalMillis);
        parcel.writeFloat(this.mMinUpdateDistanceMeters);
        parcel.writeLong(this.mMaxUpdateDelayMillis);
        parcel.writeBoolean(this.mHideFromAppOps);
        parcel.writeBoolean(this.mAdasGnssBypass);
        parcel.writeBoolean(this.mBypass);
        parcel.writeBoolean(this.mLowPower);
        parcel.writeTypedObject(this.mWorkSource, 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationRequest that = (LocationRequest)o;
        return this.mIntervalMillis == that.mIntervalMillis && this.mQuality == that.mQuality && this.mExpireAtRealtimeMillis == that.mExpireAtRealtimeMillis && this.mDurationMillis == that.mDurationMillis && this.mMaxUpdates == that.mMaxUpdates && this.mMinUpdateIntervalMillis == that.mMinUpdateIntervalMillis && Float.compare(that.mMinUpdateDistanceMeters, this.mMinUpdateDistanceMeters) == 0 && this.mMaxUpdateDelayMillis == that.mMaxUpdateDelayMillis && this.mHideFromAppOps == that.mHideFromAppOps && this.mAdasGnssBypass == that.mAdasGnssBypass && this.mBypass == that.mBypass && this.mLowPower == that.mLowPower && Objects.equals(this.mProvider, that.mProvider) && Objects.equals(this.mWorkSource, that.mWorkSource);
    }

    public int hashCode() {
        return Objects.hash(this.mProvider, this.mIntervalMillis, this.mWorkSource);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Request[");
        if (this.mProvider != null) {
            s.append(this.mProvider).append(" ");
        }
        if (this.mIntervalMillis != Long.MAX_VALUE) {
            s.append("@");
            TimeUtils.formatDuration(this.mIntervalMillis, s);
            switch (this.mQuality) {
                case 100: {
                    s.append(" HIGH_ACCURACY");
                    break;
                }
                case 102: {
                    s.append(" BALANCED");
                    break;
                }
                case 104: {
                    s.append(" LOW_POWER");
                }
            }
        } else {
            s.append("PASSIVE");
        }
        if (this.mExpireAtRealtimeMillis != Long.MAX_VALUE) {
            s.append(", expireAt=").append(TimeUtils.formatRealtime(this.mExpireAtRealtimeMillis));
        }
        if (this.mDurationMillis != Long.MAX_VALUE) {
            s.append(", duration=");
            TimeUtils.formatDuration(this.mDurationMillis, s);
        }
        if (this.mMaxUpdates != Integer.MAX_VALUE) {
            s.append(", maxUpdates=").append(this.mMaxUpdates);
        }
        if (this.mMinUpdateIntervalMillis != -1L && this.mMinUpdateIntervalMillis < this.mIntervalMillis) {
            s.append(", minUpdateInterval=");
            TimeUtils.formatDuration(this.mMinUpdateIntervalMillis, s);
        }
        if ((double)this.mMinUpdateDistanceMeters > 0.0) {
            s.append(", minUpdateDistance=").append(this.mMinUpdateDistanceMeters);
        }
        if (this.mMaxUpdateDelayMillis / 2L > this.mIntervalMillis) {
            s.append(", maxUpdateDelay=");
            TimeUtils.formatDuration(this.mMaxUpdateDelayMillis, s);
        }
        if (this.mLowPower) {
            s.append(", lowPower");
        }
        if (this.mHideFromAppOps) {
            s.append(", hiddenFromAppOps");
        }
        if (this.mAdasGnssBypass) {
            s.append(", adasGnssBypass");
        }
        if (this.mBypass) {
            s.append(", bypass");
        }
        if (this.mWorkSource != null && !this.mWorkSource.isEmpty()) {
            s.append(", ").append(this.mWorkSource);
        }
        s.append(']');
        return s.toString();
    }

    public static class Builder {
        private long mIntervalMillis;
        private int mQuality;
        private long mDurationMillis;
        private int mMaxUpdates;
        private long mMinUpdateIntervalMillis;
        private float mMinUpdateDistanceMeters;
        private long mMaxUpdateDelayMillis;
        private boolean mHiddenFromAppOps;
        private boolean mAdasGnssBypass;
        private boolean mBypass;
        private boolean mLowPower;
        private WorkSource mWorkSource;

        public Builder(long intervalMillis) {
            this.setIntervalMillis(intervalMillis);
            this.mQuality = 102;
            this.mDurationMillis = Long.MAX_VALUE;
            this.mMaxUpdates = Integer.MAX_VALUE;
            this.mMinUpdateIntervalMillis = -1L;
            this.mMinUpdateDistanceMeters = 0.0f;
            this.mMaxUpdateDelayMillis = 0L;
            this.mHiddenFromAppOps = false;
            this.mAdasGnssBypass = false;
            this.mBypass = false;
            this.mLowPower = false;
            this.mWorkSource = null;
        }

        public Builder(LocationRequest locationRequest) {
            this.mIntervalMillis = locationRequest.mIntervalMillis;
            this.mQuality = locationRequest.mQuality;
            this.mDurationMillis = locationRequest.mDurationMillis;
            this.mMaxUpdates = locationRequest.mMaxUpdates;
            this.mMinUpdateIntervalMillis = locationRequest.mMinUpdateIntervalMillis;
            this.mMinUpdateDistanceMeters = locationRequest.mMinUpdateDistanceMeters;
            this.mMaxUpdateDelayMillis = locationRequest.mMaxUpdateDelayMillis;
            this.mHiddenFromAppOps = locationRequest.mHideFromAppOps;
            this.mAdasGnssBypass = locationRequest.mAdasGnssBypass;
            this.mBypass = locationRequest.mBypass;
            this.mLowPower = locationRequest.mLowPower;
            this.mWorkSource = locationRequest.mWorkSource;
            if (this.mIntervalMillis == Long.MAX_VALUE && this.mMinUpdateIntervalMillis == -1L) {
                this.mMinUpdateIntervalMillis = 600000L;
            }
        }

        public Builder setIntervalMillis(long intervalMillis) {
            this.mIntervalMillis = Preconditions.checkArgumentInRange(intervalMillis, 0L, Long.MAX_VALUE, "intervalMillis");
            return this;
        }

        public Builder setQuality(int quality) {
            Preconditions.checkArgument(quality == 104 || quality == 102 || quality == 100, "quality must be a defined QUALITY constant, not %d", quality);
            this.mQuality = quality;
            return this;
        }

        public Builder setQuality(Criteria criteria) {
            switch (criteria.getAccuracy()) {
                case 2: {
                    this.mQuality = 102;
                    break;
                }
                case 1: {
                    this.mQuality = 100;
                    break;
                }
                default: {
                    this.mQuality = criteria.getPowerRequirement() == 3 ? 203 : 201;
                }
            }
            return this;
        }

        public Builder setDurationMillis(long durationMillis) {
            this.mDurationMillis = Preconditions.checkArgumentInRange(durationMillis, 1L, Long.MAX_VALUE, "durationMillis");
            return this;
        }

        public Builder setMaxUpdates(int maxUpdates) {
            this.mMaxUpdates = Preconditions.checkArgumentInRange(maxUpdates, 1, Integer.MAX_VALUE, "maxUpdates");
            return this;
        }

        public Builder setMinUpdateIntervalMillis(long minUpdateIntervalMillis) {
            this.mMinUpdateIntervalMillis = Preconditions.checkArgumentInRange(minUpdateIntervalMillis, 0L, Long.MAX_VALUE, "minUpdateIntervalMillis");
            return this;
        }

        public Builder clearMinUpdateIntervalMillis() {
            this.mMinUpdateIntervalMillis = -1L;
            return this;
        }

        public Builder setMinUpdateDistanceMeters(float minUpdateDistanceMeters) {
            this.mMinUpdateDistanceMeters = Preconditions.checkArgumentInRange(minUpdateDistanceMeters, 0.0f, Float.MAX_VALUE, "minUpdateDistanceMeters");
            return this;
        }

        public Builder setMaxUpdateDelayMillis(long maxUpdateDelayMillis) {
            this.mMaxUpdateDelayMillis = Preconditions.checkArgumentInRange(maxUpdateDelayMillis, 0L, Long.MAX_VALUE, "maxUpdateDelayMillis");
            return this;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.UPDATE_APP_OPS_STATS")
        public Builder setHiddenFromAppOps(boolean hiddenFromAppOps) {
            this.mHiddenFromAppOps = hiddenFromAppOps;
            return this;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.LOCATION_BYPASS")
        public Builder setAdasGnssBypass(boolean adasGnssBypass) {
            this.mAdasGnssBypass = adasGnssBypass;
            return this;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.LOCATION_BYPASS")
        public Builder setLocationSettingsIgnored(boolean locationSettingsIgnored) {
            this.mBypass = locationSettingsIgnored;
            return this;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.LOCATION_HARDWARE")
        public Builder setLowPower(boolean lowPower) {
            this.mLowPower = lowPower;
            return this;
        }

        @SystemApi
        @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
        public Builder setWorkSource(WorkSource workSource) {
            this.mWorkSource = workSource;
            return this;
        }

        public LocationRequest build() {
            Preconditions.checkState(this.mIntervalMillis != Long.MAX_VALUE || this.mMinUpdateIntervalMillis != -1L, "passive location requests must have an explicit minimum update interval");
            return new LocationRequest(null, this.mIntervalMillis, this.mQuality, Long.MAX_VALUE, this.mDurationMillis, this.mMaxUpdates, Math.min(this.mMinUpdateIntervalMillis, this.mIntervalMillis), this.mMinUpdateDistanceMeters, this.mMaxUpdateDelayMillis, this.mHiddenFromAppOps, this.mAdasGnssBypass, this.mBypass, this.mLowPower, new WorkSource(this.mWorkSource));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Quality {
    }
}

