/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.internal.annotation.MinSdk;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@MinSdk(value=31)
public class ApplicationMediaCapabilities
implements Parcelable {
    private static final String TAG = "ApplicationMediaCapabilities";
    private Set<String> mSupportedVideoMimeTypes = new HashSet<String>();
    private Set<String> mUnsupportedVideoMimeTypes = new HashSet<String>();
    private Set<String> mSupportedHdrTypes = new HashSet<String>();
    private Set<String> mUnsupportedHdrTypes = new HashSet<String>();
    private boolean mIsSlowMotionSupported = false;
    public static final Parcelable.Creator<ApplicationMediaCapabilities> CREATOR = new Parcelable.Creator<ApplicationMediaCapabilities>(){

        @Override
        public ApplicationMediaCapabilities createFromParcel(Parcel in) {
            int readCount;
            Builder builder2 = new Builder();
            int count = in.readInt();
            for (readCount = 0; readCount < count; ++readCount) {
                builder2.addSupportedVideoMimeType(in.readString());
            }
            count = in.readInt();
            for (readCount = 0; readCount < count; ++readCount) {
                builder2.addUnsupportedVideoMimeType(in.readString());
            }
            count = in.readInt();
            for (readCount = 0; readCount < count; ++readCount) {
                builder2.addSupportedHdrType(in.readString());
            }
            count = in.readInt();
            for (readCount = 0; readCount < count; ++readCount) {
                builder2.addUnsupportedHdrType(in.readString());
            }
            boolean supported = in.readBoolean();
            builder2.setSlowMotionSupported(supported);
            return builder2.build();
        }

        public ApplicationMediaCapabilities[] newArray(int size) {
            return new ApplicationMediaCapabilities[size];
        }
    };

    private ApplicationMediaCapabilities(Builder b) {
        this.mSupportedVideoMimeTypes.addAll(b.getSupportedVideoMimeTypes());
        this.mUnsupportedVideoMimeTypes.addAll(b.getUnsupportedVideoMimeTypes());
        this.mSupportedHdrTypes.addAll(b.getSupportedHdrTypes());
        this.mUnsupportedHdrTypes.addAll(b.getUnsupportedHdrTypes());
        this.mIsSlowMotionSupported = b.mIsSlowMotionSupported;
    }

    public boolean isVideoMimeTypeSupported(String videoMime) {
        return this.mSupportedVideoMimeTypes.contains(videoMime.toLowerCase());
    }

    public boolean isHdrTypeSupported(String hdrType) {
        return this.mSupportedHdrTypes.contains(hdrType);
    }

    public boolean isFormatSpecified(String format) {
        return this.mSupportedVideoMimeTypes.contains(format) || this.mUnsupportedVideoMimeTypes.contains(format) || this.mSupportedHdrTypes.contains(format) || this.mUnsupportedHdrTypes.contains(format);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSupportedVideoMimeTypes.size());
        for (String cap : this.mSupportedVideoMimeTypes) {
            dest.writeString(cap);
        }
        dest.writeInt(this.mUnsupportedVideoMimeTypes.size());
        for (String cap : this.mUnsupportedVideoMimeTypes) {
            dest.writeString(cap);
        }
        dest.writeInt(this.mSupportedHdrTypes.size());
        for (String cap : this.mSupportedHdrTypes) {
            dest.writeString(cap);
        }
        dest.writeInt(this.mUnsupportedHdrTypes.size());
        for (String cap : this.mUnsupportedHdrTypes) {
            dest.writeString(cap);
        }
        dest.writeBoolean(this.mIsSlowMotionSupported);
    }

    public String toString() {
        String caps = new String("Supported Video MimeTypes: " + this.mSupportedVideoMimeTypes.toString());
        caps = caps + "Unsupported Video MimeTypes: " + this.mUnsupportedVideoMimeTypes.toString();
        caps = caps + "Supported HDR types: " + this.mSupportedHdrTypes.toString();
        caps = caps + "Unsupported HDR types: " + this.mUnsupportedHdrTypes.toString();
        caps = caps + "Supported slow motion: " + this.mIsSlowMotionSupported;
        return caps;
    }

    public List<String> getSupportedVideoMimeTypes() {
        return new ArrayList<String>(this.mSupportedVideoMimeTypes);
    }

    public List<String> getUnsupportedVideoMimeTypes() {
        return new ArrayList<String>(this.mUnsupportedVideoMimeTypes);
    }

    public List<String> getSupportedHdrTypes() {
        return new ArrayList<String>(this.mSupportedHdrTypes);
    }

    public List<String> getUnsupportedHdrTypes() {
        return new ArrayList<String>(this.mUnsupportedHdrTypes);
    }

    public boolean isSlowMotionSupported() {
        return this.mIsSlowMotionSupported;
    }

    public static ApplicationMediaCapabilities createFromXml(XmlPullParser xmlParser) {
        Builder builder2 = new Builder();
        builder2.parseXml(xmlParser);
        return builder2.build();
    }

    public static class Builder {
        private Set<String> mSupportedVideoMimeTypes = new HashSet<String>();
        private Set<String> mSupportedHdrTypes = new HashSet<String>();
        private Set<String> mUnsupportedVideoMimeTypes = new HashSet<String>();
        private Set<String> mUnsupportedHdrTypes = new HashSet<String>();
        private boolean mIsSlowMotionSupported = false;
        private Map<String, Boolean> mFormatSupportedMap = new HashMap<String, Boolean>();

        private void parseXml(XmlPullParser xmlParser) throws UnsupportedOperationException {
            if (xmlParser == null) {
                throw new IllegalArgumentException("XmlParser must not be null");
            }
            try {
                while (xmlParser.next() != 2) {
                }
                if (!xmlParser.getName().equals("media-capabilities")) {
                    throw new UnsupportedOperationException("Invalid tag");
                }
                xmlParser.next();
                while (xmlParser.getEventType() != 3) {
                    while (xmlParser.getEventType() != 2) {
                        if (xmlParser.getEventType() == 1) {
                            return;
                        }
                        xmlParser.next();
                    }
                    if (xmlParser.getName().equals("format")) {
                        this.parseFormatTag(xmlParser);
                    } else {
                        throw new UnsupportedOperationException("Invalid tag");
                    }
                    while (xmlParser.getEventType() != 3) {
                        xmlParser.next();
                    }
                    xmlParser.next();
                }
            }
            catch (XmlPullParserException xppe) {
                throw new UnsupportedOperationException("Ill-formatted xml file");
            }
            catch (IOException ioe) {
                throw new UnsupportedOperationException("Unable to read xml file");
            }
        }

        private void parseFormatTag(XmlPullParser xmlParser) {
            boolean isSupported;
            String name = null;
            String supported = null;
            for (int i = 0; i < xmlParser.getAttributeCount(); ++i) {
                String attrName = xmlParser.getAttributeName(i);
                if (attrName.equals("name")) {
                    name = xmlParser.getAttributeValue(i);
                    continue;
                }
                if (attrName.equals("supported")) {
                    supported = xmlParser.getAttributeValue(i);
                    continue;
                }
                throw new UnsupportedOperationException("Invalid attribute name " + attrName);
            }
            if (name != null && supported != null) {
                if (!supported.equals("true") && !supported.equals("false")) {
                    throw new UnsupportedOperationException("Supported value must be either true or false");
                }
                isSupported = Boolean.parseBoolean(supported);
                if (this.mFormatSupportedMap.get(name) != null && this.mFormatSupportedMap.get(name) != isSupported) {
                    throw new UnsupportedOperationException("Format: " + name + " has conflict supported value");
                }
                switch (name) {
                    case "HEVC": {
                        if (isSupported) {
                            this.mSupportedVideoMimeTypes.add("video/hevc");
                            break;
                        }
                        this.mUnsupportedVideoMimeTypes.add("video/hevc");
                        break;
                    }
                    case "VP9": {
                        if (isSupported) {
                            this.mSupportedVideoMimeTypes.add("video/x-vnd.on2.vp9");
                            break;
                        }
                        this.mUnsupportedVideoMimeTypes.add("video/x-vnd.on2.vp9");
                        break;
                    }
                    case "AV1": {
                        if (isSupported) {
                            this.mSupportedVideoMimeTypes.add("video/av01");
                            break;
                        }
                        this.mUnsupportedVideoMimeTypes.add("video/av01");
                        break;
                    }
                    case "HDR10": {
                        if (isSupported) {
                            this.mSupportedHdrTypes.add("android.media.feature.hdr.hdr10");
                            break;
                        }
                        this.mUnsupportedHdrTypes.add("android.media.feature.hdr.hdr10");
                        break;
                    }
                    case "HDR10Plus": {
                        if (isSupported) {
                            this.mSupportedHdrTypes.add("android.media.feature.hdr.hdr10_plus");
                            break;
                        }
                        this.mUnsupportedHdrTypes.add("android.media.feature.hdr.hdr10_plus");
                        break;
                    }
                    case "Dolby-Vision": {
                        if (isSupported) {
                            this.mSupportedHdrTypes.add("android.media.feature.hdr.dolby_vision");
                            break;
                        }
                        this.mUnsupportedHdrTypes.add("android.media.feature.hdr.dolby_vision");
                        break;
                    }
                    case "HLG": {
                        if (isSupported) {
                            this.mSupportedHdrTypes.add("android.media.feature.hdr.hlg");
                            break;
                        }
                        this.mUnsupportedHdrTypes.add("android.media.feature.hdr.hlg");
                        break;
                    }
                    case "SlowMotion": {
                        this.mIsSlowMotionSupported = isSupported;
                        break;
                    }
                    default: {
                        Log.w(ApplicationMediaCapabilities.TAG, "Invalid format name " + name);
                    }
                }
            } else {
                throw new UnsupportedOperationException("Format name and supported must both be specified");
            }
            this.mFormatSupportedMap.put(name, isSupported);
        }

        public ApplicationMediaCapabilities build() {
            Log.d(ApplicationMediaCapabilities.TAG, "Building ApplicationMediaCapabilities with: (Supported HDR: " + this.mSupportedHdrTypes.toString() + " Unsupported HDR: " + this.mUnsupportedHdrTypes.toString() + ") (Supported Codec:  " + this.mSupportedVideoMimeTypes.toString() + " Unsupported Codec:" + this.mUnsupportedVideoMimeTypes.toString() + ") " + this.mIsSlowMotionSupported);
            if (!this.mSupportedHdrTypes.isEmpty() && !this.mSupportedVideoMimeTypes.contains("video/hevc")) {
                throw new UnsupportedOperationException("Only support HEVC mime type");
            }
            return new ApplicationMediaCapabilities(this);
        }

        public Builder addSupportedVideoMimeType(String codecMime) {
            this.mSupportedVideoMimeTypes.add(codecMime);
            return this;
        }

        private List<String> getSupportedVideoMimeTypes() {
            return new ArrayList<String>(this.mSupportedVideoMimeTypes);
        }

        private boolean isValidVideoCodecMimeType(String codecMime) {
            return codecMime.equalsIgnoreCase("video/hevc") || codecMime.equalsIgnoreCase("video/x-vnd.on2.vp9") || codecMime.equalsIgnoreCase("video/av01");
        }

        public Builder addUnsupportedVideoMimeType(String codecMime) {
            if (!this.isValidVideoCodecMimeType(codecMime)) {
                throw new IllegalArgumentException("Invalid codec mime type: " + codecMime);
            }
            this.mUnsupportedVideoMimeTypes.add(codecMime);
            return this;
        }

        private List<String> getUnsupportedVideoMimeTypes() {
            return new ArrayList<String>(this.mUnsupportedVideoMimeTypes);
        }

        public Builder addSupportedHdrType(String hdrType) {
            if (!this.isValidVideoCodecHdrType(hdrType)) {
                throw new IllegalArgumentException("Invalid hdr type: " + hdrType);
            }
            this.mSupportedHdrTypes.add(hdrType);
            return this;
        }

        private List<String> getSupportedHdrTypes() {
            return new ArrayList<String>(this.mSupportedHdrTypes);
        }

        private boolean isValidVideoCodecHdrType(String hdrType) {
            return hdrType.equals("android.media.feature.hdr.dolby_vision") || hdrType.equals("android.media.feature.hdr.hdr10") || hdrType.equals("android.media.feature.hdr.hdr10_plus") || hdrType.equals("android.media.feature.hdr.hlg");
        }

        public Builder addUnsupportedHdrType(String hdrType) {
            if (!this.isValidVideoCodecHdrType(hdrType)) {
                throw new IllegalArgumentException("Invalid hdr type: " + hdrType);
            }
            this.mUnsupportedHdrTypes.add(hdrType);
            return this;
        }

        private List<String> getUnsupportedHdrTypes() {
            return new ArrayList<String>(this.mUnsupportedHdrTypes);
        }

        public Builder setSlowMotionSupported(boolean slowMotionSupported) {
            this.mIsSlowMotionSupported = slowMotionSupported;
            return this;
        }
    }
}

