/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.annotation.SystemApi;
import android.media.AudioDescriptor;
import android.media.AudioDeviceInfo;
import android.media.AudioProfile;
import android.media.AudioSystem;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@SystemApi
public class AudioDeviceAttributes
implements Parcelable {
    public static final int ROLE_INPUT = 1;
    public static final int ROLE_OUTPUT = 2;
    private final int mType;
    private final String mAddress;
    private final String mName;
    private final int mRole;
    private final int mNativeType;
    private final List<AudioProfile> mAudioProfiles;
    private final List<AudioDescriptor> mAudioDescriptors;
    public static final Parcelable.Creator<AudioDeviceAttributes> CREATOR = new Parcelable.Creator<AudioDeviceAttributes>(){

        @Override
        public AudioDeviceAttributes createFromParcel(Parcel p) {
            return new AudioDeviceAttributes(p);
        }

        public AudioDeviceAttributes[] newArray(int size) {
            return new AudioDeviceAttributes[size];
        }
    };

    @SystemApi
    public AudioDeviceAttributes(AudioDeviceInfo deviceInfo) {
        Objects.requireNonNull(deviceInfo);
        this.mRole = deviceInfo.isSink() ? 2 : 1;
        this.mType = deviceInfo.getType();
        this.mAddress = deviceInfo.getAddress();
        this.mName = String.valueOf(deviceInfo.getProductName());
        this.mNativeType = deviceInfo.getInternalType();
        this.mAudioProfiles = deviceInfo.getAudioProfiles();
        this.mAudioDescriptors = deviceInfo.getAudioDescriptors();
    }

    @SystemApi
    public AudioDeviceAttributes(int role, int type, String address) {
        this(role, type, address, "", new ArrayList<AudioProfile>(), new ArrayList<AudioDescriptor>());
    }

    @SystemApi
    public AudioDeviceAttributes(int role, int type, String address, String name, List<AudioProfile> profiles, List<AudioDescriptor> descriptors) {
        Objects.requireNonNull(address);
        if (role != 2 && role != 1) {
            throw new IllegalArgumentException("Invalid role " + role);
        }
        if (role == 2) {
            AudioDeviceInfo.enforceValidAudioDeviceTypeOut(type);
            this.mNativeType = AudioDeviceInfo.convertDeviceTypeToInternalDevice(type);
        } else if (role == 1) {
            AudioDeviceInfo.enforceValidAudioDeviceTypeIn(type);
            this.mNativeType = AudioDeviceInfo.convertDeviceTypeToInternalInputDevice(type, address);
        } else {
            this.mNativeType = 0;
        }
        this.mRole = role;
        this.mType = type;
        this.mAddress = address;
        this.mName = name;
        this.mAudioProfiles = profiles;
        this.mAudioDescriptors = descriptors;
    }

    public AudioDeviceAttributes(int nativeType, String address) {
        this(nativeType, address, "");
    }

    public AudioDeviceAttributes(int nativeType, String address, String name) {
        this.mRole = (nativeType & Integer.MIN_VALUE) != 0 ? 1 : 2;
        this.mType = AudioDeviceInfo.convertInternalDeviceToDeviceType(nativeType);
        this.mAddress = address;
        this.mName = name;
        this.mNativeType = nativeType;
        this.mAudioProfiles = new ArrayList<AudioProfile>();
        this.mAudioDescriptors = new ArrayList<AudioDescriptor>();
    }

    @SystemApi
    public int getRole() {
        return this.mRole;
    }

    @SystemApi
    public int getType() {
        return this.mType;
    }

    @SystemApi
    public String getAddress() {
        return this.mAddress;
    }

    @SystemApi
    public String getName() {
        return this.mName;
    }

    public int getInternalType() {
        return this.mNativeType;
    }

    @SystemApi
    public List<AudioProfile> getAudioProfiles() {
        return this.mAudioProfiles;
    }

    @SystemApi
    public List<AudioDescriptor> getAudioDescriptors() {
        return this.mAudioDescriptors;
    }

    public int hashCode() {
        return Objects.hash(this.mRole, this.mType, this.mAddress, this.mName, this.mAudioProfiles, this.mAudioDescriptors);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioDeviceAttributes that = (AudioDeviceAttributes)o;
        return this.mRole == that.mRole && this.mType == that.mType && this.mAddress.equals(that.mAddress) && this.mName.equals(that.mName) && this.mAudioProfiles.equals(that.mAudioProfiles) && this.mAudioDescriptors.equals(that.mAudioDescriptors);
    }

    public boolean equalTypeAddress(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioDeviceAttributes that = (AudioDeviceAttributes)o;
        return this.mRole == that.mRole && this.mType == that.mType && this.mAddress.equals(that.mAddress);
    }

    public static String roleToString(int role) {
        return role == 2 ? "output" : "input";
    }

    public String toString() {
        return new String("AudioDeviceAttributes: role:" + AudioDeviceAttributes.roleToString(this.mRole) + " type:" + (this.mRole == 2 ? AudioSystem.getOutputDeviceName(this.mNativeType) : AudioSystem.getInputDeviceName(this.mNativeType)) + " addr:" + this.mAddress + " name:" + this.mName + " profiles:" + this.mAudioProfiles.toString() + " descriptors:" + this.mAudioDescriptors.toString());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mRole);
        dest.writeInt(this.mType);
        dest.writeString(this.mAddress);
        dest.writeString(this.mName);
        dest.writeInt(this.mNativeType);
        dest.writeParcelableArray(this.mAudioProfiles.toArray(new AudioProfile[this.mAudioProfiles.size()]), flags);
        dest.writeParcelableArray(this.mAudioDescriptors.toArray(new AudioDescriptor[this.mAudioDescriptors.size()]), flags);
    }

    private AudioDeviceAttributes(Parcel in) {
        this.mRole = in.readInt();
        this.mType = in.readInt();
        this.mAddress = in.readString();
        this.mName = in.readString();
        this.mNativeType = in.readInt();
        AudioProfile[] audioProfilesArray = in.readParcelableArray(AudioProfile.class.getClassLoader(), AudioProfile.class);
        this.mAudioProfiles = new ArrayList<AudioProfile>(Arrays.asList(audioProfilesArray));
        AudioDescriptor[] audioDescriptorsArray = in.readParcelableArray(AudioDescriptor.class.getClassLoader(), AudioDescriptor.class);
        this.mAudioDescriptors = new ArrayList<AudioDescriptor>(Arrays.asList(audioDescriptorsArray));
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Role {
    }
}

