/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.compat.annotation.UnsupportedAppUsage;
import android.media.AudioDescriptor;
import android.media.AudioGain;
import android.media.AudioGainConfig;
import android.media.AudioHandle;
import android.media.AudioPortConfig;
import android.media.AudioProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class AudioPort {
    private static final String TAG = "AudioPort";
    public static final int ROLE_NONE = 0;
    public static final int ROLE_SOURCE = 1;
    public static final int ROLE_SINK = 2;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_DEVICE = 1;
    public static final int TYPE_SUBMIX = 2;
    public static final int TYPE_SESSION = 3;
    @UnsupportedAppUsage
    AudioHandle mHandle;
    @UnsupportedAppUsage
    protected final int mRole;
    private final String mName;
    private final int[] mSamplingRates;
    private final int[] mChannelMasks;
    private final int[] mChannelIndexMasks;
    private final int[] mFormats;
    private final List<AudioProfile> mProfiles;
    private final List<AudioDescriptor> mDescriptors;
    @UnsupportedAppUsage
    private final AudioGain[] mGains;
    @UnsupportedAppUsage
    private AudioPortConfig mActiveConfig;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    AudioPort(AudioHandle handle, int role, String name, int[] samplingRates, int[] channelMasks, int[] channelIndexMasks, int[] formats, AudioGain[] gains) {
        this.mHandle = handle;
        this.mRole = role;
        this.mName = name;
        this.mSamplingRates = samplingRates;
        this.mChannelMasks = channelMasks;
        this.mChannelIndexMasks = channelIndexMasks;
        this.mFormats = formats;
        this.mGains = gains;
        this.mProfiles = new ArrayList<AudioProfile>();
        if (this.mFormats != null) {
            for (int format : this.mFormats) {
                this.mProfiles.add(new AudioProfile(format, samplingRates, channelMasks, channelIndexMasks, 0));
            }
        }
        this.mDescriptors = new ArrayList<AudioDescriptor>();
    }

    AudioPort(AudioHandle handle, int role, String name, List<AudioProfile> profiles, AudioGain[] gains, List<AudioDescriptor> descriptors) {
        this.mHandle = handle;
        this.mRole = role;
        this.mName = name;
        this.mProfiles = profiles;
        this.mDescriptors = descriptors;
        this.mGains = gains;
        HashSet<Integer> formats = new HashSet<Integer>();
        HashSet samplingRates = new HashSet();
        HashSet channelMasks = new HashSet();
        HashSet channelIndexMasks = new HashSet();
        for (AudioProfile profile : profiles) {
            formats.add(profile.getFormat());
            samplingRates.addAll(Arrays.stream(profile.getSampleRates()).boxed().collect(Collectors.toList()));
            channelMasks.addAll(Arrays.stream(profile.getChannelMasks()).boxed().collect(Collectors.toList()));
            channelIndexMasks.addAll(Arrays.stream(profile.getChannelIndexMasks()).boxed().collect(Collectors.toList()));
        }
        this.mSamplingRates = samplingRates.stream().mapToInt(Number::intValue).toArray();
        this.mChannelMasks = channelMasks.stream().mapToInt(Number::intValue).toArray();
        this.mChannelIndexMasks = channelIndexMasks.stream().mapToInt(Number::intValue).toArray();
        this.mFormats = formats.stream().mapToInt(Number::intValue).toArray();
    }

    AudioHandle handle() {
        return this.mHandle;
    }

    @UnsupportedAppUsage
    public int id() {
        return this.mHandle.id();
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int role() {
        return this.mRole;
    }

    public String name() {
        return this.mName;
    }

    public int[] samplingRates() {
        return this.mSamplingRates;
    }

    public int[] channelMasks() {
        return this.mChannelMasks;
    }

    public int[] channelIndexMasks() {
        return this.mChannelIndexMasks;
    }

    public int[] formats() {
        return this.mFormats;
    }

    public List<AudioProfile> profiles() {
        return this.mProfiles;
    }

    public List<AudioDescriptor> audioDescriptors() {
        return this.mDescriptors;
    }

    public AudioGain[] gains() {
        return this.mGains;
    }

    AudioGain gain(int index) {
        if (index < 0 || index >= this.mGains.length) {
            return null;
        }
        return this.mGains[index];
    }

    public AudioPortConfig buildConfig(int samplingRate, int channelMask, int format, AudioGainConfig gain) {
        return new AudioPortConfig(this, samplingRate, channelMask, format, gain);
    }

    public AudioPortConfig activeConfig() {
        return this.mActiveConfig;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AudioPort)) {
            return false;
        }
        AudioPort ap = (AudioPort)o;
        return this.mHandle.equals(ap.handle());
    }

    public int hashCode() {
        return this.mHandle.hashCode();
    }

    public String toString() {
        String role = Integer.toString(this.mRole);
        switch (this.mRole) {
            case 0: {
                role = "NONE";
                break;
            }
            case 1: {
                role = "SOURCE";
                break;
            }
            case 2: {
                role = "SINK";
            }
        }
        return "{mHandle: " + this.mHandle + ", mRole: " + role + "}";
    }
}

